/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.javadoc;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.internal.text.html.SubstitutionTextReader;
import org.eclipse.wst.jsdt.internal.ui.text.javadoc.JavaDocMessages;

public class JavaDoc2HTMLTextReader
extends SubstitutionTextReader {
    private List fParameters;
    private String fReturn;
    private List fExceptions;
    private List fAuthors;
    private List fSees;
    private List fSince;
    private List fRest;

    public JavaDoc2HTMLTextReader(Reader reader) {
        super(reader);
        this.setSkipWhitespace(false);
    }

    private int getTag(StringBuffer stringBuffer) throws IOException {
        int n = this.nextChar();
        while (n == 46 || n != -1 && Character.isLetter((char)n)) {
            stringBuffer.append((char)n);
            n = this.nextChar();
        }
        return n;
    }

    private int getContent(StringBuffer stringBuffer, char c) throws IOException {
        int n = this.nextChar();
        while (n != -1 && n != c) {
            stringBuffer.append((char)n);
            n = this.nextChar();
        }
        return n;
    }

    private int getContentUntilNextTag(StringBuffer stringBuffer) throws IOException {
        int n = this.nextChar();
        boolean bl = false;
        while (n != -1) {
            if (n == 64) {
                int n2 = stringBuffer.length();
                while (--n2 >= 0 && Character.isWhitespace(stringBuffer.charAt(n2))) {
                    switch (stringBuffer.charAt(n2)) {
                        case '\n': 
                        case '\r': {
                            return n;
                        }
                    }
                    if (n2 > 0) continue;
                    return n;
                }
            }
            if (bl) {
                stringBuffer.append(this.processBlockTag());
                bl = false;
            } else {
                stringBuffer.append((char)n);
            }
            n = this.nextChar();
            boolean bl2 = bl = n == 123;
        }
        return n;
    }

    private String substituteQualification(String string) {
        String string2 = string.replace('#', '.');
        if (string2.startsWith(".")) {
            string2 = string2.substring(1);
        }
        return string2;
    }

    private void printDefinitions(StringBuffer stringBuffer, List list, boolean bl) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append("<dd>");
            if (!bl) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append("<b>");
                int n = this.getParamEndOffset(string);
                if (n <= string.length()) {
                    stringBuffer.append(HTMLPrinter.convertToHTMLContent((String)string.substring(0, n)));
                    stringBuffer.append("</b>");
                    stringBuffer.append(string.substring(n));
                } else {
                    stringBuffer.append("</b>");
                }
            }
            stringBuffer.append("</dd>");
        }
    }

    /*
     * Unable to fully structure code
     */
    private int getParamEndOffset(String var1_1) {
        block5: {
            var2_2 = 0;
            var3_3 = var1_1.length();
            while (var2_2 < var3_3 && Character.isWhitespace(var1_1.charAt(var2_2))) {
                ++var2_2;
            }
            if (var2_2 >= var3_3 || var1_1.charAt(var2_2) != '<') ** GOTO lbl18
            while (var2_2 < var3_3 && Character.isWhitespace(var1_1.charAt(var2_2))) {
                ++var2_2;
            }
            while (var2_2 < var3_3 && Character.isJavaIdentifierPart(var1_1.charAt(var2_2))) {
                ++var2_2;
            }
            while (var2_2 < var3_3 && var1_1.charAt(var2_2) != '>') {
                ++var2_2;
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                ++var2_2;
lbl18:
                // 2 sources

                ** while (var2_2 < var3_3 && Character.isJavaIdentifierPart((char)var1_1.charAt((int)var2_2)))
            }
        }
        return var2_2;
    }

    private void print(StringBuffer stringBuffer, String string, List list, boolean bl) {
        if (!list.isEmpty()) {
            stringBuffer.append("<dt>");
            stringBuffer.append(string);
            stringBuffer.append("</dt>");
            this.printDefinitions(stringBuffer, list, bl);
        }
    }

    private void print(StringBuffer stringBuffer, String string, String string2) {
        if (string2 != null) {
            stringBuffer.append("<dt>");
            stringBuffer.append(string);
            stringBuffer.append("</dt>");
            stringBuffer.append("<dd>");
            stringBuffer.append(string2);
            stringBuffer.append("</dd>");
        }
    }

    private void printRest(StringBuffer stringBuffer) {
        if (!this.fRest.isEmpty()) {
            Iterator iterator = this.fRest.iterator();
            while (iterator.hasNext()) {
                Pair pair = (Pair)iterator.next();
                stringBuffer.append("<dt>");
                if (pair.fTag != null) {
                    stringBuffer.append(pair.fTag);
                }
                stringBuffer.append("</dt>");
                stringBuffer.append("<dd>");
                if (pair.fContent != null) {
                    stringBuffer.append(pair.fContent);
                }
                stringBuffer.append("</dd>");
            }
        }
    }

    private String printSimpleTag() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<dl>");
        this.print(stringBuffer, JavaDocMessages.JavaDoc2HTMLTextReader_see_section, this.fSees, false);
        this.print(stringBuffer, JavaDocMessages.JavaDoc2HTMLTextReader_parameters_section, this.fParameters, true);
        this.print(stringBuffer, JavaDocMessages.JavaDoc2HTMLTextReader_returns_section, this.fReturn);
        this.print(stringBuffer, JavaDocMessages.JavaDoc2HTMLTextReader_throws_section, this.fExceptions, false);
        this.print(stringBuffer, JavaDocMessages.JavaDoc2HTMLTextReader_author_section, this.fAuthors, false);
        this.print(stringBuffer, JavaDocMessages.JavaDoc2HTMLTextReader_since_section, this.fSince, false);
        this.printRest(stringBuffer);
        stringBuffer.append("</dl>");
        return stringBuffer.toString();
    }

    private void handleTag(String string, String string2) {
        string2 = string2.trim();
        if ("@param".equals(string)) {
            this.fParameters.add(string2);
        } else if ("@return".equals(string)) {
            this.fReturn = string2;
        } else if ("@exception".equals(string)) {
            this.fExceptions.add(string2);
        } else if ("@throws".equals(string)) {
            this.fExceptions.add(string2);
        } else if ("@author".equals(string)) {
            this.fAuthors.add(this.substituteQualification(string2));
        } else if ("@see".equals(string)) {
            this.fSees.add(this.substituteQualification(string2));
        } else if ("@since".equals(string)) {
            this.fSince.add(this.substituteQualification(string2));
        } else if (string2 != null) {
            this.fRest.add(new Pair(string, string2));
        }
    }

    private String processSimpleTag() throws IOException {
        this.fParameters = new ArrayList();
        this.fExceptions = new ArrayList();
        this.fAuthors = new ArrayList();
        this.fSees = new ArrayList();
        this.fSince = new ArrayList();
        this.fRest = new ArrayList();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 64;
        while (n != -1) {
            stringBuffer.setLength(0);
            stringBuffer.append((char)n);
            n = this.getTag(stringBuffer);
            String string = stringBuffer.toString();
            stringBuffer.setLength(0);
            if (n != -1) {
                n = this.getContentUntilNextTag(stringBuffer);
            }
            this.handleTag(string, stringBuffer.toString());
        }
        return this.printSimpleTag();
    }

    private String printBlockTag(String string, String string2) {
        if ("@link".equals(string) || "@linkplain".equals(string)) {
            char[] cArray = string2.toCharArray();
            boolean bl = false;
            int n = 0;
            int n2 = 0;
            while (n2 < cArray.length) {
                char c = cArray[n2];
                if (n2 == 0 && Character.isWhitespace(c)) {
                    n = 1;
                } else if (c == '(') {
                    bl = true;
                } else if (c == ')') {
                    bl = false;
                } else if (!bl && Character.isWhitespace(c)) {
                    n = n2 + 1;
                    break;
                }
                ++n2;
            }
            if ("@link".equals(string)) {
                return "<code>" + this.substituteQualification(string2.substring(n)) + "</code>";
            }
            return this.substituteQualification(string2.substring(n));
        }
        if ("@literal".equals(string)) {
            return this.printLiteral(string2);
        }
        if ("@code".equals(string)) {
            return "<code>" + this.printLiteral(string2) + "</code>";
        }
        return this.substituteQualification(string2);
    }

    private String printLiteral(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            if (!Character.isWhitespace(string.charAt(n2))) {
                n = n2;
                break;
            }
            ++n2;
        }
        return HTMLPrinter.convertToHTMLContent((String)string.substring(n));
    }

    private String processBlockTag() throws IOException {
        int n = this.nextChar();
        if (n != 64) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('{');
            stringBuffer.append((char)n);
            return stringBuffer.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (n != -1) {
            stringBuffer.setLength(0);
            stringBuffer.append((char)n);
            n = this.getTag(stringBuffer);
            String string = stringBuffer.toString();
            stringBuffer.setLength(0);
            if (n != -1 && n != 125) {
                stringBuffer.append((char)n);
                n = this.getContent(stringBuffer, '}');
            }
            return this.printBlockTag(string, stringBuffer.toString());
        }
        return null;
    }

    protected String computeSubstitution(int n) throws IOException {
        if (n == 64 && this.fWasWhiteSpace) {
            return this.processSimpleTag();
        }
        if (n == 123) {
            return this.processBlockTag();
        }
        return null;
    }

    private static class Pair {
        String fTag;
        String fContent;

        Pair(String string, String string2) {
            this.fTag = string;
            this.fContent = string2;
        }
    }
}

