/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.spelling;

import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.SpellCheckEngine;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.WordCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.ISpellCheckEngine;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.ISpellChecker;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;
import org.eclipse.wst.jsdt.ui.text.java.IInvocationContext;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposal;

public class AddWordProposal
implements IJavaCompletionProposal {
    private static final String PREF_KEY_DO_NOT_ASK = "do_not_ask_to_install_user_dictionary";
    private final IInvocationContext fContext;
    private final String fWord;

    public AddWordProposal(String string, IInvocationContext iInvocationContext) {
        this.fContext = iInvocationContext;
        this.fWord = string;
    }

    public final void apply(IDocument iDocument) {
        ISpellCheckEngine iSpellCheckEngine = SpellCheckEngine.getInstance();
        ISpellChecker iSpellChecker = iSpellCheckEngine.getSpellChecker();
        if (iSpellChecker == null) {
            return;
        }
        ITextEditor iTextEditor = this.getEditor();
        if (!iSpellChecker.acceptsWords()) {
            Shell shell = iTextEditor != null ? iTextEditor.getEditorSite().getShell() : JavaPlugin.getActiveWorkbenchShell();
            if (!AddWordProposal.canAskToConfigure() || !this.askUserToConfigureUserDictionary(shell)) {
                return;
            }
            String[] stringArray = new String[]{"org.eclipse.ui.editors.preferencePages.Spelling"};
            PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)stringArray[0], (String[])stringArray, null).open();
        }
        if (iSpellChecker.acceptsWords()) {
            iSpellChecker.addWord(this.fWord);
            SpellingProblem.removeAllInActiveEditor((ITextEditor)iTextEditor, (String)this.fWord);
        }
    }

    private boolean askUserToConfigureUserDictionary(Shell shell) {
        MessageDialogWithToggle messageDialogWithToggle = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)JavaUIMessages.Spelling_add_askToConfigure_title, (String)JavaUIMessages.Spelling_add_askToConfigure_question, (String)JavaUIMessages.Spelling_add_askToConfigure_ignoreMessage, (boolean)false, null, null);
        PreferenceConstants.getPreferenceStore().setValue(PREF_KEY_DO_NOT_ASK, messageDialogWithToggle.getToggleState());
        return messageDialogWithToggle.getReturnCode() == 2;
    }

    static boolean canAskToConfigure() {
        return !PreferenceConstants.getPreferenceStore().getBoolean(PREF_KEY_DO_NOT_ASK);
    }

    private ITextEditor getEditor() {
        IWorkbenchPage iWorkbenchPage = JavaPlugin.getActivePage();
        if (iWorkbenchPage == null) {
            return null;
        }
        IEditorPart iEditorPart = iWorkbenchPage.getActiveEditor();
        if (iWorkbenchPage.getActivePart() != iEditorPart || !(iEditorPart instanceof ITextEditor)) {
            return null;
        }
        return (ITextEditor)iEditorPart;
    }

    public String getAdditionalProposalInfo() {
        return Messages.format(JavaUIMessages.Spelling_add_info, new String[]{WordCorrectionProposal.getHtmlRepresentation(this.fWord)});
    }

    public final IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return Messages.format(JavaUIMessages.Spelling_add_label, new String[]{this.fWord});
    }

    public Image getImage() {
        return JavaPluginImages.get("org.eclipse.wst.jsdt.ui.add_correction.gif");
    }

    public int getRelevance() {
        return Integer.MIN_VALUE;
    }

    public final Point getSelection(IDocument iDocument) {
        return new Point(this.fContext.getSelectionOffset(), this.fContext.getSelectionLength());
    }
}

