/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.spelling;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.SpellCheckEngine;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.WordCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.ISpellCheckEngine;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.ISpellChecker;
import org.eclipse.wst.jsdt.ui.text.java.IInvocationContext;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposal;

public class WordIgnoreProposal
implements IJavaCompletionProposal {
    private IInvocationContext fContext;
    private String fWord;

    public WordIgnoreProposal(String string, IInvocationContext iInvocationContext) {
        this.fWord = string;
        this.fContext = iInvocationContext;
    }

    public final void apply(IDocument iDocument) {
        ISpellCheckEngine iSpellCheckEngine = SpellCheckEngine.getInstance();
        ISpellChecker iSpellChecker = iSpellCheckEngine.getSpellChecker();
        if (iSpellChecker != null) {
            iSpellChecker.ignoreWord(this.fWord);
            SpellingProblem.removeAllInActiveEditor((ITextEditor)this.getEditor(), (String)this.fWord);
        }
    }

    private ITextEditor getEditor() {
        IWorkbenchPage iWorkbenchPage = JavaPlugin.getActivePage();
        if (iWorkbenchPage == null) {
            return null;
        }
        IEditorPart iEditorPart = iWorkbenchPage.getActiveEditor();
        if (iWorkbenchPage.getActivePart() != iEditorPart || !(iEditorPart instanceof ITextEditor)) {
            return null;
        }
        return (ITextEditor)iEditorPart;
    }

    public String getAdditionalProposalInfo() {
        return Messages.format(JavaUIMessages.Spelling_ignore_info, new String[]{WordCorrectionProposal.getHtmlRepresentation(this.fWord)});
    }

    public final IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return Messages.format(JavaUIMessages.Spelling_ignore_label, new String[]{this.fWord});
    }

    public Image getImage() {
        return JavaPluginImages.get("org.eclipse.wst.jsdt.ui.never_translate.gif");
    }

    public final int getRelevance() {
        return -2147483647;
    }

    public final Point getSelection(IDocument iDocument) {
        return new Point(this.fContext.getSelectionOffset(), this.fContext.getSelectionLength());
    }
}

