/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.spelling.engine;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.ISpellCheckIterator;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.ISpellChecker;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.ISpellDictionary;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.ISpellEvent;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.ISpellEventListener;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.SpellEvent;

public class DefaultSpellChecker
implements ISpellChecker {
    public static final String[] URL_PREFIXES = new String[]{"http://", "https://", "www.", "ftp://", "ftps://", "news://", "mailto://"};
    private final Set fDictionaries = Collections.synchronizedSet(new HashSet());
    private final Set fIgnored = Collections.synchronizedSet(new HashSet());
    private final Set fListeners = Collections.synchronizedSet(new HashSet());
    private final IPreferenceStore fPreferences;
    private Locale fLocale;

    protected static boolean isDigits(String string) {
        int n = 0;
        while (n < string.length()) {
            if (Character.isDigit(string.charAt(n))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected static boolean isMixedCase(String string, boolean bl) {
        int n = string.length();
        boolean bl2 = Character.isUpperCase(string.charAt(0));
        if (bl && bl2 && n > 1) {
            bl2 = Character.isUpperCase(string.charAt(1));
        }
        if (bl2) {
            int n2 = n - 1;
            while (n2 > 0) {
                if (Character.isLowerCase(string.charAt(n2))) {
                    return true;
                }
                --n2;
            }
        } else {
            int n3 = n - 1;
            while (n3 > 0) {
                if (Character.isUpperCase(string.charAt(n3))) {
                    return true;
                }
                --n3;
            }
        }
        return false;
    }

    protected static boolean isUpperCase(String string) {
        int n = string.length() - 1;
        while (n >= 0) {
            if (Character.isLowerCase(string.charAt(n))) {
                return false;
            }
            --n;
        }
        return true;
    }

    protected static boolean isUrl(String string) {
        int n = 0;
        while (n < URL_PREFIXES.length) {
            if (string.startsWith(URL_PREFIXES[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public DefaultSpellChecker(IPreferenceStore iPreferenceStore, Locale locale) {
        Assert.isLegal((iPreferenceStore != null ? 1 : 0) != 0);
        Assert.isLegal((locale != null ? 1 : 0) != 0);
        this.fPreferences = iPreferenceStore;
        this.fLocale = locale;
    }

    public final void addDictionary(ISpellDictionary iSpellDictionary) {
        this.fDictionaries.add(iSpellDictionary);
    }

    public final void addListener(ISpellEventListener iSpellEventListener) {
        this.fListeners.add(iSpellEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acceptsWords() {
        HashSet hashSet;
        Object object = this.fDictionaries;
        synchronized (object) {
            hashSet = new HashSet(this.fDictionaries);
        }
        object = null;
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object = (ISpellDictionary)iterator.next();
            if (!object.acceptsWords()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWord(String string) {
        HashSet hashSet;
        Object object = this.fDictionaries;
        synchronized (object) {
            hashSet = new HashSet(this.fDictionaries);
        }
        object = string.toLowerCase();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ISpellDictionary iSpellDictionary = (ISpellDictionary)iterator.next();
            if (!iSpellDictionary.acceptsWords()) continue;
            iSpellDictionary.addWord((String)object);
        }
    }

    public final void checkWord(String string) {
        this.fIgnored.remove(string.toLowerCase());
    }

    public void execute(ISpellCheckIterator iSpellCheckIterator) {
        boolean bl = this.fPreferences.getBoolean("spelling_ignore_digits");
        boolean bl2 = this.fPreferences.getBoolean("spelling_ignore_mixed");
        boolean bl3 = this.fPreferences.getBoolean("spelling_ignore_sentence");
        boolean bl4 = this.fPreferences.getBoolean("spelling_ignore_upper");
        boolean bl5 = this.fPreferences.getBoolean("spelling_ignore_urls");
        boolean bl6 = this.fPreferences.getBoolean("spelling_ignore_non_letters");
        boolean bl7 = this.fPreferences.getBoolean("spelling_ignore_single_letters");
        iSpellCheckIterator.setIgnoreSingleLetters(bl7);
        Iterator iterator = this.fDictionaries.iterator();
        while (iterator.hasNext()) {
            ((ISpellDictionary)iterator.next()).setStripNonLetters(bl6);
        }
        String string = null;
        boolean bl8 = false;
        while (iSpellCheckIterator.hasNext()) {
            string = (String)iSpellCheckIterator.next();
            if (string == null || this.fIgnored.contains(string)) continue;
            bl8 = iSpellCheckIterator.startsSentence();
            if (!this.isCorrect(string)) {
                boolean bl9 = DefaultSpellChecker.isMixedCase(string, true);
                boolean bl10 = DefaultSpellChecker.isUpperCase(string);
                boolean bl11 = DefaultSpellChecker.isDigits(string);
                boolean bl12 = DefaultSpellChecker.isUrl(string);
                if (!(!bl2 && bl9 || !bl4 && bl10 || !bl && bl11 || !bl5 && bl12) && (bl9 || bl10 || bl11 || bl12)) continue;
                this.fireEvent(new SpellEvent(this, string, iSpellCheckIterator.getBegin(), iSpellCheckIterator.getEnd(), bl8, false));
                continue;
            }
            if (bl3 || !bl8 || !Character.isLowerCase(string.charAt(0))) continue;
            this.fireEvent(new SpellEvent(this, string, iSpellCheckIterator.getBegin(), iSpellCheckIterator.getEnd(), true, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireEvent(ISpellEvent iSpellEvent) {
        HashSet hashSet;
        Object object = this.fListeners;
        synchronized (object) {
            hashSet = new HashSet(this.fListeners);
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            ((ISpellEventListener)object.next()).handle(iSpellEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getProposals(String string, boolean bl) {
        HashSet hashSet;
        Object object = this.fDictionaries;
        synchronized (object) {
            hashSet = new HashSet(this.fDictionaries);
        }
        object = null;
        HashSet hashSet2 = new HashSet();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object = (ISpellDictionary)iterator.next();
            hashSet2.addAll(object.getProposals(string, bl));
        }
        return hashSet2;
    }

    public final void ignoreWord(String string) {
        this.fIgnored.add(string.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isCorrect(String string) {
        HashSet hashSet;
        Object object = this.fDictionaries;
        synchronized (object) {
            hashSet = new HashSet(this.fDictionaries);
        }
        if (this.fIgnored.contains(string.toLowerCase())) {
            return true;
        }
        object = null;
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object = (ISpellDictionary)iterator.next();
            if (!object.isCorrect(string)) continue;
            return true;
        }
        return false;
    }

    public final void removeDictionary(ISpellDictionary iSpellDictionary) {
        this.fDictionaries.remove(iSpellDictionary);
    }

    public final void removeListener(ISpellEventListener iSpellEventListener) {
        this.fListeners.remove(iSpellEventListener);
    }

    public Locale getLocale() {
        return this.fLocale;
    }
}

