/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.template.contentassist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.corext.template.java.CompilationUnitContext;
import org.eclipse.wst.jsdt.internal.corext.template.java.CompilationUnitContextType;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.text.template.contentassist.TemplateProposal;

public class TemplateEngine {
    private static final String $_LINE_SELECTION = "${line_selection}";
    private static final String $_WORD_SELECTION = "${word_selection}";
    private TemplateContextType fContextType;
    private ArrayList fProposals = new ArrayList();
    private final Map fPositions = new HashMap();

    public TemplateEngine(TemplateContextType templateContextType) {
        Assert.isNotNull((Object)templateContextType);
        this.fContextType = templateContextType;
    }

    public void reset() {
        this.fProposals.clear();
        Iterator iterator = this.fPositions.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            IDocument iDocument = (IDocument)entry.getKey();
            Position position = (Position)entry.getValue();
            iDocument.removePosition(position);
        }
        this.fPositions.clear();
    }

    public TemplateProposal[] getResults() {
        return this.fProposals.toArray(new TemplateProposal[this.fProposals.size()]);
    }

    public void complete(ITextViewer iTextViewer, int n, ICompilationUnit iCompilationUnit) {
        IDocument iDocument = iTextViewer.getDocument();
        if (!(this.fContextType instanceof CompilationUnitContextType)) {
            return;
        }
        Point point = iTextViewer.getSelectedRange();
        Position position = new Position(n, point.y);
        String string = null;
        if (point.y != 0) {
            try {
                string = iDocument.get(point.x, point.y);
                iDocument.addPosition(position);
                this.fPositions.put(iDocument, position);
            }
            catch (BadLocationException badLocationException) {}
        }
        CompilationUnitContext compilationUnitContext = ((CompilationUnitContextType)this.fContextType).createContext(iDocument, position, iCompilationUnit);
        compilationUnitContext.setVariable("selection", string);
        int n2 = compilationUnitContext.getStart();
        int n3 = compilationUnitContext.getEnd();
        Region region = new Region(n2, n3 - n2);
        Template[] templateArray = JavaPlugin.getDefault().getTemplateStore().getTemplates();
        if (point.y == 0) {
            int n4 = 0;
            while (n4 != templateArray.length) {
                if (compilationUnitContext.canEvaluate(templateArray[n4])) {
                    this.fProposals.add(new TemplateProposal(templateArray[n4], (TemplateContext)compilationUnitContext, (IRegion)region, JavaPluginImages.get("org.eclipse.wst.jsdt.ui.template_obj.gif")));
                }
                ++n4;
            }
        } else {
            if (compilationUnitContext.getKey().length() == 0) {
                compilationUnitContext.setForceEvaluation(true);
            }
            boolean bl = this.areMultipleLinesSelected(iTextViewer);
            int n5 = 0;
            while (n5 != templateArray.length) {
                Template template = templateArray[n5];
                if (compilationUnitContext.canEvaluate(template) && template.getContextTypeId().equals(compilationUnitContext.getContextType().getId()) && (!bl && template.getPattern().indexOf($_WORD_SELECTION) != -1 || bl && template.getPattern().indexOf($_LINE_SELECTION) != -1)) {
                    this.fProposals.add(new TemplateProposal(templateArray[n5], (TemplateContext)compilationUnitContext, (IRegion)region, JavaPluginImages.get("org.eclipse.wst.jsdt.ui.template_obj.gif")));
                }
                ++n5;
            }
        }
    }

    private boolean areMultipleLinesSelected(ITextViewer iTextViewer) {
        if (iTextViewer == null) {
            return false;
        }
        Point point = iTextViewer.getSelectedRange();
        if (point.y == 0) {
            return false;
        }
        try {
            IDocument iDocument = iTextViewer.getDocument();
            int n = iDocument.getLineOfOffset(point.x);
            int n2 = iDocument.getLineOfOffset(point.x + point.y);
            IRegion iRegion = iDocument.getLineInformation(n);
            return n != n2 || point.x == iRegion.getOffset() && point.y == iRegion.getLength();
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }
}

