/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.typehierarchy;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.HistoryAction;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.HistoryListAction;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.TypeHierarchyMessages;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.TypeHierarchyViewPart;

public class HistoryDropDownAction
extends Action
implements IMenuCreator {
    public static final int RESULTS_IN_DROP_DOWN = 10;
    private TypeHierarchyViewPart fHierarchyView;
    private Menu fMenu;

    public HistoryDropDownAction(TypeHierarchyViewPart typeHierarchyViewPart) {
        this.fHierarchyView = typeHierarchyViewPart;
        this.fMenu = null;
        this.setToolTipText(TypeHierarchyMessages.HistoryDropDownAction_tooltip);
        JavaPluginImages.setLocalImageDescriptors((IAction)this, "history_list.gif");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.typehierarchy_history_action");
        this.setMenuCreator(this);
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
    }

    public Menu getMenu(Menu menu) {
        return null;
    }

    public Menu getMenu(Control control) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(control);
        IJavaElement[] iJavaElementArray = this.fHierarchyView.getHistoryEntries();
        this.addEntries(this.fMenu, iJavaElementArray);
        new MenuItem(this.fMenu, 2);
        this.addActionToMenu(this.fMenu, new HistoryListAction(this.fHierarchyView));
        this.addActionToMenu(this.fMenu, new ClearHistoryAction(this.fHierarchyView));
        return this.fMenu;
    }

    private boolean addEntries(Menu menu, IJavaElement[] iJavaElementArray) {
        boolean bl = false;
        int n = Math.min(iJavaElementArray.length, 10);
        int n2 = 0;
        while (n2 < n) {
            HistoryAction historyAction = new HistoryAction(this.fHierarchyView, iJavaElementArray[n2]);
            historyAction.setChecked(iJavaElementArray[n2].equals(this.fHierarchyView.getInputElement()));
            bl = bl || historyAction.isChecked();
            this.addActionToMenu(menu, historyAction);
            ++n2;
        }
        return bl;
    }

    protected void addActionToMenu(Menu menu, Action action) {
        ActionContributionItem actionContributionItem = new ActionContributionItem((IAction)action);
        actionContributionItem.fill(menu, -1);
    }

    public void run() {
        new HistoryListAction(this.fHierarchyView).run();
    }

    public static class ClearHistoryAction
    extends Action {
        private TypeHierarchyViewPart fView;

        public ClearHistoryAction(TypeHierarchyViewPart typeHierarchyViewPart) {
            super(TypeHierarchyMessages.HistoryDropDownAction_clearhistory_label);
            this.fView = typeHierarchyViewPart;
        }

        public void run() {
            this.fView.setHistoryEntries(new IJavaElement[0]);
            this.fView.setInputElement(null);
        }
    }
}

