/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.viewsupport;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.IPackageBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.wst.jsdt.ui.JavaElementImageDescriptor;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class BindingLabelProvider
extends LabelProvider {
    public static final long DEFAULT_TEXTFLAGS = JavaElementLabels.ALL_DEFAULT;
    public static final int DEFAULT_IMAGEFLAGS = 1;
    private final long fTextFlags;
    private final int fImageFlags;
    private ImageDescriptorRegistry fRegistry;

    private static int getAdornmentFlags(IBinding iBinding, int n) {
        int n2;
        int n3 = 0;
        if (iBinding instanceof IMethodBinding && ((IMethodBinding)iBinding).isConstructor()) {
            n3 |= 0x200;
        }
        if (Modifier.isAbstract((int)(n2 = iBinding.getModifiers()))) {
            n3 |= 1;
        }
        if (Modifier.isFinal((int)n2)) {
            n3 |= 2;
        }
        if (Modifier.isSynchronized((int)n2)) {
            n3 |= 4;
        }
        if (Modifier.isStatic((int)n2)) {
            n3 |= 8;
        }
        if (iBinding.isDeprecated()) {
            n3 |= 0x400;
        }
        if (iBinding instanceof IVariableBinding && ((IVariableBinding)iBinding).isField()) {
            if (Modifier.isTransient((int)n2)) {
                n3 |= 0x1000;
            }
            if (Modifier.isVolatile((int)n2)) {
                n3 |= 0x800;
            }
        }
        return n3;
    }

    private static ImageDescriptor getBaseImageDescriptor(IBinding iBinding, int n) {
        if (iBinding instanceof ITypeBinding) {
            ITypeBinding iTypeBinding = (ITypeBinding)iBinding;
            if (iTypeBinding.isArray()) {
                iTypeBinding = iTypeBinding.getElementType();
            }
            if (iTypeBinding.isCapture()) {
                iTypeBinding.getWildcard();
            }
            return BindingLabelProvider.getTypeImageDescriptor(iTypeBinding.getDeclaringClass() != null, iTypeBinding, n);
        }
        if (iBinding instanceof IMethodBinding) {
            ITypeBinding iTypeBinding = ((IMethodBinding)iBinding).getDeclaringClass();
            int n2 = iBinding.getModifiers();
            if (iTypeBinding.isEnum() && !Modifier.isPublic((int)n2) && !Modifier.isProtected((int)n2) && !Modifier.isPrivate((int)n2) && ((IMethodBinding)iBinding).isConstructor()) {
                return JavaPluginImages.DESC_MISC_PRIVATE;
            }
            return BindingLabelProvider.getMethodImageDescriptor(iBinding.getModifiers());
        }
        if (iBinding instanceof IVariableBinding) {
            return BindingLabelProvider.getFieldImageDescriptor((IVariableBinding)iBinding);
        }
        return JavaPluginImages.DESC_OBJS_UNKNOWN;
    }

    private static ImageDescriptor getClassImageDescriptor(int n) {
        if (Modifier.isPublic((int)n) || Modifier.isProtected((int)n) || Modifier.isPrivate((int)n)) {
            return JavaPluginImages.DESC_OBJS_CLASS;
        }
        return JavaPluginImages.DESC_OBJS_CLASS_DEFAULT;
    }

    private static ImageDescriptor getFieldImageDescriptor(IVariableBinding iVariableBinding) {
        int n = iVariableBinding.getModifiers();
        if (Modifier.isPublic((int)n) || iVariableBinding.isEnumConstant()) {
            return JavaPluginImages.DESC_FIELD_PUBLIC;
        }
        if (Modifier.isProtected((int)n)) {
            return JavaPluginImages.DESC_FIELD_PROTECTED;
        }
        if (Modifier.isPrivate((int)n)) {
            return JavaPluginImages.DESC_FIELD_PRIVATE;
        }
        return JavaPluginImages.DESC_FIELD_DEFAULT;
    }

    private static void getFieldLabel(IVariableBinding iVariableBinding, long l, StringBuffer stringBuffer) {
        ITypeBinding iTypeBinding;
        if ((l & 0x8000L) != 0L && !iVariableBinding.isEnumConstant()) {
            BindingLabelProvider.getTypeLabel(iVariableBinding.getType(), l & 0x200000L, stringBuffer);
            stringBuffer.append(' ');
        }
        if ((l & 0x10000L) != 0L && (iTypeBinding = iVariableBinding.getDeclaringClass()) != null) {
            BindingLabelProvider.getTypeLabel(iTypeBinding, 0x40000L | l & 0x2000000000L, stringBuffer);
            stringBuffer.append('.');
        }
        stringBuffer.append(iVariableBinding.getName());
        if ((l & 0x4000L) != 0L && !iVariableBinding.isEnumConstant()) {
            stringBuffer.append(JavaElementLabels.DECL_STRING);
            BindingLabelProvider.getTypeLabel(iVariableBinding.getType(), l & 0x200000L, stringBuffer);
        }
        if ((l & 0x20000L) != 0L && (iTypeBinding = iVariableBinding.getDeclaringClass()) != null) {
            stringBuffer.append(JavaElementLabels.CONCAT_STRING);
            BindingLabelProvider.getTypeLabel(iTypeBinding, 0x40000L | l & 0x2000000000L, stringBuffer);
        }
    }

    private static void getLocalVariableLabel(IVariableBinding iVariableBinding, long l, StringBuffer stringBuffer) {
        IMethodBinding iMethodBinding;
        if ((l & 0x8000L) != 0L) {
            BindingLabelProvider.getTypeLabel(iVariableBinding.getType(), l & 0x200000L, stringBuffer);
            stringBuffer.append(' ');
        }
        if ((l & 0x10000L) != 0L && (iMethodBinding = iVariableBinding.getDeclaringMethod()) != null) {
            BindingLabelProvider.getMethodLabel(iMethodBinding, l, stringBuffer);
            stringBuffer.append('.');
        }
        stringBuffer.append(iVariableBinding.getName());
        if ((l & 0x4000L) != 0L) {
            stringBuffer.append(JavaElementLabels.DECL_STRING);
            BindingLabelProvider.getTypeLabel(iVariableBinding.getType(), l & 0x200000L, stringBuffer);
        }
    }

    private static ImageDescriptor getInnerClassImageDescriptor(int n) {
        if (Modifier.isPublic((int)n)) {
            return JavaPluginImages.DESC_OBJS_INNER_CLASS_PUBLIC;
        }
        if (Modifier.isPrivate((int)n)) {
            return JavaPluginImages.DESC_OBJS_INNER_CLASS_PRIVATE;
        }
        if (Modifier.isProtected((int)n)) {
            return JavaPluginImages.DESC_OBJS_INNER_CLASS_PROTECTED;
        }
        return JavaPluginImages.DESC_OBJS_INNER_CLASS_DEFAULT;
    }

    private static ImageDescriptor getInnerInterfaceImageDescriptor(int n) {
        if (Modifier.isPublic((int)n)) {
            return JavaPluginImages.DESC_OBJS_INNER_INTERFACE_PUBLIC;
        }
        if (Modifier.isPrivate((int)n)) {
            return JavaPluginImages.DESC_OBJS_INNER_INTERFACE_PRIVATE;
        }
        if (Modifier.isProtected((int)n)) {
            return JavaPluginImages.DESC_OBJS_INNER_INTERFACE_PROTECTED;
        }
        return JavaPluginImages.DESC_OBJS_INTERFACE_DEFAULT;
    }

    private static ImageDescriptor getInterfaceImageDescriptor(int n) {
        if (Modifier.isPublic((int)n) || Modifier.isProtected((int)n) || Modifier.isPrivate((int)n)) {
            return JavaPluginImages.DESC_OBJS_INTERFACE;
        }
        return JavaPluginImages.DESC_OBJS_INTERFACE_DEFAULT;
    }

    private static ImageDescriptor getMethodImageDescriptor(int n) {
        if (Modifier.isPublic((int)n)) {
            return JavaPluginImages.DESC_MISC_PUBLIC;
        }
        if (Modifier.isProtected((int)n)) {
            return JavaPluginImages.DESC_MISC_PROTECTED;
        }
        if (Modifier.isPrivate((int)n)) {
            return JavaPluginImages.DESC_MISC_PRIVATE;
        }
        return JavaPluginImages.DESC_MISC_DEFAULT;
    }

    private static void appendDimensions(int n, StringBuffer stringBuffer) {
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append('[').append(']');
            ++n2;
        }
    }

    private static void getMethodLabel(IMethodBinding iMethodBinding, long l, StringBuffer stringBuffer) {
        int n;
        ITypeBinding[] iTypeBindingArray;
        if ((l & 4L) != 0L && iMethodBinding.isGenericMethod() && (iTypeBindingArray = iMethodBinding.getTypeParameters()).length > 0) {
            BindingLabelProvider.getTypeParametersLabel(iTypeBindingArray, l & 0x200000L, stringBuffer);
            stringBuffer.append(' ');
        }
        if ((l & 0x40L) != 0L && !iMethodBinding.isConstructor()) {
            BindingLabelProvider.getTypeLabel(iMethodBinding.getReturnType(), l & 0x200000L, stringBuffer);
            stringBuffer.append(' ');
        }
        if ((l & 0x80L) != 0L) {
            BindingLabelProvider.getTypeLabel(iMethodBinding.getDeclaringClass(), 0x40000L | l & 0x2000000000L, stringBuffer);
            stringBuffer.append('.');
        }
        stringBuffer.append(iMethodBinding.getName());
        if ((l & 8L) != 0L && iMethodBinding.isParameterizedMethod() && (iTypeBindingArray = iMethodBinding.getTypeArguments()).length > 0) {
            stringBuffer.append(' ');
            BindingLabelProvider.getTypeArgumentsLabel(iTypeBindingArray, l & 0x200000L, stringBuffer);
        }
        stringBuffer.append('(');
        if ((l & 1L | 2L) != 0L) {
            ITypeBinding[] iTypeBindingArray2 = iTypeBindingArray = (l & 1L) != 0L ? iMethodBinding.getParameterTypes() : null;
            if (iTypeBindingArray != null) {
                n = 0;
                while (n < iTypeBindingArray.length) {
                    if (n > 0) {
                        stringBuffer.append(JavaElementLabels.COMMA_STRING);
                    }
                    ITypeBinding iTypeBinding = iTypeBindingArray[n];
                    if (iMethodBinding.isVarargs() && n == iTypeBindingArray.length - 1) {
                        BindingLabelProvider.getTypeLabel(iTypeBinding.getElementType(), l & 0x200000L, stringBuffer);
                        BindingLabelProvider.appendDimensions(iTypeBinding.getDimensions() - 1, stringBuffer);
                        stringBuffer.append("...");
                    } else {
                        BindingLabelProvider.getTypeLabel(iTypeBinding, l & 0x200000L, stringBuffer);
                    }
                    ++n;
                }
            }
        } else if (iMethodBinding.getParameterTypes().length > 0) {
            stringBuffer.append("...");
        }
        stringBuffer.append(')');
        if ((l & 0x10L) != 0L && (iTypeBindingArray = iMethodBinding.getExceptionTypes()).length > 0) {
            stringBuffer.append(" throws ");
            n = 0;
            while (n < iTypeBindingArray.length) {
                if (n > 0) {
                    stringBuffer.append(JavaElementLabels.COMMA_STRING);
                }
                BindingLabelProvider.getTypeLabel(iTypeBindingArray[n], l & 0x200000L, stringBuffer);
                ++n;
            }
        }
        if ((l & 8L) != 0L && iMethodBinding.isGenericMethod() && (iTypeBindingArray = iMethodBinding.getTypeParameters()).length > 0) {
            stringBuffer.append(' ');
            BindingLabelProvider.getTypeParametersLabel(iTypeBindingArray, l & 0x200000L, stringBuffer);
        }
        if ((l & 0x20L) != 0L && !iMethodBinding.isConstructor()) {
            stringBuffer.append(JavaElementLabels.DECL_STRING);
            BindingLabelProvider.getTypeLabel(iMethodBinding.getReturnType(), l & 0x200000L, stringBuffer);
        }
        if ((l & 0x100L) != 0L) {
            stringBuffer.append(JavaElementLabels.CONCAT_STRING);
            BindingLabelProvider.getTypeLabel(iMethodBinding.getDeclaringClass(), 0x40000L | l & 0x2000000000L, stringBuffer);
        }
    }

    private static ImageDescriptor getTypeImageDescriptor(boolean bl, ITypeBinding iTypeBinding, int n) {
        if (iTypeBinding.isEnum()) {
            return JavaPluginImages.DESC_OBJS_ENUM;
        }
        if (iTypeBinding.isAnnotation()) {
            return JavaPluginImages.DESC_OBJS_ANNOTATION;
        }
        if (iTypeBinding.isInterface()) {
            if ((n & 4) != 0) {
                return JavaPluginImages.DESC_OBJS_INTERFACEALT;
            }
            if (bl) {
                return BindingLabelProvider.getInnerInterfaceImageDescriptor(iTypeBinding.getModifiers());
            }
            return BindingLabelProvider.getInterfaceImageDescriptor(iTypeBinding.getModifiers());
        }
        if (iTypeBinding.isClass()) {
            if ((n & 4) != 0) {
                return JavaPluginImages.DESC_OBJS_CLASSALT;
            }
            if (bl) {
                return BindingLabelProvider.getInnerClassImageDescriptor(iTypeBinding.getModifiers());
            }
            return BindingLabelProvider.getClassImageDescriptor(iTypeBinding.getModifiers());
        }
        if (iTypeBinding.isTypeVariable()) {
            return JavaPluginImages.DESC_OBJS_TYPEVARIABLE;
        }
        return null;
    }

    private static void getTypeLabel(ITypeBinding iTypeBinding, long l, StringBuffer stringBuffer) {
        IPackageBinding iPackageBinding;
        ITypeBinding[] iTypeBindingArray;
        Object object;
        if ((l & 0x40000L) != 0L && (object = iTypeBinding.getPackage()) != null && !object.isUnnamed()) {
            stringBuffer.append(object.getName());
            stringBuffer.append('.');
        }
        if ((l & 0xC0000L) != 0L) {
            object = iTypeBinding.getDeclaringClass();
            if (object != null) {
                BindingLabelProvider.getTypeLabel((ITypeBinding)object, 0x80000L | l & 0x2000000000L, stringBuffer);
                stringBuffer.append('.');
            }
            if ((iTypeBindingArray = iTypeBinding.getDeclaringMethod()) != null) {
                BindingLabelProvider.getMethodLabel((IMethodBinding)iTypeBindingArray, 0L, stringBuffer);
                stringBuffer.append('.');
            }
        }
        if (iTypeBinding.isCapture()) {
            BindingLabelProvider.getTypeLabel(iTypeBinding.getWildcard(), l & 0x200000L, stringBuffer);
        } else if (iTypeBinding.isWildcardType()) {
            stringBuffer.append('?');
            object = iTypeBinding.getBound();
            if (object != null) {
                if (iTypeBinding.isUpperbound()) {
                    stringBuffer.append(" extends ");
                } else {
                    stringBuffer.append(" super ");
                }
                BindingLabelProvider.getTypeLabel((ITypeBinding)object, l & 0x200000L, stringBuffer);
            }
        } else if (iTypeBinding.isArray()) {
            BindingLabelProvider.getTypeLabel(iTypeBinding.getElementType(), l & 0x200000L, stringBuffer);
            BindingLabelProvider.appendDimensions(iTypeBinding.getDimensions(), stringBuffer);
        } else {
            object = iTypeBinding.getTypeDeclaration().getName();
            if (((String)object).length() == 0) {
                if (iTypeBinding.isEnum()) {
                    stringBuffer.append("{...}");
                } else if (iTypeBinding.isAnonymous()) {
                    iTypeBindingArray = iTypeBinding.getInterfaces();
                    iPackageBinding = iTypeBindingArray.length > 0 ? iTypeBindingArray[0] : iTypeBinding.getSuperclass();
                    if (iPackageBinding != null) {
                        StringBuffer stringBuffer2 = new StringBuffer();
                        BindingLabelProvider.getTypeLabel((ITypeBinding)iPackageBinding, l & 0x200000L, stringBuffer2);
                        stringBuffer.append(Messages.format(JavaUIMessages.JavaElementLabels_anonym_type, stringBuffer2.toString()));
                    } else {
                        stringBuffer.append(JavaUIMessages.JavaElementLabels_anonym);
                    }
                } else {
                    stringBuffer.append("UNKNOWN");
                }
            } else {
                stringBuffer.append((String)object);
            }
            if ((l & 0x200000L) != 0L) {
                if (iTypeBinding.isGenericType()) {
                    BindingLabelProvider.getTypeParametersLabel(iTypeBinding.getTypeParameters(), l, stringBuffer);
                } else if (iTypeBinding.isParameterizedType()) {
                    BindingLabelProvider.getTypeArgumentsLabel(iTypeBinding.getTypeArguments(), l, stringBuffer);
                }
            }
        }
        if ((l & 0x100000L) != 0L) {
            object = iTypeBinding.getDeclaringMethod();
            iTypeBindingArray = iTypeBinding.getDeclaringClass();
            if (object != null) {
                stringBuffer.append(JavaElementLabels.CONCAT_STRING);
                BindingLabelProvider.getMethodLabel((IMethodBinding)object, 0x40000L | l & 0x2000000000L, stringBuffer);
            } else if (iTypeBindingArray != null) {
                stringBuffer.append(JavaElementLabels.CONCAT_STRING);
                BindingLabelProvider.getTypeLabel((ITypeBinding)iTypeBindingArray, 0x40000L | l & 0x2000000000L, stringBuffer);
            } else {
                iPackageBinding = iTypeBinding.getPackage();
                if (iPackageBinding != null && !iPackageBinding.isUnnamed()) {
                    stringBuffer.append(JavaElementLabels.CONCAT_STRING);
                    stringBuffer.append(iPackageBinding.getName());
                }
            }
        }
    }

    private static void getTypeArgumentsLabel(ITypeBinding[] iTypeBindingArray, long l, StringBuffer stringBuffer) {
        if (iTypeBindingArray.length > 0) {
            stringBuffer.append('<');
            int n = 0;
            while (n < iTypeBindingArray.length) {
                if (n > 0) {
                    stringBuffer.append(JavaElementLabels.COMMA_STRING);
                }
                BindingLabelProvider.getTypeLabel(iTypeBindingArray[n], l & 0x200000L, stringBuffer);
                ++n;
            }
            stringBuffer.append('>');
        }
    }

    private static void getTypeParametersLabel(ITypeBinding[] iTypeBindingArray, long l, StringBuffer stringBuffer) {
        if (iTypeBindingArray.length > 0) {
            stringBuffer.append('<');
            int n = 0;
            while (n < iTypeBindingArray.length) {
                if (n > 0) {
                    stringBuffer.append(JavaElementLabels.COMMA_STRING);
                }
                stringBuffer.append(iTypeBindingArray[n].getName());
                ++n;
            }
            stringBuffer.append('>');
        }
    }

    public static String getBindingLabel(IBinding iBinding, long l) {
        StringBuffer stringBuffer = new StringBuffer(60);
        if (iBinding instanceof ITypeBinding) {
            BindingLabelProvider.getTypeLabel((ITypeBinding)iBinding, l, stringBuffer);
        } else if (iBinding instanceof IMethodBinding) {
            BindingLabelProvider.getMethodLabel((IMethodBinding)iBinding, l, stringBuffer);
        } else if (iBinding instanceof IVariableBinding) {
            IVariableBinding iVariableBinding = (IVariableBinding)iBinding;
            if (iVariableBinding.isField()) {
                BindingLabelProvider.getFieldLabel(iVariableBinding, l, stringBuffer);
            } else {
                BindingLabelProvider.getLocalVariableLabel(iVariableBinding, l, stringBuffer);
            }
        }
        return stringBuffer.toString();
    }

    public static ImageDescriptor getBindingImageDescriptor(IBinding iBinding, int n) {
        ImageDescriptor imageDescriptor = BindingLabelProvider.getBaseImageDescriptor(iBinding, n);
        if (imageDescriptor != null) {
            int n2 = BindingLabelProvider.getAdornmentFlags(iBinding, n);
            Point point = (n & 2) != 0 ? JavaElementImageProvider.SMALL_SIZE : JavaElementImageProvider.BIG_SIZE;
            return new JavaElementImageDescriptor(imageDescriptor, n2, point);
        }
        return null;
    }

    public BindingLabelProvider() {
        this(DEFAULT_TEXTFLAGS, 1);
    }

    public BindingLabelProvider(long l, int n) {
        this.fImageFlags = n;
        this.fTextFlags = l;
        this.fRegistry = null;
    }

    public Image getImage(Object object) {
        ImageDescriptor imageDescriptor;
        if (object instanceof IBinding && (imageDescriptor = BindingLabelProvider.getBindingImageDescriptor((IBinding)object, this.fImageFlags)) != null) {
            return this.getRegistry().get(imageDescriptor);
        }
        return super.getImage(object);
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = JavaPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    public String getText(Object object) {
        if (object instanceof IBinding) {
            return BindingLabelProvider.getBindingLabel((IBinding)object, this.fTextFlags);
        }
        return super.getText(object);
    }
}

