/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.TypeNameMatch;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.OpenTypeSelectionDialog;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.ui.wizards.NewTypeWizardPage;

public class SuperInterfaceSelectionDialog
extends OpenTypeSelectionDialog {
    private static final int ADD_ID = 1025;
    private NewTypeWizardPage fTypeWizardPage;
    private List fOldContent;

    public SuperInterfaceSelectionDialog(Shell shell, IRunnableContext iRunnableContext, NewTypeWizardPage newTypeWizardPage, IJavaProject iJavaProject) {
        super(shell, true, iRunnableContext, SuperInterfaceSelectionDialog.createSearchScope(iJavaProject), 6);
        this.fTypeWizardPage = newTypeWizardPage;
        this.fOldContent = this.fTypeWizardPage.getSuperInterfaces();
        this.setStatusLineAboveButtons(true);
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 1025, NewWizardMessages.SuperInterfaceSelectionDialog_addButton_label, true);
        super.createButtonsForButtonBar(composite);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return JavaPlugin.getDefault().getDialogSettingsSection("DialogBounds_SuperInterfaceSelectionDialog");
    }

    protected void updateButtonsEnableState(IStatus iStatus) {
        super.updateButtonsEnableState(iStatus);
        Button button = this.getButton(1025);
        if (button != null && !button.isDisposed()) {
            button.setEnabled(!iStatus.matches(4));
        }
    }

    protected void handleShellCloseEvent() {
        super.handleShellCloseEvent();
        this.fTypeWizardPage.setSuperInterfaces(this.fOldContent, true);
    }

    protected void cancelPressed() {
        this.fTypeWizardPage.setSuperInterfaces(this.fOldContent, true);
        super.cancelPressed();
    }

    protected void buttonPressed(int n) {
        if (n == 1025) {
            this.addSelectedInterfaces();
        } else {
            super.buttonPressed(n);
        }
    }

    protected void okPressed() {
        this.addSelectedInterfaces();
        super.okPressed();
    }

    private void addSelectedInterfaces() {
        StructuredSelection structuredSelection = this.getSelectedItems();
        if (structuredSelection == null) {
            return;
        }
        Iterator iterator = structuredSelection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof TypeNameMatch)) continue;
            this.accessedHistoryItem(e);
            TypeNameMatch typeNameMatch = (TypeNameMatch)e;
            String string = JavaModelUtil.getFullyQualifiedName(typeNameMatch.getType());
            String string2 = this.fTypeWizardPage.addSuperInterface(string) ? Messages.format(NewWizardMessages.SuperInterfaceSelectionDialog_interfaceadded_info, string) : Messages.format(NewWizardMessages.SuperInterfaceSelectionDialog_interfacealreadyadded_info, string);
            this.updateStatus(new StatusInfo(1, string2));
        }
    }

    private static IJavaSearchScope createSearchScope(IJavaProject iJavaProject) {
        return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaProject[]{iJavaProject});
    }

    protected void handleDoubleClick() {
        this.buttonPressed(1025);
    }

    protected void handleSelected(StructuredSelection structuredSelection) {
        super.handleSelected(structuredSelection);
        if (structuredSelection.size() == 0 && this.fTypeWizardPage.getSuperInterfaces().size() > this.fOldContent.size()) {
            this.updateStatus((IStatus)new Status(0, JavaPlugin.getPluginId(), 0, "", null));
            this.getButton(1025).setEnabled(false);
        } else {
            this.getButton(1025).setEnabled(this.getButton(0).isEnabled());
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.wst.jsdt.ui.super_interface_selection_dialog_context");
    }
}

