/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPVariableElement;

public class CPVariableElementLabelProvider
extends LabelProvider
implements IColorProvider {
    private Image fJARImage;
    private Image fFolderImage;
    private Color fResolvedBackground;
    private Image fDeprecatedJARImage;
    private Image fDeprecatedFolderImage;
    private boolean fHighlightReadOnly;

    public CPVariableElementLabelProvider(boolean bl) {
        ImageRegistry imageRegistry = JavaPlugin.getDefault().getImageRegistry();
        this.fJARImage = imageRegistry.get("org.eclipse.wst.jsdt.ui.jar_l_obj.gif");
        this.fFolderImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        this.fDeprecatedJARImage = new DecorationOverlayIcon(this.fJARImage, JavaPluginImages.DESC_OVR_DEPRECATED, 0).createImage();
        this.fDeprecatedFolderImage = new DecorationOverlayIcon(this.fFolderImage, JavaPluginImages.DESC_OVR_DEPRECATED, 0).createImage();
        this.fHighlightReadOnly = bl;
        this.fResolvedBackground = null;
    }

    public Image getImage(Object object) {
        if (object instanceof CPVariableElement) {
            CPVariableElement cPVariableElement = (CPVariableElement)object;
            IPath iPath = cPVariableElement.getPath();
            if (iPath.toFile().isFile()) {
                return cPVariableElement.isDeprecated() ? this.fDeprecatedJARImage : this.fJARImage;
            }
            return cPVariableElement.isDeprecated() ? this.fDeprecatedFolderImage : this.fFolderImage;
        }
        return super.getImage(object);
    }

    public String getText(Object object) {
        if (object instanceof CPVariableElement) {
            CPVariableElement cPVariableElement = (CPVariableElement)object;
            String string = cPVariableElement.getName();
            IPath iPath = cPVariableElement.getPath();
            String string2 = string;
            ArrayList<String> arrayList = new ArrayList<String>(2);
            if (cPVariableElement.isReadOnly() && this.fHighlightReadOnly) {
                arrayList.add(NewWizardMessages.CPVariableElementLabelProvider_read_only);
            }
            if (cPVariableElement.isDeprecated()) {
                arrayList.add(NewWizardMessages.CPVariableElementLabelProvider_deprecated);
            }
            if (arrayList.size() == 1) {
                string2 = Messages.format(NewWizardMessages.CPVariableElementLabelProvider_one_restriction, new Object[]{string2, arrayList.get(0)});
            } else if (arrayList.size() == 2) {
                string2 = Messages.format(NewWizardMessages.CPVariableElementLabelProvider_two_restrictions, new Object[]{string2, arrayList.get(0), arrayList.get(1)});
            }
            if (iPath != null) {
                String string3 = !iPath.isEmpty() ? iPath.toOSString() : NewWizardMessages.CPVariableElementLabelProvider_empty;
                string2 = Messages.format(NewWizardMessages.CPVariableElementLabelProvider_appendix, new Object[]{string2, string3});
            }
            return string2;
        }
        return super.getText(object);
    }

    public Color getForeground(Object object) {
        return null;
    }

    public Color getBackground(Object object) {
        if (object instanceof CPVariableElement) {
            CPVariableElement cPVariableElement = (CPVariableElement)object;
            if (this.fHighlightReadOnly && cPVariableElement.isReadOnly()) {
                if (this.fResolvedBackground == null) {
                    Display display = Display.getCurrent();
                    this.fResolvedBackground = display.getSystemColor(29);
                }
                return this.fResolvedBackground;
            }
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        this.fDeprecatedFolderImage.dispose();
        this.fDeprecatedJARImage.dispose();
    }
}

