/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.util.CoreUtility;
import org.eclipse.wst.jsdt.ui.wizards.ClasspathAttributeConfiguration;

public class ClasspathAttributeConfigurationDescriptors {
    private static final String ATT_EXTENSION = "classpathAttributeConfiguration";
    private HashMap fDescriptors = null;

    private HashMap getDescriptors() {
        if (this.fDescriptors == null) {
            this.fDescriptors = ClasspathAttributeConfigurationDescriptors.readExtensions();
        }
        return this.fDescriptors;
    }

    public boolean containsKey(String string) {
        return this.getDescriptors().containsKey(string);
    }

    public ClasspathAttributeConfiguration get(final String string) {
        final Descriptor descriptor = (Descriptor)this.getDescriptors().get(string);
        if (descriptor == null) {
            return null;
        }
        final ClasspathAttributeConfiguration[] classpathAttributeConfigurationArray = new ClasspathAttributeConfiguration[1];
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable throwable) {
                JavaPlugin.log(throwable);
                ClasspathAttributeConfigurationDescriptors.this.getDescriptors().remove(string);
            }

            public void run() throws Exception {
                classpathAttributeConfigurationArray[0] = descriptor.getInstance();
            }
        });
        return classpathAttributeConfigurationArray[0];
    }

    private static HashMap readExtensions() {
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.wst.jsdt.ui", ATT_EXTENSION);
        HashMap<String, Descriptor> hashMap = new HashMap<String, Descriptor>(iConfigurationElementArray.length * 2);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            try {
                Descriptor descriptor = new Descriptor(iConfigurationElementArray[n]);
                hashMap.put(descriptor.getKey(), descriptor);
            }
            catch (CoreException coreException) {
                JavaPlugin.log(coreException);
            }
            ++n;
        }
        return hashMap;
    }

    private static class Descriptor {
        private IConfigurationElement fConfigElement;
        private ClasspathAttributeConfiguration fInstance;
        private static final String ATT_NAME = "attributeName";
        private static final String ATT_CLASS = "class";

        public Descriptor(IConfigurationElement iConfigurationElement) throws CoreException {
            this.fConfigElement = iConfigurationElement;
            this.fInstance = null;
            String string = iConfigurationElement.getAttribute(ATT_NAME);
            String string2 = iConfigurationElement.getAttribute(ATT_CLASS);
            if (string == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.ui", 0, "Invalid extension (missing attributeName)", null));
            }
            if (string2 == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.ui", 0, "Invalid extension (missing class name): " + string, null));
            }
        }

        public ClasspathAttributeConfiguration getInstance() throws CoreException {
            if (this.fInstance == null) {
                Object object = CoreUtility.createExtension(this.fConfigElement, ATT_CLASS);
                if (object instanceof ClasspathAttributeConfiguration) {
                    this.fInstance = (ClasspathAttributeConfiguration)object;
                } else {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.ui", 0, "Invalid extension (page not of type IClasspathContainerPage): " + this.getKey(), null));
                }
            }
            return this.fInstance;
        }

        public String getKey() {
            return this.fConfigElement.getAttribute(ATT_NAME);
        }
    }
}

