/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.LibrarySuperType;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathBasePage;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ObjectStringStatusButtonDialogField;
import org.eclipse.wst.jsdt.ui.wizards.BuildPathDialogAccess;

public class ClasspathOrderingWorkbookPage
extends BuildPathBasePage {
    private ListDialogField fClassPathList;
    private List allCpElements;
    private static final boolean HIDE_ALL_READONLY_CONTAINERS = true;
    private ObjectStringStatusButtonDialogField superTypeField;
    private IJavaProject fJavaProject;
    private Control fSWTControl;

    public ClasspathOrderingWorkbookPage(ListDialogField listDialogField) {
        this.fClassPathList = listDialogField;
        this.superTypeField = new ObjectStringStatusButtonDialogField(new OrderingWorkbookPageAdapter());
    }

    public ObjectStringStatusButtonDialogField getSuperField() {
        return this.superTypeField;
    }

    private String[] popupFieldSelectionDialog() {
        return new String[]{"Window", "Basic Browser Library"};
    }

    public Control getControl(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        this.superTypeField.setButtonLabel("Select && Re-order Libraries");
        this.superTypeField.setLabelText("JavaScript file 'SuperType'  ---\n  [Every (.js) file will inherit the 'SuperType' fields/methods]:");
        LayoutUtil.doDefaultLayout(composite2, new DialogField[]{this.fClassPathList, this.superTypeField}, true, -1, -1);
        LayoutUtil.setHorizontalGrabbing(this.fClassPathList.getListControl(null));
        int n = pixelConverter.convertWidthInCharsToPixels(24);
        this.fClassPathList.setButtonsMinWidth(n);
        this.fSWTControl = composite2;
        return composite2;
    }

    public List getSelection() {
        return this.fClassPathList.getSelectedElements();
    }

    public void setSelection(List list, boolean bl) {
        this.allCpElements = list;
        this.fClassPathList.selectElements((ISelection)new StructuredSelection(this.allCpElements));
    }

    private List filterNodes(List list) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof CPListElement && ((CPListElement)e).isJRE() || e instanceof CPListElement && ((CPListElement)e).isInNonModifiableContainer()) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public boolean isEntryKind(int n) {
        return true;
    }

    public void init(IJavaProject iJavaProject) {
        this.fJavaProject = iJavaProject;
    }

    public void setFocus() {
        this.fClassPathList.setFocus();
    }

    public void aboutToDispose() {
        this.fClassPathList.setElements(this.allCpElements);
    }

    public void aboutToShow() {
        this.allCpElements = this.fClassPathList.getElements();
        this.fClassPathList.setElements(this.filterNodes(this.fClassPathList.getElements()));
    }

    private LibrarySuperType openSuperTypeSelectionDialog(CPListElement[] cPListElementArray, LibrarySuperType librarySuperType) {
        LibrarySuperType librarySuperType2 = BuildPathDialogAccess.chooseSuperType(this.getShell(), cPListElementArray, librarySuperType, this.fJavaProject);
        return librarySuperType2;
    }

    private Shell getShell() {
        if (this.fSWTControl != null) {
            return this.fSWTControl.getShell();
        }
        return JavaPlugin.getActiveWorkbenchShell();
    }

    class OrderingWorkbookPageAdapter
    implements IStringButtonAdapter {
        OrderingWorkbookPageAdapter() {
        }

        public void changeControlPressed(DialogField dialogField) {
            if (dialogField == ClasspathOrderingWorkbookPage.this.superTypeField) {
                LibrarySuperType librarySuperType;
                CPListElement[] cPListElementArray = ClasspathOrderingWorkbookPage.this.allCpElements.toArray(new CPListElement[ClasspathOrderingWorkbookPage.this.allCpElements.size()]);
                Object object = ClasspathOrderingWorkbookPage.this.superTypeField.getValue();
                LibrarySuperType librarySuperType2 = null;
                if (object != null) {
                    librarySuperType2 = (LibrarySuperType)object;
                }
                if ((librarySuperType = ClasspathOrderingWorkbookPage.this.openSuperTypeSelectionDialog(cPListElementArray, librarySuperType2)) != null && librarySuperType != librarySuperType2) {
                    ClasspathOrderingWorkbookPage.this.superTypeField.setValue(librarySuperType);
                    IPath iPath = librarySuperType.getRawContainerPath();
                    Iterator iterator = ClasspathOrderingWorkbookPage.this.allCpElements.iterator();
                    CPListElement cPListElement = null;
                    int n = -1;
                    while (iterator.hasNext()) {
                        ++n;
                        CPListElement cPListElement2 = (CPListElement)iterator.next();
                        if (!cPListElement2.getPath().equals((Object)iPath)) continue;
                        cPListElement = cPListElement2;
                        break;
                    }
                    if (cPListElement != null) {
                        ClasspathOrderingWorkbookPage.this.allCpElements.add(0, ClasspathOrderingWorkbookPage.this.allCpElements.remove(n));
                    }
                    ClasspathOrderingWorkbookPage.this.fClassPathList.setElements(ClasspathOrderingWorkbookPage.this.filterNodes(ClasspathOrderingWorkbookPage.this.allCpElements));
                }
            }
        }
    }
}

