/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.AccessRulesDialog;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.AddSourceFolderWizard;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathBasePage;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathWizard;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElementSorter;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CreateMultipleSourceFoldersDialog;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.EditFilterWizard;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.NewContainerDialog;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.OutputLocationDialog;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.wst.jsdt.ui.actions.AbstractOpenWizardAction;
import org.eclipse.wst.jsdt.ui.wizards.BuildPathDialogAccess;

public class SourceContainerWorkbookPage
extends BuildPathBasePage {
    private ListDialogField fClassPathList;
    private IJavaProject fCurrJProject;
    private Control fSWTControl;
    private TreeListDialogField fFoldersList;
    private final int IDX_ADD = 0;
    private final int IDX_ADD_LINK = 1;
    private final int IDX_ADDEXT = 3;
    private final int IDX_ADDJAR = 4;
    private final int IDX_ADDVAR = 5;
    private final int IDX_EDIT = 7;
    private final int IDX_REMOVE = 8;

    private static AddSourceFolderWizard newSourceFolderWizard(CPListElement cPListElement, List list, String string, boolean bl) {
        CPListElement[] cPListElementArray = list.toArray(new CPListElement[list.size()]);
        AddSourceFolderWizard addSourceFolderWizard = new AddSourceFolderWizard(cPListElementArray, cPListElement, new Path(string).makeAbsolute(), false, bl, bl, bl ? CPListElement.isProjectSourceFolder(cPListElementArray, cPListElement.getJavaProject()) : false, bl);
        addSourceFolderWizard.setDoFlushChange(false);
        return addSourceFolderWizard;
    }

    private static AddSourceFolderWizard newLinkedSourceFolderWizard(CPListElement cPListElement, List list, String string, boolean bl) {
        CPListElement[] cPListElementArray = list.toArray(new CPListElement[list.size()]);
        AddSourceFolderWizard addSourceFolderWizard = new AddSourceFolderWizard(cPListElementArray, cPListElement, new Path(string).makeAbsolute(), true, bl, bl, bl ? CPListElement.isProjectSourceFolder(cPListElementArray, cPListElement.getJavaProject()) : false, bl);
        addSourceFolderWizard.setDoFlushChange(false);
        return addSourceFolderWizard;
    }

    private static EditFilterWizard newEditFilterWizard(CPListElement cPListElement, List list, String string) {
        CPListElement[] cPListElementArray = list.toArray(new CPListElement[list.size()]);
        EditFilterWizard editFilterWizard = new EditFilterWizard(cPListElementArray, cPListElement, new Path(string).makeAbsolute());
        editFilterWizard.setDoFlushChange(false);
        return editFilterWizard;
    }

    public SourceContainerWorkbookPage(ListDialogField listDialogField) {
        this.fClassPathList = listDialogField;
        this.fSWTControl = null;
        SourceContainerAdapter sourceContainerAdapter = new SourceContainerAdapter();
        String[] stringArray = new String[9];
        stringArray[0] = NewWizardMessages.SourceContainerWorkbookPage_folders_add_button;
        stringArray[1] = NewWizardMessages.SourceContainerWorkbookPage_folders_link_source_button;
        stringArray[3] = NewWizardMessages.LibrariesWorkbookPage_libraries_addextjar_button;
        stringArray[4] = NewWizardMessages.LibrariesWorkbookPage_libraries_addjar_button;
        stringArray[5] = NewWizardMessages.LibrariesWorkbookPage_libraries_addvariable_button;
        stringArray[7] = NewWizardMessages.SourceContainerWorkbookPage_folders_edit_button;
        stringArray[8] = NewWizardMessages.SourceContainerWorkbookPage_folders_remove_button;
        String[] stringArray2 = stringArray;
        this.fFoldersList = new TreeListDialogField(sourceContainerAdapter, stringArray2, (ILabelProvider)new CPListLabelProvider());
        this.fFoldersList.setDialogFieldListener(sourceContainerAdapter);
        this.fFoldersList.setLabelText(NewWizardMessages.SourceContainerWorkbookPage_folders_label);
        this.fFoldersList.setViewerComparator(new CPListElementSorter());
        this.fFoldersList.enableButton(7, false);
    }

    public void init(IJavaProject iJavaProject) {
        this.fCurrJProject = iJavaProject;
        if (Display.getCurrent() != null) {
            this.updateFoldersList();
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    SourceContainerWorkbookPage.this.updateFoldersList();
                }
            });
        }
    }

    private void updateFoldersList() {
        CPListElement cPListElement;
        if (this.fSWTControl == null || this.fSWTControl.isDisposed()) {
            return;
        }
        ArrayList<CPListElement> arrayList = new ArrayList<CPListElement>();
        List list = this.fClassPathList.getElements();
        int n = 0;
        while (n < list.size()) {
            cPListElement = (CPListElement)list.get(n);
            if (this.isEntryKind(cPListElement.getEntryKind())) {
                boolean bl;
                arrayList.add(cPListElement);
                boolean bl2 = bl = cPListElement.getAttribute("output") != null;
                if (bl) {
                    // empty if block
                }
            }
            ++n;
        }
        this.fFoldersList.setElements(arrayList);
        n = 0;
        while (n < arrayList.size()) {
            boolean bl;
            cPListElement = (CPListElement)arrayList.get(n);
            IPath[] iPathArray = (IPath[])cPListElement.getAttribute("exclusion");
            IPath[] iPathArray2 = (IPath[])cPListElement.getAttribute("inclusion");
            boolean bl3 = bl = cPListElement.getAttribute("output") != null;
            if (iPathArray != null && iPathArray2 != null && (iPathArray.length > 0 || iPathArray2.length > 0 || bl)) {
                this.fFoldersList.expandElement(cPListElement, 3);
            }
            ++n;
        }
    }

    public Control getControl(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        LayoutUtil.doDefaultLayout(composite2, new DialogField[]{this.fFoldersList}, true, -1, -1);
        LayoutUtil.setHorizontalGrabbing(this.fFoldersList.getTreeControl(null));
        int n = pixelConverter.convertWidthInCharsToPixels(24);
        this.fFoldersList.setButtonsMinWidth(n);
        this.fSWTControl = composite2;
        List list = this.fFoldersList.getElements();
        int n2 = 0;
        while (n2 < list.size()) {
            CPListElement cPListElement = (CPListElement)list.get(n2);
            IPath[] iPathArray = (IPath[])cPListElement.getAttribute("exclusion");
            IPath[] iPathArray2 = (IPath[])cPListElement.getAttribute("inclusion");
            IPath iPath = (IPath)cPListElement.getAttribute("output");
            if (iPathArray.length > 0 || iPathArray2.length > 0 || iPath != null) {
                this.fFoldersList.expandElement(cPListElement, 3);
            }
            ++n2;
        }
        return composite2;
    }

    private Shell getShell() {
        if (this.fSWTControl != null) {
            return this.fSWTControl.getShell();
        }
        return JavaPlugin.getActiveWorkbenchShell();
    }

    protected void sourcePageKeyPressed(TreeListDialogField treeListDialogField, KeyEvent keyEvent) {
        List list;
        if (treeListDialogField == this.fFoldersList && keyEvent.character == '\u007f' && keyEvent.stateMask == 0 && this.canRemove(list = treeListDialogField.getSelectedElements())) {
            this.removeEntry();
        }
    }

    protected void sourcePageDoubleClicked(TreeListDialogField treeListDialogField) {
        List list;
        if (treeListDialogField == this.fFoldersList && this.canEdit(list = treeListDialogField.getSelectedElements())) {
            this.editEntry();
        }
    }

    protected void sourcePageCustomButtonPressed(DialogField dialogField, int n) {
        Object object;
        Object object2;
        Object[] objectArray = null;
        if (dialogField == this.fFoldersList) {
            Object object3;
            if (n == 0) {
                Object object4;
                object3 = this.fCurrJProject.getProject();
                if (object3.exists() && this.hasFolders((IContainer)object3)) {
                    object2 = this.fFoldersList.getElements();
                    object = object2.toArray(new CPListElement[object2.size()]);
                    object4 = new CreateMultipleSourceFoldersDialog(this.fCurrJProject, (CPListElement[])object, "", this.getShell());
                    if (((CreateMultipleSourceFoldersDialog)((Object)object4)).open() == 0) {
                        this.refresh(((CreateMultipleSourceFoldersDialog)((Object)object4)).getInsertedElements(), ((CreateMultipleSourceFoldersDialog)((Object)object4)).getRemovedElements(), ((CreateMultipleSourceFoldersDialog)((Object)object4)).getModifiedElements(), ((CreateMultipleSourceFoldersDialog)((Object)object4)).getOutputLocation());
                    }
                } else {
                    object2 = new CPListElement(this.fCurrJProject, 3);
                    object = SourceContainerWorkbookPage.newSourceFolderWizard((CPListElement)object2, this.fFoldersList.getElements(), "", true);
                    object4 = new OpenBuildPathWizardAction((BuildPathWizard)((Object)object));
                    object4.run();
                }
            } else if (n == 1) {
                object3 = new CPListElement(this.fCurrJProject, 3);
                object2 = SourceContainerWorkbookPage.newLinkedSourceFolderWizard((CPListElement)object3, this.fFoldersList.getElements(), "", true);
                object = new OpenBuildPathWizardAction((BuildPathWizard)((Object)object2));
                ((AbstractOpenWizardAction)((Object)object)).run();
            } else if (n == 4) {
                objectArray = this.openJarFileDialog(null);
            } else if (n == 3) {
                objectArray = this.openExtJarFileDialog(null);
            } else if (n == 5) {
                objectArray = this.openVariableSelectionDialog(null);
            } else if (n == 7) {
                this.editEntry();
            } else if (n == 8) {
                this.removeEntry();
            }
        }
        if (objectArray != null) {
            int n2 = objectArray.length;
            object2 = this.fClassPathList.getElements();
            object = new ArrayList(n2);
            int n3 = 0;
            while (n3 < n2) {
                CPListElement cPListElement = objectArray[n3];
                if (!object2.contains(cPListElement) && !object.contains(cPListElement)) {
                    object.add(cPListElement);
                    cPListElement.setAttribute("sourcepath", BuildPathSupport.guessSourceAttachment(cPListElement));
                    cPListElement.setAttribute("javadoc_location", BuildPathSupport.guessJavadocLocation(cPListElement));
                }
                ++n3;
            }
            this.refresh((List)object, null, null, null);
            this.fClassPathList.addElements((List)object);
            this.fClassPathList.postSetSelection((ISelection)new StructuredSelection(objectArray));
        }
    }

    private CPListElement[] openJarFileDialog(CPListElement cPListElement) {
        IWorkspaceRoot iWorkspaceRoot = this.fCurrJProject.getProject().getWorkspace().getRoot();
        if (cPListElement == null) {
            IPath[] iPathArray = BuildPathDialogAccess.chooseJAREntries(this.getShell(), this.fCurrJProject.getPath(), this.getUsedJARFiles(cPListElement));
            if (iPathArray != null) {
                ArrayList<CPListElement> arrayList = new ArrayList<CPListElement>();
                int n = 0;
                while (n < iPathArray.length) {
                    IPath iPath = iPathArray[n];
                    IResource iResource = iWorkspaceRoot.findMember(iPath);
                    if (iResource instanceof IFile) {
                        arrayList.add(this.newCPLibraryElement(iResource));
                    }
                    ++n;
                }
                return arrayList.toArray(new CPListElement[arrayList.size()]);
            }
        } else {
            IResource iResource;
            IPath iPath = BuildPathDialogAccess.configureJAREntry(this.getShell(), cPListElement.getPath(), this.getUsedJARFiles(cPListElement));
            if (iPath != null && (iResource = iWorkspaceRoot.findMember(iPath)) instanceof IFile) {
                return new CPListElement[]{this.newCPLibraryElement(iResource)};
            }
        }
        return null;
    }

    private CPListElement[] openExtJarFileDialog(CPListElement cPListElement) {
        CPListElement cPListElement2 = null;
        if (cPListElement == null) {
            IPath[] iPathArray = BuildPathDialogAccess.chooseExternalJAREntries(this.getShell());
            if (iPathArray != null) {
                ArrayList<CPListElement> arrayList = new ArrayList<CPListElement>();
                int n = 0;
                while (n < iPathArray.length) {
                    cPListElement2 = new CPListElement(this.fCurrJProject, 1, iPathArray[n], null);
                    cPListElement2.setExported(true);
                    arrayList.add(cPListElement2);
                    ++n;
                }
                return arrayList.toArray(new CPListElement[arrayList.size()]);
            }
        } else {
            IPath iPath = BuildPathDialogAccess.configureExternalJAREntry(this.getShell(), cPListElement.getPath());
            if (iPath != null) {
                cPListElement2 = new CPListElement(this.fCurrJProject, 1, iPath, null);
                cPListElement2.setExported(true);
                return new CPListElement[]{cPListElement2};
            }
        }
        return null;
    }

    private IPath[] getUsedJARFiles(CPListElement cPListElement) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List list = this.fFoldersList.getElements();
        int n = 0;
        while (n < list.size()) {
            CPListElement cPListElement2 = (CPListElement)list.get(n);
            if (cPListElement2.getEntryKind() == 1 && cPListElement2 != cPListElement) {
                IResource iResource = cPListElement2.getResource();
                if (iResource instanceof IFile) {
                    arrayList.add(iResource.getFullPath());
                } else if (iResource instanceof IPath) {
                    arrayList.add(iResource);
                }
            }
            ++n;
        }
        return arrayList.toArray(new IPath[arrayList.size()]);
    }

    private CPListElement newCPLibraryElement(IResource iResource) {
        CPListElement cPListElement = new CPListElement(this.fCurrJProject, 1, iResource.getFullPath(), iResource);
        cPListElement.setExported(true);
        return cPListElement;
    }

    private CPListElement[] openVariableSelectionDialog(CPListElement cPListElement) {
        IPath iPath;
        List list = this.fFoldersList.getElements();
        ArrayList<IPath> arrayList = new ArrayList<IPath>(list.size());
        int n = 0;
        while (n < list.size()) {
            iPath = (IPath)list.get(n);
            if (iPath.getEntryKind() == 4) {
                arrayList.add(iPath.getPath());
            }
            ++n;
        }
        IPath[] iPathArray = arrayList.toArray(new IPath[arrayList.size()]);
        if (cPListElement == null) {
            iPath = BuildPathDialogAccess.chooseVariableEntries(this.getShell(), iPathArray);
            if (iPath != null) {
                ArrayList<CPListElement> arrayList2 = new ArrayList<CPListElement>();
                int n2 = 0;
                while (n2 < ((IPath)iPath).length) {
                    IPath iPath2 = iPath[n2];
                    CPListElement cPListElement2 = this.createCPVariableElement(iPath2);
                    if (!list.contains(cPListElement2)) {
                        arrayList2.add(cPListElement2);
                    }
                    ++n2;
                }
                return arrayList2.toArray(new CPListElement[arrayList2.size()]);
            }
        } else {
            iPath = BuildPathDialogAccess.configureVariableEntry(this.getShell(), cPListElement.getPath(), iPathArray);
            if (iPath != null) {
                return new CPListElement[]{this.createCPVariableElement(iPath)};
            }
        }
        return null;
    }

    private CPListElement createCPVariableElement(IPath iPath) {
        CPListElement cPListElement = new CPListElement(this.fCurrJProject, 4, iPath, null);
        IPath iPath2 = JavaCore.getResolvedVariablePath((IPath)iPath);
        cPListElement.setIsMissing(iPath2 == null || !iPath2.toFile().exists());
        return cPListElement;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasFolders(IContainer iContainer) {
        Object object;
        try {
            object = iContainer.members();
            int n = 0;
            while (n < ((Object)object).length) {
                if (object[n] instanceof IContainer) {
                    return true;
                }
                ++n;
            }
        }
        catch (CoreException coreException) {}
        if ((object = this.fFoldersList.getElements()).size() > 1) {
            return true;
        }
        if (object.size() == 0) {
            return false;
        }
        CPListElement cPListElement = (CPListElement)object.get(0);
        return !cPListElement.getPath().equals((Object)this.fCurrJProject.getPath());
    }

    private void editEntry() {
        List list = this.fFoldersList.getSelectedElements();
        if (list.size() != 1) {
            return;
        }
        Object e = list.get(0);
        if (this.fFoldersList.getIndexOfElement(e) != -1) {
            this.editElementEntry((CPListElement)e);
        } else if (e instanceof CPListElementAttribute) {
            this.editAttributeEntry((CPListElementAttribute)e);
        }
    }

    private void editElementEntry(CPListElement cPListElement) {
        Object object;
        Object object2;
        CPListElement[] cPListElementArray = null;
        if (cPListElement.getEntryKind() == 5) {
            cPListElementArray = this.openContainerSelectionDialog(cPListElement);
        } else if (cPListElement.getEntryKind() == 1) {
            object2 = cPListElement.getResource();
            if (object2 == null) {
                cPListElementArray = this.openExtJarFileDialog(cPListElement);
            } else if (object2.getType() == 2) {
                cPListElementArray = object2.exists() ? this.openClassFolderDialog(cPListElement) : this.openNewClassFolderDialog(cPListElement);
            } else if (object2.getType() == 1) {
                cPListElementArray = this.openJarFileDialog(cPListElement);
            }
        } else if (cPListElement.getEntryKind() == 4) {
            cPListElementArray = this.openVariableSelectionDialog(cPListElement);
        } else if (cPListElement.getLinkTarget() != null) {
            object2 = SourceContainerWorkbookPage.newLinkedSourceFolderWizard(cPListElement, this.fFoldersList.getElements(), "", false);
            object = new OpenBuildPathWizardAction((BuildPathWizard)((Object)object2));
            ((AbstractOpenWizardAction)((Object)object)).run();
        } else {
            object2 = SourceContainerWorkbookPage.newSourceFolderWizard(cPListElement, this.fFoldersList.getElements(), "", false);
            object = new OpenBuildPathWizardAction((BuildPathWizard)((Object)object2));
            ((AbstractOpenWizardAction)((Object)object)).run();
        }
        if (cPListElementArray != null && cPListElementArray.length > 0) {
            object2 = cPListElementArray[0];
            object2.setExported(cPListElement.isExported());
            object2.setAttributesFromExisting(cPListElement);
            object = new ArrayList(0);
            ArrayList<CPListElement> arrayList = new ArrayList<CPListElement>(0);
            ((ArrayList)object).add(object2);
            arrayList.add(cPListElement);
            this.refresh(arrayList, (List)object, null, null);
        }
    }

    private CPListElement[] openNewClassFolderDialog(CPListElement cPListElement) {
        String string = cPListElement == null ? NewWizardMessages.LibrariesWorkbookPage_NewClassFolderDialog_new_title : NewWizardMessages.LibrariesWorkbookPage_NewClassFolderDialog_edit_title;
        IProject iProject = this.fCurrJProject.getProject();
        NewContainerDialog newContainerDialog = new NewContainerDialog(this.getShell(), string, iProject, this.getUsedContainers(cPListElement), cPListElement);
        IPath iPath = iProject.getFullPath();
        newContainerDialog.setMessage(Messages.format(NewWizardMessages.LibrariesWorkbookPage_NewClassFolderDialog_description, iPath.toString()));
        if (newContainerDialog.open() == 0) {
            IFolder iFolder = newContainerDialog.getFolder();
            return new CPListElement[]{this.newCPLibraryElement((IResource)iFolder)};
        }
        return null;
    }

    private IPath[] getUsedContainers(CPListElement cPListElement) {
        List list;
        ArrayList arrayList = new ArrayList();
        if (this.fCurrJProject.exists()) {
            try {
                list = this.fCurrJProject.getOutputLocation();
                if (list != null && list.segmentCount() > 1) {
                    arrayList.add(list);
                }
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException.getStatus());
            }
        }
        list = this.fFoldersList.getElements();
        int n = 0;
        while (n < list.size()) {
            IResource iResource;
            CPListElement cPListElement2 = (CPListElement)list.get(n);
            if (cPListElement2.getEntryKind() == 1 && cPListElement2 != cPListElement && (iResource = cPListElement2.getResource()) instanceof IContainer && !iResource.equals((Object)cPListElement)) {
                arrayList.add(iResource.getFullPath());
            }
            ++n;
        }
        return arrayList.toArray(new IPath[arrayList.size()]);
    }

    private CPListElement[] openClassFolderDialog(CPListElement cPListElement) {
        IPath[] iPathArray;
        if (cPListElement == null && (iPathArray = BuildPathDialogAccess.chooseClassFolderEntries(this.getShell(), this.fCurrJProject.getPath(), this.getUsedContainers(cPListElement))) != null) {
            IWorkspaceRoot iWorkspaceRoot = this.fCurrJProject.getProject().getWorkspace().getRoot();
            ArrayList<CPListElement> arrayList = new ArrayList<CPListElement>();
            int n = 0;
            while (n < iPathArray.length) {
                IPath iPath = iPathArray[n];
                IResource iResource = iWorkspaceRoot.findMember(iPath);
                if (iResource instanceof IContainer) {
                    arrayList.add(this.newCPLibraryElement(iResource));
                }
                ++n;
            }
            return arrayList.toArray(new CPListElement[arrayList.size()]);
        }
        return null;
    }

    private CPListElement[] openContainerSelectionDialog(CPListElement cPListElement) {
        if (cPListElement == null) {
            IClasspathEntry[] iClasspathEntryArray = BuildPathDialogAccess.chooseContainerEntries(this.getShell(), this.fCurrJProject, this.getRawClasspath());
            if (iClasspathEntryArray != null) {
                CPListElement[] cPListElementArray = new CPListElement[iClasspathEntryArray.length];
                int n = 0;
                while (n < cPListElementArray.length) {
                    cPListElementArray[n] = new CPListElement(this.fCurrJProject, 5, iClasspathEntryArray[n].getPath(), null);
                    ++n;
                }
                return cPListElementArray;
            }
        } else {
            IClasspathEntry iClasspathEntry = BuildPathDialogAccess.configureContainerEntry(this.getShell(), cPListElement.getClasspathEntry(), this.fCurrJProject, this.getRawClasspath());
            if (iClasspathEntry != null) {
                CPListElement cPListElement2 = new CPListElement(this.fCurrJProject, 5, iClasspathEntry.getPath(), null);
                return new CPListElement[]{cPListElement2};
            }
        }
        return null;
    }

    private IClasspathEntry[] getRawClasspath() {
        IClasspathEntry[] iClasspathEntryArray = new IClasspathEntry[this.fClassPathList.getSize()];
        int n = 0;
        while (n < iClasspathEntryArray.length) {
            CPListElement cPListElement = (CPListElement)this.fClassPathList.getElement(n);
            iClasspathEntryArray[n] = cPListElement.getClasspathEntry();
            ++n;
        }
        return iClasspathEntryArray;
    }

    private void attributeUpdated(CPListElement cPListElement, String[] stringArray) {
        Object object = cPListElement.getParentContainer();
        if (object instanceof CPListElement) {
            IClasspathEntry iClasspathEntry = cPListElement.getClasspathEntry();
            this.updateContainerEntry(iClasspathEntry, stringArray, this.fCurrJProject, ((CPListElement)object).getPath());
        }
    }

    private void updateContainerEntry(final IClasspathEntry iClasspathEntry, final String[] stringArray, final IJavaProject iJavaProject, final IPath iPath) {
        try {
            IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                    BuildPathSupport.modifyClasspathEntry(null, iClasspathEntry, stringArray, iJavaProject, iPath, iProgressMonitor);
                }
            };
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(iWorkspaceRunnable));
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = NewWizardMessages.LibrariesWorkbookPage_configurecontainer_error_title;
            String string2 = NewWizardMessages.LibrariesWorkbookPage_configurecontainer_error_message;
            ExceptionHandler.handle(invocationTargetException, this.getShell(), string, string2);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void editAttributeEntry(CPListElementAttribute cPListElementAttribute) {
        String string = cPListElementAttribute.getKey();
        CPListElement cPListElement = cPListElementAttribute.getParent();
        if (string.equals("sourcepath")) {
            IClasspathEntry iClasspathEntry = BuildPathDialogAccess.configureSourceAttachment(this.getShell(), cPListElement.getClasspathEntry());
            if (iClasspathEntry != null) {
                cPListElement.setAttribute("sourcepath", iClasspathEntry.getSourceAttachmentPath());
                String[] stringArray = new String[]{"sourcepath"};
                this.attributeUpdated(cPListElement, stringArray);
                this.fFoldersList.refresh(cPListElementAttribute);
                this.fFoldersList.update(cPListElement);
                this.fClassPathList.refresh();
                this.updateEnabledState();
            }
        } else if (string.equals("accessrules")) {
            AccessRulesDialog accessRulesDialog = new AccessRulesDialog(this.getShell(), cPListElement, this.fCurrJProject, false);
            int n = accessRulesDialog.open();
            if (n == 0 || n == 10) {
                cPListElement.setAttribute("accessrules", accessRulesDialog.getAccessRules());
                String[] stringArray = new String[]{"accessrules"};
                this.attributeUpdated(cPListElement, stringArray);
                this.fFoldersList.refresh(cPListElementAttribute);
                this.fClassPathList.dialogFieldChanged();
                this.updateEnabledState();
            }
        } else if (string.equals("output")) {
            OutputLocationDialog outputLocationDialog = new OutputLocationDialog(this.getShell(), cPListElement, this.fClassPathList.getElements(), new Path("").makeAbsolute(), true);
            if (outputLocationDialog.open() == 0) {
                cPListElement.setAttribute("output", outputLocationDialog.getOutputLocation());
                this.fFoldersList.refresh();
                this.fClassPathList.dialogFieldChanged();
            }
        } else if (string.equals("exclusion") || string.equals("inclusion")) {
            EditFilterWizard editFilterWizard = SourceContainerWorkbookPage.newEditFilterWizard(cPListElementAttribute.getParent(), this.fFoldersList.getElements(), "");
            OpenBuildPathWizardAction openBuildPathWizardAction = new OpenBuildPathWizardAction(editFilterWizard);
            openBuildPathWizardAction.run();
        } else if (this.editCustomAttribute(this.getShell(), cPListElementAttribute)) {
            this.fFoldersList.refresh();
            this.fClassPathList.dialogFieldChanged();
        }
    }

    protected void sourcePageSelectionChanged(DialogField dialogField) {
        List list = this.fFoldersList.getSelectedElements();
        this.fFoldersList.enableButton(7, this.canEdit(list));
        this.fFoldersList.enableButton(8, this.canRemove(list));
        boolean bl = this.containsOnlyTopLevelEntries(list);
        this.fFoldersList.enableButton(0, bl);
    }

    private void removeEntry() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        List list = this.fFoldersList.getSelectedElements();
        int n = list.size() - 1;
        while (n >= 0) {
            object4 = list.get(n);
            if (object4 instanceof CPListElementAttribute) {
                object3 = (CPListElementAttribute)object4;
                object2 = ((CPListElementAttribute)object3).getKey();
                if (((CPListElementAttribute)object3).isBuiltIn()) {
                    object = null;
                    if (((String)object2).equals("exclusion") || ((String)object2).equals("inclusion")) {
                        object = new Path[]{};
                    }
                    ((CPListElementAttribute)object3).getParent().setAttribute((String)object2, object);
                } else {
                    this.removeCustomAttribute((CPListElementAttribute)object3);
                }
                list.remove(n);
            }
            --n;
        }
        if (list.isEmpty()) {
            this.fFoldersList.refresh();
            this.fClassPathList.dialogFieldChanged();
        } else {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object4 = (CPListElement)iterator.next();
                if (((CPListElement)object4).getEntryKind() != 3) continue;
                object3 = ClasspathModifier.removeFilters(((CPListElement)object4).getPath(), this.fCurrJProject, this.fFoldersList.getElements());
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (CPListElement)object2.next();
                    this.fFoldersList.refresh(object);
                    this.fFoldersList.expandElement(object, 3);
                }
            }
            this.fFoldersList.removeElements(list);
        }
    }

    private boolean canRemove(List list) {
        if (list.size() == 0) {
            return false;
        }
        int n = 0;
        while (n < list.size()) {
            Object object;
            Object e = list.get(n);
            if (e instanceof CPListElementAttribute) {
                object = (CPListElementAttribute)e;
                String string = ((CPListElementAttribute)object).getKey();
                if (((CPListElementAttribute)object).isBuiltIn() ? ("inclusion".equals(string) ? ((IPath[])((CPListElementAttribute)object).getValue()).length == 0 : ("exclusion".equals(string) ? ((IPath[])((CPListElementAttribute)object).getValue()).length == 0 : ((CPListElementAttribute)object).getValue() == null)) : !this.canRemoveCustomAttribute((CPListElementAttribute)object)) {
                    return false;
                }
            } else if (e instanceof CPListElement && ((CPListElement)(object = (CPListElement)e)).getParentContainer() != null) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean canEdit(List list) {
        if (list.size() != 1) {
            return false;
        }
        Object e = list.get(0);
        if (e instanceof CPListElement) {
            CPListElement cPListElement = (CPListElement)e;
            return !cPListElement.getPath().equals((Object)cPListElement.getJavaProject().getPath());
        }
        if (e instanceof CPListElementAttribute) {
            CPListElementAttribute cPListElementAttribute = (CPListElementAttribute)e;
            if (cPListElementAttribute.isBuiltIn()) {
                return true;
            }
            return this.canEditCustomAttribute(cPListElementAttribute);
        }
        return false;
    }

    private void sourcePageDialogFieldChanged(DialogField dialogField) {
        if (this.fCurrJProject == null) {
            return;
        }
        if (dialogField == this.fFoldersList) {
            this.updateClasspathList();
        }
    }

    private void updateClasspathList() {
        int n;
        List list = this.fFoldersList.getElements();
        List list2 = this.fClassPathList.getElements();
        int n2 = n = list2.size();
        int n3 = 0;
        int n4 = n - 1;
        while (n4 >= 0) {
            CPListElement cPListElement = (CPListElement)list2.get(n4);
            int n5 = cPListElement.getEntryKind();
            if (this.isEntryKind(n5)) {
                if (!list.remove(cPListElement)) {
                    list2.remove(n4);
                    n2 = n4;
                } else if (n2 == n) {
                    n3 = n4 + 1;
                }
            }
            --n4;
        }
        if (!list.isEmpty()) {
            n4 = Math.min(n3, n2);
            list2.addAll(n4, list);
        }
        if (n2 != n || !list.isEmpty()) {
            this.fClassPathList.setElements(list2);
        }
    }

    public List getSelection() {
        return this.fFoldersList.getSelectedElements();
    }

    public void setSelection(List list, boolean bl) {
        this.fFoldersList.selectElements((ISelection)new StructuredSelection(list));
        if (bl) {
            int n = 0;
            while (n < list.size()) {
                this.fFoldersList.expandElement(list.get(n), 1);
                ++n;
            }
        }
    }

    public boolean isEntryKind(int n) {
        return n == 3 || n == 1 || n == 4;
    }

    private void refresh(List list, List list2, List list3, IPath iPath) {
        CPListElement cPListElement;
        this.fFoldersList.addElements(list);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            cPListElement = (CPListElement)iterator.next();
            this.fFoldersList.expandElement(cPListElement, 3);
        }
        this.fFoldersList.removeElements(list2);
        iterator = list3.iterator();
        while (iterator.hasNext()) {
            cPListElement = (CPListElement)iterator.next();
            this.fFoldersList.refresh(cPListElement);
            this.fFoldersList.expandElement(cPListElement, 3);
        }
        this.fFoldersList.refresh();
        if (!list.isEmpty()) {
            this.fFoldersList.postSetSelection((ISelection)new StructuredSelection(list));
        }
    }

    private void updateEnabledState() {
        List list = this.fFoldersList.getSelectedElements();
        this.fFoldersList.enableButton(7, this.canEdit(list));
        this.fFoldersList.enableButton(8, this.canRemove(list));
        this.containsOnlyTopLevelEntries(list);
    }

    public void setFocus() {
        this.fFoldersList.setFocus();
    }

    private class OpenBuildPathWizardAction
    extends AbstractOpenWizardAction
    implements IPropertyChangeListener {
        private final BuildPathWizard fWizard;
        private final List fSelectedElements;

        public OpenBuildPathWizardAction(BuildPathWizard buildPathWizard) {
            this.fWizard = buildPathWizard;
            this.addPropertyChangeListener(this);
            this.fSelectedElements = SourceContainerWorkbookPage.this.fFoldersList.getSelectedElements();
        }

        protected INewWizard createWizard() throws CoreException {
            return this.fWizard;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getProperty().equals("result")) {
                if (propertyChangeEvent.getNewValue().equals(Boolean.TRUE)) {
                    this.finishWizard();
                } else {
                    this.fWizard.cancel();
                }
            }
        }

        protected void finishWizard() {
            List list = this.fWizard.getInsertedElements();
            SourceContainerWorkbookPage.this.refresh(list, this.fWizard.getRemovedElements(), this.fWizard.getModifiedElements(), this.fWizard.getOutputLocation());
            if (list.isEmpty()) {
                SourceContainerWorkbookPage.this.fFoldersList.postSetSelection((ISelection)new StructuredSelection(this.fSelectedElements));
            }
        }
    }

    private class SourceContainerAdapter
    implements ITreeListAdapter,
    IDialogFieldListener {
        private final Object[] EMPTY_ARR = new Object[0];

        private SourceContainerAdapter() {
        }

        public void customButtonPressed(TreeListDialogField treeListDialogField, int n) {
            SourceContainerWorkbookPage.this.sourcePageCustomButtonPressed(treeListDialogField, n);
        }

        public void selectionChanged(TreeListDialogField treeListDialogField) {
            SourceContainerWorkbookPage.this.sourcePageSelectionChanged(treeListDialogField);
        }

        public void doubleClicked(TreeListDialogField treeListDialogField) {
            SourceContainerWorkbookPage.this.sourcePageDoubleClicked(treeListDialogField);
        }

        public void keyPressed(TreeListDialogField treeListDialogField, KeyEvent keyEvent) {
            SourceContainerWorkbookPage.this.sourcePageKeyPressed(treeListDialogField, keyEvent);
        }

        public Object[] getChildren(TreeListDialogField treeListDialogField, Object object) {
            if (object instanceof CPListElement) {
                return ((CPListElement)object).getChildren(true);
            }
            return this.EMPTY_ARR;
        }

        public Object getParent(TreeListDialogField treeListDialogField, Object object) {
            if (object instanceof CPListElementAttribute) {
                return ((CPListElementAttribute)object).getParent();
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField treeListDialogField, Object object) {
            return object instanceof CPListElement;
        }

        public void dialogFieldChanged(DialogField dialogField) {
            SourceContainerWorkbookPage.this.sourcePageDialogFieldChanged(dialogField);
        }
    }
}

