/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.buildpath.BuildpathDelta;
import org.eclipse.wst.jsdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage.BuildpathModifierAction;

public class IncludeToBuildpathAction
extends BuildpathModifierAction {
    private final IRunnableContext fContext;

    public IncludeToBuildpathAction(IWorkbenchSite iWorkbenchSite) {
        this(iWorkbenchSite, null, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
    }

    public IncludeToBuildpathAction(IRunnableContext iRunnableContext, ISetSelectionTarget iSetSelectionTarget) {
        this(null, iSetSelectionTarget, iRunnableContext);
    }

    private IncludeToBuildpathAction(IWorkbenchSite iWorkbenchSite, ISetSelectionTarget iSetSelectionTarget, IRunnableContext iRunnableContext) {
        super(iWorkbenchSite, iSetSelectionTarget, 10);
        this.fContext = iRunnableContext;
        this.setText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Unexclude_label);
        this.setImageDescriptor(JavaPluginImages.DESC_ELCL_INCLUDE_ON_BUILDPATH);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Unexclude_tooltip);
        this.setDisabledImageDescriptor(JavaPluginImages.DESC_DLCL_INCLUDE_ON_BUILDPATH);
    }

    public String getDetailedDescription() {
        if (!this.isEnabled()) {
            return null;
        }
        if (this.getSelectedElements().size() != 1) {
            return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_Unexclude;
        }
        IResource iResource = (IResource)this.getSelectedElements().get(0);
        String string = ClasspathModifier.escapeSpecialChars(iResource.getName());
        if (iResource instanceof IContainer) {
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_UnexcludeFolder, string);
        }
        if (iResource instanceof IFile) {
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_UnexcludeFile, string);
        }
        return null;
    }

    public void run() {
        IResource iResource = (IResource)this.getSelectedElements().get(0);
        final IJavaProject iJavaProject = JavaCore.create((IProject)iResource.getProject());
        try {
            IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    try {
                        List list = IncludeToBuildpathAction.this.unExclude(IncludeToBuildpathAction.this.getSelectedElements(), iJavaProject, iProgressMonitor);
                        IncludeToBuildpathAction.this.selectAndReveal((ISelection)new StructuredSelection(list));
                    }
                    catch (CoreException coreException) {
                        throw new InvocationTargetException(coreException);
                    }
                }
            };
            this.fContext.run(false, false, iRunnableWithProgress);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof CoreException) {
                this.showExceptionDialog((CoreException)invocationTargetException.getCause(), NewWizardMessages.IncludeToBuildpathAction_ErrorTitle);
            } else {
                JavaPlugin.log(invocationTargetException);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    protected List unExclude(List list, IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws JavaModelException {
        Object object;
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            Object object2;
            iProgressMonitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_Including, 2 * list.size());
            List list2 = ClasspathModifier.getExistingEntries(iJavaProject);
            int n = 0;
            while (n < list.size()) {
                object2 = (IResource)list.get(n);
                IPackageFragmentRoot iPackageFragmentRoot = ClasspathModifier.getFragmentRoot(object2, iJavaProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                if (iPackageFragmentRoot != null) {
                    CPListElement cPListElement = ClasspathModifier.getClasspathEntry(list2, iPackageFragmentRoot);
                    ClasspathModifier.unExclude(object2, cPListElement, iJavaProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                }
                ++n;
            }
            ClasspathModifier.commitClassPath(list2, iJavaProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 4));
            BuildpathDelta buildpathDelta = new BuildpathDelta(this.getToolTipText());
            buildpathDelta.setNewEntries(list2.toArray(new CPListElement[list2.size()]));
            this.informListeners(buildpathDelta);
            object = object2 = ClasspathModifier.getCorrespondingElements(list, iJavaProject);
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean canHandle(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.size() == 0) {
            return false;
        }
        try {
            IJavaProject iJavaProject;
            IResource iResource;
            Iterator iterator = iStructuredSelection.iterator();
            do {
                if (!iterator.hasNext()) {
                    return true;
                }
                Object e = iterator.next();
                if (!(e instanceof IResource)) {
                    return false;
                }
                iResource = (IResource)e;
                iJavaProject = JavaCore.create((IProject)iResource.getProject());
                if (iJavaProject != null && iJavaProject.exists()) continue;
                return false;
            } while (ClasspathModifier.isExcluded(iResource, iJavaProject));
            return false;
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

