/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.buildpath.BuildpathDelta;
import org.eclipse.wst.jsdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage.BuildpathModifierAction;

public class ResetAllOutputFoldersAction
extends BuildpathModifierAction {
    private final IRunnableContext fContext;
    private final IJavaProject fJavaProject;

    public ResetAllOutputFoldersAction(IRunnableContext iRunnableContext, IJavaProject iJavaProject, ISetSelectionTarget iSetSelectionTarget) {
        this(null, iSetSelectionTarget, iRunnableContext, iJavaProject);
    }

    public ResetAllOutputFoldersAction(IWorkbenchSite iWorkbenchSite, ISetSelectionTarget iSetSelectionTarget, IRunnableContext iRunnableContext, IJavaProject iJavaProject) {
        super(iWorkbenchSite, iSetSelectionTarget, 17);
        this.fContext = iRunnableContext;
        this.fJavaProject = iJavaProject;
        this.setText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Reset_tooltip);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Reset_tooltip);
    }

    public String getDetailedDescription() {
        return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_ResetAllOutputFolders;
    }

    public void run() {
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                try {
                    ResetAllOutputFoldersAction.this.resetOutputFolders(ResetAllOutputFoldersAction.this.fJavaProject, iProgressMonitor);
                }
                catch (CoreException coreException) {
                    throw new InvocationTargetException(coreException);
                }
            }
        };
        try {
            this.fContext.run(false, false, iRunnableWithProgress);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof CoreException) {
                this.showExceptionDialog((CoreException)invocationTargetException.getCause(), NewWizardMessages.RemoveFromBuildpathAction_ErrorTitle);
            } else {
                JavaPlugin.log(invocationTargetException);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    private List resetOutputFolders(IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws JavaModelException {
        List list;
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray = iJavaProject.getPackageFragmentRoots();
            iProgressMonitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_ResetOutputFolder, iPackageFragmentRootArray.length + 10);
            ArrayList<CPListElementAttribute> arrayList = new ArrayList<CPListElementAttribute>();
            int n = 0;
            while (n < iPackageFragmentRootArray.length) {
                iProgressMonitor.worked(1);
                if (!iPackageFragmentRootArray[n].isArchive()) {
                    IClasspathEntry iClasspathEntry = iPackageFragmentRootArray[n].getRawClasspathEntry();
                    CPListElement cPListElement = CPListElement.createFromExisting(iClasspathEntry, iJavaProject);
                    CPListElementAttribute cPListElementAttribute = new CPListElementAttribute(cPListElement, "output", cPListElement.getAttribute("output"), true);
                    arrayList.add(cPListElementAttribute);
                }
                ++n;
            }
            list = this.reset(arrayList, iJavaProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 10));
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return list;
    }

    private List reset(List list, IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws JavaModelException {
        ArrayList<Object> arrayList;
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            iProgressMonitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_Resetting, list.size());
            List list2 = ClasspathModifier.getExistingEntries(iJavaProject);
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            int n = 0;
            while (n < list.size()) {
                Object object;
                CPListElement cPListElement;
                Object object2;
                Object e = list.get(n);
                if (e instanceof IJavaElement) {
                    object2 = (IJavaElement)e;
                    cPListElement = e instanceof IJavaProject ? iJavaProject.getPackageFragmentRoot(iJavaProject.getResource()) : (IPackageFragmentRoot)e;
                    object = ClasspathModifier.getClasspathEntry(list2, (IPackageFragmentRoot)cPListElement);
                    ClasspathModifier.resetFilters(object2, (CPListElement)object, iJavaProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    arrayList2.add(object2);
                } else {
                    object2 = ((CPListElementAttribute)e).getParent();
                    cPListElement = ClasspathModifier.getClasspathEntry(list2, (CPListElement)object2);
                    object = ClasspathModifier.resetOutputFolder(cPListElement, iJavaProject);
                    arrayList2.add(object);
                }
                ++n;
            }
            ClasspathModifier.commitClassPath(list2, iJavaProject, null);
            BuildpathDelta buildpathDelta = new BuildpathDelta(this.getToolTipText());
            buildpathDelta.setNewEntries(list2.toArray(new CPListElement[list2.size()]));
            this.informListeners(buildpathDelta);
            arrayList = arrayList2;
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return arrayList;
    }

    protected boolean canHandle(IStructuredSelection iStructuredSelection) {
        return true;
    }
}

