/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.launching;

import com.ibm.icu.text.MessageFormat;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.IAccessRule;
import org.eclipse.wst.jsdt.core.IClasspathAttribute;
import org.eclipse.wst.jsdt.core.IClasspathContainer;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.launching.IVMInstall;
import org.eclipse.wst.jsdt.launching.IVMInstallChangedListener;
import org.eclipse.wst.jsdt.launching.JavaRuntime;
import org.eclipse.wst.jsdt.launching.LaunchingMessages;
import org.eclipse.wst.jsdt.launching.LibraryLocation;
import org.eclipse.wst.jsdt.launching.PropertyChangeEvent;

public class JREContainer
implements IClasspathContainer {
    private IVMInstall fVMInstall = null;
    private IPath fPath = null;
    private static Map fgClasspathEntries = null;
    private static IAccessRule[] EMPTY_RULES = new IAccessRule[0];

    private static IClasspathEntry[] getClasspathEntries(IVMInstall iVMInstall) {
        IClasspathEntry[] iClasspathEntryArray;
        if (fgClasspathEntries == null) {
            fgClasspathEntries = new HashMap(10);
            new IVMInstallChangedListener(){

                public void defaultVMInstallChanged(IVMInstall iVMInstall, IVMInstall iVMInstall2) {
                }

                public void vmChanged(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getSource() != null) {
                        fgClasspathEntries.remove(propertyChangeEvent.getSource());
                    }
                }

                public void vmAdded(IVMInstall iVMInstall) {
                }

                public void vmRemoved(IVMInstall iVMInstall) {
                    fgClasspathEntries.remove(iVMInstall);
                }
            };
        }
        if ((iClasspathEntryArray = (IClasspathEntry[])fgClasspathEntries.get(iVMInstall)) == null) {
            iClasspathEntryArray = JREContainer.computeClasspathEntries(iVMInstall);
            fgClasspathEntries.put(iVMInstall, iClasspathEntryArray);
        }
        return iClasspathEntryArray;
    }

    private static IClasspathEntry[] computeClasspathEntries(IVMInstall iVMInstall) {
        LibraryLocation[] libraryLocationArray = iVMInstall.getLibraryLocations();
        boolean bl = false;
        if (libraryLocationArray == null) {
            libraryLocationArray = JavaRuntime.getLibraryLocations(iVMInstall);
            bl = true;
        }
        ArrayList<IClasspathEntry> arrayList = new ArrayList<IClasspathEntry>(libraryLocationArray.length);
        int n = 0;
        while (n < libraryLocationArray.length) {
            if (!libraryLocationArray[n].getSystemLibraryPath().isEmpty()) {
                IPath iPath;
                IPath iPath2 = libraryLocationArray[n].getSystemLibrarySourcePath();
                if (iPath2.isEmpty()) {
                    iPath2 = null;
                }
                if ((iPath = libraryLocationArray[n].getPackageRootPath()).isEmpty()) {
                    iPath = null;
                }
                URL uRL = libraryLocationArray[n].getJavadocLocation();
                if (bl && uRL == null) {
                    uRL = iVMInstall.getJavadocLocation();
                }
                IClasspathAttribute[] iClasspathAttributeArray = null;
                iClasspathAttributeArray = uRL == null ? new IClasspathAttribute[]{} : new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"javadoc_location", (String)uRL.toExternalForm())};
                arrayList.add(JavaCore.newLibraryEntry((IPath)libraryLocationArray[n].getSystemLibraryPath(), (IPath)iPath2, (IPath)iPath, (IAccessRule[])EMPTY_RULES, (IClasspathAttribute[])iClasspathAttributeArray, (boolean)false));
            }
            ++n;
        }
        return arrayList.toArray(new IClasspathEntry[arrayList.size()]);
    }

    public JREContainer(IVMInstall iVMInstall, IPath iPath) {
        this.fVMInstall = iVMInstall;
        this.fPath = iPath;
    }

    public IClasspathEntry[] getClasspathEntries() {
        return JREContainer.getClasspathEntries(this.fVMInstall);
    }

    public String getDescription() {
        return MessageFormat.format((String)LaunchingMessages.JREContainer_JRE_System_Library_1, (Object[])new String[0]);
    }

    public int getKind() {
        return 3;
    }

    public IPath getPath() {
        return this.fPath;
    }
}

