/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.launching;

public class ListenerList {
    private int fSize;
    private Object[] fListeners = null;
    private static final Object[] EmptyArray = new Object[0];

    public ListenerList(int n) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.fListeners = new Object[n];
        this.fSize = 0;
    }

    public synchronized void add(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while (n < this.fSize) {
            if (this.fListeners[n] == object) {
                return;
            }
            ++n;
        }
        if (this.fSize == this.fListeners.length) {
            Object[] objectArray = new Object[this.fSize * 2 + 1];
            System.arraycopy(this.fListeners, 0, objectArray, 0, this.fSize);
            this.fListeners = objectArray;
        }
        this.fListeners[this.fSize++] = object;
    }

    public synchronized Object[] getListeners() {
        if (this.fSize == 0) {
            return EmptyArray;
        }
        Object[] objectArray = new Object[this.fSize];
        System.arraycopy(this.fListeners, 0, objectArray, 0, this.fSize);
        return objectArray;
    }

    public synchronized void remove(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while (n < this.fSize) {
            if (this.fListeners[n] == object) {
                if (--this.fSize == 0) {
                    this.fListeners = new Object[1];
                } else {
                    if (n < this.fSize) {
                        this.fListeners[n] = this.fListeners[this.fSize];
                    }
                    this.fListeners[this.fSize] = null;
                }
                return;
            }
            ++n;
        }
    }

    public void removeAll() {
        this.fListeners = new Object[0];
        this.fSize = 0;
    }

    public int size() {
        return this.fSize;
    }
}

