/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui;

import java.util.regex.Pattern;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;

public class CodeStyleConfiguration {
    private static final Pattern SEMICOLON_PATTERN = Pattern.compile(";");

    private CodeStyleConfiguration() {
    }

    public static ImportRewrite createImportRewrite(ICompilationUnit iCompilationUnit, boolean bl) throws JavaModelException {
        return CodeStyleConfiguration.configureImportRewrite(ImportRewrite.create((ICompilationUnit)iCompilationUnit, (boolean)bl));
    }

    public static ImportRewrite createImportRewrite(CompilationUnit compilationUnit, boolean bl) {
        return CodeStyleConfiguration.configureImportRewrite(ImportRewrite.create((CompilationUnit)compilationUnit, (boolean)bl));
    }

    private static ImportRewrite configureImportRewrite(ImportRewrite importRewrite) {
        IJavaProject iJavaProject = importRewrite.getCompilationUnit().getJavaProject();
        String string = PreferenceConstants.getPreference("org.eclipse.wst.jsdt.ui.importorder", iJavaProject);
        importRewrite.setImportOrder(SEMICOLON_PATTERN.split(string, 0));
        String string2 = PreferenceConstants.getPreference("org.eclipse.wst.jsdt.ui.ondemandthreshold", iJavaProject);
        try {
            int n = Integer.parseInt(string2);
            if (n == 0) {
                n = 1;
            }
            importRewrite.setOnDemandImportThreshold(n);
        }
        catch (NumberFormatException numberFormatException) {}
        String string3 = PreferenceConstants.getPreference("org.eclipse.wst.jsdt.ui.staticondemandthreshold", iJavaProject);
        try {
            int n = Integer.parseInt(string3);
            if (n == 0) {
                n = 1;
            }
            importRewrite.setStaticOnDemandImportThreshold(n);
        }
        catch (NumberFormatException numberFormatException) {}
        return importRewrite;
    }
}

