/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class IntroduceIndirectionAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public IntroduceIndirectionAction(JavaEditor javaEditor) {
        this((IWorkbenchSite)javaEditor.getEditorSite());
        this.fEditor = javaEditor;
        this.setEnabled(true);
    }

    public IntroduceIndirectionAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(RefactoringMessages.IntroduceIndirectionAction_title);
        this.setToolTipText(RefactoringMessages.IntroduceIndirectionAction_tooltip);
        this.setDescription(RefactoringMessages.IntroduceIndirectionAction_description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.introduce_indirection_action");
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        block2: {
            try {
                this.setEnabled(RefactoringAvailabilityTester.isIntroduceIndirectionAvailable(iStructuredSelection));
            }
            catch (JavaModelException javaModelException) {
                if (!JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)javaModelException))) break block2;
                JavaPlugin.log(javaModelException);
            }
        }
    }

    public void selectionChanged(ITextSelection iTextSelection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection javaTextSelection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isIntroduceIndirectionAvailable(javaTextSelection));
        }
        catch (JavaModelException javaModelException) {
            this.setEnabled(false);
        }
    }

    public void run(IStructuredSelection iStructuredSelection) {
        try {
            Assert.isTrue((boolean)RefactoringAvailabilityTester.isIntroduceIndirectionAvailable(iStructuredSelection));
            Object object = iStructuredSelection.getFirstElement();
            Assert.isTrue((boolean)(object instanceof IMethod));
            this.run((IMethod)object);
        }
        catch (CoreException coreException) {
            ExceptionHandler.handle(coreException, RefactoringMessages.IntroduceIndirectionAction_dialog_title, RefactoringMessages.IntroduceIndirectionAction_unknown_exception);
        }
    }

    public void run(ITextSelection iTextSelection) {
        try {
            IJavaElement iJavaElement = SelectionConverter.getInput(this.fEditor);
            if (iJavaElement instanceof ICompilationUnit) {
                this.run(iTextSelection.getOffset(), iTextSelection.getLength(), (ICompilationUnit)iJavaElement);
            } else if (iJavaElement instanceof IClassFile) {
                this.run(iTextSelection.getOffset(), iTextSelection.getLength(), (IClassFile)iJavaElement);
            }
        }
        catch (JavaModelException javaModelException) {
            ExceptionHandler.handle((CoreException)((Object)javaModelException), this.getShell(), RefactoringMessages.IntroduceIndirectionAction_dialog_title, RefactoringMessages.IntroduceIndirectionAction_unknown_exception);
        }
    }

    private void run(int n, int n2, ICompilationUnit iCompilationUnit) throws JavaModelException {
        if (!ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaElement)iCompilationUnit)) {
            return;
        }
        RefactoringExecutionStarter.startIntroduceIndirectionRefactoring(iCompilationUnit, n, n2, this.getShell());
    }

    private void run(int n, int n2, IClassFile iClassFile) throws JavaModelException {
        if (!ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaElement)iClassFile)) {
            return;
        }
        RefactoringExecutionStarter.startIntroduceIndirectionRefactoring(iClassFile, n, n2, this.getShell());
    }

    private void run(IMethod iMethod) throws JavaModelException {
        if (!ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaElement)iMethod)) {
            return;
        }
        RefactoringExecutionStarter.startIntroduceIndirectionRefactoring(iMethod, this.getShell());
    }
}

