/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.ui.actions.OpenAction;

public class OpenEditorActionGroup
extends ActionGroup {
    private IWorkbenchSite fSite;
    private boolean fIsEditorOwner;
    private OpenAction fOpen;
    static /* synthetic */ Class class$0;

    public OpenEditorActionGroup(IViewPart iViewPart) {
        this.fSite = iViewPart.getSite();
        this.fOpen = new OpenAction(this.fSite);
        this.fOpen.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.open.editor");
        this.initialize(this.fSite.getSelectionProvider());
    }

    public OpenEditorActionGroup(JavaEditor javaEditor) {
        this.fIsEditorOwner = true;
        this.fOpen = new OpenAction(javaEditor);
        this.fOpen.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.open.editor");
        javaEditor.setAction("OpenEditor", (IAction)this.fOpen);
        this.fSite = javaEditor.getEditorSite();
        this.initialize(this.fSite.getSelectionProvider());
    }

    public IAction getOpenAction() {
        return this.fOpen;
    }

    private void initialize(ISelectionProvider iSelectionProvider) {
        ISelection iSelection = iSelectionProvider.getSelection();
        this.fOpen.update(iSelection);
        if (!this.fIsEditorOwner) {
            iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.fOpen);
        }
    }

    public void fillActionBars(IActionBars iActionBars) {
        super.fillActionBars(iActionBars);
        this.setGlobalActionHandlers(iActionBars);
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        super.fillContextMenu(iMenuManager);
        this.appendToGroup(iMenuManager, (IAction)this.fOpen);
        if (!this.fIsEditorOwner) {
            this.addOpenWithMenu(iMenuManager);
        }
    }

    public void dispose() {
        ISelectionProvider iSelectionProvider = this.fSite.getSelectionProvider();
        iSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fOpen);
        super.dispose();
    }

    private void setGlobalActionHandlers(IActionBars iActionBars) {
        iActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.Open", (IAction)this.fOpen);
    }

    private void appendToGroup(IMenuManager iMenuManager, IAction iAction) {
        if (iAction.isEnabled()) {
            iMenuManager.appendToGroup("group.open", iAction);
        }
    }

    private void addOpenWithMenu(IMenuManager iMenuManager) {
        Object object;
        ISelection iSelection = this.getContext().getSelection();
        if (iSelection.isEmpty() || !(iSelection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        if (iStructuredSelection.size() != 1) {
            return;
        }
        Object object2 = iStructuredSelection.getFirstElement();
        if (!(object2 instanceof IAdaptable)) {
            return;
        }
        IAdaptable iAdaptable = (IAdaptable)object2;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!((object = iAdaptable.getAdapter((Class)clazz)) instanceof IFile)) {
            return;
        }
        MenuManager menuManager = new MenuManager(ActionMessages.OpenWithMenu_label);
        menuManager.add((IContributionItem)new OpenWithMenu(this.fSite.getPage(), (IAdaptable)((IFile)object)));
        iMenuManager.appendToGroup("group.open", (IContributionItem)menuManager);
    }
}

