/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.wst.jsdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.JavaUI;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class OpenSuperImplementationAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public OpenSuperImplementationAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(ActionMessages.OpenSuperImplementationAction_label);
        this.setDescription(ActionMessages.OpenSuperImplementationAction_description);
        this.setToolTipText(ActionMessages.OpenSuperImplementationAction_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.open_super_implementation_action");
    }

    public OpenSuperImplementationAction(IWorkbenchSite iWorkbenchSite, ISelectionProvider iSelectionProvider) {
        this(iWorkbenchSite);
        this.setSpecialSelectionProvider(iSelectionProvider);
    }

    public OpenSuperImplementationAction(JavaEditor javaEditor) {
        this((IWorkbenchSite)javaEditor.getEditorSite());
        this.fEditor = javaEditor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(ITextSelection iTextSelection) {
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        IMethod iMethod = this.getMethod(iStructuredSelection);
        this.setEnabled(iMethod != null && this.checkMethod(iMethod));
    }

    public void run(ITextSelection iTextSelection) {
        if (!ActionUtil.isProcessable(this.fEditor)) {
            return;
        }
        IJavaElement iJavaElement = this.elementAtOffset();
        if (iJavaElement == null || !(iJavaElement instanceof IMethod)) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)OpenSuperImplementationAction.getDialogTitle(), (String)ActionMessages.OpenSuperImplementationAction_not_applicable);
            return;
        }
        this.run((IMethod)iJavaElement);
    }

    public void run(IStructuredSelection iStructuredSelection) {
        this.run(this.getMethod(iStructuredSelection));
    }

    public void run(IMethod iMethod) {
        if (iMethod == null) {
            return;
        }
        if (!ActionUtil.isProcessable(this.getShell(), (IJavaElement)iMethod)) {
            return;
        }
        if (!this.checkMethod(iMethod)) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)OpenSuperImplementationAction.getDialogTitle(), (String)Messages.format(ActionMessages.OpenSuperImplementationAction_no_super_implementation, iMethod.getElementName()));
            return;
        }
        try {
            IMethod iMethod2 = this.findSuperImplementation(iMethod);
            if (iMethod2 != null) {
                JavaUI.openInEditor((IJavaElement)iMethod2, true, true);
            }
        }
        catch (CoreException coreException) {
            ExceptionHandler.handle(coreException, OpenSuperImplementationAction.getDialogTitle(), ActionMessages.OpenSuperImplementationAction_error_message);
        }
    }

    private IMethod findSuperImplementation(IMethod iMethod) throws JavaModelException {
        MethodOverrideTester methodOverrideTester = SuperTypeHierarchyCache.getMethodOverrideTester(iMethod.getDeclaringType());
        return methodOverrideTester.findOverriddenMethod(iMethod, false);
    }

    private IMethod getMethod(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.size() != 1) {
            return null;
        }
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof IMethod) {
            return (IMethod)object;
        }
        return null;
    }

    private boolean checkMethod(IMethod iMethod) {
        block3: {
            IType iType;
            block4: {
                int n = iMethod.getFlags();
                if (Flags.isStatic((int)n) || Flags.isPrivate((int)n)) break block3;
                iType = iMethod.getDeclaringType();
                if (iType != null) break block4;
                return false;
            }
            try {
                return !SuperTypeHierarchyCache.hasInCache(iType) || this.findSuperImplementation(iMethod) != null;
            }
            catch (JavaModelException javaModelException) {
                if (javaModelException.isDoesNotExist()) break block3;
                JavaPlugin.log(javaModelException);
            }
        }
        return false;
    }

    private IJavaElement elementAtOffset() {
        try {
            return SelectionConverter.getElementAtOffset(this.fEditor);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    private static String getDialogTitle() {
        return ActionMessages.OpenSuperImplementationAction_error_title;
    }
}

