/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.OpenTypeHierarchyUtil;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class OpenTypeHierarchyAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public OpenTypeHierarchyAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(ActionMessages.OpenTypeHierarchyAction_label);
        this.setToolTipText(ActionMessages.OpenTypeHierarchyAction_tooltip);
        this.setDescription(ActionMessages.OpenTypeHierarchyAction_description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.open_type_hierarchy_action");
    }

    public OpenTypeHierarchyAction(IWorkbenchSite iWorkbenchSite, ISelectionProvider iSelectionProvider) {
        this(iWorkbenchSite);
        this.setSpecialSelectionProvider(iSelectionProvider);
    }

    public OpenTypeHierarchyAction(JavaEditor javaEditor) {
        this((IWorkbenchSite)javaEditor.getEditorSite());
        this.fEditor = javaEditor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(ITextSelection iTextSelection) {
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.setEnabled(this.isEnabled(iStructuredSelection));
    }

    private boolean isEnabled(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.size() != 1) {
            return false;
        }
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof LogicalPackage) {
            return true;
        }
        if (!(object instanceof IJavaElement)) {
            return false;
        }
        switch (((IJavaElement)object).getElementType()) {
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    public void run(ITextSelection iTextSelection) {
        IJavaElement iJavaElement = SelectionConverter.getInput(this.fEditor);
        if (!ActionUtil.isProcessable(this.getShell(), iJavaElement)) {
            return;
        }
        try {
            IJavaElement[] iJavaElementArray = SelectionConverter.codeResolveOrInputForked(this.fEditor);
            if (iJavaElementArray == null) {
                return;
            }
            ArrayList<IJavaElement> arrayList = new ArrayList<IJavaElement>(iJavaElementArray.length);
            int n = 0;
            while (n < iJavaElementArray.length) {
                IJavaElement[] iJavaElementArray2 = OpenTypeHierarchyUtil.getCandidates(iJavaElementArray[n]);
                if (iJavaElementArray2 != null) {
                    arrayList.addAll(Arrays.asList(iJavaElementArray2));
                }
                ++n;
            }
            this.run(arrayList.toArray(new IJavaElement[arrayList.size()]));
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionHandler.handle(invocationTargetException, this.getShell(), OpenTypeHierarchyAction.getDialogTitle(), ActionMessages.SelectionConverter_codeResolve_failed);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void run(IStructuredSelection iStructuredSelection) {
        IStatus iStatus;
        if (iStructuredSelection.size() != 1) {
            return;
        }
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof LogicalPackage) {
            iStatus = ((LogicalPackage)((Object)object)).getFragments();
            if (((IPackageFragment[])iStatus).length == 0) {
                return;
            }
            object = iStatus[0];
        }
        if (!(object instanceof IJavaElement)) {
            iStatus = OpenTypeHierarchyAction.createStatus(ActionMessages.OpenTypeHierarchyAction_messages_no_java_element);
            ErrorDialog.openError((Shell)this.getShell(), (String)OpenTypeHierarchyAction.getDialogTitle(), (String)ActionMessages.OpenTypeHierarchyAction_messages_title, (IStatus)iStatus);
            return;
        }
        iStatus = (IJavaElement)object;
        if (!ActionUtil.isProcessable(this.getShell(), (IJavaElement)iStatus)) {
            return;
        }
        ArrayList arrayList = new ArrayList(1);
        IStatus iStatus2 = OpenTypeHierarchyAction.compileCandidates(arrayList, (IJavaElement)iStatus);
        if (iStatus2.isOK()) {
            this.run(arrayList.toArray(new IJavaElement[arrayList.size()]));
        } else {
            ErrorDialog.openError((Shell)this.getShell(), (String)OpenTypeHierarchyAction.getDialogTitle(), (String)ActionMessages.OpenTypeHierarchyAction_messages_title, (IStatus)iStatus2);
        }
    }

    public void run(IJavaElement[] iJavaElementArray) {
        if (iJavaElementArray.length == 0) {
            this.getShell().getDisplay().beep();
            return;
        }
        OpenTypeHierarchyUtil.open(iJavaElementArray, this.getSite().getWorkbenchWindow());
    }

    private static String getDialogTitle() {
        return ActionMessages.OpenTypeHierarchyAction_dialog_title;
    }

    private static IStatus compileCandidates(List list, IJavaElement object) {
        Status status = new Status(0, JavaPlugin.getPluginId(), 0, "", null);
        try {
            switch (object.getElementType()) {
                case 2: 
                case 3: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    list.add(object);
                    return status;
                }
                case 4: {
                    if (((IPackageFragment)object).containsJavaResources()) {
                        list.add(object);
                        return status;
                    }
                    return OpenTypeHierarchyAction.createStatus(ActionMessages.OpenTypeHierarchyAction_messages_no_java_resources);
                }
                case 11: {
                    list.add(object.getAncestor(4));
                    return status;
                }
                case 13: {
                    IImportDeclaration iImportDeclaration = (IImportDeclaration)object;
                    object = iImportDeclaration.isOnDemand() ? JavaModelUtil.findTypeContainer(object.getJavaProject(), Signature.getQualifier((String)object.getElementName())) : object.getJavaProject().findType(object.getElementName());
                    if (object != null) {
                        list.add(object);
                        return status;
                    }
                    return OpenTypeHierarchyAction.createStatus(ActionMessages.OpenTypeHierarchyAction_messages_unknown_import_decl);
                }
                case 6: {
                    list.add(((IClassFile)object).getType());
                    return status;
                }
                case 5: {
                    ICompilationUnit iCompilationUnit = (ICompilationUnit)object;
                    IType[] iTypeArray = iCompilationUnit.getTypes();
                    if (iTypeArray.length > 0) {
                        list.addAll(Arrays.asList(iTypeArray));
                        return status;
                    }
                    return OpenTypeHierarchyAction.createStatus(ActionMessages.OpenTypeHierarchyAction_messages_no_types);
                }
            }
        }
        catch (JavaModelException javaModelException) {
            return javaModelException.getStatus();
        }
        return OpenTypeHierarchyAction.createStatus(ActionMessages.OpenTypeHierarchyAction_messages_no_valid_java_element);
    }

    private static IStatus createStatus(String string) {
        return new Status(1, JavaPlugin.getPluginId(), 10001, string, null);
    }
}

