/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.text.java;

import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.jsdt.core.CompletionContext;
import org.eclipse.wst.jsdt.core.CompletionRequestor;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.text.java.ContentAssistHistory;
import org.eclipse.wst.jsdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.wst.jsdt.ui.text.java.CompletionProposalLabelProvider;
import org.eclipse.wst.jsdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposal;

public class JavaContentAssistInvocationContext
extends ContentAssistInvocationContext {
    private final IEditorPart fEditor;
    private ICompilationUnit fCU = null;
    private boolean fCUComputed = false;
    private CompletionProposalLabelProvider fLabelProvider;
    private CompletionProposalCollector fCollector;
    private ContentAssistHistory.RHSHistory fRHSHistory;
    private IType fType;
    private IJavaCompletionProposal[] fKeywordProposals = null;
    private CompletionContext fCoreContext = null;

    public JavaContentAssistInvocationContext(ITextViewer iTextViewer, int n, IEditorPart iEditorPart) {
        super(iTextViewer, n);
        this.fEditor = iEditorPart;
    }

    public JavaContentAssistInvocationContext(ICompilationUnit iCompilationUnit) {
        this.fCU = iCompilationUnit;
        this.fCUComputed = true;
        this.fEditor = null;
    }

    public ICompilationUnit getCompilationUnit() {
        if (!this.fCUComputed) {
            this.fCUComputed = true;
            if (this.fCollector != null) {
                this.fCU = this.fCollector.getCompilationUnit();
            } else {
                IJavaElement iJavaElement = EditorUtility.getEditorInputJavaElement(this.fEditor, false);
                if (iJavaElement instanceof ICompilationUnit) {
                    this.fCU = (ICompilationUnit)iJavaElement;
                }
            }
        }
        return this.fCU;
    }

    public IJavaProject getProject() {
        ICompilationUnit iCompilationUnit = this.getCompilationUnit();
        return iCompilationUnit == null ? null : iCompilationUnit.getJavaProject();
    }

    public IJavaCompletionProposal[] getKeywordProposals() {
        if (this.fKeywordProposals == null) {
            if (this.fCollector != null && !this.fCollector.isIgnored(3) && this.fCollector.getContext() != null) {
                this.fKeywordProposals = this.fCollector.getKeywordCompletionProposals();
            } else {
                this.computeKeywordsAndContext();
            }
        }
        return this.fKeywordProposals;
    }

    public CompletionContext getCoreContext() {
        if (this.fCoreContext == null) {
            if (this.fCollector != null) {
                this.fCoreContext = this.fCollector.getContext();
            }
            if (this.fCoreContext == null) {
                this.computeKeywordsAndContext();
            }
        }
        return this.fCoreContext;
    }

    public float getHistoryRelevance(String string) {
        return this.getRHSHistory().getRank(string);
    }

    private ContentAssistHistory.RHSHistory getRHSHistory() {
        if (this.fRHSHistory == null) {
            char[][] cArray;
            CompletionContext completionContext = this.getCoreContext();
            if (completionContext != null && (cArray = completionContext.getExpectedTypesSignatures()) != null && cArray.length > 0) {
                String string = SignatureUtil.stripSignatureToFQN(String.valueOf(cArray[0]));
                this.fRHSHistory = JavaPlugin.getDefault().getContentAssistHistory().getHistory(string);
            }
            if (this.fRHSHistory == null) {
                this.fRHSHistory = JavaPlugin.getDefault().getContentAssistHistory().getHistory(null);
            }
        }
        return this.fRHSHistory;
    }

    public IType getExpectedType() {
        IJavaProject iJavaProject;
        char[][] cArray;
        CompletionContext completionContext;
        if (this.fType == null && this.getCompilationUnit() != null && (completionContext = this.getCoreContext()) != null && (cArray = completionContext.getExpectedTypesSignatures()) != null && cArray.length > 0 && (iJavaProject = this.getCompilationUnit().getJavaProject()) != null) {
            try {
                this.fType = iJavaProject.findType(SignatureUtil.stripSignatureToFQN(String.valueOf(cArray[0])));
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
        }
        return this.fType;
    }

    public CompletionProposalLabelProvider getLabelProvider() {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = this.fCollector != null ? this.fCollector.getLabelProvider() : new CompletionProposalLabelProvider();
        }
        return this.fLabelProvider;
    }

    protected void setCollector(CompletionProposalCollector completionProposalCollector) {
        this.fCollector = completionProposalCollector;
    }

    private void computeKeywordsAndContext() {
        block7: {
            ICompilationUnit iCompilationUnit = this.getCompilationUnit();
            if (iCompilationUnit == null) {
                if (this.fKeywordProposals == null) {
                    this.fKeywordProposals = new IJavaCompletionProposal[0];
                }
                return;
            }
            CompletionProposalCollector completionProposalCollector = new CompletionProposalCollector(iCompilationUnit);
            completionProposalCollector.setIgnored(3, false);
            completionProposalCollector.setIgnored(13, true);
            completionProposalCollector.setIgnored(1, true);
            completionProposalCollector.setIgnored(2, true);
            completionProposalCollector.setIgnored(4, true);
            completionProposalCollector.setIgnored(5, true);
            completionProposalCollector.setIgnored(7, true);
            completionProposalCollector.setIgnored(12, true);
            completionProposalCollector.setIgnored(6, true);
            completionProposalCollector.setIgnored(8, true);
            completionProposalCollector.setIgnored(11, true);
            completionProposalCollector.setIgnored(10, true);
            completionProposalCollector.setIgnored(19, true);
            completionProposalCollector.setIgnored(14, true);
            completionProposalCollector.setIgnored(20, true);
            completionProposalCollector.setIgnored(15, true);
            completionProposalCollector.setIgnored(18, true);
            completionProposalCollector.setIgnored(16, true);
            completionProposalCollector.setIgnored(17, true);
            completionProposalCollector.setIgnored(9, true);
            try {
                iCompilationUnit.codeComplete(this.getInvocationOffset(), (CompletionRequestor)completionProposalCollector);
                if (this.fCoreContext == null) {
                    this.fCoreContext = completionProposalCollector.getContext();
                }
                if (this.fKeywordProposals == null) {
                    this.fKeywordProposals = completionProposalCollector.getKeywordCompletionProposals();
                }
                if (this.fLabelProvider == null) {
                    this.fLabelProvider = completionProposalCollector.getLabelProvider();
                }
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
                if (this.fKeywordProposals != null) break block7;
                this.fKeywordProposals = new IJavaCompletionProposal[0];
            }
        }
    }
}

