/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.IViewPartInputProvider;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.wst.jsdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.wst.jsdt.ui.JavaElementComparator;
import org.eclipse.wst.jsdt.ui.JavaElementLabelProvider;
import org.eclipse.wst.jsdt.ui.StandardJavaElementContentProvider;
import org.eclipse.wst.jsdt.ui.wizards.NewElementWizardPage;

public abstract class NewContainerWizardPage
extends NewElementWizardPage {
    protected static final String CONTAINER = "NewContainerWizardPage.container";
    protected IStatus fContainerStatus;
    private StringButtonDialogField fContainerDialogField;
    private IPackageFragmentRoot fCurrRoot;
    private IWorkspaceRoot fWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public NewContainerWizardPage(String string) {
        super(string);
        ContainerFieldAdapter containerFieldAdapter = new ContainerFieldAdapter();
        this.fContainerDialogField = new StringButtonDialogField(containerFieldAdapter);
        this.fContainerDialogField.setDialogFieldListener(containerFieldAdapter);
        this.fContainerDialogField.setLabelText(this.getContainerLabel());
        this.fContainerDialogField.setButtonLabel(NewWizardMessages.NewContainerWizardPage_container_button);
        this.fContainerStatus = new StatusInfo();
        this.fCurrRoot = null;
    }

    protected String getContainerLabel() {
        return NewWizardMessages.NewContainerWizardPage_container_label;
    }

    protected void initContainerPage(IJavaElement iJavaElement) {
        IPackageFragmentRoot iPackageFragmentRoot = null;
        if (iJavaElement != null) {
            iPackageFragmentRoot = JavaModelUtil.getPackageFragmentRoot(iJavaElement);
            try {
                IJavaProject iJavaProject;
                if ((iPackageFragmentRoot == null || iPackageFragmentRoot.getKind() != 1) && (iJavaProject = iJavaElement.getJavaProject()) != null) {
                    iPackageFragmentRoot = null;
                    if (iJavaProject.exists()) {
                        IPackageFragmentRoot[] iPackageFragmentRootArray = iJavaProject.getPackageFragmentRoots();
                        int n = 0;
                        while (n < iPackageFragmentRootArray.length) {
                            if (iPackageFragmentRootArray[n].getKind() == 1) {
                                iPackageFragmentRoot = iPackageFragmentRootArray[n];
                                break;
                            }
                            ++n;
                        }
                    }
                    if (iPackageFragmentRoot == null) {
                        iPackageFragmentRoot = iJavaProject.getPackageFragmentRoot(iJavaProject.getResource());
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
        }
        this.setPackageFragmentRoot(iPackageFragmentRoot, true);
    }

    protected IJavaElement getInitialJavaElement(IStructuredSelection iStructuredSelection) {
        Object object;
        IEditorPart iEditorPart;
        IEditorPart iEditorPart2 = null;
        if (iStructuredSelection != null && !iStructuredSelection.isEmpty() && (iEditorPart = iStructuredSelection.getFirstElement()) instanceof IAdaptable) {
            object = (IAdaptable)iEditorPart;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iEditorPart2 = (IJavaElement)object.getAdapter((Class)clazz)) == null) {
                IResource iResource;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iResource = (IResource)object.getAdapter((Class)clazz2)) != null && iResource.getType() != 8) {
                    while (iEditorPart2 == null && iResource.getType() != 4) {
                        iResource = iResource.getParent();
                        Class<?> clazz3 = class$0;
                        if (clazz3 == null) {
                            try {
                                clazz3 = Class.forName("org.eclipse.wst.jsdt.core.IJavaElement");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        iEditorPart2 = (IJavaElement)iResource.getAdapter((Class)clazz3);
                    }
                    if (iEditorPart2 == null) {
                        iEditorPart2 = JavaCore.create((IResource)iResource);
                    }
                }
            }
        }
        if (iEditorPart2 == null) {
            iEditorPart = JavaPlugin.getActivePage().getActivePart();
            if (iEditorPart instanceof ContentOutline) {
                iEditorPart = JavaPlugin.getActivePage().getActiveEditor();
            }
            if (iEditorPart instanceof IViewPartInputProvider && (object = ((IViewPartInputProvider)iEditorPart).getViewPartInput()) instanceof IJavaElement) {
                iEditorPart2 = (IJavaElement)object;
            }
        }
        if (iEditorPart2 == null || iEditorPart2.getElementType() == 1) {
            try {
                iEditorPart = JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot()).getJavaProjects();
                if (((IEditorPart)iEditorPart).length == 1) {
                    iEditorPart2 = iEditorPart[0];
                }
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
        }
        return iEditorPart2;
    }

    protected ITextSelection getCurrentTextSelection() {
        ISelection iSelection;
        ISelectionProvider iSelectionProvider;
        IWorkbenchPart iWorkbenchPart = JavaPlugin.getActivePage().getActivePart();
        if (iWorkbenchPart instanceof IEditorPart && (iSelectionProvider = iWorkbenchPart.getSite().getSelectionProvider()) != null && (iSelection = iSelectionProvider.getSelection()) instanceof ITextSelection) {
            return (ITextSelection)iSelection;
        }
        return null;
    }

    protected int getMaxFieldWidth() {
        return this.convertWidthInCharsToPixels(40);
    }

    protected void createContainerControls(Composite composite, int n) {
        this.fContainerDialogField.doFillIntoGrid(composite, n);
        LayoutUtil.setWidthHint((Control)this.fContainerDialogField.getTextControl(null), this.getMaxFieldWidth());
    }

    protected void setFocusOnContainer() {
        this.fContainerDialogField.setFocus();
    }

    private void containerChangeControlPressed(DialogField dialogField) {
        IPackageFragmentRoot iPackageFragmentRoot = this.chooseContainer();
        if (iPackageFragmentRoot != null) {
            this.setPackageFragmentRoot(iPackageFragmentRoot, true);
        }
    }

    private void containerDialogFieldChanged(DialogField dialogField) {
        if (dialogField == this.fContainerDialogField) {
            this.fContainerStatus = this.containerChanged();
        }
        this.handleFieldChanged(CONTAINER);
    }

    protected IStatus containerChanged() {
        StatusInfo statusInfo = new StatusInfo();
        this.fCurrRoot = null;
        String string = this.getPackageFragmentRootText();
        if (string.length() == 0) {
            statusInfo.setError(NewWizardMessages.NewContainerWizardPage_error_EnterContainerName);
            return statusInfo;
        }
        Path path = new Path(string);
        IResource iResource = this.fWorkspaceRoot.findMember((IPath)path);
        if (iResource != null) {
            int n = iResource.getType();
            if (n == 4 || n == 2) {
                IProject iProject = iResource.getProject();
                if (!iProject.isOpen()) {
                    statusInfo.setError(Messages.format(NewWizardMessages.NewContainerWizardPage_error_ProjectClosed, iProject.getFullPath().toString()));
                    return statusInfo;
                }
                IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
                this.fCurrRoot = iJavaProject.getPackageFragmentRoot(iResource);
                if (iResource.exists()) {
                    try {
                        if (!iProject.hasNature("org.eclipse.wst.jsdt.core.jsNature")) {
                            if (n == 4) {
                                statusInfo.setError(NewWizardMessages.NewContainerWizardPage_warning_NotAJavaProject);
                            } else {
                                statusInfo.setWarning(NewWizardMessages.NewContainerWizardPage_warning_NotInAJavaProject);
                            }
                            return statusInfo;
                        }
                        if (this.fCurrRoot.isArchive()) {
                            statusInfo.setError(Messages.format(NewWizardMessages.NewContainerWizardPage_error_ContainerIsBinary, string));
                            return statusInfo;
                        }
                        if (this.fCurrRoot.getKind() == 2) {
                            statusInfo.setWarning(Messages.format(NewWizardMessages.NewContainerWizardPage_warning_inside_classfolder, string));
                        } else if (!iJavaProject.isOnClasspath((IJavaElement)this.fCurrRoot)) {
                            statusInfo.setWarning(Messages.format(NewWizardMessages.NewContainerWizardPage_warning_NotOnClassPath, string));
                        }
                    }
                    catch (CoreException coreException) {
                        statusInfo.setWarning(NewWizardMessages.NewContainerWizardPage_warning_NotAJavaProject);
                    }
                }
                return statusInfo;
            }
            statusInfo.setError(Messages.format(NewWizardMessages.NewContainerWizardPage_error_NotAFolder, string));
            return statusInfo;
        }
        statusInfo.setError(Messages.format(NewWizardMessages.NewContainerWizardPage_error_ContainerDoesNotExist, string));
        return statusInfo;
    }

    protected void handleFieldChanged(String string) {
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return this.fWorkspaceRoot;
    }

    public IJavaProject getJavaProject() {
        IPackageFragmentRoot iPackageFragmentRoot = this.getPackageFragmentRoot();
        if (iPackageFragmentRoot != null) {
            return iPackageFragmentRoot.getJavaProject();
        }
        return null;
    }

    public IPackageFragmentRoot getPackageFragmentRoot() {
        return this.fCurrRoot;
    }

    public String getPackageFragmentRootText() {
        return this.fContainerDialogField.getText();
    }

    public void setPackageFragmentRoot(IPackageFragmentRoot iPackageFragmentRoot, boolean bl) {
        this.fCurrRoot = iPackageFragmentRoot;
        String string = iPackageFragmentRoot == null ? "" : iPackageFragmentRoot.getPath().makeRelative().toString();
        this.fContainerDialogField.setText(string);
        this.fContainerDialogField.setEnabled(bl);
    }

    protected IPackageFragmentRoot chooseContainer() {
        IPackageFragmentRoot iPackageFragmentRoot = this.getPackageFragmentRoot();
        Class[] classArray = new Class[2];
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.wst.jsdt.core.IPackageFragmentRoot");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            try {
                clazz2 = class$3 = Class.forName("org.eclipse.wst.jsdt.core.IJavaProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class[] classArray2 = classArray;
        TypedElementSelectionValidator typedElementSelectionValidator = new TypedElementSelectionValidator(classArray2, false){

            public boolean isSelectedValid(Object object) {
                try {
                    if (object instanceof IJavaProject) {
                        IJavaProject iJavaProject = (IJavaProject)object;
                        IPath iPath = iJavaProject.getProject().getFullPath();
                        return iJavaProject.findPackageFragmentRoot(iPath) != null;
                    }
                    if (object instanceof IPackageFragmentRoot) {
                        return ((IPackageFragmentRoot)object).getKind() == 1;
                    }
                    return true;
                }
                catch (JavaModelException javaModelException) {
                    JavaPlugin.log(javaModelException.getStatus());
                    return false;
                }
            }
        };
        Class[] classArray3 = new Class[3];
        Class<?> clazz3 = class$4;
        if (clazz3 == null) {
            try {
                clazz3 = class$4 = Class.forName("org.eclipse.wst.jsdt.core.IJavaModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray3[0] = clazz3;
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("org.eclipse.wst.jsdt.core.IPackageFragmentRoot");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray3[1] = clazz4;
        Class<?> clazz5 = class$3;
        if (clazz5 == null) {
            try {
                clazz5 = class$3 = Class.forName("org.eclipse.wst.jsdt.core.IJavaProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray3[2] = clazz5;
        classArray2 = classArray3;
        TypedViewerFilter typedViewerFilter = new TypedViewerFilter(classArray2){

            public boolean select(Viewer viewer, Object object, Object object2) {
                if (object2 instanceof IPackageFragmentRoot) {
                    try {
                        return ((IPackageFragmentRoot)object2).getKind() == 1;
                    }
                    catch (JavaModelException javaModelException) {
                        JavaPlugin.log(javaModelException.getStatus());
                        return false;
                    }
                }
                return super.select(viewer, object, object2);
            }
        };
        StandardJavaElementContentProvider standardJavaElementContentProvider = new StandardJavaElementContentProvider();
        JavaElementLabelProvider javaElementLabelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementTreeSelectionDialog elementTreeSelectionDialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)javaElementLabelProvider, (ITreeContentProvider)standardJavaElementContentProvider);
        elementTreeSelectionDialog.setValidator((ISelectionStatusValidator)typedElementSelectionValidator);
        elementTreeSelectionDialog.setComparator((ViewerComparator)new JavaElementComparator());
        elementTreeSelectionDialog.setTitle(NewWizardMessages.NewContainerWizardPage_ChooseSourceContainerDialog_title);
        elementTreeSelectionDialog.setMessage(NewWizardMessages.NewContainerWizardPage_ChooseSourceContainerDialog_description);
        elementTreeSelectionDialog.addFilter((ViewerFilter)typedViewerFilter);
        elementTreeSelectionDialog.setInput((Object)JavaCore.create((IWorkspaceRoot)this.fWorkspaceRoot));
        elementTreeSelectionDialog.setInitialSelection((Object)iPackageFragmentRoot);
        elementTreeSelectionDialog.setHelpAvailable(false);
        if (elementTreeSelectionDialog.open() == 0) {
            Object object = elementTreeSelectionDialog.getFirstResult();
            if (object instanceof IJavaProject) {
                IJavaProject iJavaProject = (IJavaProject)object;
                return iJavaProject.getPackageFragmentRoot((IResource)iJavaProject.getProject());
            }
            if (object instanceof IPackageFragmentRoot) {
                return (IPackageFragmentRoot)object;
            }
            return null;
        }
        return null;
    }

    private class ContainerFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private ContainerFieldAdapter() {
        }

        public void changeControlPressed(DialogField dialogField) {
            NewContainerWizardPage.this.containerChangeControlPressed(dialogField);
        }

        public void dialogFieldChanged(DialogField dialogField) {
            NewContainerWizardPage.this.containerDialogFieldChanged(dialogField);
        }
    }
}

