/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core;

public final class Flags {
    public static final int AccDefault = 0;
    public static final int AccPublic = 1;
    public static final int AccPrivate = 2;
    public static final int AccProtected = 4;
    public static final int AccStatic = 8;
    public static final int AccFinal = 16;
    public static final int AccSynchronized = 32;
    public static final int AccVolatile = 64;
    public static final int AccTransient = 128;
    public static final int AccNative = 256;
    public static final int AccInterface = 512;
    public static final int AccAbstract = 1024;
    public static final int AccStrictfp = 2048;
    public static final int AccSuper = 32;
    public static final int AccSynthetic = 4096;
    public static final int AccDeprecated = 0x100000;
    public static final int AccBridge = 64;
    public static final int AccVarargs = 128;
    public static final int AccEnum = 16384;
    public static final int AccAnnotation = 8192;

    private Flags() {
    }

    public static boolean isAbstract(int n) {
        return (n & 0x400) != 0;
    }

    public static boolean isDeprecated(int n) {
        return (n & 0x100000) != 0;
    }

    public static boolean isFinal(int n) {
        return (n & 0x10) != 0;
    }

    public static boolean isInterface(int n) {
        return (n & 0x200) != 0;
    }

    public static boolean isNative(int n) {
        return (n & 0x100) != 0;
    }

    public static boolean isPackageDefault(int n) {
        return (n & 7) == 0;
    }

    public static boolean isPrivate(int n) {
        return (n & 2) != 0;
    }

    public static boolean isProtected(int n) {
        return (n & 4) != 0;
    }

    public static boolean isPublic(int n) {
        return (n & 1) != 0;
    }

    public static boolean isStatic(int n) {
        return (n & 8) != 0;
    }

    public static boolean isSuper(int n) {
        return (n & 0x20) != 0;
    }

    public static boolean isStrictfp(int n) {
        return (n & 0x800) != 0;
    }

    public static boolean isSynchronized(int n) {
        return (n & 0x20) != 0;
    }

    public static boolean isSynthetic(int n) {
        return (n & 0x1000) != 0;
    }

    public static boolean isTransient(int n) {
        return (n & 0x80) != 0;
    }

    public static boolean isVolatile(int n) {
        return (n & 0x40) != 0;
    }

    public static boolean isBridge(int n) {
        return (n & 0x40) != 0;
    }

    public static boolean isVarargs(int n) {
        return (n & 0x80) != 0;
    }

    public static boolean isEnum(int n) {
        return (n & 0x4000) != 0;
    }

    public static boolean isAnnotation(int n) {
        return (n & 0x2000) != 0;
    }

    public static String toString(int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        if (Flags.isPublic(n)) {
            stringBuffer.append("public ");
        }
        if (Flags.isProtected(n)) {
            stringBuffer.append("protected ");
        }
        if (Flags.isPrivate(n)) {
            stringBuffer.append("private ");
        }
        if (Flags.isStatic(n)) {
            stringBuffer.append("static ");
        }
        if (Flags.isAbstract(n)) {
            stringBuffer.append("abstract ");
        }
        if (Flags.isFinal(n)) {
            stringBuffer.append("final ");
        }
        if (Flags.isNative(n)) {
            stringBuffer.append("native ");
        }
        if (Flags.isSynchronized(n)) {
            stringBuffer.append("synchronized ");
        }
        if (Flags.isTransient(n)) {
            stringBuffer.append("transient ");
        }
        if (Flags.isVolatile(n)) {
            stringBuffer.append("volatile ");
        }
        if (Flags.isStrictfp(n)) {
            stringBuffer.append("strictfp ");
        }
        if ((n2 = stringBuffer.length()) == 0) {
            return "";
        }
        stringBuffer.setLength(n2 - 1);
        return stringBuffer.toString();
    }
}

