/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core;

import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.ClasspathContainerInitializer;
import org.eclipse.wst.jsdt.core.IClasspathContainer;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;

public class LibrarySuperType {
    IPath cpEntry;
    String superTypeName;
    String libraryName;
    IJavaProject javaProject;
    public static final String SUPER_TYPE_CONTAINER = "org.eclipse.wst.jsdt.ui.superType.container";
    public static final String SUPER_TYPE_NAME = "org.eclipse.wst.jsdt.ui.superType.name";

    public LibrarySuperType(IPath iPath, IJavaProject iJavaProject, String string) {
        this.cpEntry = iPath;
        this.superTypeName = string;
        this.javaProject = iJavaProject;
        this.libraryName = this.initLibraryName();
    }

    public LibrarySuperType(String string, IJavaProject iJavaProject, String string2) {
        this((IPath)new Path(string), iJavaProject, string2);
    }

    public LibrarySuperType(IPath iPath, IJavaProject iJavaProject) {
        this(iPath, iJavaProject, null);
    }

    public IPath getRawContainerPath() {
        return this.cpEntry;
    }

    public boolean hasChildren() {
        if (this.superTypeName != null) {
            return false;
        }
        ClasspathContainerInitializer classpathContainerInitializer = this.getContainerInitializer();
        if (classpathContainerInitializer == null) {
            return false;
        }
        String[] stringArray = classpathContainerInitializer.containerSuperTypes();
        return stringArray != null && stringArray.length > 0;
    }

    public LibrarySuperType[] getChildren() {
        if (this.superTypeName != null) {
            return new LibrarySuperType[0];
        }
        return LibrarySuperType.getFlatLibrarySuperTypes(this.cpEntry, this.javaProject);
    }

    public LibrarySuperType getParent() {
        if (this.superTypeName == null) {
            return null;
        }
        return new LibrarySuperType(this.cpEntry, this.javaProject, null);
    }

    public boolean isParent() {
        return this.getParent() == null;
    }

    public ClasspathContainerInitializer getContainerInitializer() {
        return LibrarySuperType.getContainerInitializer(this.cpEntry);
    }

    public IClasspathEntry[] getClasspathEntries() {
        IClasspathContainer iClasspathContainer = null;
        try {
            iClasspathContainer = JavaCore.getClasspathContainer(this.cpEntry, this.javaProject);
        }
        catch (JavaModelException javaModelException) {
            javaModelException.printStackTrace();
        }
        if (iClasspathContainer != null) {
            return iClasspathContainer.getClasspathEntries();
        }
        return new IClasspathEntry[0];
    }

    private static LibrarySuperType[] getFlatLibrarySuperTypes(IPath iPath, IJavaProject iJavaProject) {
        ClasspathContainerInitializer classpathContainerInitializer = LibrarySuperType.getContainerInitializer(iPath);
        if (classpathContainerInitializer == null) {
            return new LibrarySuperType[0];
        }
        String[] stringArray = classpathContainerInitializer.containerSuperTypes();
        LibrarySuperType[] librarySuperTypeArray = new LibrarySuperType[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            librarySuperTypeArray[n] = new LibrarySuperType(iPath, iJavaProject, stringArray[n]);
            ++n;
        }
        return librarySuperTypeArray;
    }

    public String getSuperTypeName() {
        return this.superTypeName;
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    private String initLibraryName() {
        ClasspathContainerInitializer classpathContainerInitializer = this.getContainerInitializer();
        if (this.superTypeName == null) {
            if (classpathContainerInitializer == null) {
                return this.cpEntry.toString();
            }
            return classpathContainerInitializer.getDescription(this.cpEntry, this.javaProject);
        }
        LibrarySuperType librarySuperType = this.getParent();
        if (!(librarySuperType instanceof LibrarySuperType)) {
            return null;
        }
        return librarySuperType.getLibraryName();
    }

    public String toString() {
        if (this.isParent()) {
            return this.getLibraryName();
        }
        return String.valueOf(this.superTypeName) + "() in " + this.getLibraryName();
    }

    public boolean equals(Object object) {
        if (!(object instanceof LibrarySuperType)) {
            return false;
        }
        LibrarySuperType librarySuperType = (LibrarySuperType)object;
        if (librarySuperType.cpEntry != null && !librarySuperType.cpEntry.equals((Object)this.cpEntry)) {
            return false;
        }
        if (librarySuperType.superTypeName == this.superTypeName) {
            return true;
        }
        if (librarySuperType.superTypeName != null && this.superTypeName != null) {
            return librarySuperType.superTypeName.equals(this.superTypeName);
        }
        return false;
    }

    public IPackageFragment[] getPackageFragments() {
        IClasspathEntry[] iClasspathEntryArray = this.getClasspathEntries();
        ArrayList<IJavaElement> arrayList = new ArrayList<IJavaElement>();
        try {
            int n = 0;
            while (n < iClasspathEntryArray.length) {
                IPath iPath = iClasspathEntryArray[n].getPath();
                IPackageFragmentRoot iPackageFragmentRoot = this.javaProject.findPackageFragmentRoot(iPath.makeAbsolute());
                IJavaElement[] iJavaElementArray = iPackageFragmentRoot.getChildren();
                int n2 = 0;
                while (n2 < iJavaElementArray.length) {
                    if (iJavaElementArray[n2] instanceof IPackageFragment) {
                        arrayList.add(iJavaElementArray[n2]);
                    }
                    ++n2;
                }
                ++n;
            }
        }
        catch (JavaModelException javaModelException) {
            javaModelException.printStackTrace();
        }
        return arrayList.toArray(new IPackageFragment[arrayList.size()]);
    }

    public static ClasspathContainerInitializer getContainerInitializer(IPath iPath) {
        if (iPath == null) {
            return null;
        }
        ClasspathContainerInitializer classpathContainerInitializer = JavaCore.getClasspathContainerInitializer(iPath.segment(0));
        return classpathContainerInitializer;
    }
}

