/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.dom.AnnotationBinding;
import org.eclipse.wst.jsdt.core.dom.BindingComparator;
import org.eclipse.wst.jsdt.core.dom.BindingResolver;
import org.eclipse.wst.jsdt.core.dom.DefaultBindingResolver;
import org.eclipse.wst.jsdt.core.dom.IAnnotationBinding;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.IPackageBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.JavaElement;

class CompilationUnitBinding
implements ITypeBinding {
    private static final IMethodBinding[] NO_METHOD_BINDINGS = new IMethodBinding[0];
    private static final String NO_NAME = "";
    private static final ITypeBinding[] NO_TYPE_BINDINGS = new ITypeBinding[0];
    private static final IVariableBinding[] NO_VARIABLE_BINDINGS = new IVariableBinding[0];
    private static final int VALID_MODIFIERS = 3103;
    TypeBinding binding;
    private String key;
    private BindingResolver resolver;

    public CompilationUnitBinding(BindingResolver bindingResolver, TypeBinding typeBinding) {
        this.binding = typeBinding;
        this.resolver = bindingResolver;
    }

    public ITypeBinding createArrayType(int n) {
        return null;
    }

    public IAnnotationBinding[] getAnnotations() {
        return AnnotationBinding.NoAnnotations;
    }

    public String getBinaryName() {
        char[] cArray = this.binding.constantPoolName();
        if (cArray == null) {
            return null;
        }
        char[] cArray2 = CharOperation.replaceOnCopy(cArray, '/', '.');
        return new String(cArray2);
    }

    public ITypeBinding getBound() {
        return null;
    }

    private ICompilationUnit getCompilationUnit(char[] cArray) {
        ICompilationUnit iCompilationUnit;
        char[] cArray2 = CharOperation.replaceOnCopy(cArray, File.separatorChar, '/');
        int n = CharOperation.lastIndexOf('/', cArray2);
        if (n == -1) {
            return null;
        }
        IPackageFragment iPackageFragment = this.getPackageFragment(cArray2, n, -1);
        if (iPackageFragment == null) {
            return null;
        }
        int n2 = n + 1;
        ICompilationUnit iCompilationUnit2 = iPackageFragment.getCompilationUnit(new String(cArray2, n2, cArray2.length - n2));
        if (this.resolver instanceof DefaultBindingResolver && (iCompilationUnit = iCompilationUnit2.findWorkingCopy(((DefaultBindingResolver)this.resolver).workingCopyOwner)) != null) {
            return iCompilationUnit;
        }
        return iCompilationUnit2;
    }

    public ITypeBinding getComponentType() {
        return null;
    }

    public IVariableBinding[] getDeclaredFields() {
        try {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            FieldBinding[] fieldBindingArray = referenceBinding.fields();
            int n = fieldBindingArray.length;
            IVariableBinding[] iVariableBindingArray = new IVariableBinding[n];
            int n2 = 0;
            while (n2 < n) {
                iVariableBindingArray[n2] = this.resolver.getVariableBinding(fieldBindingArray[n2]);
                ++n2;
            }
            return iVariableBindingArray;
        }
        catch (RuntimeException runtimeException) {
            return NO_VARIABLE_BINDINGS;
        }
    }

    public IMethodBinding[] getDeclaredMethods() {
        try {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            MethodBinding[] methodBindingArray = referenceBinding.methods();
            int n = methodBindingArray.length;
            IMethodBinding[] iMethodBindingArray = new IMethodBinding[n];
            int n2 = 0;
            while (n2 < n) {
                MethodBinding methodBinding = methodBindingArray[n2];
                iMethodBindingArray[n2] = this.resolver.getMethodBinding(methodBinding);
                ++n2;
            }
            return iMethodBindingArray;
        }
        catch (RuntimeException runtimeException) {
            return NO_METHOD_BINDINGS;
        }
    }

    public int getDeclaredModifiers() {
        return this.getModifiers();
    }

    public ITypeBinding[] getDeclaredTypes() {
        return NO_TYPE_BINDINGS;
    }

    public IMethodBinding getDeclaringMethod() {
        return null;
    }

    public ITypeBinding getDeclaringClass() {
        return null;
    }

    public int getDimensions() {
        return 0;
    }

    public ITypeBinding getElementType() {
        return null;
    }

    public ITypeBinding getTypeDeclaration() {
        return this;
    }

    public ITypeBinding getErasure() {
        return this.resolver.getTypeBinding(this.binding.erasure());
    }

    public ITypeBinding[] getInterfaces() {
        return NO_TYPE_BINDINGS;
    }

    public IJavaElement getJavaElement() {
        JavaElement javaElement = this.getUnresolvedJavaElement();
        if (javaElement == null) {
            return null;
        }
        return javaElement.resolved(this.binding);
    }

    private JavaElement getUnresolvedJavaElement() {
        return this.getUnresolvedJavaElement(this.binding);
    }

    private JavaElement getUnresolvedJavaElement(TypeBinding typeBinding) {
        if (typeBinding == null) {
            return null;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
        char[] cArray = referenceBinding.getFileName();
        if (cArray == null) {
            return null;
        }
        ITypeBinding iTypeBinding = this.getDeclaringClass();
        if (iTypeBinding == null) {
            if (((ReferenceBinding)this.binding).isBinaryBinding()) {
                ClassFile classFile = (ClassFile)this.getClassFile(cArray);
                return classFile;
            }
            ICompilationUnit iCompilationUnit = this.getCompilationUnit(cArray);
            return (JavaElement)((Object)iCompilationUnit);
        }
        IType iType = (IType)iTypeBinding.getJavaElement();
        if (iType == null) {
            return null;
        }
        return (JavaElement)((Object)iType.getType(new String(referenceBinding.sourceName())));
    }

    public String getKey() {
        if (this.key == null) {
            this.key = new String(this.binding.computeUniqueKey());
        }
        return this.key;
    }

    public int getKind() {
        return 2;
    }

    public int getModifiers() {
        if (this.isClass()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            int n = referenceBinding.getAccessFlags() & 0xC1F;
            if (referenceBinding.isAnonymousType()) {
                return n & 0xFFFFFFEF;
            }
            return n;
        }
        if (this.isAnnotation()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            int n = referenceBinding.getAccessFlags() & 0xC1F;
            return n & 0xFFFFD9FF;
        }
        if (this.isInterface()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            int n = referenceBinding.getAccessFlags() & 0xC1F;
            return n & 0xFFFFF9FF;
        }
        if (this.isEnum()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            int n = referenceBinding.getAccessFlags() & 0xC1F;
            return n & 0xFFFFBFFF;
        }
        return 0;
    }

    public String getName() {
        return new String(this.binding.sourceName());
    }

    public IPackageBinding getPackage() {
        switch (this.binding.kind()) {
            case 68: 
            case 132: 
            case 516: 
            case 4100: {
                return null;
            }
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
        return this.resolver.getPackageBinding(referenceBinding.getPackage());
    }

    private IPackageFragment getPackageFragment(char[] cArray, int n, int n2) {
        if (n2 != -1) {
            String string = new String(cArray, 0, n2);
            IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)JavaCore.create(string);
            if (n == n2) {
                return iPackageFragmentRoot.getPackageFragment(NO_NAME);
            }
            char[] cArray2 = CharOperation.subarray(cArray, n2 + 1, n);
            CharOperation.replace(cArray2, '/', '.');
            return iPackageFragmentRoot.getPackageFragment(new String(cArray2));
        }
        Path path = new Path(new String(cArray, 0, n));
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        Object object = path.segmentCount() == 1 ? iWorkspaceRoot.getProject(path.lastSegment()) : iWorkspaceRoot.getFolder((IPath)path);
        IJavaElement iJavaElement = JavaCore.create((IResource)object);
        if (iJavaElement == null) {
            return null;
        }
        switch (iJavaElement.getElementType()) {
            case 4: {
                return (IPackageFragment)iJavaElement;
            }
            case 3: {
                return ((IPackageFragmentRoot)iJavaElement).getPackageFragment(NO_NAME);
            }
            case 2: {
                IPackageFragmentRoot iPackageFragmentRoot = ((IJavaProject)iJavaElement).getPackageFragmentRoot((IResource)object);
                if (iPackageFragmentRoot == null) {
                    return null;
                }
                return iPackageFragmentRoot.getPackageFragment(NO_NAME);
            }
        }
        return null;
    }

    public String getQualifiedName() {
        if (this.isAnonymous() || this.isLocal()) {
            return NO_NAME;
        }
        if (this.isPrimitive() || this.isNullType()) {
            BaseTypeBinding baseTypeBinding = (BaseTypeBinding)this.binding;
            return new String(baseTypeBinding.simpleName);
        }
        if (this.isMember()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getDeclaringClass().getQualifiedName()).append('.');
            stringBuffer.append(this.getName());
            return String.valueOf(stringBuffer);
        }
        PackageBinding packageBinding = this.binding.getPackage();
        StringBuffer stringBuffer = new StringBuffer();
        if (packageBinding != null && packageBinding.compoundName != CharOperation.NO_CHAR_CHAR) {
            stringBuffer.append(CharOperation.concatWith(packageBinding.compoundName, '.')).append('.');
        }
        stringBuffer.append(this.getName());
        return String.valueOf(stringBuffer);
    }

    public ITypeBinding getSuperclass() {
        return null;
    }

    public ITypeBinding[] getTypeArguments() {
        return NO_TYPE_BINDINGS;
    }

    public ITypeBinding[] getTypeBounds() {
        return NO_TYPE_BINDINGS;
    }

    public ITypeBinding[] getTypeParameters() {
        return NO_TYPE_BINDINGS;
    }

    public ITypeBinding getWildcard() {
        return null;
    }

    public boolean isGenericType() {
        return false;
    }

    public boolean isAnnotation() {
        return false;
    }

    public boolean isAnonymous() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isAssignmentCompatible(ITypeBinding iTypeBinding) {
        return false;
    }

    public boolean isCapture() {
        return false;
    }

    public boolean isCastCompatible(ITypeBinding iTypeBinding) {
        return false;
    }

    public boolean isClass() {
        return this.binding.isClass();
    }

    public boolean isDeprecated() {
        if (this.isClass() || this.isInterface() || this.isEnum()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return referenceBinding.isDeprecated();
        }
        return false;
    }

    public boolean isEnum() {
        return false;
    }

    public boolean isEqualTo(IBinding iBinding) {
        if (iBinding == this) {
            return true;
        }
        if (iBinding == null) {
            return false;
        }
        if (!(iBinding instanceof CompilationUnitBinding)) {
            return false;
        }
        TypeBinding typeBinding = ((CompilationUnitBinding)iBinding).binding;
        return BindingComparator.isEqual(this.binding, typeBinding);
    }

    public boolean isFromSource() {
        return !((ReferenceBinding)this.binding).isBinaryBinding();
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isLocal() {
        return true;
    }

    public boolean isMember() {
        return false;
    }

    public boolean isNested() {
        return false;
    }

    public boolean isNullType() {
        return false;
    }

    public boolean isParameterizedType() {
        return false;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isRawType() {
        return false;
    }

    public boolean isSubTypeCompatible(ITypeBinding iTypeBinding) {
        return false;
    }

    public boolean isSynthetic() {
        return false;
    }

    public boolean isTopLevel() {
        return true;
    }

    public boolean isTypeVariable() {
        return false;
    }

    public boolean isUpperbound() {
        return false;
    }

    public boolean isWildcardType() {
        return false;
    }

    public String toString() {
        return this.binding.toString();
    }

    public boolean isCompilationUnit() {
        return true;
    }

    private IClassFile getClassFile(char[] cArray) {
        int n = CharOperation.indexOf('|', cArray);
        int n2 = CharOperation.lastIndexOf('/', cArray);
        if (n2 == -1) {
            n2 = CharOperation.lastIndexOf(File.separatorChar, cArray);
        }
        if (n != -1 && n2 < n) {
            n2 = n;
        }
        if (n2 == -1) {
            return null;
        }
        IPackageFragment iPackageFragment = this.getPackageFragment(cArray, n2, n);
        if (iPackageFragment == null) {
            return null;
        }
        int n3 = n2 + 1;
        return iPackageFragment.getClassFile(new String(cArray, n3, cArray.length - n3));
    }

    public boolean isRecovered() {
        return false;
    }
}

