/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.formatter;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.formatter.CodeFormatter;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class CodeFormatterApplication
implements IApplication {
    private static final String ARG_CONFIG = "-config";
    private static final String ARG_HELP = "-help";
    private static final String ARG_QUIET = "-quiet";
    private static final String ARG_VERBOSE = "-verbose";
    private String configName;
    private Map options = null;
    private static final String PDE_LAUNCH = "-pdelaunch";
    private boolean quiet = false;
    private boolean verbose = false;
    static /* synthetic */ Class class$0;

    private void displayHelp() {
        System.out.println(Messages.bind(Messages.CommandLineUsage));
    }

    private void displayHelp(String string) {
        System.err.println(string);
        System.out.println();
        this.displayHelp();
    }

    private void formatDirTree(File file, CodeFormatter codeFormatter) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        int n = 0;
        while (n < fileArray.length) {
            File file2 = fileArray[n];
            if (file2.isDirectory()) {
                this.formatDirTree(file2, codeFormatter);
            } else if (Util.isJavaLikeFileName(file2.getPath())) {
                this.formatFile(file2, codeFormatter);
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void formatFile(File file, CodeFormatter codeFormatter) {
        Document document = new Document();
        try {
            if (this.verbose) {
                System.out.println(Messages.bind(Messages.CommandLineFormatting, file.getAbsolutePath()));
            }
            String string = new String(org.eclipse.wst.jsdt.internal.compiler.util.Util.getFileCharContent(file, null));
            document.set(string);
            TextEdit textEdit = codeFormatter.format(8, string, 0, string.length(), 0, null);
            if (textEdit == null) {
                System.err.println(Messages.bind(Messages.FormatProblem, file.getAbsolutePath()));
                return;
            }
            textEdit.apply((IDocument)document);
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            try {
                bufferedWriter.write(document.get());
                bufferedWriter.flush();
            }
            catch (Throwable throwable) {
                Object var7_12 = null;
                try {
                    bufferedWriter.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var7_13 = null;
                try {}
                catch (IOException iOException) {
                    return;
                }
                bufferedWriter.close();
                return;
            }
        }
        catch (IOException iOException) {
            String string = Messages.bind(Messages.CaughtException, "IOException", iOException.getLocalizedMessage());
            Util.log(iOException, string);
            System.err.println(Messages.bind(Messages.ExceptionSkip, string));
            return;
        }
        catch (BadLocationException badLocationException) {
            String string = Messages.bind(Messages.CaughtException, "BadLocationException", badLocationException.getLocalizedMessage());
            Util.log(badLocationException, string);
            System.err.println(Messages.bind(Messages.ExceptionSkip, string));
        }
    }

    private File[] processCommandLine(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            arrayList.add(stringArray[n]);
            ++n;
        }
        n = 0;
        n2 = stringArray.length;
        int n3 = 0;
        int n4 = 0;
        File[] fileArray = new File[1];
        block5: while (n < n2) {
            String string = stringArray[n++];
            switch (n3) {
                case 0: {
                    if (PDE_LAUNCH.equals(string)) continue block5;
                    if (ARG_HELP.equals(string)) {
                        this.displayHelp();
                        return null;
                    }
                    if (ARG_VERBOSE.equals(string)) {
                        this.verbose = true;
                        break;
                    }
                    if (ARG_QUIET.equals(string)) {
                        this.quiet = true;
                        break;
                    }
                    if (ARG_CONFIG.equals(string)) {
                        n3 = 1;
                        break;
                    }
                    File file = new File(string);
                    if (file.exists()) {
                        if (fileArray.length == n4) {
                            File[] fileArray2 = fileArray;
                            fileArray = new File[n4 * 2];
                            System.arraycopy(fileArray2, 0, fileArray, 0, n4);
                        }
                        fileArray[n4++] = file;
                        break;
                    }
                    this.displayHelp(Messages.bind(Messages.CommandLineErrorFile, string));
                    return null;
                }
                case 1: {
                    this.configName = string;
                    this.options = this.readConfig(string);
                    if (this.options == null) {
                        this.displayHelp(Messages.bind(Messages.CommandLineErrorConfig, string));
                        return null;
                    }
                    n3 = 0;
                }
            }
        }
        if (n3 == 1 || this.options == null) {
            this.displayHelp(Messages.bind(Messages.CommandLineErrorNoConfigFile));
            return null;
        }
        if (this.quiet && this.verbose) {
            this.displayHelp(Messages.bind(Messages.CommandLineErrorQuietVerbose, new String[]{ARG_QUIET, ARG_VERBOSE}));
            return null;
        }
        if (n4 == 0) {
            this.displayHelp(Messages.bind(Messages.CommandLineErrorFileDir));
            return null;
        }
        if (fileArray.length != n4) {
            File[] fileArray3 = fileArray;
            fileArray = new File[n4];
            System.arraycopy(fileArray3, 0, fileArray, 0, n4);
        }
        return fileArray;
    }

    /*
     * Exception decompiling
     */
    private Properties readConfig(String var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 85->88)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Object start(IApplicationContext iApplicationContext) throws Exception {
        File[] fileArray = this.processCommandLine((String[])iApplicationContext.getArguments().get("application.args"));
        if (fileArray == null) {
            return IApplication.EXIT_OK;
        }
        if (!this.quiet) {
            if (this.configName != null) {
                System.out.println(Messages.bind(Messages.CommandLineConfigFile, this.configName));
            }
            System.out.println(Messages.bind(Messages.CommandLineStart));
        }
        CodeFormatter codeFormatter = ToolFactory.createCodeFormatter(this.options);
        int n = 0;
        int n2 = fileArray.length;
        while (n < n2) {
            File file = fileArray[n];
            if (file.isDirectory()) {
                this.formatDirTree(file, codeFormatter);
            } else if (Util.isJavaLikeFileName(file.getPath())) {
                this.formatFile(file, codeFormatter);
            }
            ++n;
        }
        if (!this.quiet) {
            System.out.println(Messages.bind(Messages.CommandLineDone));
        }
        return IApplication.EXIT_OK;
    }

    public void stop() {
    }

    private static final class Messages
    extends NLS {
        private static final String BUNDLE_NAME = "org.eclipse.wst.jsdt.core.formatter.messages";
        public static String CommandLineConfigFile;
        public static String CommandLineDone;
        public static String CommandLineErrorConfig;
        public static String CommandLineErrorFile;
        public static String CommandLineErrorFileDir;
        public static String CommandLineErrorQuietVerbose;
        public static String CommandLineErrorNoConfigFile;
        public static String CommandLineFormatting;
        public static String CommandLineStart;
        public static String CommandLineUsage;
        public static String ConfigFileReadingError;
        public static String FormatProblem;
        public static String CaughtException;
        public static String ExceptionSkip;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.formatter.CodeFormatterApplication$Messages");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            NLS.initializeMessages((String)BUNDLE_NAME, (Class)clazz);
        }

        private Messages() {
        }

        public static String bind(String string) {
            return Messages.bind(string, null);
        }

        public static String bind(String string, Object object) {
            return Messages.bind(string, new Object[]{object});
        }

        public static String bind(String string, Object object, Object object2) {
            return Messages.bind(string, new Object[]{object, object2});
        }

        public static String bind(String string, Object[] objectArray) {
            return MessageFormat.format(string, objectArray);
        }
    }
}

