/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.search;

import org.eclipse.core.resources.IResource;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.internal.core.JavaElement;

public class SearchMatch {
    public static final int A_ACCURATE = 0;
    public static final int A_INACCURATE = 1;
    private Object element;
    private int length;
    private int offset;
    private int accuracy;
    private SearchParticipant participant;
    private IResource resource;
    private boolean insideDocComment = false;
    private static final int ALL_GENERIC_FLAVORS = 112;
    private int rule = 112;
    private boolean raw = false;
    private boolean implicit = false;

    public SearchMatch(IJavaElement iJavaElement, int n, int n2, int n3, SearchParticipant searchParticipant, IResource iResource) {
        this.element = iJavaElement;
        this.offset = n2;
        this.length = n3;
        this.accuracy = n & 1;
        if (n > 1) {
            int n4 = n & 0x70;
            if (n4 > 0) {
                this.rule &= 0xFFFFFF8F;
            }
            this.rule |= n & 0xFFFFFFFE;
        }
        this.participant = searchParticipant;
        this.resource = iResource;
    }

    public final int getAccuracy() {
        return this.accuracy;
    }

    public final Object getElement() {
        return this.element;
    }

    public final int getLength() {
        return this.length;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final SearchParticipant getParticipant() {
        return this.participant;
    }

    public final IResource getResource() {
        return this.resource;
    }

    public final int getRule() {
        return this.rule;
    }

    public final boolean isEquivalent() {
        return this.isErasure() && (this.rule & 0x20) != 0;
    }

    public final boolean isErasure() {
        return (this.rule & 0x10) != 0;
    }

    public final boolean isExact() {
        return this.isEquivalent() && (this.rule & 0x40) != 0;
    }

    public final boolean isImplicit() {
        return this.implicit;
    }

    public final boolean isRaw() {
        return this.raw;
    }

    public final boolean isInsideDocComment() {
        return this.insideDocComment;
    }

    public final void setAccuracy(int n) {
        this.accuracy = n;
    }

    public final void setElement(Object object) {
        this.element = object;
    }

    public final void setInsideDocComment(boolean bl) {
        this.insideDocComment = bl;
    }

    public final void setImplicit(boolean bl) {
        this.implicit = bl;
    }

    public final void setLength(int n) {
        this.length = n;
    }

    public final void setOffset(int n) {
        this.offset = n;
    }

    public final void setParticipant(SearchParticipant searchParticipant) {
        this.participant = searchParticipant;
    }

    public final void setResource(IResource iResource) {
        this.resource = iResource;
    }

    public final void setRule(int n) {
        this.rule = n;
    }

    public final void setRaw(boolean bl) {
        this.raw = bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Search match");
        stringBuffer.append("\n  accuracy=");
        stringBuffer.append(this.accuracy == 0 ? "ACCURATE" : "INACCURATE");
        stringBuffer.append("\n  rule=");
        if ((this.rule & 0x40) != 0) {
            stringBuffer.append("EXACT");
        } else if ((this.rule & 0x20) != 0) {
            stringBuffer.append("EQUIVALENT");
        } else if ((this.rule & 0x10) != 0) {
            stringBuffer.append("ERASURE");
        }
        stringBuffer.append("\n  raw=");
        stringBuffer.append(this.raw);
        stringBuffer.append("\n  offset=");
        stringBuffer.append(this.offset);
        stringBuffer.append("\n  length=");
        stringBuffer.append(this.length);
        if (this.element != null) {
            stringBuffer.append("\n  element=");
            stringBuffer.append(((JavaElement)this.getElement()).toStringWithAncestors());
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

