/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.codeassist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.codeassist.CompletionEngine;
import org.eclipse.wst.jsdt.internal.codeassist.ISearchRequestor;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Wildcard;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRestriction;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfObjectToInt;
import org.eclipse.wst.jsdt.internal.core.SearchableEnvironment;

public class MissingTypesGuesser
extends ASTVisitor {
    private CompletionEngine.CompletionProblemFactory problemFactory;
    private SearchableEnvironment nameEnvironment;
    private HashMap substituedTypes;
    private HashMap originalTypes;
    private int combinationsCount;

    public MissingTypesGuesser(CompletionEngine completionEngine) {
        this.problemFactory = completionEngine.problemFactory;
        this.nameEnvironment = completionEngine.nameEnvironment;
    }

    private boolean computeMissingElements(QualifiedTypeReference[] qualifiedTypeReferenceArray, char[][][] cArray, Binding[] bindingArray, int[] nArray, int[] nArray2) {
        int n = qualifiedTypeReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReferenceBinding referenceBinding;
            QualifiedTypeReference qualifiedTypeReference = qualifiedTypeReferenceArray[n2];
            if (qualifiedTypeReference.resolvedType == null) {
                return false;
            }
            ReferenceBinding referenceBinding2 = (ReferenceBinding)qualifiedTypeReference.resolvedType.leafComponentType().erasure();
            int n3 = cArray[n2].length - 1;
            if (n3 == 0) {
                referenceBinding = referenceBinding2;
            } else {
                int n4 = referenceBinding2.depth() + 1;
                if (n4 > n3) {
                    referenceBinding = referenceBinding2.enclosingTypeAt(n3);
                } else {
                    return false;
                }
            }
            bindingArray[n2] = referenceBinding;
            nArray[n2] = qualifiedTypeReference.sourceStart;
            nArray2[n2] = qualifiedTypeReference.sourceEnd + 1;
            ++n2;
        }
        return true;
    }

    private TypeReference convert(ArrayQualifiedTypeReference arrayQualifiedTypeReference) {
        if (arrayQualifiedTypeReference.resolvedType != null) {
            if (arrayQualifiedTypeReference.resolvedType.isValidBinding()) {
                ArrayQualifiedTypeReference arrayQualifiedTypeReference2 = new ArrayQualifiedTypeReference(arrayQualifiedTypeReference.tokens, arrayQualifiedTypeReference.dimensions(), arrayQualifiedTypeReference.sourcePositions);
                arrayQualifiedTypeReference2.sourceStart = arrayQualifiedTypeReference.sourceStart;
                arrayQualifiedTypeReference2.sourceEnd = arrayQualifiedTypeReference.sourceEnd;
                return arrayQualifiedTypeReference2;
            }
            if ((arrayQualifiedTypeReference.resolvedType.problemId() & 1) != 0) {
                if (((ReferenceBinding)arrayQualifiedTypeReference.resolvedType.leafComponentType()).compoundName.length != 1) {
                    return null;
                }
                char[][] cArray = arrayQualifiedTypeReference.getTypeName();
                char[][][] cArray2 = this.findTypeNames(cArray);
                if (cArray2 == null || cArray2.length == 0) {
                    return null;
                }
                ArrayQualifiedTypeReference arrayQualifiedTypeReference3 = new ArrayQualifiedTypeReference(cArray2[0], arrayQualifiedTypeReference.dimensions(), new long[cArray2[0].length]);
                arrayQualifiedTypeReference3.sourceStart = arrayQualifiedTypeReference.sourceStart;
                arrayQualifiedTypeReference3.sourceEnd = (int)(arrayQualifiedTypeReference.sourcePositions[0] & 0xFFFFFFFFL);
                this.substituedTypes.put(arrayQualifiedTypeReference3, cArray2);
                this.originalTypes.put(arrayQualifiedTypeReference3, cArray);
                this.combinationsCount *= cArray2.length;
                return arrayQualifiedTypeReference3;
            }
        }
        return null;
    }

    private TypeReference convert(ArrayTypeReference arrayTypeReference) {
        if (arrayTypeReference.resolvedType != null) {
            if (arrayTypeReference.resolvedType.isValidBinding()) {
                ArrayTypeReference arrayTypeReference2 = new ArrayTypeReference(arrayTypeReference.token, arrayTypeReference.dimensions, 0L);
                arrayTypeReference2.sourceStart = arrayTypeReference.sourceStart;
                arrayTypeReference2.sourceEnd = arrayTypeReference.originalSourceEnd;
                return arrayTypeReference2;
            }
            if ((arrayTypeReference.resolvedType.problemId() & 1) != 0) {
                char[][] cArray = arrayTypeReference.getTypeName();
                char[][][] cArray2 = this.findTypeNames(cArray);
                if (cArray2 == null || cArray2.length == 0) {
                    return null;
                }
                ArrayQualifiedTypeReference arrayQualifiedTypeReference = new ArrayQualifiedTypeReference(cArray2[0], arrayTypeReference.dimensions, new long[cArray2[0].length]);
                arrayQualifiedTypeReference.sourceStart = arrayTypeReference.sourceStart;
                arrayQualifiedTypeReference.sourceEnd = arrayTypeReference.originalSourceEnd;
                this.substituedTypes.put(arrayQualifiedTypeReference, cArray2);
                this.originalTypes.put(arrayQualifiedTypeReference, cArray);
                this.combinationsCount *= cArray2.length;
                return arrayQualifiedTypeReference;
            }
        }
        return null;
    }

    private TypeReference convert(ParameterizedQualifiedTypeReference parameterizedQualifiedTypeReference) {
        if (parameterizedQualifiedTypeReference.resolvedType != null) {
            TypeReference[][] typeReferenceArray = parameterizedQualifiedTypeReference.typeArguments;
            int n = typeReferenceArray.length;
            TypeReference[][] typeReferenceArray2 = new TypeReference[n][];
            int n2 = 0;
            while (n2 < n) {
                if (typeReferenceArray[n2] != null) {
                    int n3 = typeReferenceArray[n2].length;
                    typeReferenceArray2[n2] = new TypeReference[n3];
                    int n4 = 0;
                    while (n4 < n3) {
                        typeReferenceArray2[n2][n4] = this.convert(typeReferenceArray[n2][n4]);
                        if (typeReferenceArray2[n2][n4] == null) {
                            return null;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            if (parameterizedQualifiedTypeReference.resolvedType.isValidBinding()) {
                ParameterizedQualifiedTypeReference parameterizedQualifiedTypeReference2 = new ParameterizedQualifiedTypeReference(parameterizedQualifiedTypeReference.tokens, typeReferenceArray2, parameterizedQualifiedTypeReference.dimensions(), new long[parameterizedQualifiedTypeReference.tokens.length]);
                parameterizedQualifiedTypeReference2.sourceStart = parameterizedQualifiedTypeReference.sourceStart;
                parameterizedQualifiedTypeReference2.sourceEnd = parameterizedQualifiedTypeReference.sourceEnd;
                return parameterizedQualifiedTypeReference2;
            }
            if ((parameterizedQualifiedTypeReference.resolvedType.problemId() & 1) != 0) {
                if (((ReferenceBinding)parameterizedQualifiedTypeReference.resolvedType.leafComponentType()).compoundName.length != 1) {
                    return null;
                }
                char[][] cArray = parameterizedQualifiedTypeReference.getTypeName();
                char[][][] cArray2 = this.findTypeNames(cArray);
                if (cArray2 == null || cArray2.length == 0) {
                    return null;
                }
                TypeReference[][] typeReferenceArray3 = new TypeReference[cArray2[0].length][];
                int n5 = typeReferenceArray3.length - 1;
                int n6 = typeReferenceArray2.length - 1;
                while (n5 > -1 && n6 > -1) {
                    typeReferenceArray3[n5] = typeReferenceArray2[n6];
                    --n5;
                    --n6;
                }
                ParameterizedQualifiedTypeReference parameterizedQualifiedTypeReference3 = new ParameterizedQualifiedTypeReference(cArray2[0], typeReferenceArray3, parameterizedQualifiedTypeReference.dimensions(), new long[cArray2[0].length]);
                parameterizedQualifiedTypeReference3.sourceStart = parameterizedQualifiedTypeReference.sourceStart;
                parameterizedQualifiedTypeReference3.sourceEnd = (int)(parameterizedQualifiedTypeReference.sourcePositions[0] & 0xFFFFFFFFL);
                this.substituedTypes.put(parameterizedQualifiedTypeReference3, cArray2);
                this.originalTypes.put(parameterizedQualifiedTypeReference3, cArray);
                this.combinationsCount *= cArray2.length;
                return parameterizedQualifiedTypeReference3;
            }
        }
        return null;
    }

    private TypeReference convert(ParameterizedSingleTypeReference parameterizedSingleTypeReference) {
        if (parameterizedSingleTypeReference.resolvedType != null) {
            TypeReference[] typeReferenceArray = parameterizedSingleTypeReference.typeArguments;
            int n = typeReferenceArray.length;
            TypeReference[] typeReferenceArray2 = new TypeReference[n];
            int n2 = 0;
            while (n2 < n) {
                typeReferenceArray2[n2] = this.convert(typeReferenceArray[n2]);
                if (typeReferenceArray2[n2] == null) {
                    return null;
                }
                ++n2;
            }
            if (parameterizedSingleTypeReference.resolvedType.isValidBinding()) {
                ParameterizedSingleTypeReference parameterizedSingleTypeReference2 = new ParameterizedSingleTypeReference(parameterizedSingleTypeReference.token, typeReferenceArray2, parameterizedSingleTypeReference.dimensions, 0L);
                parameterizedSingleTypeReference2.sourceStart = parameterizedSingleTypeReference.sourceStart;
                parameterizedSingleTypeReference2.sourceEnd = parameterizedSingleTypeReference.sourceEnd;
                return parameterizedSingleTypeReference2;
            }
            if ((parameterizedSingleTypeReference.resolvedType.problemId() & 1) != 0) {
                char[][] cArray = parameterizedSingleTypeReference.getTypeName();
                char[][][] cArray2 = this.findTypeNames(cArray);
                if (cArray2 == null || cArray2.length == 0) {
                    return null;
                }
                TypeReference[][] typeReferenceArray3 = new TypeReference[cArray2[0].length][];
                typeReferenceArray3[typeReferenceArray3.length - 1] = typeReferenceArray2;
                ParameterizedQualifiedTypeReference parameterizedQualifiedTypeReference = new ParameterizedQualifiedTypeReference(cArray2[0], typeReferenceArray3, parameterizedSingleTypeReference.dimensions, new long[cArray2[0].length]);
                parameterizedQualifiedTypeReference.sourceStart = parameterizedSingleTypeReference.sourceStart;
                parameterizedQualifiedTypeReference.sourceEnd = parameterizedSingleTypeReference.sourceEnd;
                this.substituedTypes.put(parameterizedQualifiedTypeReference, cArray2);
                this.originalTypes.put(parameterizedQualifiedTypeReference, cArray);
                this.combinationsCount *= cArray2.length;
                return parameterizedQualifiedTypeReference;
            }
        }
        return null;
    }

    private TypeReference convert(QualifiedTypeReference qualifiedTypeReference) {
        if (qualifiedTypeReference.resolvedType != null) {
            if (qualifiedTypeReference.resolvedType.isValidBinding()) {
                QualifiedTypeReference qualifiedTypeReference2 = new QualifiedTypeReference(qualifiedTypeReference.tokens, qualifiedTypeReference.sourcePositions);
                qualifiedTypeReference2.sourceStart = qualifiedTypeReference.sourceStart;
                qualifiedTypeReference2.sourceEnd = qualifiedTypeReference.sourceEnd;
                return qualifiedTypeReference2;
            }
            if ((qualifiedTypeReference.resolvedType.problemId() & 1) != 0) {
                if (((ReferenceBinding)qualifiedTypeReference.resolvedType).compoundName.length != 1) {
                    return null;
                }
                char[][] cArray = qualifiedTypeReference.getTypeName();
                char[][][] cArray2 = this.findTypeNames(cArray);
                if (cArray2 == null || cArray2.length == 0) {
                    return null;
                }
                QualifiedTypeReference qualifiedTypeReference3 = new QualifiedTypeReference(cArray2[0], new long[cArray2[0].length]);
                qualifiedTypeReference3.sourceStart = qualifiedTypeReference.sourceStart;
                qualifiedTypeReference3.sourceEnd = (int)(qualifiedTypeReference.sourcePositions[0] & 0xFFFFFFFFL);
                this.substituedTypes.put(qualifiedTypeReference3, cArray2);
                this.originalTypes.put(qualifiedTypeReference3, cArray);
                this.combinationsCount *= cArray2.length;
                return qualifiedTypeReference3;
            }
        }
        return null;
    }

    private TypeReference convert(SingleTypeReference singleTypeReference) {
        if (singleTypeReference.resolvedType != null) {
            if (singleTypeReference.resolvedType.isValidBinding()) {
                SingleTypeReference singleTypeReference2 = new SingleTypeReference(singleTypeReference.token, 0L);
                singleTypeReference2.sourceStart = singleTypeReference.sourceStart;
                singleTypeReference2.sourceEnd = singleTypeReference.sourceEnd;
                return singleTypeReference2;
            }
            if ((singleTypeReference.resolvedType.problemId() & 1) != 0) {
                char[][] cArray = singleTypeReference.getTypeName();
                char[][][] cArray2 = this.findTypeNames(cArray);
                if (cArray2 == null || cArray2.length == 0) {
                    return null;
                }
                QualifiedTypeReference qualifiedTypeReference = new QualifiedTypeReference(cArray2[0], new long[cArray2[0].length]);
                qualifiedTypeReference.sourceStart = singleTypeReference.sourceStart;
                qualifiedTypeReference.sourceEnd = singleTypeReference.sourceEnd;
                this.substituedTypes.put(qualifiedTypeReference, cArray2);
                this.originalTypes.put(qualifiedTypeReference, cArray);
                this.combinationsCount *= cArray2.length;
                return qualifiedTypeReference;
            }
        }
        return null;
    }

    private TypeReference convert(TypeReference typeReference) {
        if (typeReference instanceof ParameterizedSingleTypeReference) {
            return this.convert((ParameterizedSingleTypeReference)typeReference);
        }
        if (typeReference instanceof ParameterizedQualifiedTypeReference) {
            return this.convert((ParameterizedQualifiedTypeReference)typeReference);
        }
        if (typeReference instanceof ArrayTypeReference) {
            return this.convert((ArrayTypeReference)typeReference);
        }
        if (typeReference instanceof ArrayQualifiedTypeReference) {
            return this.convert((ArrayQualifiedTypeReference)typeReference);
        }
        if (typeReference instanceof Wildcard) {
            return this.convert((Wildcard)typeReference);
        }
        if (typeReference instanceof SingleTypeReference) {
            return this.convert((SingleTypeReference)typeReference);
        }
        if (typeReference instanceof QualifiedTypeReference) {
            return this.convert((QualifiedTypeReference)typeReference);
        }
        return null;
    }

    private TypeReference convert(Wildcard wildcard) {
        TypeReference typeReference = wildcard.bound;
        TypeReference typeReference2 = null;
        if (typeReference != null && (typeReference2 = this.convert(typeReference)) == null) {
            return null;
        }
        Wildcard wildcard2 = new Wildcard(wildcard.kind);
        wildcard2.bound = typeReference2;
        wildcard2.sourceStart = wildcard.sourceStart;
        wildcard2.sourceEnd = wildcard.sourceEnd;
        return wildcard2;
    }

    private char[][][] findTypeNames(char[][] cArray) {
        char[] cArray2 = cArray[cArray.length - 1];
        final boolean bl = cArray.length > 1;
        final char[] cArray3 = bl ? CharOperation.concatWith(cArray, '.') : null;
        final ArrayList arrayList = new ArrayList();
        ISearchRequestor iSearchRequestor = new ISearchRequestor(){

            public void acceptPackage(char[] cArray) {
            }

            public void acceptType(char[] cArray, char[] cArray2, char[][] cArray32, int n, AccessRestriction accessRestriction) {
                char[] cArray4 = CharOperation.concat(cArray, CharOperation.concat(CharOperation.concatWith(cArray32, '.'), cArray2, '.'), '.');
                if (bl && !CharOperation.endsWith(cArray4, cArray3)) {
                    return;
                }
                char[][] cArray5 = CharOperation.splitOn('.', cArray4);
                arrayList.add(cArray5);
            }

            public void acceptBinding(char[] cArray, char[] cArray2, int n, int n2, AccessRestriction accessRestriction) {
            }
        };
        this.nameEnvironment.findExactTypes(cArray2, true, 0, iSearchRequestor);
        if (arrayList.size() == 0) {
            return null;
        }
        return (char[][][])arrayList.toArray((T[])new char[arrayList.size()][0][0]);
    }

    private char[][] getOriginal(TypeReference typeReference) {
        return (char[][])this.originalTypes.get(typeReference);
    }

    private QualifiedTypeReference[] getSubstituedTypes() {
        Set set = this.substituedTypes.keySet();
        return set.toArray(new QualifiedTypeReference[set.size()]);
    }

    private char[][][] getSubstitution(TypeReference typeReference) {
        return (char[][][])this.substituedTypes.get(typeReference);
    }

    public void guess(TypeReference typeReference, Scope scope, GuessedTypeRequestor guessedTypeRequestor) {
        this.substituedTypes = new HashMap();
        this.originalTypes = new HashMap();
        this.combinationsCount = 1;
        TypeReference typeReference2 = this.convert(typeReference);
        if (typeReference2 == null) {
            return;
        }
        QualifiedTypeReference[] qualifiedTypeReferenceArray = this.getSubstituedTypes();
        int n = qualifiedTypeReferenceArray.length;
        int[] nArray = new int[qualifiedTypeReferenceArray.length];
        char[][][][] cArrayArray = new char[qualifiedTypeReferenceArray.length][][][];
        char[][][] cArrayArray2 = new char[qualifiedTypeReferenceArray.length][][];
        int n2 = 0;
        while (n2 < qualifiedTypeReferenceArray.length) {
            cArrayArray[n2] = this.getSubstitution(qualifiedTypeReferenceArray[n2]);
            cArrayArray2[n2] = this.getOriginal(qualifiedTypeReferenceArray[n2]);
            ++n2;
        }
        ResolutionCleaner resolutionCleaner = new ResolutionCleaner();
        int n3 = 0;
        while (n3 < this.combinationsCount) {
            int[] nArray2;
            int[] nArray3;
            Binding[] bindingArray;
            this.nextSubstitution(qualifiedTypeReferenceArray, cArrayArray, nArray);
            this.problemFactory.startCheckingProblems();
            TypeBinding typeBinding = null;
            switch (scope.kind) {
                case 1: 
                case 2: {
                    resolutionCleaner.cleanUp(typeReference2, (BlockScope)scope);
                    typeBinding = typeReference2.resolveType((BlockScope)scope);
                    break;
                }
                case 3: {
                    resolutionCleaner.cleanUp(typeReference2, (ClassScope)scope);
                    typeBinding = typeReference2.resolveType((ClassScope)scope);
                }
            }
            this.problemFactory.stopCheckingProblems();
            if (!this.problemFactory.hasForbiddenProblems && typeBinding != null && this.computeMissingElements(qualifiedTypeReferenceArray, cArrayArray2, bindingArray = new Binding[n], nArray3 = new int[n], nArray2 = new int[n])) {
                guessedTypeRequestor.accept(typeBinding.capture(scope, typeReference.sourceEnd), bindingArray, nArray3, nArray2, this.problemFactory.hasAllowedProblems);
            }
            ++n3;
        }
    }

    private void nextSubstitution(QualifiedTypeReference[] qualifiedTypeReferenceArray, char[][][][] cArray, int[] nArray) {
        int n = qualifiedTypeReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (nArray[n2] < cArray[n2].length - 1) {
                int n3 = n2;
                nArray[n3] = nArray[n3] + 1;
                break;
            }
            nArray[n2] = 0;
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            QualifiedTypeReference qualifiedTypeReference = qualifiedTypeReferenceArray[n2];
            qualifiedTypeReference.tokens = cArray[n2][nArray[n2]];
            qualifiedTypeReference.sourcePositions = new long[qualifiedTypeReference.tokens.length];
            if (qualifiedTypeReference instanceof ParameterizedQualifiedTypeReference) {
                ParameterizedQualifiedTypeReference parameterizedQualifiedTypeReference = (ParameterizedQualifiedTypeReference)qualifiedTypeReference;
                TypeReference[][] typeReferenceArray = parameterizedQualifiedTypeReference.typeArguments;
                TypeReference[][] typeReferenceArrayArray = new TypeReference[qualifiedTypeReference.tokens.length][];
                int n4 = typeReferenceArrayArray.length - 1;
                int n5 = typeReferenceArray.length - 1;
                while (n4 > -1 && n5 > -1) {
                    typeReferenceArrayArray[n4] = typeReferenceArray[n5];
                    --n4;
                    --n5;
                }
            }
            ++n2;
        }
    }

    public static interface GuessedTypeRequestor {
        public void accept(TypeBinding var1, Binding[] var2, int[] var3, int[] var4, boolean var5);
    }

    private static class ResolutionCleaner
    extends ASTVisitor {
        private HashtableOfObjectToInt bitsMap = new HashtableOfObjectToInt();
        private boolean firstCall = true;

        private void cleanUp(TypeReference typeReference) {
            if (this.firstCall) {
                this.bitsMap.put(typeReference, typeReference.bits);
            } else {
                typeReference.bits = this.bitsMap.get(typeReference);
            }
            typeReference.resolvedType = null;
        }

        private void cleanUp(ParameterizedSingleTypeReference parameterizedSingleTypeReference) {
            this.cleanUp((TypeReference)parameterizedSingleTypeReference);
            parameterizedSingleTypeReference.bits &= 0xFFFBFFFF;
        }

        private void cleanUp(ParameterizedQualifiedTypeReference parameterizedQualifiedTypeReference) {
            this.cleanUp((TypeReference)parameterizedQualifiedTypeReference);
            parameterizedQualifiedTypeReference.bits &= 0xFFFBFFFF;
        }

        public void cleanUp(TypeReference typeReference, BlockScope blockScope) {
            typeReference.traverse((ASTVisitor)this, blockScope);
            this.firstCall = false;
        }

        public void cleanUp(TypeReference typeReference, ClassScope classScope) {
            typeReference.traverse((ASTVisitor)this, classScope);
            this.firstCall = false;
        }

        public boolean visit(SingleTypeReference singleTypeReference, BlockScope blockScope) {
            this.cleanUp(singleTypeReference);
            return true;
        }

        public boolean visit(SingleTypeReference singleTypeReference, ClassScope classScope) {
            this.cleanUp(singleTypeReference);
            return true;
        }

        public boolean visit(Wildcard wildcard, BlockScope blockScope) {
            this.cleanUp(wildcard);
            return true;
        }

        public boolean visit(Wildcard wildcard, ClassScope classScope) {
            this.cleanUp(wildcard);
            return true;
        }

        public boolean visit(ArrayTypeReference arrayTypeReference, BlockScope blockScope) {
            this.cleanUp(arrayTypeReference);
            return true;
        }

        public boolean visit(ArrayTypeReference arrayTypeReference, ClassScope classScope) {
            this.cleanUp(arrayTypeReference);
            return true;
        }

        public boolean visit(ParameterizedSingleTypeReference parameterizedSingleTypeReference, BlockScope blockScope) {
            this.cleanUp(parameterizedSingleTypeReference);
            return true;
        }

        public boolean visit(ParameterizedSingleTypeReference parameterizedSingleTypeReference, ClassScope classScope) {
            this.cleanUp(parameterizedSingleTypeReference);
            return true;
        }

        public boolean visit(QualifiedTypeReference qualifiedTypeReference, BlockScope blockScope) {
            this.cleanUp(qualifiedTypeReference);
            return true;
        }

        public boolean visit(QualifiedTypeReference qualifiedTypeReference, ClassScope classScope) {
            this.cleanUp(qualifiedTypeReference);
            return true;
        }

        public boolean visit(ArrayQualifiedTypeReference arrayQualifiedTypeReference, BlockScope blockScope) {
            this.cleanUp(arrayQualifiedTypeReference);
            return true;
        }

        public boolean visit(ArrayQualifiedTypeReference arrayQualifiedTypeReference, ClassScope classScope) {
            this.cleanUp(arrayQualifiedTypeReference);
            return true;
        }

        public boolean visit(ParameterizedQualifiedTypeReference parameterizedQualifiedTypeReference, BlockScope blockScope) {
            this.cleanUp(parameterizedQualifiedTypeReference);
            return true;
        }

        public boolean visit(ParameterizedQualifiedTypeReference parameterizedQualifiedTypeReference, ClassScope classScope) {
            this.cleanUp(parameterizedQualifiedTypeReference);
            return true;
        }
    }
}

