/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.internal.compiler.AbstractAnnotationProcessorManager;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.ICompilerRequestor;
import org.eclipse.wst.jsdt.internal.compiler.IDebugRequestor;
import org.eclipse.wst.jsdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.wst.jsdt.internal.compiler.IProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.SourceJavadocParser;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ImportReference;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRestriction;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryType;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.env.INameEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.env.ISourceType;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.parser.Parser;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemSeverities;
import org.eclipse.wst.jsdt.internal.compiler.util.Messages;

public class Compiler
implements ITypeRequestor,
ProblemSeverities {
    public Parser parser;
    public ICompilerRequestor requestor;
    public CompilerOptions options;
    public ProblemReporter problemReporter;
    protected PrintWriter out;
    public CompilationUnitDeclaration[] unitsToProcess;
    public int totalUnits;
    public LookupEnvironment lookupEnvironment;
    public static boolean DEBUG = false;
    public int parseThreshold = -1;
    public AbstractAnnotationProcessorManager annotationProcessorManager;
    public ReferenceBinding[] referenceBindings;
    public static IDebugRequestor DebugRequestor = null;

    public Compiler(INameEnvironment iNameEnvironment, IErrorHandlingPolicy iErrorHandlingPolicy, Map map, ICompilerRequestor iCompilerRequestor, IProblemFactory iProblemFactory) {
        this(iNameEnvironment, iErrorHandlingPolicy, new CompilerOptions(map), iCompilerRequestor, iProblemFactory, null);
    }

    public Compiler(INameEnvironment iNameEnvironment, IErrorHandlingPolicy iErrorHandlingPolicy, Map map, ICompilerRequestor iCompilerRequestor, IProblemFactory iProblemFactory, boolean bl) {
        this(iNameEnvironment, iErrorHandlingPolicy, new CompilerOptions(map, bl), iCompilerRequestor, iProblemFactory, null);
    }

    public Compiler(INameEnvironment iNameEnvironment, IErrorHandlingPolicy iErrorHandlingPolicy, CompilerOptions compilerOptions, ICompilerRequestor iCompilerRequestor, IProblemFactory iProblemFactory) {
        this(iNameEnvironment, iErrorHandlingPolicy, compilerOptions, iCompilerRequestor, iProblemFactory, null);
    }

    public Compiler(INameEnvironment iNameEnvironment, IErrorHandlingPolicy iErrorHandlingPolicy, CompilerOptions compilerOptions, final ICompilerRequestor iCompilerRequestor, IProblemFactory iProblemFactory, PrintWriter printWriter) {
        this.options = compilerOptions;
        this.requestor = DebugRequestor == null ? iCompilerRequestor : new ICompilerRequestor(){

            public void acceptResult(CompilationResult compilationResult) {
                if (DebugRequestor.isActive()) {
                    DebugRequestor.acceptDebugResult(compilationResult);
                }
                iCompilerRequestor.acceptResult(compilationResult);
            }
        };
        this.problemReporter = new ProblemReporter(iErrorHandlingPolicy, this.options, iProblemFactory);
        this.lookupEnvironment = new LookupEnvironment(this, this.options, this.problemReporter, iNameEnvironment);
        this.out = printWriter == null ? new PrintWriter(System.out, true) : printWriter;
        this.initializeParser();
    }

    public void accept(IBinaryType iBinaryType, PackageBinding packageBinding, AccessRestriction accessRestriction) {
    }

    public void accept(ICompilationUnit iCompilationUnit, AccessRestriction accessRestriction) {
        CompilationResult compilationResult = new CompilationResult(iCompilationUnit, this.totalUnits, this.totalUnits, this.options.maxProblemsPerUnit);
        try {
            Object object;
            if (this.options.verbose) {
                object = String.valueOf(this.totalUnits + 1);
                this.out.println(Messages.bind(Messages.compilation_request, new String[]{object, object, new String(iCompilationUnit.getFileName())}));
            }
            object = this.totalUnits < this.parseThreshold ? this.parser.parse(iCompilationUnit, compilationResult) : this.parser.dietParse(iCompilationUnit, compilationResult);
            ((CompilationUnitDeclaration)object).bits |= 1;
            this.parser.inferTypes((CompilationUnitDeclaration)object, this.options);
            this.lookupEnvironment.buildTypeBindings((CompilationUnitDeclaration)object, accessRestriction);
            if (!(iCompilationUnit instanceof IClassFile)) {
                this.addCompilationUnit(iCompilationUnit, (CompilationUnitDeclaration)object);
            }
            this.lookupEnvironment.completeTypeBindings((CompilationUnitDeclaration)object);
        }
        catch (AbortCompilationUnit abortCompilationUnit) {
            if (compilationResult.compilationUnit == iCompilationUnit) {
                this.requestor.acceptResult(compilationResult.tagAsAccepted());
            }
            throw abortCompilationUnit;
        }
    }

    public CompilationUnitDeclaration doParse(ICompilationUnit iCompilationUnit, AccessRestriction accessRestriction) {
        Object object;
        CompilationResult compilationResult = new CompilationResult(iCompilationUnit, this.totalUnits, this.totalUnits, this.options.maxProblemsPerUnit);
        if (this.options.verbose) {
            object = String.valueOf(this.totalUnits + 1);
            this.out.println(Messages.bind(Messages.compilation_request, new String[]{object, object, new String(iCompilationUnit.getFileName())}));
        }
        object = this.totalUnits < this.parseThreshold ? this.parser.parse(iCompilationUnit, compilationResult) : this.parser.dietParse(iCompilationUnit, compilationResult);
        this.parser.inferTypes((CompilationUnitDeclaration)object, this.options);
        return object;
    }

    public void accept(ISourceType[] iSourceTypeArray, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        this.problemReporter.abortDueToInternalError(Messages.bind(Messages.abort_againstSourceModel, new String[]{String.valueOf(iSourceTypeArray[0].getName()), String.valueOf(iSourceTypeArray[0].getFileName())}));
    }

    protected void addCompilationUnit(ICompilationUnit iCompilationUnit, CompilationUnitDeclaration compilationUnitDeclaration) {
        int n = this.unitsToProcess.length;
        if (this.totalUnits == n) {
            this.unitsToProcess = new CompilationUnitDeclaration[n * 2];
            System.arraycopy(this.unitsToProcess, 0, this.unitsToProcess, 0, this.totalUnits);
        }
        this.unitsToProcess[this.totalUnits++] = compilationUnitDeclaration;
    }

    protected void beginToCompile(ICompilationUnit[] iCompilationUnitArray) {
        int n = iCompilationUnitArray.length;
        this.totalUnits = 0;
        this.unitsToProcess = new CompilationUnitDeclaration[n];
        this.internalBeginToCompile(iCompilationUnitArray, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void compile(ICompilationUnit[] iCompilationUnitArray) {
        CompilationUnitDeclaration compilationUnitDeclaration = null;
        int n = 0;
        try {
            try {
                this.beginToCompile(iCompilationUnitArray);
                if (this.annotationProcessorManager != null) {
                    this.processAnnotations();
                    if (!this.options.generateClassFiles) {
                        Object var6_4 = null;
                        this.reset();
                        return;
                    }
                }
                while (n < this.totalUnits) {
                    block15: {
                        Object var4_7;
                        compilationUnitDeclaration = this.unitsToProcess[n];
                        try {
                            if (this.options.verbose) {
                                this.out.println(Messages.bind(Messages.compilation_process, new String[]{String.valueOf(n + 1), String.valueOf(this.totalUnits), new String(this.unitsToProcess[n].getFileName())}));
                            }
                            this.process(compilationUnitDeclaration, n);
                            var4_7 = null;
                            compilationUnitDeclaration.cleanUp();
                            this.unitsToProcess[n] = null;
                            this.requestor.acceptResult(compilationUnitDeclaration.compilationResult.tagAsAccepted());
                            if (!this.options.verbose) break block15;
                        }
                        catch (Throwable throwable) {
                            var4_7 = null;
                            compilationUnitDeclaration.cleanUp();
                            throw throwable;
                        }
                        this.out.println(Messages.bind(Messages.compilation_done, new String[]{String.valueOf(n + 1), String.valueOf(this.totalUnits), new String(compilationUnitDeclaration.getFileName())}));
                    }
                    ++n;
                }
            }
            catch (AbortCompilation abortCompilation) {
                this.handleInternalException(abortCompilation, compilationUnitDeclaration);
            }
            catch (Error error) {
                this.handleInternalException(error, compilationUnitDeclaration, null);
                throw error;
            }
            catch (RuntimeException runtimeException) {
                this.handleInternalException(runtimeException, compilationUnitDeclaration, null);
                throw runtimeException;
            }
            Object var6_6 = null;
            this.reset();
            if (!this.options.verbose) return;
            if (this.totalUnits > 1) {
                this.out.println(Messages.bind(Messages.compilation_units, String.valueOf(this.totalUnits)));
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.reset();
            throw throwable;
        }
        this.out.println(Messages.bind(Messages.compilation_unit, String.valueOf(this.totalUnits)));
    }

    protected void handleInternalException(Throwable throwable, CompilationUnitDeclaration compilationUnitDeclaration, CompilationResult compilationResult) {
        if (compilationResult == null && compilationUnitDeclaration != null) {
            compilationResult = compilationUnitDeclaration.compilationResult;
        }
        if (compilationResult == null && this.lookupEnvironment.unitBeingCompleted != null) {
            compilationResult = this.lookupEnvironment.unitBeingCompleted.compilationResult;
        }
        if (compilationResult == null && this.lookupEnvironment.unitBeingCompleted != null) {
            compilationResult = this.lookupEnvironment.unitBeingCompleted.compilationResult;
        }
        if (compilationResult == null && this.unitsToProcess != null && this.totalUnits > 0) {
            compilationResult = this.unitsToProcess[this.totalUnits - 1].compilationResult;
        }
        boolean bl = true;
        if (compilationResult != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            StringBuffer stringBuffer = stringWriter.getBuffer();
            String[] stringArray = new String[]{String.valueOf(Messages.compilation_internalError) + "\n" + stringBuffer.toString()};
            compilationResult.record(this.problemReporter.createProblem(compilationResult.getFileName(), 0, stringArray, stringArray, 1, 0, 0, 0, 0), compilationUnitDeclaration);
            if (!compilationResult.hasBeenAccepted) {
                this.requestor.acceptResult(compilationResult.tagAsAccepted());
                bl = false;
            }
        }
        if (bl) {
            throwable.printStackTrace();
        }
    }

    public void setBinaryTypes(ReferenceBinding[] referenceBindingArray) {
        this.referenceBindings = referenceBindingArray;
    }

    protected void handleInternalException(AbortCompilation abortCompilation, CompilationUnitDeclaration compilationUnitDeclaration) {
        if (abortCompilation.isSilent) {
            if (abortCompilation.silentException == null) {
                return;
            }
            throw abortCompilation.silentException;
        }
        CompilationResult compilationResult = abortCompilation.compilationResult;
        if (compilationResult == null && compilationUnitDeclaration != null) {
            compilationResult = compilationUnitDeclaration.compilationResult;
        }
        if (compilationResult == null && this.lookupEnvironment.unitBeingCompleted != null) {
            compilationResult = this.lookupEnvironment.unitBeingCompleted.compilationResult;
        }
        if (compilationResult == null && this.unitsToProcess != null && this.totalUnits > 0) {
            compilationResult = this.unitsToProcess[this.totalUnits - 1].compilationResult;
        }
        if (compilationResult != null && !compilationResult.hasBeenAccepted) {
            block14: {
                if (abortCompilation.problem != null) {
                    CategorizedProblem categorizedProblem = abortCompilation.problem;
                    CategorizedProblem[] categorizedProblemArray = compilationResult.problems;
                    int n = 0;
                    while (n < compilationResult.problemCount) {
                        if (categorizedProblemArray[n] != categorizedProblem) {
                            ++n;
                            continue;
                        }
                        break block14;
                    }
                    if (categorizedProblem instanceof DefaultProblem) {
                        ((DefaultProblem)categorizedProblem).setOriginatingFileName(compilationResult.getFileName());
                    }
                    compilationResult.record(categorizedProblem, compilationUnitDeclaration);
                } else if (abortCompilation.exception != null) {
                    this.handleInternalException(abortCompilation.exception, null, compilationResult);
                    return;
                }
            }
            if (!compilationResult.hasBeenAccepted) {
                this.requestor.acceptResult(compilationResult.tagAsAccepted());
            }
        } else {
            abortCompilation.printStackTrace();
        }
    }

    public void initializeParser() {
        this.parser = new Parser(this.problemReporter, this.options.parseLiteralExpressionsAsConstants);
        this.parser.javadocParser = new SourceJavadocParser(this.parser);
        this.parser.javadocParser.checkDocComment = true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void internalBeginToCompile(ICompilationUnit[] iCompilationUnitArray, int n) {
        int n2 = 0;
        while (true) {
            Object var7_7;
            if (n2 >= n) {
                this.lookupEnvironment.completeTypeBindings();
                return;
            }
            CompilationResult compilationResult = new CompilationResult(iCompilationUnitArray[n2], n2, n, this.options.maxProblemsPerUnit);
            try {
                if (this.options.verbose) {
                    this.out.println(Messages.bind(Messages.compilation_request, new String[]{String.valueOf(n2 + 1), String.valueOf(n), new String(iCompilationUnitArray[n2].getFileName())}));
                }
                CompilationUnitDeclaration compilationUnitDeclaration = this.totalUnits < this.parseThreshold ? this.parser.parse(iCompilationUnitArray[n2], compilationResult) : this.parser.dietParse(iCompilationUnitArray[n2], compilationResult);
                this.parser.inferTypes(compilationUnitDeclaration, this.options);
                this.addCompilationUnit(iCompilationUnitArray[n2], compilationUnitDeclaration);
                this.lookupEnvironment.buildTypeBindings(compilationUnitDeclaration, null);
                ImportReference importReference = compilationUnitDeclaration.currentPackage;
                if (importReference != null) {
                    compilationResult.recordPackageName(importReference.tokens);
                }
            }
            catch (Throwable throwable) {
                var7_7 = null;
                iCompilationUnitArray[n2] = null;
                throw throwable;
            }
            {
                var7_7 = null;
                iCompilationUnitArray[n2] = null;
                ++n2;
                continue;
            }
            break;
        }
    }

    public void process(CompilationUnitDeclaration compilationUnitDeclaration, int n) {
        this.lookupEnvironment.unitBeingCompleted = compilationUnitDeclaration;
        this.parser.getMethodBodies(compilationUnitDeclaration);
        if (compilationUnitDeclaration.scope != null) {
            compilationUnitDeclaration.scope.faultInTypes();
        }
        if (compilationUnitDeclaration.scope != null) {
            compilationUnitDeclaration.scope.verifyMethods(this.lookupEnvironment.methodVerifier());
        }
        compilationUnitDeclaration.resolve();
        compilationUnitDeclaration.analyseCode();
        compilationUnitDeclaration.generateCode();
        if (this.options.produceReferenceInfo && compilationUnitDeclaration.scope != null) {
            compilationUnitDeclaration.scope.storeDependencyInfo();
        }
        compilationUnitDeclaration.compilationResult.totalUnitsKnown = this.totalUnits;
        this.lookupEnvironment.unitBeingCompleted = null;
    }

    protected void processAnnotations() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.unitsToProcess.length;
        ReferenceBinding[] referenceBindingArray = this.referenceBindings;
        if (n4 == 0 && referenceBindingArray == null) {
            return;
        }
        this.referenceBindings = null;
        do {
            ReferenceBinding[] referenceBindingArray2;
            int n5 = n4 - n3;
            CompilationUnitDeclaration[] compilationUnitDeclarationArray = new CompilationUnitDeclaration[n5];
            int n6 = 0;
            int n7 = n3;
            while (n7 < n4) {
                referenceBindingArray2 = this.unitsToProcess[n7];
                if ((referenceBindingArray2.bits & 1) == 0) {
                    compilationUnitDeclarationArray[n6++] = referenceBindingArray2;
                }
                ++n7;
            }
            if (n6 != n5) {
                CompilationUnitDeclaration[] compilationUnitDeclarationArray2 = compilationUnitDeclarationArray;
                compilationUnitDeclarationArray = new CompilationUnitDeclaration[n6];
                System.arraycopy(compilationUnitDeclarationArray2, 0, compilationUnitDeclarationArray, 0, n6);
            }
            this.annotationProcessorManager.processAnnotations(compilationUnitDeclarationArray, referenceBindingArray, false);
            ICompilationUnit[] iCompilationUnitArray = this.annotationProcessorManager.getNewUnits();
            n = iCompilationUnitArray.length;
            referenceBindingArray2 = this.annotationProcessorManager.getNewClassFiles();
            referenceBindingArray = referenceBindingArray2;
            n2 = referenceBindingArray2.length;
            if (n != 0) {
                this.internalBeginToCompile(iCompilationUnitArray, n);
                n3 = n4;
                n4 = this.unitsToProcess.length;
            } else {
                n3 = n4;
            }
            this.annotationProcessorManager.reset();
        } while (n != 0 || n2 != 0);
        this.annotationProcessorManager.processAnnotations(null, null, true);
    }

    public void reset() {
        this.lookupEnvironment.reset();
        this.parser.scanner.source = null;
        this.unitsToProcess = null;
        if (DebugRequestor != null) {
            DebugRequestor.reset();
        }
        this.problemReporter.reset();
    }

    public CompilationUnitDeclaration resolve(CompilationUnitDeclaration compilationUnitDeclaration, ICompilationUnit iCompilationUnit, boolean bl, boolean bl2, boolean bl3) {
        try {
            if (compilationUnitDeclaration == null) {
                this.parseThreshold = 0;
                this.beginToCompile(new ICompilationUnit[]{iCompilationUnit});
                compilationUnitDeclaration = this.unitsToProcess[0];
            } else {
                this.lookupEnvironment.buildTypeBindings(compilationUnitDeclaration, null);
                this.lookupEnvironment.completeTypeBindings();
            }
            this.lookupEnvironment.unitBeingCompleted = compilationUnitDeclaration;
            this.parser.getMethodBodies(compilationUnitDeclaration);
            if (compilationUnitDeclaration.scope != null) {
                compilationUnitDeclaration.scope.faultInTypes();
                if (compilationUnitDeclaration.scope != null && bl) {
                    compilationUnitDeclaration.scope.verifyMethods(this.lookupEnvironment.methodVerifier());
                }
                compilationUnitDeclaration.resolve();
                if (bl2) {
                    compilationUnitDeclaration.analyseCode();
                }
            }
            if (this.unitsToProcess != null) {
                this.unitsToProcess[0] = null;
            }
            this.requestor.acceptResult(compilationUnitDeclaration.compilationResult.tagAsAccepted());
            return compilationUnitDeclaration;
        }
        catch (AbortCompilation abortCompilation) {
            this.handleInternalException(abortCompilation, compilationUnitDeclaration);
            return compilationUnitDeclaration == null ? this.unitsToProcess[0] : compilationUnitDeclaration;
        }
        catch (Error error) {
            this.handleInternalException(error, compilationUnitDeclaration, null);
            throw error;
        }
        catch (RuntimeException runtimeException) {
            this.handleInternalException(runtimeException, compilationUnitDeclaration, null);
            throw runtimeException;
        }
    }

    public CompilationUnitDeclaration resolve(ICompilationUnit iCompilationUnit, boolean bl, boolean bl2, boolean bl3) {
        return this.resolve(null, iCompilationUnit, bl, bl2, bl3);
    }
}

