/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.codegen.CodeStream;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class ArrayAllocationExpression
extends Expression {
    public TypeReference type;
    public Expression[] dimensions;
    public ArrayInitializer initializer;

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        int n = 0;
        int n2 = this.dimensions.length;
        while (n < n2) {
            Expression expression = this.dimensions[n];
            if (expression != null) {
                flowInfo = expression.analyseCode(blockScope, flowContext, flowInfo);
            }
            ++n;
        }
        if (this.initializer != null) {
            return this.initializer.analyseCode(blockScope, flowContext, flowInfo);
        }
        return flowInfo;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n = codeStream.position;
        if (this.initializer != null) {
            this.initializer.generateCode(blockScope, codeStream, bl);
            return;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = this.dimensions.length;
        while (n3 < n4) {
            Expression expression = this.dimensions[n3];
            if (expression == null) break;
            expression.generateCode(blockScope, codeStream, true);
            ++n2;
            ++n3;
        }
        if (n2 == 1) {
            codeStream.newArray((ArrayBinding)this.resolvedType);
        } else {
            codeStream.multianewarray(this.resolvedType, n2);
        }
        if (bl) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else {
            codeStream.pop();
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        stringBuffer.append("new ");
        this.type.print(0, stringBuffer);
        int n2 = 0;
        while (n2 < this.dimensions.length) {
            if (this.dimensions[n2] == null) {
                stringBuffer.append("[]");
            } else {
                stringBuffer.append('[');
                this.dimensions[n2].printExpression(0, stringBuffer);
                stringBuffer.append(']');
            }
            ++n2;
        }
        if (this.initializer != null) {
            this.initializer.printExpression(0, stringBuffer);
        }
        return stringBuffer;
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        TypeBinding typeBinding = this.type.resolveType(blockScope, true);
        this.constant = Constant.NotAConstant;
        if (typeBinding == TypeBinding.VOID) {
            blockScope.problemReporter().cannotAllocateVoidArray(this);
            typeBinding = null;
        }
        int n = -1;
        int n2 = this.dimensions.length;
        while (--n2 >= 0) {
            if (this.dimensions[n2] != null) {
                if (n >= 0) continue;
                n = n2;
                continue;
            }
            if (n <= 0) continue;
            blockScope.problemReporter().incorrectLocationForNonEmptyDimension(this, n);
            break;
        }
        if (this.initializer == null) {
            if (n < 0) {
                blockScope.problemReporter().mustDefineDimensionsOrInitializer(this);
            }
            if (typeBinding != null && !typeBinding.isReifiable()) {
                blockScope.problemReporter().illegalGenericArray(typeBinding, this);
            }
        } else if (n >= 0) {
            blockScope.problemReporter().cannotDefineDimensionsAndInitializer(this);
        }
        n2 = 0;
        while (n2 <= n) {
            TypeBinding typeBinding2;
            Expression expression = this.dimensions[n2];
            if (expression != null && (typeBinding2 = expression.resolveTypeExpecting(blockScope, TypeBinding.INT)) != null) {
                this.dimensions[n2].computeConversion(blockScope, TypeBinding.INT, typeBinding2);
            }
            ++n2;
        }
        if (typeBinding != null) {
            if (this.dimensions.length > 255) {
                blockScope.problemReporter().tooManyDimensions(this);
            }
            this.resolvedType = blockScope.createArrayType(typeBinding, this.dimensions.length);
            if (this.initializer != null && this.initializer.resolveTypeExpecting(blockScope, this.resolvedType) != null) {
                this.initializer.binding = (ArrayBinding)this.resolvedType;
            }
        }
        return this.resolvedType;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n = this.dimensions.length;
            this.type.traverse(aSTVisitor, blockScope);
            int n2 = 0;
            while (n2 < n) {
                if (this.dimensions[n2] != null) {
                    this.dimensions[n2].traverse(aSTVisitor, blockScope);
                }
                ++n2;
            }
            if (this.initializer != null) {
                this.initializer.traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

