/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.wst.jsdt.internal.compiler.ast.Assignment;
import org.eclipse.wst.jsdt.internal.compiler.ast.CastExpression;
import org.eclipse.wst.jsdt.internal.compiler.codegen.CodeStream;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class FieldDeclaration
extends AbstractVariableDeclaration {
    public FieldBinding binding;
    public int endPart1Position;
    public int endPart2Position;

    public FieldDeclaration() {
    }

    public FieldDeclaration(char[] cArray, int n, int n2) {
        this.name = cArray;
        this.sourceStart = n;
        this.sourceEnd = n2;
    }

    public FlowInfo analyseCode(MethodScope methodScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.binding != null && !this.binding.isUsed() && (this.binding.isPrivate() || this.binding.declaringClass != null && this.binding.declaringClass.isLocalType()) && !methodScope.referenceCompilationUnit().compilationResult.hasSyntaxError) {
            methodScope.problemReporter().unusedPrivateField(this);
        }
        if (this.binding != null && this.binding.isValidBinding() && this.binding.isStatic() && this.binding.constant() == Constant.NotAConstant && this.binding.declaringClass.isNestedType() && !this.binding.declaringClass.isStatic()) {
            methodScope.problemReporter().unexpectedStaticModifierForField((SourceTypeBinding)this.binding.declaringClass, this);
        }
        if (this.initialization != null) {
            flowInfo = this.initialization.analyseCode(methodScope, flowContext, flowInfo).unconditionalInits();
            flowInfo.markAsDefinitelyAssigned(this.binding);
        }
        return flowInfo;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        boolean bl;
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n = codeStream.position;
        if (!(this.initialization == null || (bl = this.binding.isStatic()) && this.binding.constant() != Constant.NotAConstant)) {
            if (!bl) {
                codeStream.aload_0();
            }
            this.initialization.generateCode(blockScope, codeStream, true);
            if (bl) {
                codeStream.putstatic(this.binding);
            } else {
                codeStream.putfield(this.binding);
            }
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public int getKind() {
        return 1;
    }

    public boolean isStatic() {
        if (this.binding != null) {
            return this.binding.isStatic();
        }
        return (this.modifiers & 8) != 0;
    }

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        if (this.javadoc != null) {
            this.javadoc.print(n, stringBuffer);
        }
        return super.printStatement(n, stringBuffer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resolve(MethodScope methodScope) {
        Binding binding;
        Binding binding2;
        Binding binding3;
        if ((this.bits & 0x10) != 0) {
            return;
        }
        if (this.binding == null) return;
        if (!this.binding.isValidBinding()) {
            return;
        }
        this.bits |= 0x10;
        ClassScope classScope = methodScope.enclosingClassScope();
        if (classScope != null) {
            Object object;
            binding3 = classScope.enclosingSourceType();
            if (((SourceTypeBinding)binding3).superclass != null && (object = classScope.findField(((SourceTypeBinding)binding3).superclass, this.name, this, false)) != null && ((Binding)object).isValidBinding() && (!(object instanceof FieldBinding) || ((FieldBinding)(binding2 = (FieldBinding)object)).original() != this.binding)) {
                methodScope.problemReporter().fieldHiding(this, (Binding)object);
            } else {
                object = classScope.parent;
                if (((Scope)object).kind != 4 && (binding2 = ((Scope)object).getBinding(this.name, 3, this, false)) != null && binding2.isValidBinding() && binding2 != this.binding && (!(binding2 instanceof FieldBinding) || ((FieldBinding)(binding = (FieldBinding)binding2)).original() != this.binding && (((FieldBinding)binding).isStatic() || !((ReferenceBinding)binding3).isStatic()))) {
                    methodScope.problemReporter().fieldHiding(this, binding2);
                }
            }
        }
        if (this.type != null) {
            this.type.resolvedType = this.binding.type;
        }
        binding3 = methodScope.initializedField;
        int n = methodScope.lastVisibleFieldID;
        try {
            methodScope.initializedField = this.binding;
            methodScope.lastVisibleFieldID = this.binding.id;
            FieldDeclaration.resolveAnnotations(methodScope, this.annotations, this.binding);
            if ((this.binding.getAnnotationTagBits() & 0x400000000000L) == 0L && (this.binding.modifiers & 0x100000) != 0 && methodScope.compilerOptions().sourceLevel >= 0x310000L) {
                methodScope.problemReporter().missingDeprecatedAnnotationForField(this);
            }
            if (this.initialization == null) {
                this.binding.setConstant(Constant.NotAConstant);
            } else {
                this.binding.setConstant(Constant.NotAConstant);
                binding2 = this.binding.type;
                this.initialization.setExpectedType((TypeBinding)binding2);
                if (this.initialization instanceof ArrayInitializer) {
                    binding = this.initialization.resolveTypeExpecting((BlockScope)methodScope, (TypeBinding)binding2);
                    if (binding != null) {
                        ((ArrayInitializer)this.initialization).binding = (ArrayBinding)binding;
                        this.initialization.computeConversion(methodScope, (TypeBinding)binding2, (TypeBinding)binding);
                    }
                } else {
                    binding = this.initialization.resolveType(methodScope);
                    if (binding != null) {
                        if (binding2 != binding) {
                            methodScope.compilationUnitScope().recordTypeConversion((TypeBinding)binding2, (TypeBinding)binding);
                        }
                        if (this.initialization.isConstantValueOfTypeAssignableToType((TypeBinding)binding, (TypeBinding)binding2) || ((TypeBinding)binding2).isBaseType() && BaseTypeBinding.isWidening(((TypeBinding)binding2).id, ((TypeBinding)binding).id) || ((TypeBinding)binding).isCompatibleWith((TypeBinding)binding2)) {
                            this.initialization.computeConversion(methodScope, (TypeBinding)binding2, (TypeBinding)binding);
                            if (((TypeBinding)binding).needsUncheckedConversion((TypeBinding)binding2)) {
                                methodScope.problemReporter().unsafeTypeConversion(this.initialization, (TypeBinding)binding, (TypeBinding)binding2);
                            }
                            if (this.initialization instanceof CastExpression && (this.initialization.bits & 0x4000) == 0) {
                                CastExpression.checkNeedForAssignedCast(methodScope, (TypeBinding)binding2, (CastExpression)this.initialization);
                            }
                        } else if (methodScope.isBoxingCompatibleWith((TypeBinding)binding, (TypeBinding)binding2) || ((TypeBinding)binding).isBaseType() && methodScope.compilerOptions().sourceLevel >= 0x310000L && !((TypeBinding)binding2).isBaseType() && this.initialization.isConstantValueOfTypeAssignableToType((TypeBinding)binding, methodScope.environment().computeBoxingType((TypeBinding)binding2))) {
                            this.initialization.computeConversion(methodScope, (TypeBinding)binding2, (TypeBinding)binding);
                            if (this.initialization instanceof CastExpression && (this.initialization.bits & 0x4000) == 0) {
                                CastExpression.checkNeedForAssignedCast(methodScope, (TypeBinding)binding2, (CastExpression)this.initialization);
                            }
                        } else {
                            methodScope.problemReporter().typeMismatchError((TypeBinding)binding, (TypeBinding)binding2, this);
                        }
                        if (this.binding.isFinal()) {
                            this.binding.setConstant(this.initialization.constant.castTo((this.binding.type.id << 4) + this.initialization.constant.typeID()));
                        }
                    } else {
                        this.binding.setConstant(Constant.NotAConstant);
                    }
                }
                if (this.binding == Assignment.getDirectBinding(this.initialization)) {
                    methodScope.problemReporter().assignmentHasNoEffect(this, this.name);
                }
            }
            if (this.javadoc != null) {
                this.javadoc.resolve(methodScope);
            } else if (this.binding.declaringClass != null && !this.binding.declaringClass.isLocalType()) {
                methodScope.problemReporter().javadocMissing(this.sourceStart, this.sourceEnd, this.binding.modifiers);
            }
            Object var7_10 = null;
            methodScope.initializedField = binding3;
            methodScope.lastVisibleFieldID = n;
            if (this.binding.constant() != null) return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            methodScope.initializedField = binding3;
            methodScope.lastVisibleFieldID = n;
            if (this.binding.constant() != null) throw throwable;
            this.binding.setConstant(Constant.NotAConstant);
            throw throwable;
        }
        this.binding.setConstant(Constant.NotAConstant);
    }

    public void traverse(ASTVisitor aSTVisitor, MethodScope methodScope) {
        if (aSTVisitor.visit(this, methodScope)) {
            if (this.javadoc != null) {
                this.javadoc.traverse(aSTVisitor, methodScope);
            }
            if (this.annotations != null) {
                int n = this.annotations.length;
                int n2 = 0;
                while (n2 < n) {
                    this.annotations[n2].traverse(aSTVisitor, methodScope);
                    ++n2;
                }
            }
            if (this.type != null) {
                this.type.traverse(aSTVisitor, methodScope);
            }
            if (this.initialization != null) {
                this.initialization.traverse(aSTVisitor, methodScope);
            }
        }
        aSTVisitor.endVisit(this, methodScope);
    }
}

