/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.codegen.CodeStream;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class ListExpression
extends Expression {
    public Expression[] expressions;
    public Constant optimizedBooleanConstant;

    public ListExpression(Expression expression, Expression expression2) {
        if (expression instanceof ListExpression) {
            ListExpression listExpression = (ListExpression)expression;
            this.expressions = new Expression[listExpression.expressions.length + 1];
            System.arraycopy(listExpression.expressions, 0, this.expressions, 0, listExpression.expressions.length);
            this.expressions[this.expressions.length - 1] = expression2;
        } else {
            this.expressions = new Expression[]{expression, expression2};
        }
        this.sourceStart = this.expressions[0].sourceStart;
        this.sourceEnd = this.expressions[this.expressions.length - 1].sourceEnd;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        int n = 0;
        while (n < this.expressions.length) {
            this.expressions[n].checkNPE(blockScope, flowContext, flowInfo);
            flowInfo = this.expressions[n].analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
            ++n;
        }
        return flowInfo;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
    }

    public boolean isCompactableOperation() {
        return true;
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        int n = 0;
        while (n < this.expressions.length) {
            this.resolvedType = this.expressions[n].resolveType(blockScope);
            ++n;
        }
        return this.resolvedType;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n = 0;
            while (n < this.expressions.length) {
                this.expressions[n].traverse(aSTVisitor, blockScope);
                ++n;
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        int n2 = 0;
        while (n2 < this.expressions.length) {
            if (n2 > 0) {
                stringBuffer.append(", ");
            }
            this.expressions[n2].printExpression(n, stringBuffer);
            ++n2;
        }
        return stringBuffer;
    }
}

