/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.EmptyStatement;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.codegen.CodeStream;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.WithScope;

public class WithStatement
extends Statement {
    public Expression condition;
    public Statement action;

    public WithStatement(Expression expression, Statement statement, int n, int n2) {
        this.condition = expression;
        this.action = statement;
        if (statement instanceof EmptyStatement) {
            statement.bits |= 1;
        }
        this.sourceStart = n;
        this.sourceEnd = n2;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        flowInfo = this.condition.analyseCode(blockScope, flowContext, flowInfo);
        if (this.action != null && !this.action.complainIfUnreachable(flowInfo, blockScope, false)) {
            flowInfo = this.action.analyseCode(blockScope, flowContext, flowInfo);
        }
        return flowInfo;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
    }

    public void resolve(BlockScope blockScope) {
        BlockScope blockScope2;
        TypeBinding typeBinding = this.condition.resolveTypeExpecting(blockScope, TypeBinding.ANY);
        BlockScope blockScope3 = blockScope2 = typeBinding instanceof ReferenceBinding ? new WithScope((Scope)blockScope, (ReferenceBinding)typeBinding) : blockScope;
        if (this.action != null) {
            this.action.resolve(blockScope2);
        }
    }

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        WithStatement.printIndent(n, stringBuffer).append("with (");
        this.condition.printExpression(0, stringBuffer).append(")\n");
        if (this.action == null) {
            stringBuffer.append(';');
        } else {
            this.action.printStatement(n + 1, stringBuffer);
        }
        return stringBuffer;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.condition.traverse(aSTVisitor, blockScope);
            if (this.action != null) {
                this.action.traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

