/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.codegen;

public class IntegerCache {
    public int[] keyTable;
    public int[] valueTable;
    int elementSize = 0;
    int threshold;

    public IntegerCache() {
        this(13);
    }

    public IntegerCache(int n) {
        this.threshold = (int)((double)n * 0.66);
        this.keyTable = new int[n];
        this.valueTable = new int[n];
    }

    public void clear() {
        int n = this.keyTable.length;
        while (--n >= 0) {
            this.keyTable[n] = 0;
            this.valueTable[n] = 0;
        }
        this.elementSize = 0;
    }

    public boolean containsKey(int n) {
        int n2 = this.hash(n);
        int n3 = this.keyTable.length;
        while (this.keyTable[n2] != 0 || this.keyTable[n2] == 0 && this.valueTable[n2] != 0) {
            if (this.keyTable[n2] == n) {
                return true;
            }
            if (++n2 != n3) continue;
            n2 = 0;
        }
        return false;
    }

    public int hash(int n) {
        return (n & Integer.MAX_VALUE) % this.keyTable.length;
    }

    public int put(int n, int n2) {
        int n3 = this.hash(n);
        int n4 = this.keyTable.length;
        while (this.keyTable[n3] != 0 || this.keyTable[n3] == 0 && this.valueTable[n3] != 0) {
            if (this.keyTable[n3] == n) {
                this.valueTable[n3] = n2;
                return this.valueTable[n3];
            }
            if (++n3 != n4) continue;
            n3 = 0;
        }
        this.keyTable[n3] = n;
        this.valueTable[n3] = n2;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return n2;
    }

    public int putIfAbsent(int n, int n2) {
        int n3 = this.hash(n);
        int n4 = this.keyTable.length;
        while (this.keyTable[n3] != 0 || this.keyTable[n3] == 0 && this.valueTable[n3] != 0) {
            if (this.keyTable[n3] == n) {
                return this.valueTable[n3];
            }
            if (++n3 != n4) continue;
            n3 = 0;
        }
        this.keyTable[n3] = n;
        this.valueTable[n3] = n2;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return -n2;
    }

    private void rehash() {
        IntegerCache integerCache = new IntegerCache(this.keyTable.length * 2);
        int n = this.keyTable.length;
        while (--n >= 0) {
            int n2 = this.keyTable[n];
            int n3 = this.valueTable[n];
            if (n2 == 0 && (n2 != 0 || n3 == 0)) continue;
            integerCache.put(n2, n3);
        }
        this.keyTable = integerCache.keyTable;
        this.valueTable = integerCache.valueTable;
        this.threshold = integerCache.threshold;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        int n = this.size();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        int n2 = 0;
        while (n2 < n) {
            if (this.keyTable[n2] != 0 || this.keyTable[n2] == 0 && this.valueTable[n2] != 0) {
                stringBuffer.append(this.keyTable[n2]).append("->").append(this.valueTable[n2]);
            }
            if (n2 < n) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

