/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.lookup;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfBinding;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfPackage;

public class PackageBinding
extends Binding
implements TypeConstants {
    public long tagBits = 0L;
    public char[][] compoundName;
    PackageBinding parent;
    public LookupEnvironment environment;
    HashtableOfBinding[] knownBindings = new HashtableOfBinding[16];
    HashtableOfPackage knownPackages;

    protected PackageBinding() {
    }

    public PackageBinding(char[][] cArray, PackageBinding packageBinding, LookupEnvironment lookupEnvironment) {
        this.compoundName = cArray;
        this.parent = packageBinding;
        this.environment = lookupEnvironment;
        this.knownPackages = new HashtableOfPackage(3);
    }

    public PackageBinding(char[] cArray, LookupEnvironment lookupEnvironment) {
        this(new char[][]{cArray}, null, lookupEnvironment);
    }

    public PackageBinding(LookupEnvironment lookupEnvironment) {
        this(CharOperation.NO_CHAR_CHAR, null, lookupEnvironment);
    }

    private void addNotFoundPackage(char[] cArray) {
        this.knownPackages.put(cArray, LookupEnvironment.TheNotFoundPackage);
    }

    private void addNotFoundType(char[] cArray) {
        if (this.knownBindings[4] == null) {
            this.knownBindings[4] = new HashtableOfBinding(25);
        }
        this.knownBindings[4].put(cArray, LookupEnvironment.TheNotFoundType);
    }

    private void addNotFoundBinding1(char[] cArray, int n) {
        if (this.knownBindings[n] == null) {
            this.knownBindings[n] = new HashtableOfBinding(25);
        }
        this.knownBindings[n].put(cArray, LookupEnvironment.TheNotFoundType);
    }

    private void addNotFoundBinding(char[] cArray, int n) {
        if ((3 & n) != 0) {
            this.addNotFoundBinding1(cArray, 3);
        }
        if ((8 & n) != 0) {
            this.addNotFoundBinding1(cArray, 8);
        }
        if ((4 & n) != 0) {
            this.addNotFoundBinding1(cArray, 4);
        }
    }

    void addPackage(PackageBinding packageBinding) {
        this.knownPackages.put(packageBinding.compoundName[packageBinding.compoundName.length - 1], packageBinding);
    }

    void addType(ReferenceBinding referenceBinding) {
        if (this.knownBindings[4] == null) {
            this.knownBindings[4] = new HashtableOfBinding(25);
        }
        this.knownBindings[4].put(referenceBinding.compoundName[referenceBinding.compoundName.length - 1], referenceBinding);
    }

    public void addBinding(Binding binding, char[] cArray, int n) {
        if (this.knownBindings[n] == null) {
            this.knownBindings[n] = new HashtableOfBinding(25);
        }
        this.knownBindings[n].put(cArray, binding);
    }

    public final int kind() {
        return 16;
    }

    public char[] computeUniqueKey(boolean bl) {
        return CharOperation.concatWith(this.compoundName, '/');
    }

    private PackageBinding findPackage(char[] cArray) {
        if (!this.environment.isPackage(this.compoundName, cArray)) {
            return null;
        }
        char[][] cArray2 = CharOperation.arrayConcat(this.compoundName, cArray);
        PackageBinding packageBinding = new PackageBinding(cArray2, this, this.environment);
        this.addPackage(packageBinding);
        return packageBinding;
    }

    PackageBinding getPackage(char[] cArray) {
        PackageBinding packageBinding = this.getPackage0(cArray);
        if (packageBinding != null) {
            if (packageBinding == LookupEnvironment.TheNotFoundPackage) {
                return null;
            }
            return packageBinding;
        }
        packageBinding = this.findPackage(cArray);
        if (packageBinding != null) {
            return packageBinding;
        }
        this.addNotFoundPackage(cArray);
        return null;
    }

    PackageBinding getPackage0(char[] cArray) {
        return this.knownPackages.get(cArray);
    }

    ReferenceBinding getType(char[] cArray) {
        return (ReferenceBinding)this.getBinding(cArray, 4);
    }

    public Binding getBinding(char[] cArray, int n) {
        Binding binding = this.getBinding0(cArray, n);
        if (binding == null && (binding = this.environment.askForBinding(this, cArray, n)) == null) {
            this.addNotFoundBinding(cArray, n);
            return null;
        }
        if (binding == LookupEnvironment.TheNotFoundType) {
            return null;
        }
        return binding;
    }

    ReferenceBinding getType0(char[] cArray) {
        if (this.knownBindings[4] == null) {
            return null;
        }
        return (ReferenceBinding)this.knownBindings[4].get(cArray);
    }

    Binding getBinding1(char[] cArray, int n) {
        if (this.knownBindings[n] == null) {
            return null;
        }
        return this.knownBindings[n].get(cArray);
    }

    Binding getBinding0(char[] cArray, int n) {
        Binding binding;
        if ((n & 3) != 0 && (binding = this.getBinding1(cArray, 3)) != null) {
            return binding;
        }
        if ((n & 4) != 0 && (binding = this.getBinding1(cArray, 4)) != null) {
            return binding;
        }
        if ((n & 8) != 0 && (binding = this.getBinding1(cArray, 8)) != null) {
            return binding;
        }
        return null;
    }

    public Binding getTypeOrPackage(char[] cArray, int n) {
        Binding binding = this.getBinding0(cArray, n);
        if (binding != null) {
            return binding;
        }
        PackageBinding packageBinding = this.getPackage0(cArray);
        if (packageBinding != null && packageBinding != LookupEnvironment.TheNotFoundPackage) {
            return packageBinding;
        }
        if (binding == null) {
            binding = this.environment.askForBinding(this, cArray, n);
            if (binding != null) {
                return binding;
            }
            this.addNotFoundBinding(cArray, n);
        }
        if (packageBinding == null) {
            packageBinding = this.findPackage(cArray);
            if (packageBinding != null) {
                return packageBinding;
            }
            this.addNotFoundPackage(cArray);
        }
        return null;
    }

    public char[] readableName() {
        return CharOperation.concatWith(this.compoundName, '.');
    }

    public String toString() {
        if (this.compoundName == CharOperation.NO_CHAR_CHAR) {
            return "The Default Package";
        }
        return "package " + (this.compoundName != null ? CharOperation.toString(this.compoundName) : "UNNAMED");
    }
}

