/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.ArrayList;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.OverflowingLRUCache;
import org.eclipse.wst.jsdt.internal.core.util.LRUCache;

public class BufferCache
extends OverflowingLRUCache {
    private ThreadLocal buffersToClose = new ThreadLocal();

    public BufferCache(int n) {
        super(n);
    }

    public BufferCache(int n, int n2) {
        super(n, n2);
    }

    protected boolean close(LRUCache.LRUCacheEntry lRUCacheEntry) {
        IBuffer iBuffer = (IBuffer)lRUCacheEntry._fValue;
        if (!((Openable)iBuffer.getOwner()).canBufferBeRemovedFromCache(iBuffer)) {
            return false;
        }
        ArrayList<IBuffer> arrayList = (ArrayList<IBuffer>)this.buffersToClose.get();
        if (arrayList == null) {
            arrayList = new ArrayList<IBuffer>();
            this.buffersToClose.set(arrayList);
        }
        arrayList.add(iBuffer);
        return true;
    }

    void closeBuffers() {
        ArrayList arrayList = (ArrayList)this.buffersToClose.get();
        if (arrayList == null) {
            return;
        }
        this.buffersToClose.set(null);
        int n = 0;
        int n2 = arrayList.size();
        while (n < n2) {
            ((IBuffer)arrayList.get(n)).close();
            ++n;
        }
    }

    protected LRUCache newInstance(int n, int n2) {
        return new BufferCache(n, n2);
    }
}

