/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.core.ClasspathChange;
import org.eclipse.wst.jsdt.internal.core.ClasspathValidation;
import org.eclipse.wst.jsdt.internal.core.DeltaProcessingState;
import org.eclipse.wst.jsdt.internal.core.DeltaProcessor;
import org.eclipse.wst.jsdt.internal.core.JavaElementDelta;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaModelOperation;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.ProjectReferenceChange;

public abstract class ChangeClasspathOperation
extends JavaModelOperation {
    protected boolean canChangeResources;

    public ChangeClasspathOperation(IJavaElement[] iJavaElementArray, boolean bl) {
        super(iJavaElementArray);
        this.canChangeResources = bl;
    }

    protected boolean canModifyRoots() {
        return true;
    }

    protected void classpathChanged(JavaProject javaProject) throws JavaModelException {
        DeltaProcessingState deltaProcessingState = JavaModelManager.getJavaModelManager().deltaState;
        DeltaProcessor deltaProcessor = deltaProcessingState.getDeltaProcessor();
        ClasspathChange classpathChange = (ClasspathChange)deltaProcessor.classpathChanges.get(javaProject.getProject());
        if (this.canChangeResources) {
            if (this.isTopLevelOperation() && !ResourcesPlugin.getWorkspace().isTreeLocked()) {
                new ClasspathValidation(javaProject).validate();
            }
            new ProjectReferenceChange(javaProject, classpathChange.oldResolvedClasspath).updateProjectReferencesIfNecessary();
        } else {
            JavaElementDelta javaElementDelta = new JavaElementDelta(this.getJavaModel());
            int n = classpathChange.generateDelta(javaElementDelta);
            if ((n & ClasspathChange.HAS_DELTA) != 0) {
                this.addDelta(javaElementDelta);
                classpathChange.requestIndexing();
                deltaProcessingState.addClasspathValidation(javaProject);
            }
            if ((n & ClasspathChange.HAS_PROJECT_CHANGE) != 0) {
                deltaProcessingState.addProjectReferenceChange(javaProject, classpathChange.oldResolvedClasspath);
            }
        }
    }

    protected ISchedulingRule getSchedulingRule() {
        return null;
    }

    public boolean isReadOnly() {
        return !this.canChangeResources;
    }
}

