/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaModelStatus;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.core.ClasspathEntry;
import org.eclipse.wst.jsdt.internal.core.JavaModelOperation;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.util.Messages;

public class CopyPackageFragmentRootOperation
extends JavaModelOperation {
    IPath destination;
    int updateResourceFlags;
    int updateModelFlags;
    IClasspathEntry sibling;

    public CopyPackageFragmentRootOperation(IPackageFragmentRoot iPackageFragmentRoot, IPath iPath, int n, int n2, IClasspathEntry iClasspathEntry) {
        super(iPackageFragmentRoot);
        this.destination = iPath;
        this.updateResourceFlags = n;
        this.updateModelFlags = n2;
        this.sibling = iClasspathEntry;
    }

    protected void executeOperation() throws JavaModelException {
        IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)this.getElementToProcess();
        IClasspathEntry iClasspathEntry = iPackageFragmentRoot.getRawClasspathEntry();
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (!iPackageFragmentRoot.isExternal() && (this.updateModelFlags & 1) == 0) {
            this.copyResource(iPackageFragmentRoot, iClasspathEntry, iWorkspaceRoot);
        }
        if ((this.updateModelFlags & 8) != 0) {
            this.addEntryToClasspath(iClasspathEntry, iWorkspaceRoot);
        }
    }

    protected void copyResource(IPackageFragmentRoot iPackageFragmentRoot, IClasspathEntry iClasspathEntry, final IWorkspaceRoot iWorkspaceRoot) throws JavaModelException {
        char[][] cArray = ((ClasspathEntry)iClasspathEntry).fullExclusionPatternChars();
        IResource iResource = iPackageFragmentRoot.getResource();
        if (iPackageFragmentRoot.getKind() == 2 || cArray == null) {
            try {
                if ((this.updateModelFlags & 0x10) != 0) {
                    if (iClasspathEntry.getPath().equals((Object)this.destination)) {
                        return;
                    }
                    IResource iResource2 = iWorkspaceRoot.findMember(this.destination);
                    if (iResource2 != null) {
                        iResource2.delete(this.updateResourceFlags, this.progressMonitor);
                    }
                }
                iResource.copy(this.destination, this.updateResourceFlags, this.progressMonitor);
            }
            catch (CoreException coreException) {
                throw new JavaModelException(coreException);
            }
        }
        final int n = iClasspathEntry.getPath().segmentCount();
        final IFolder iFolder = iWorkspaceRoot.getFolder(this.destination);
        final IPath[] iPathArray = this.getNestedFolders(iPackageFragmentRoot);
        IResourceProxyVisitor iResourceProxyVisitor = new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy iResourceProxy) throws CoreException {
                IResource iResource;
                if (iResourceProxy.getType() == 2) {
                    IResource iResource2;
                    IPath iPath = iResourceProxy.requestFullPath();
                    if (CopyPackageFragmentRootOperation.this.prefixesOneOf(iPath, iPathArray)) {
                        if (CopyPackageFragmentRootOperation.this.equalsOneOf(iPath, iPathArray)) {
                            return false;
                        }
                        IFolder iFolder2 = iFolder.getFolder(iPath.removeFirstSegments(n));
                        if ((CopyPackageFragmentRootOperation.this.updateModelFlags & 0x10) != 0 && iFolder2.exists()) {
                            return true;
                        }
                        iFolder2.create(CopyPackageFragmentRootOperation.this.updateResourceFlags, true, CopyPackageFragmentRootOperation.this.progressMonitor);
                        return true;
                    }
                    IPath iPath2 = CopyPackageFragmentRootOperation.this.destination.append(iPath.removeFirstSegments(n));
                    if ((CopyPackageFragmentRootOperation.this.updateModelFlags & 0x10) != 0 && (iResource2 = iWorkspaceRoot.findMember(iPath2)) != null) {
                        iResource2.delete(CopyPackageFragmentRootOperation.this.updateResourceFlags, CopyPackageFragmentRootOperation.this.progressMonitor);
                    }
                    iResourceProxy.requestResource().copy(iPath2, CopyPackageFragmentRootOperation.this.updateResourceFlags, CopyPackageFragmentRootOperation.this.progressMonitor);
                    return false;
                }
                IPath iPath = iResourceProxy.requestFullPath();
                IPath iPath3 = CopyPackageFragmentRootOperation.this.destination.append(iPath.removeFirstSegments(n));
                if ((CopyPackageFragmentRootOperation.this.updateModelFlags & 0x10) != 0 && (iResource = iWorkspaceRoot.findMember(iPath3)) != null) {
                    iResource.delete(CopyPackageFragmentRootOperation.this.updateResourceFlags, CopyPackageFragmentRootOperation.this.progressMonitor);
                }
                iResourceProxy.requestResource().copy(iPath3, CopyPackageFragmentRootOperation.this.updateResourceFlags, CopyPackageFragmentRootOperation.this.progressMonitor);
                return false;
            }
        };
        try {
            iResource.accept(iResourceProxyVisitor, 0);
        }
        catch (CoreException coreException) {
            throw new JavaModelException(coreException);
        }
        CopyPackageFragmentRootOperation.setAttribute("hasModifiedResource", "true");
    }

    protected void addEntryToClasspath(IClasspathEntry iClasspathEntry, IWorkspaceRoot iWorkspaceRoot) throws JavaModelException {
        IClasspathEntry iClasspathEntry2;
        int n;
        IProject iProject = iWorkspaceRoot.getProject(this.destination.segment(0));
        IJavaProject iJavaProject = JavaCore.create(iProject);
        IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
        int n2 = iClasspathEntryArray.length;
        if ((this.updateModelFlags & 0x10) != 0) {
            n = 0;
            while (n < n2) {
                if (this.destination.equals((Object)iClasspathEntryArray[n].getPath())) {
                    IClasspathEntry[] iClasspathEntryArray2 = new IClasspathEntry[n2];
                    System.arraycopy(iClasspathEntryArray, 0, iClasspathEntryArray2, 0, n2);
                    iClasspathEntryArray2[n] = this.copy(iClasspathEntry);
                    iJavaProject.setRawClasspath(iClasspathEntryArray2, this.progressMonitor);
                    return;
                }
                ++n;
            }
        }
        if (this.sibling == null) {
            n = n2;
        } else {
            n = -1;
            int n3 = 0;
            while (n3 < n2) {
                if (this.sibling.equals(iClasspathEntryArray[n3])) {
                    n = n3;
                    break;
                }
                ++n3;
            }
        }
        if (n == -1) {
            throw new JavaModelException(new JavaModelStatus(993, this.sibling.toString()));
        }
        IClasspathEntry[] iClasspathEntryArray3 = new IClasspathEntry[n2 + 1];
        if (n != 0) {
            System.arraycopy(iClasspathEntryArray, 0, iClasspathEntryArray3, 0, n);
        }
        if (n != n2) {
            System.arraycopy(iClasspathEntryArray, n, iClasspathEntryArray3, n + 1, n2 - n);
        }
        iClasspathEntryArray3[n] = iClasspathEntry2 = this.copy(iClasspathEntry);
        iJavaProject.setRawClasspath(iClasspathEntryArray3, this.progressMonitor);
    }

    protected IClasspathEntry copy(IClasspathEntry iClasspathEntry) throws JavaModelException {
        switch (iClasspathEntry.getEntryKind()) {
            case 5: {
                return JavaCore.newContainerEntry(iClasspathEntry.getPath(), iClasspathEntry.getAccessRules(), iClasspathEntry.getExtraAttributes(), iClasspathEntry.isExported());
            }
            case 1: {
                try {
                    return JavaCore.newLibraryEntry(this.destination, iClasspathEntry.getSourceAttachmentPath(), iClasspathEntry.getSourceAttachmentRootPath(), iClasspathEntry.getAccessRules(), iClasspathEntry.getExtraAttributes(), iClasspathEntry.isExported());
                }
                catch (AssertionFailedException assertionFailedException) {
                    JavaModelStatus javaModelStatus = new JavaModelStatus(979, assertionFailedException.getMessage());
                    throw new JavaModelException(javaModelStatus);
                }
            }
            case 2: {
                return JavaCore.newProjectEntry(iClasspathEntry.getPath(), iClasspathEntry.getAccessRules(), iClasspathEntry.combineAccessRules(), iClasspathEntry.getExtraAttributes(), iClasspathEntry.isExported());
            }
            case 3: {
                return JavaCore.newSourceEntry(this.destination, iClasspathEntry.getInclusionPatterns(), iClasspathEntry.getExclusionPatterns(), iClasspathEntry.getOutputLocation(), iClasspathEntry.getExtraAttributes());
            }
            case 4: {
                try {
                    return JavaCore.newVariableEntry(iClasspathEntry.getPath(), iClasspathEntry.getSourceAttachmentPath(), iClasspathEntry.getSourceAttachmentRootPath(), iClasspathEntry.getAccessRules(), iClasspathEntry.getExtraAttributes(), iClasspathEntry.isExported());
                }
                catch (AssertionFailedException assertionFailedException) {
                    JavaModelStatus javaModelStatus = new JavaModelStatus(979, assertionFailedException.getMessage());
                    throw new JavaModelException(javaModelStatus);
                }
            }
        }
        throw new JavaModelException(new JavaModelStatus(969, this.getElementToProcess()));
    }

    public IJavaModelStatus verify() {
        IJavaModelStatus iJavaModelStatus = super.verify();
        if (!iJavaModelStatus.isOK()) {
            return iJavaModelStatus;
        }
        IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)this.getElementToProcess();
        if (iPackageFragmentRoot == null || !iPackageFragmentRoot.exists()) {
            return new JavaModelStatus(969, iPackageFragmentRoot);
        }
        IResource iResource = iPackageFragmentRoot.getResource();
        if (iResource instanceof IFolder && iResource.isLinked()) {
            return new JavaModelStatus(995, iPackageFragmentRoot);
        }
        if ((this.updateModelFlags & 8) != 0) {
            String string = this.destination.segment(0);
            IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string);
            if (JavaProject.hasJavaNature(iProject)) {
                try {
                    IJavaProject iJavaProject = JavaCore.create(iProject);
                    IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
                    boolean bl = false;
                    boolean bl2 = false;
                    int n = 0;
                    int n2 = iClasspathEntryArray.length;
                    while (n < n2) {
                        IClasspathEntry iClasspathEntry = iClasspathEntryArray[n];
                        if (iClasspathEntry.equals(this.sibling)) {
                            bl = true;
                            break;
                        }
                        if (iClasspathEntry.getPath().equals((Object)this.destination)) {
                            bl2 = true;
                        }
                        ++n;
                    }
                    if (this.sibling != null && !bl) {
                        return new JavaModelStatus(993, this.sibling.toString());
                    }
                    if (bl2 && (this.updateModelFlags & 0x10) == 0) {
                        return new JavaModelStatus(977, Messages.bind(Messages.status_nameCollision, new String[]{this.destination.toString()}));
                    }
                }
                catch (JavaModelException javaModelException) {
                    return javaModelException.getJavaModelStatus();
                }
            }
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

