/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IRegion;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaElementDelta;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.MultiOperation;
import org.eclipse.wst.jsdt.internal.core.Region;
import org.eclipse.wst.jsdt.internal.core.util.Messages;

public class DeleteElementsOperation
extends MultiOperation {
    protected Map childrenToRemove;
    protected ASTParser parser;

    public DeleteElementsOperation(IJavaElement[] iJavaElementArray, boolean bl) {
        super(iJavaElementArray, bl);
        this.initASTParser();
    }

    private void deleteElement(IJavaElement iJavaElement, ICompilationUnit iCompilationUnit) throws JavaModelException {
        iCompilationUnit.makeConsistent(this.progressMonitor);
        this.parser.setSource(iCompilationUnit);
        CompilationUnit compilationUnit = (CompilationUnit)this.parser.createAST(this.progressMonitor);
        ASTNode aSTNode = ((JavaElement)iJavaElement).findNode(compilationUnit);
        if (aSTNode == null) {
            Assert.isTrue((boolean)false, (String)("Failed to locate " + iJavaElement.getElementName() + " in " + iCompilationUnit.getElementName()));
        }
        IDocument iDocument = this.getDocument(iCompilationUnit);
        AST aST = compilationUnit.getAST();
        ASTRewrite aSTRewrite = ASTRewrite.create(aST);
        aSTRewrite.remove(aSTNode, null);
        TextEdit textEdit = aSTRewrite.rewriteAST(iDocument, null);
        try {
            textEdit.apply(iDocument);
        }
        catch (BadLocationException badLocationException) {
            throw new JavaModelException(badLocationException, 984);
        }
    }

    private void initASTParser() {
        this.parser = ASTParser.newParser(3);
    }

    protected String getMainTaskName() {
        return Messages.operation_deleteElementProgress;
    }

    protected ISchedulingRule getSchedulingRule() {
        IResource iResource;
        if (this.elementsToProcess != null && this.elementsToProcess.length == 1 && (iResource = this.elementsToProcess[0].getResource()) != null) {
            return ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule(iResource);
        }
        return super.getSchedulingRule();
    }

    protected void groupElements() throws JavaModelException {
        this.childrenToRemove = new HashMap(1);
        int n = 0;
        int n2 = 0;
        int n3 = this.elementsToProcess.length;
        while (n2 < n3) {
            IJavaElement iJavaElement = this.elementsToProcess[n2];
            ICompilationUnit iCompilationUnit = this.getCompilationUnitFor(iJavaElement);
            if (iCompilationUnit == null) {
                throw new JavaModelException(new JavaModelStatus(976, iJavaElement));
            }
            IRegion iRegion = (IRegion)this.childrenToRemove.get(iCompilationUnit);
            if (iRegion == null) {
                iRegion = new Region();
                this.childrenToRemove.put(iCompilationUnit, iRegion);
                ++n;
            }
            iRegion.add(iJavaElement);
            ++n2;
        }
        this.elementsToProcess = new IJavaElement[n];
        Iterator iterator = this.childrenToRemove.keySet().iterator();
        n3 = 0;
        while (iterator.hasNext()) {
            this.elementsToProcess[n3++] = (IJavaElement)iterator.next();
        }
    }

    protected void processElement(IJavaElement iJavaElement) throws JavaModelException {
        ICompilationUnit iCompilationUnit = (ICompilationUnit)iJavaElement;
        int n = iCompilationUnit.getImports().length;
        JavaElementDelta javaElementDelta = new JavaElementDelta(iCompilationUnit);
        IJavaElement[] iJavaElementArray = ((IRegion)this.childrenToRemove.get(iCompilationUnit)).getElements();
        int n2 = 0;
        int n3 = iJavaElementArray.length;
        while (n2 < n3) {
            IJavaElement iJavaElement2 = iJavaElementArray[n2];
            if (iJavaElement2.exists()) {
                this.deleteElement(iJavaElement2, iCompilationUnit);
                javaElementDelta.removed(iJavaElement2);
                if (iJavaElement2.getElementType() == 13 && --n == 0) {
                    javaElementDelta.removed(iCompilationUnit.getImportContainer());
                }
            }
            ++n2;
        }
        if (javaElementDelta.getAffectedChildren().length > 0) {
            iCompilationUnit.save(this.getSubProgressMonitor(1), this.force);
            if (!iCompilationUnit.isWorkingCopy()) {
                this.addDelta(javaElementDelta);
                DeleteElementsOperation.setAttribute("hasModifiedResource", "true");
            }
        }
    }

    protected void processElements() throws JavaModelException {
        this.groupElements();
        super.processElements();
    }

    protected void verify(IJavaElement iJavaElement) throws JavaModelException {
        IJavaElement[] iJavaElementArray = ((IRegion)this.childrenToRemove.get(iJavaElement)).getElements();
        int n = 0;
        while (n < iJavaElementArray.length) {
            IJavaElement iJavaElement2 = iJavaElementArray[n];
            if (iJavaElement2.getCorrespondingResource() != null) {
                this.error(967, iJavaElement2);
            }
            if (iJavaElement2.isReadOnly()) {
                this.error(976, iJavaElement2);
            }
            ++n;
        }
    }
}

