/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.internal.core.ElementCache;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaElementInfo;
import org.eclipse.wst.jsdt.internal.core.JavaModelInfo;
import org.eclipse.wst.jsdt.internal.core.VerboseElementCache;
import org.eclipse.wst.jsdt.internal.core.util.LRUCache;

public class JavaModelCache {
    public static boolean VERBOSE = false;
    public static final int DEFAULT_PROJECT_SIZE = 5;
    public static final int DEFAULT_ROOT_SIZE = 50;
    public static final int DEFAULT_PKG_SIZE = 500;
    public static final int DEFAULT_OPENABLE_SIZE = 500;
    public static final int DEFAULT_CHILDREN_SIZE = 10000;
    public static final Object NON_EXISTING_JAR_TYPE_INFO = new Object();
    protected double memoryRatio = -1.0;
    protected JavaModelInfo modelInfo;
    protected HashMap projectCache;
    protected ElementCache rootCache;
    protected ElementCache pkgCache;
    protected ElementCache openableCache;
    protected Map childrenCache;
    protected LRUCache jarTypeCache;

    public JavaModelCache() {
        double d = this.getMemoryRatio();
        this.projectCache = new HashMap(5);
        if (VERBOSE) {
            this.rootCache = new VerboseElementCache((int)(50.0 * d), "Root cache");
            this.pkgCache = new VerboseElementCache((int)(500.0 * d), "Package cache");
            this.openableCache = new VerboseElementCache((int)(500.0 * d), "Openable cache");
        } else {
            this.rootCache = new ElementCache((int)(50.0 * d));
            this.pkgCache = new ElementCache((int)(500.0 * d));
            this.openableCache = new ElementCache((int)(500.0 * d));
        }
        this.childrenCache = new HashMap((int)(10000.0 * d));
        this.resetJarTypeCache();
    }

    public Object getInfo(IJavaElement iJavaElement) {
        switch (iJavaElement.getElementType()) {
            case 1: {
                return this.modelInfo;
            }
            case 2: {
                return this.projectCache.get(iJavaElement);
            }
            case 3: {
                return this.rootCache.get(iJavaElement);
            }
            case 4: {
                return this.pkgCache.get(iJavaElement);
            }
            case 5: 
            case 6: {
                return this.openableCache.get(iJavaElement);
            }
            case 7: {
                Object object = this.jarTypeCache.get(iJavaElement);
                if (object != null) {
                    return object;
                }
                return this.childrenCache.get(iJavaElement);
            }
        }
        return this.childrenCache.get(iJavaElement);
    }

    protected double getMemoryRatio() {
        if (this.memoryRatio == -1.0) {
            long l = Runtime.getRuntime().maxMemory();
            this.memoryRatio = l == Long.MAX_VALUE ? 4.0 : (double)l / 6.7108864E7;
        }
        return this.memoryRatio;
    }

    protected Object peekAtInfo(IJavaElement iJavaElement) {
        switch (iJavaElement.getElementType()) {
            case 1: {
                return this.modelInfo;
            }
            case 2: {
                return this.projectCache.get(iJavaElement);
            }
            case 3: {
                return this.rootCache.peek(iJavaElement);
            }
            case 4: {
                return this.pkgCache.peek(iJavaElement);
            }
            case 5: 
            case 6: {
                return this.openableCache.peek(iJavaElement);
            }
            case 7: {
                Object object = this.jarTypeCache.peek(iJavaElement);
                if (object != null) {
                    return object;
                }
                return this.childrenCache.get(iJavaElement);
            }
        }
        return this.childrenCache.get(iJavaElement);
    }

    protected void putInfo(IJavaElement iJavaElement, Object object) {
        switch (iJavaElement.getElementType()) {
            case 1: {
                this.modelInfo = (JavaModelInfo)object;
                break;
            }
            case 2: {
                this.projectCache.put(iJavaElement, object);
                this.rootCache.ensureSpaceLimit(((JavaElementInfo)object).children.length, iJavaElement);
                break;
            }
            case 3: {
                this.rootCache.put(iJavaElement, object);
                this.pkgCache.ensureSpaceLimit(((JavaElementInfo)object).children.length, iJavaElement);
                break;
            }
            case 4: {
                this.pkgCache.put(iJavaElement, object);
                this.openableCache.ensureSpaceLimit(((JavaElementInfo)object).children.length, iJavaElement);
                break;
            }
            case 5: 
            case 6: {
                this.openableCache.put(iJavaElement, object);
                break;
            }
            default: {
                this.childrenCache.put(iJavaElement, object);
            }
        }
    }

    protected void removeInfo(JavaElement javaElement) {
        switch (javaElement.getElementType()) {
            case 1: {
                this.modelInfo = null;
                break;
            }
            case 2: {
                this.projectCache.remove(javaElement);
                this.rootCache.resetSpaceLimit((int)(50.0 * this.getMemoryRatio()), javaElement);
                break;
            }
            case 3: {
                this.rootCache.remove(javaElement);
                this.pkgCache.resetSpaceLimit((int)(500.0 * this.getMemoryRatio()), javaElement);
                break;
            }
            case 4: {
                this.pkgCache.remove(javaElement);
                this.openableCache.resetSpaceLimit((int)(500.0 * this.getMemoryRatio()), javaElement);
                break;
            }
            case 5: 
            case 6: {
                this.openableCache.remove(javaElement);
                break;
            }
            default: {
                this.childrenCache.remove(javaElement);
            }
        }
    }

    protected void resetJarTypeCache() {
        this.jarTypeCache = new LRUCache((int)(500.0 * this.getMemoryRatio()));
    }

    public String toString() {
        return this.toStringFillingRation("");
    }

    public String toStringFillingRation(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("Project cache: ");
        stringBuffer.append(this.projectCache.size());
        stringBuffer.append(" projects\n");
        stringBuffer.append(string);
        stringBuffer.append(this.rootCache.toStringFillingRation("Root cache"));
        stringBuffer.append('\n');
        stringBuffer.append(string);
        stringBuffer.append(this.pkgCache.toStringFillingRation("Package cache"));
        stringBuffer.append('\n');
        stringBuffer.append(string);
        stringBuffer.append(this.openableCache.toStringFillingRation("Openable cache"));
        stringBuffer.append('\n');
        stringBuffer.append(string);
        stringBuffer.append(this.jarTypeCache.toStringFillingRation("Jar type cache"));
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }
}

