/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.wst.jsdt.core.BufferChangedEvent;
import org.eclipse.wst.jsdt.core.CompletionRequestor;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.IBufferChangedListener;
import org.eclipse.wst.jsdt.core.IBufferFactory;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IOpenable;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.internal.codeassist.CompletionEngine;
import org.eclipse.wst.jsdt.internal.codeassist.SelectionEngine;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.core.BufferManager;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaModel;
import org.eclipse.wst.jsdt.internal.core.JavaModelCache;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.NameLookup;
import org.eclipse.wst.jsdt.internal.core.NullBuffer;
import org.eclipse.wst.jsdt.internal.core.OpenableElementInfo;
import org.eclipse.wst.jsdt.internal.core.PackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.SearchableEnvironment;
import org.eclipse.wst.jsdt.internal.core.SelectionRequestor;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public abstract class Openable
extends JavaElement
implements IOpenable,
IBufferChangedListener {
    protected Openable(JavaElement javaElement) {
        super(javaElement);
    }

    public void bufferChanged(BufferChangedEvent bufferChangedEvent) {
        if (bufferChangedEvent.getBuffer().isClosed()) {
            JavaModelManager.getJavaModelManager().getElementsOutOfSynchWithBuffers().remove(this);
            this.getBufferManager().removeBuffer(bufferChangedEvent.getBuffer());
        } else {
            JavaModelManager.getJavaModelManager().getElementsOutOfSynchWithBuffers().add(this);
        }
    }

    protected abstract boolean buildStructure(OpenableElementInfo var1, IProgressMonitor var2, Map var3, IResource var4) throws JavaModelException;

    public boolean canBeRemovedFromCache() {
        try {
            return !this.hasUnsavedChanges();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public boolean canBufferBeRemovedFromCache(IBuffer iBuffer) {
        return !iBuffer.hasUnsavedChanges();
    }

    protected void closeBuffer() {
        if (!this.hasBuffer()) {
            return;
        }
        IBuffer iBuffer = this.getBufferManager().getBuffer(this);
        if (iBuffer != null) {
            iBuffer.close();
            iBuffer.removeBufferChangedListener(this);
        }
    }

    protected void closing(Object object) {
        this.closeBuffer();
    }

    protected void codeComplete(ICompilationUnit iCompilationUnit, ICompilationUnit iCompilationUnit2, int n, CompletionRequestor completionRequestor, WorkingCopyOwner workingCopyOwner) throws JavaModelException {
        IBuffer iBuffer;
        PerformanceStats performanceStats;
        if (completionRequestor == null) {
            throw new IllegalArgumentException("Completion requestor cannot be null");
        }
        PerformanceStats performanceStats2 = performanceStats = CompletionEngine.PERF ? PerformanceStats.getStats((String)"org.eclipse.wst.jsdt.core/perf/completion", (Object)this) : null;
        if (performanceStats != null) {
            performanceStats.startRun(String.valueOf(new String(iCompilationUnit.getFileName())) + " at " + n);
        }
        if ((iBuffer = this.getBuffer()) == null) {
            return;
        }
        if (n < -1 || n > iBuffer.getLength()) {
            throw new JavaModelException(new JavaModelStatus(980));
        }
        JavaProject javaProject = (JavaProject)this.getJavaProject();
        SearchableEnvironment searchableEnvironment = this.newSearchableNameEnvironment(workingCopyOwner);
        searchableEnvironment.unitToSkip = iCompilationUnit2;
        CompletionEngine completionEngine = new CompletionEngine(searchableEnvironment, completionRequestor, javaProject.getOptions(true), javaProject);
        completionEngine.complete(iCompilationUnit, n, 0);
        if (performanceStats != null) {
            performanceStats.endRun();
        }
        if (NameLookup.VERBOSE) {
            System.out.println(Thread.currentThread() + " TIME SPENT in NameLoopkup#seekTypesInSourcePackage: " + searchableEnvironment.nameLookup.timeSpentInSeekTypesInSourcePackage + "ms");
            System.out.println(Thread.currentThread() + " TIME SPENT in NameLoopkup#seekTypesInBinaryPackage: " + searchableEnvironment.nameLookup.timeSpentInSeekTypesInBinaryPackage + "ms");
        }
    }

    protected IJavaElement[] codeSelect(ICompilationUnit iCompilationUnit, int n, int n2, WorkingCopyOwner workingCopyOwner) throws JavaModelException {
        PerformanceStats performanceStats;
        PerformanceStats performanceStats2 = performanceStats = SelectionEngine.PERF ? PerformanceStats.getStats((String)"org.eclipse.wst.jsdt.core/perf/selection", (Object)this) : null;
        if (performanceStats != null) {
            performanceStats.startRun(String.valueOf(new String(iCompilationUnit.getFileName())) + " at [" + n + "," + n2 + "]");
        }
        JavaProject javaProject = (JavaProject)this.getJavaProject();
        SearchableEnvironment searchableEnvironment = this.newSearchableNameEnvironment(workingCopyOwner);
        SelectionRequestor selectionRequestor = new SelectionRequestor(searchableEnvironment.nameLookup, this);
        IBuffer iBuffer = this.getBuffer();
        if (iBuffer == null) {
            return selectionRequestor.getElements();
        }
        int n3 = iBuffer.getLength();
        if (n < 0 || n2 < 0 || n + n2 > n3) {
            throw new JavaModelException(new JavaModelStatus(980));
        }
        SelectionEngine selectionEngine = new SelectionEngine(searchableEnvironment, selectionRequestor, javaProject.getOptions(true));
        selectionEngine.select(iCompilationUnit, n, n + n2 - 1);
        if (performanceStats != null) {
            performanceStats.endRun();
        }
        if (NameLookup.VERBOSE) {
            System.out.println(Thread.currentThread() + " TIME SPENT in NameLoopkup#seekTypesInSourcePackage: " + searchableEnvironment.nameLookup.timeSpentInSeekTypesInSourcePackage + "ms");
            System.out.println(Thread.currentThread() + " TIME SPENT in NameLoopkup#seekTypesInBinaryPackage: " + searchableEnvironment.nameLookup.timeSpentInSeekTypesInBinaryPackage + "ms");
        }
        return selectionRequestor.getElements();
    }

    protected Object createElementInfo() {
        return new OpenableElementInfo();
    }

    public boolean exists() {
        JavaModelManager javaModelManager = JavaModelManager.getJavaModelManager();
        if (javaModelManager.getInfo(this) != null) {
            return true;
        }
        if (!this.parentExists()) {
            return false;
        }
        PackageFragmentRoot packageFragmentRoot = this.getPackageFragmentRoot();
        if (!(packageFragmentRoot == null || packageFragmentRoot != this && packageFragmentRoot.isArchive())) {
            return this.resourceExists();
        }
        return super.exists();
    }

    public String findRecommendedLineSeparator() throws JavaModelException {
        IBuffer iBuffer = this.getBuffer();
        String string = iBuffer == null ? null : iBuffer.getContents();
        return Util.getLineSeparator(string, this.getJavaProject());
    }

    protected void generateInfos(Object object, HashMap hashMap, IProgressMonitor iProgressMonitor) throws JavaModelException {
        Object object2;
        if (JavaModelCache.VERBOSE) {
            switch (this.getElementType()) {
                case 2: {
                    object2 = "project";
                    break;
                }
                case 3: {
                    object2 = "root";
                    break;
                }
                case 4: {
                    object2 = "package";
                    break;
                }
                case 6: {
                    object2 = "class file";
                    break;
                }
                case 5: {
                    object2 = "compilation unit";
                    break;
                }
                default: {
                    object2 = "element";
                }
            }
            System.out.println(Thread.currentThread() + " OPENING " + (String)object2 + " " + this.toStringWithAncestors());
        }
        this.openParent(object, hashMap, iProgressMonitor);
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        hashMap.put(this, object);
        try {
            object2 = (OpenableElementInfo)object;
            boolean bl = this.buildStructure((OpenableElementInfo)object2, iProgressMonitor, hashMap, this.getResource());
            ((OpenableElementInfo)object2).setIsStructureKnown(bl);
        }
        catch (JavaModelException javaModelException) {
            hashMap.remove(this);
            throw javaModelException;
        }
        JavaModelManager.getJavaModelManager().getElementsOutOfSynchWithBuffers().remove(this);
        if (JavaModelCache.VERBOSE) {
            System.out.println(JavaModelManager.getJavaModelManager().cacheToString("-> "));
        }
    }

    public IBuffer getBuffer() throws JavaModelException {
        if (this.hasBuffer()) {
            Object object = this.getElementInfo();
            IBuffer iBuffer = this.getBufferManager().getBuffer(this);
            if (iBuffer == null) {
                iBuffer = this.openBuffer(null, object);
            }
            if (iBuffer instanceof NullBuffer) {
                return null;
            }
            return iBuffer;
        }
        return null;
    }

    public IBufferFactory getBufferFactory() {
        return this.getBufferManager().getDefaultBufferFactory();
    }

    protected BufferManager getBufferManager() {
        return BufferManager.getDefaultBufferManager();
    }

    public IResource getCorrespondingResource() throws JavaModelException {
        return this.getUnderlyingResource();
    }

    public IOpenable getOpenable() {
        return this;
    }

    public IResource getUnderlyingResource() throws JavaModelException {
        IResource iResource = this.parent.getUnderlyingResource();
        if (iResource == null) {
            return null;
        }
        int n = iResource.getType();
        if (n == 2 || n == 4) {
            IContainer iContainer = (IContainer)iResource;
            IResource iResource2 = iContainer.findMember(this.getElementName());
            if (iResource2 == null) {
                throw this.newNotPresentException();
            }
            return iResource2;
        }
        return iResource;
    }

    protected boolean hasBuffer() {
        return false;
    }

    public boolean hasUnsavedChanges() throws JavaModelException {
        if (this.isReadOnly() || !this.isOpen()) {
            return false;
        }
        IBuffer iBuffer = this.getBuffer();
        if (iBuffer != null && iBuffer.hasUnsavedChanges()) {
            return true;
        }
        int n = this.getElementType();
        if (n == 4 || n == 3 || n == 2 || n == 1) {
            Enumeration enumeration = this.getBufferManager().getOpenBuffers();
            while (enumeration.hasMoreElements()) {
                IJavaElement iJavaElement;
                IBuffer iBuffer2 = (IBuffer)enumeration.nextElement();
                if (!iBuffer2.hasUnsavedChanges() || !this.isAncestorOf(iJavaElement = (IJavaElement)((Object)iBuffer2.getOwner()))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isConsistent() {
        return true;
    }

    public boolean isOpen() {
        return JavaModelManager.getJavaModelManager().getInfo(this) != null;
    }

    protected boolean isSourceElement() {
        return false;
    }

    public boolean isStructureKnown() throws JavaModelException {
        return ((OpenableElementInfo)this.getElementInfo()).isStructureKnown();
    }

    public void makeConsistent(IProgressMonitor iProgressMonitor) throws JavaModelException {
    }

    public void open(IProgressMonitor iProgressMonitor) throws JavaModelException {
        this.getElementInfo(iProgressMonitor);
    }

    protected IBuffer openBuffer(IProgressMonitor iProgressMonitor, Object object) throws JavaModelException {
        return null;
    }

    protected void openParent(Object object, HashMap hashMap, IProgressMonitor iProgressMonitor) throws JavaModelException {
        Openable openable = (Openable)this.getOpenableParent();
        if (openable != null && !openable.isOpen()) {
            openable.generateInfos(openable.createElementInfo(), hashMap, iProgressMonitor);
        }
    }

    protected boolean parentExists() {
        IJavaElement iJavaElement = this.getParent();
        if (iJavaElement == null) {
            return true;
        }
        return iJavaElement.exists();
    }

    protected boolean resourceExists() {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        if (iWorkspace == null) {
            return false;
        }
        return JavaModel.getTarget((IContainer)iWorkspace.getRoot(), this.getPath().makeRelative(), true) != null;
    }

    public void save(IProgressMonitor iProgressMonitor, boolean bl) throws JavaModelException {
        if (this.isReadOnly()) {
            throw new JavaModelException(new JavaModelStatus(976, this));
        }
        IBuffer iBuffer = this.getBuffer();
        if (iBuffer != null) {
            iBuffer.save(iProgressMonitor, bl);
            this.makeConsistent(iProgressMonitor);
        }
    }

    public PackageFragmentRoot getPackageFragmentRoot() {
        return (PackageFragmentRoot)this.getAncestor(3);
    }
}

