/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.jsdt.core.CompletionRequestor;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.ICompletionRequestor;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IInitializer;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.IWorkingCopy;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.internal.codeassist.CompletionEngine;
import org.eclipse.wst.jsdt.internal.codeassist.CompletionRequestorWrapper;
import org.eclipse.wst.jsdt.internal.codeassist.ISelectionRequestor;
import org.eclipse.wst.jsdt.internal.codeassist.SelectionEngine;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.env.ISourceType;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.core.BasicCompilationUnit;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.CreateFieldOperation;
import org.eclipse.wst.jsdt.internal.core.CreateInitializerOperation;
import org.eclipse.wst.jsdt.internal.core.CreateMethodOperation;
import org.eclipse.wst.jsdt.internal.core.CreateTypeHierarchyOperation;
import org.eclipse.wst.jsdt.internal.core.CreateTypeOperation;
import org.eclipse.wst.jsdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.wst.jsdt.internal.core.Initializer;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.NameLookup;
import org.eclipse.wst.jsdt.internal.core.NamedMember;
import org.eclipse.wst.jsdt.internal.core.ResolvedSourceType;
import org.eclipse.wst.jsdt.internal.core.SearchableEnvironment;
import org.eclipse.wst.jsdt.internal.core.SourceField;
import org.eclipse.wst.jsdt.internal.core.SourceMethod;
import org.eclipse.wst.jsdt.internal.core.SourceType;
import org.eclipse.wst.jsdt.internal.core.SourceTypeElementInfo;
import org.eclipse.wst.jsdt.internal.core.TypeParameter;
import org.eclipse.wst.jsdt.internal.core.TypeParameterElementInfo;
import org.eclipse.wst.jsdt.internal.core.hierarchy.TypeHierarchy;
import org.eclipse.wst.jsdt.internal.core.util.MementoTokenizer;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class SourceType
extends NamedMember
implements IType {
    protected SourceType(JavaElement javaElement, String string) {
        super(javaElement, string);
    }

    protected void closing(Object object) throws JavaModelException {
        super.closing(object);
        SourceTypeElementInfo sourceTypeElementInfo = (SourceTypeElementInfo)object;
        ITypeParameter[] iTypeParameterArray = sourceTypeElementInfo.typeParameters;
        int n = 0;
        int n2 = iTypeParameterArray.length;
        while (n < n2) {
            ((TypeParameter)iTypeParameterArray[n]).close();
            ++n;
        }
    }

    public void codeComplete(char[] cArray, int n, int n2, char[][] cArray2, char[][] cArray3, int[] nArray, boolean bl, ICompletionRequestor iCompletionRequestor) throws JavaModelException {
        this.codeComplete(cArray, n, n2, cArray2, cArray3, nArray, bl, iCompletionRequestor, (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
    }

    public void codeComplete(char[] cArray, int n, int n2, char[][] cArray2, char[][] cArray3, int[] nArray, boolean bl, ICompletionRequestor iCompletionRequestor, WorkingCopyOwner workingCopyOwner) throws JavaModelException {
        if (iCompletionRequestor == null) {
            throw new IllegalArgumentException("Completion requestor cannot be null");
        }
        this.codeComplete(cArray, n, n2, cArray2, cArray3, nArray, bl, new CompletionRequestorWrapper(iCompletionRequestor), workingCopyOwner);
    }

    public void codeComplete(char[] cArray, int n, int n2, char[][] cArray2, char[][] cArray3, int[] nArray, boolean bl, CompletionRequestor completionRequestor) throws JavaModelException {
        this.codeComplete(cArray, n, n2, cArray2, cArray3, nArray, bl, completionRequestor, (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
    }

    public void codeComplete(char[] cArray, int n, int n2, char[][] cArray2, char[][] cArray3, int[] nArray, boolean bl, CompletionRequestor completionRequestor, WorkingCopyOwner workingCopyOwner) throws JavaModelException {
        if (completionRequestor == null) {
            throw new IllegalArgumentException("Completion requestor cannot be null");
        }
        JavaProject javaProject = (JavaProject)this.getJavaProject();
        SearchableEnvironment searchableEnvironment = this.newSearchableNameEnvironment(workingCopyOwner);
        CompletionEngine completionEngine = new CompletionEngine(searchableEnvironment, completionRequestor, javaProject.getOptions(true), javaProject);
        String string = this.getCompilationUnit().getSource();
        if (string != null && n > -1 && n < string.length()) {
            char[] cArray4 = CharOperation.concat(string.substring(0, n).toCharArray(), new char[]{'{'});
            char[] cArray5 = CharOperation.concat(new char[]{'}'}, string.substring(n).toCharArray());
            char[] cArray6 = CharOperation.concat(cArray4, cArray, cArray5);
            BasicCompilationUnit basicCompilationUnit = new BasicCompilationUnit(cArray6, null, this.getElementName(), this.getParent());
            completionEngine.complete(basicCompilationUnit, cArray4.length + n2, cArray4.length);
        } else {
            completionEngine.complete(this, cArray, n2, cArray2, cArray3, nArray, bl);
        }
        if (NameLookup.VERBOSE) {
            System.out.println(Thread.currentThread() + " TIME SPENT in NameLoopkup#seekTypesInSourcePackage: " + searchableEnvironment.nameLookup.timeSpentInSeekTypesInSourcePackage + "ms");
            System.out.println(Thread.currentThread() + " TIME SPENT in NameLoopkup#seekTypesInBinaryPackage: " + searchableEnvironment.nameLookup.timeSpentInSeekTypesInBinaryPackage + "ms");
        }
    }

    public IField createField(String string, IJavaElement iJavaElement, boolean bl, IProgressMonitor iProgressMonitor) throws JavaModelException {
        CreateFieldOperation createFieldOperation = new CreateFieldOperation(this, string, bl);
        if (iJavaElement != null) {
            createFieldOperation.createBefore(iJavaElement);
        }
        createFieldOperation.runOperation(iProgressMonitor);
        return (IField)createFieldOperation.getResultElements()[0];
    }

    public IInitializer createInitializer(String string, IJavaElement iJavaElement, IProgressMonitor iProgressMonitor) throws JavaModelException {
        CreateInitializerOperation createInitializerOperation = new CreateInitializerOperation(this, string);
        if (iJavaElement != null) {
            createInitializerOperation.createBefore(iJavaElement);
        }
        createInitializerOperation.runOperation(iProgressMonitor);
        return (IInitializer)createInitializerOperation.getResultElements()[0];
    }

    public IMethod createMethod(String string, IJavaElement iJavaElement, boolean bl, IProgressMonitor iProgressMonitor) throws JavaModelException {
        CreateMethodOperation createMethodOperation = new CreateMethodOperation(this, string, bl);
        if (iJavaElement != null) {
            createMethodOperation.createBefore(iJavaElement);
        }
        createMethodOperation.runOperation(iProgressMonitor);
        return (IMethod)createMethodOperation.getResultElements()[0];
    }

    public IType createType(String string, IJavaElement iJavaElement, boolean bl, IProgressMonitor iProgressMonitor) throws JavaModelException {
        CreateTypeOperation createTypeOperation = new CreateTypeOperation(this, string, bl);
        if (iJavaElement != null) {
            createTypeOperation.createBefore(iJavaElement);
        }
        createTypeOperation.runOperation(iProgressMonitor);
        return (IType)createTypeOperation.getResultElements()[0];
    }

    public boolean equals(Object object) {
        if (!(object instanceof SourceType)) {
            return false;
        }
        return super.equals(object);
    }

    public IMethod[] findMethods(IMethod iMethod) {
        try {
            return SourceType.findMethods(iMethod, this.getMethods());
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public IJavaElement[] getChildrenForCategory(String string) throws JavaModelException {
        IJavaElement[] iJavaElementArray = this.getChildren();
        int n = iJavaElementArray.length;
        if (n == 0) {
            return NO_ELEMENTS;
        }
        SourceTypeElementInfo sourceTypeElementInfo = (SourceTypeElementInfo)this.getElementInfo();
        HashMap hashMap = sourceTypeElementInfo.getCategories();
        if (hashMap == null) {
            return NO_ELEMENTS;
        }
        IJavaElement[] iJavaElementArray2 = new IJavaElement[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            IJavaElement iJavaElement = iJavaElementArray[n3];
            String[] stringArray = (String[])hashMap.get(iJavaElement);
            if (stringArray != null) {
                int n4 = 0;
                int n5 = stringArray.length;
                while (n4 < n5) {
                    if (stringArray[n4].equals(string)) {
                        iJavaElementArray2[n2++] = iJavaElement;
                    }
                    ++n4;
                }
            }
            ++n3;
        }
        if (n2 == 0) {
            return NO_ELEMENTS;
        }
        if (n2 < n) {
            IJavaElement[] iJavaElementArray3 = iJavaElementArray2;
            iJavaElementArray2 = new IJavaElement[n2];
            System.arraycopy(iJavaElementArray3, 0, iJavaElementArray2, 0, n2);
        }
        return iJavaElementArray2;
    }

    public IType getDeclaringType() {
        for (IJavaElement iJavaElement = this.getParent(); iJavaElement != null; iJavaElement = iJavaElement.getParent()) {
            if (iJavaElement.getElementType() == 7) {
                return (IType)iJavaElement;
            }
            if (iJavaElement instanceof IMember) {
                continue;
            }
            return null;
        }
        return null;
    }

    public int getElementType() {
        return 7;
    }

    public IField getField(String string) {
        return new SourceField(this, string);
    }

    public IField[] getFields() throws JavaModelException {
        ArrayList arrayList = this.getChildrenOfType(8);
        IField[] iFieldArray = new IField[arrayList.size()];
        arrayList.toArray(iFieldArray);
        return iFieldArray;
    }

    public String getFullyQualifiedName() {
        return this.getFullyQualifiedName('$');
    }

    public String getFullyQualifiedName(char c) {
        try {
            return this.getFullyQualifiedName(c, false);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public String getFullyQualifiedParameterizedName() throws JavaModelException {
        return this.getFullyQualifiedName('.', true);
    }

    public IJavaElement getHandleFromMemento(String string, MementoTokenizer mementoTokenizer, WorkingCopyOwner workingCopyOwner) {
        switch (string.charAt(0)) {
            case '!': {
                return this.getHandleUpdatingCountFromMemento(mementoTokenizer, workingCopyOwner);
            }
            case '^': {
                if (!mementoTokenizer.hasMoreTokens()) {
                    return this;
                }
                String string2 = mementoTokenizer.nextToken();
                JavaElement javaElement = (JavaElement)((Object)this.getField(string2));
                return javaElement.getHandleFromMemento(mementoTokenizer, workingCopyOwner);
            }
            case '|': {
                if (!mementoTokenizer.hasMoreTokens()) {
                    return this;
                }
                String string3 = mementoTokenizer.nextToken();
                JavaElement javaElement = (JavaElement)((Object)this.getInitializer(Integer.parseInt(string3)));
                return javaElement.getHandleFromMemento(mementoTokenizer, workingCopyOwner);
            }
            case '~': {
                Object object;
                Object object2;
                if (!mementoTokenizer.hasMoreTokens()) {
                    return this;
                }
                String string4 = mementoTokenizer.nextToken();
                ArrayList<String> arrayList = new ArrayList<String>();
                block15: while (mementoTokenizer.hasMoreTokens()) {
                    string = mementoTokenizer.nextToken();
                    switch (string.charAt(0)) {
                        case '[': 
                        case ']': {
                            break block15;
                        }
                        case '~': {
                            if (!mementoTokenizer.hasMoreTokens()) {
                                return this;
                            }
                            object2 = mementoTokenizer.nextToken();
                            object = new StringBuffer();
                            while (((String)object2).length() == 1 && '[' == ((String)object2).charAt(0)) {
                                ((StringBuffer)object).append('[');
                                if (!mementoTokenizer.hasMoreTokens()) {
                                    return this;
                                }
                                object2 = mementoTokenizer.nextToken();
                            }
                            arrayList.add(String.valueOf(((StringBuffer)object).toString()) + (String)object2);
                            break;
                        }
                        default: {
                            break block15;
                        }
                    }
                }
                object2 = new String[arrayList.size()];
                arrayList.toArray((T[])object2);
                object = (JavaElement)((Object)this.getMethod(string4, (String[])object2));
                switch (string.charAt(0)) {
                    case '@': 
                    case '[': 
                    case ']': {
                        return ((JavaElement)object).getHandleFromMemento(string, mementoTokenizer, workingCopyOwner);
                    }
                }
                return object;
            }
            case '[': {
                String string5;
                if (mementoTokenizer.hasMoreTokens()) {
                    string5 = mementoTokenizer.nextToken();
                    char c = string5.charAt(0);
                    if (c == '^' || c == '|' || c == '~' || c == '[' || c == '!') {
                        string = string5;
                        string5 = "";
                    } else {
                        string = null;
                    }
                } else {
                    string5 = "";
                    string = null;
                }
                JavaElement javaElement = (JavaElement)((Object)this.getType(string5));
                if (string == null) {
                    return javaElement.getHandleFromMemento(mementoTokenizer, workingCopyOwner);
                }
                return javaElement.getHandleFromMemento(string, mementoTokenizer, workingCopyOwner);
            }
            case ']': {
                if (!mementoTokenizer.hasMoreTokens()) {
                    return this;
                }
                String string6 = mementoTokenizer.nextToken();
                TypeParameter typeParameter = new TypeParameter(this, string6);
                return typeParameter.getHandleFromMemento(mementoTokenizer, workingCopyOwner);
            }
        }
        return null;
    }

    public IInitializer getInitializer(int n) {
        return new Initializer(this, n);
    }

    public IInitializer[] getInitializers() throws JavaModelException {
        ArrayList arrayList = this.getChildrenOfType(10);
        IInitializer[] iInitializerArray = new IInitializer[arrayList.size()];
        arrayList.toArray(iInitializerArray);
        return iInitializerArray;
    }

    public String getKey() {
        try {
            return this.getKey(this, false);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public IMethod getMethod(String string, String[] stringArray) {
        return new SourceMethod(this, string, stringArray);
    }

    public IMethod[] getMethods() throws JavaModelException {
        ArrayList arrayList = this.getChildrenOfType(9);
        IMethod[] iMethodArray = new IMethod[arrayList.size()];
        arrayList.toArray(iMethodArray);
        return iMethodArray;
    }

    public IPackageFragment getPackageFragment() {
        IJavaElement iJavaElement = this.parent;
        while (iJavaElement != null) {
            if (iJavaElement.getElementType() == 4) {
                return (IPackageFragment)iJavaElement;
            }
            iJavaElement = iJavaElement.getParent();
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public IJavaElement getPrimaryElement(boolean bl) {
        IJavaElement iJavaElement;
        if (bl && ((CompilationUnit)(iJavaElement = (CompilationUnit)this.getAncestor(5))).isPrimary()) {
            return this;
        }
        iJavaElement = this.parent.getPrimaryElement(false);
        switch (iJavaElement.getElementType()) {
            case 5: {
                return ((ICompilationUnit)iJavaElement).getType(this.name);
            }
            case 7: {
                return ((IType)iJavaElement).getType(this.name);
            }
            case 8: 
            case 9: 
            case 10: {
                return ((IMember)iJavaElement).getType(this.name, this.occurrenceCount);
            }
        }
        return this;
    }

    public String getSuperclassName() throws JavaModelException {
        SourceTypeElementInfo sourceTypeElementInfo = (SourceTypeElementInfo)this.getElementInfo();
        char[] cArray = sourceTypeElementInfo.getSuperclassName();
        if (cArray == null) {
            return null;
        }
        return new String(cArray);
    }

    public String getSuperclassTypeSignature() throws JavaModelException {
        SourceTypeElementInfo sourceTypeElementInfo = (SourceTypeElementInfo)this.getElementInfo();
        char[] cArray = sourceTypeElementInfo.getSuperclassName();
        if (cArray == null) {
            return null;
        }
        return new String(Signature.createTypeSignature(cArray, false));
    }

    public String[] getSuperInterfaceNames() throws JavaModelException {
        SourceTypeElementInfo sourceTypeElementInfo = (SourceTypeElementInfo)this.getElementInfo();
        char[][] cArray = sourceTypeElementInfo.getInterfaceNames();
        return CharOperation.toStrings(cArray);
    }

    public String[] getSuperInterfaceTypeSignatures() throws JavaModelException {
        SourceTypeElementInfo sourceTypeElementInfo = (SourceTypeElementInfo)this.getElementInfo();
        char[][] cArray = sourceTypeElementInfo.getInterfaceNames();
        if (cArray == null) {
            return CharOperation.NO_STRINGS;
        }
        String[] stringArray = new String[cArray.length];
        int n = 0;
        while (n < cArray.length) {
            stringArray[n] = new String(Signature.createTypeSignature(cArray[n], false));
            ++n;
        }
        return stringArray;
    }

    public ITypeParameter[] getTypeParameters() throws JavaModelException {
        SourceTypeElementInfo sourceTypeElementInfo = (SourceTypeElementInfo)this.getElementInfo();
        return sourceTypeElementInfo.typeParameters;
    }

    public String[] getTypeParameterSignatures() throws JavaModelException {
        ITypeParameter[] iTypeParameterArray = this.getTypeParameters();
        int n = iTypeParameterArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            TypeParameter typeParameter = (TypeParameter)iTypeParameterArray[n2];
            TypeParameterElementInfo typeParameterElementInfo = (TypeParameterElementInfo)typeParameter.getElementInfo();
            char[][] cArray = typeParameterElementInfo.bounds;
            if (cArray == null) {
                stringArray[n2] = Signature.createTypeParameterSignature(typeParameter.getElementName(), CharOperation.NO_STRINGS);
            } else {
                int n3 = cArray.length;
                char[][] cArrayArray = new char[n3][];
                int n4 = 0;
                while (n4 < n3) {
                    cArrayArray[n4] = Signature.createCharArrayTypeSignature(cArray[n4], false);
                    ++n4;
                }
                stringArray[n2] = new String(Signature.createTypeParameterSignature(typeParameter.getElementName().toCharArray(), cArrayArray));
            }
            ++n2;
        }
        return stringArray;
    }

    public IType getType(String string) {
        return new SourceType(this, string);
    }

    public ITypeParameter getTypeParameter(String string) {
        return new TypeParameter(this, string);
    }

    public String getTypeQualifiedName() {
        return this.getTypeQualifiedName('$');
    }

    public String getTypeQualifiedName(char c) {
        try {
            return this.getTypeQualifiedName(c, false);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public IType[] getTypes() throws JavaModelException {
        ArrayList arrayList = this.getChildrenOfType(7);
        IType[] iTypeArray = new IType[arrayList.size()];
        arrayList.toArray(iTypeArray);
        return iTypeArray;
    }

    public boolean isAnonymous() {
        return this.name.length() == 0 || this.name.startsWith(Util.ANONYMOUS_MARKER);
    }

    public boolean isClass() throws JavaModelException {
        SourceTypeElementInfo sourceTypeElementInfo = (SourceTypeElementInfo)this.getElementInfo();
        return TypeDeclaration.kind(sourceTypeElementInfo.getModifiers()) == 1;
    }

    public boolean isEnum() throws JavaModelException {
        SourceTypeElementInfo sourceTypeElementInfo = (SourceTypeElementInfo)this.getElementInfo();
        return TypeDeclaration.kind(sourceTypeElementInfo.getModifiers()) == 3;
    }

    public boolean isInterface() throws JavaModelException {
        SourceTypeElementInfo sourceTypeElementInfo = (SourceTypeElementInfo)this.getElementInfo();
        switch (TypeDeclaration.kind(sourceTypeElementInfo.getModifiers())) {
            case 2: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public boolean isAnnotation() throws JavaModelException {
        SourceTypeElementInfo sourceTypeElementInfo = (SourceTypeElementInfo)this.getElementInfo();
        return TypeDeclaration.kind(sourceTypeElementInfo.getModifiers()) == 4;
    }

    public boolean isLocal() {
        switch (this.parent.getElementType()) {
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    public boolean isMember() {
        return this.getDeclaringType() != null;
    }

    public boolean isResolved() {
        return false;
    }

    public ITypeHierarchy loadTypeHierachy(InputStream inputStream, IProgressMonitor iProgressMonitor) throws JavaModelException {
        return this.loadTypeHierachy(inputStream, DefaultWorkingCopyOwner.PRIMARY, iProgressMonitor);
    }

    public ITypeHierarchy loadTypeHierachy(InputStream inputStream, WorkingCopyOwner workingCopyOwner, IProgressMonitor iProgressMonitor) throws JavaModelException {
        return TypeHierarchy.load(this, inputStream, workingCopyOwner);
    }

    public ITypeHierarchy newSupertypeHierarchy(IProgressMonitor iProgressMonitor) throws JavaModelException {
        return this.newSupertypeHierarchy(DefaultWorkingCopyOwner.PRIMARY, iProgressMonitor);
    }

    public ITypeHierarchy newSupertypeHierarchy(ICompilationUnit[] iCompilationUnitArray, IProgressMonitor iProgressMonitor) throws JavaModelException {
        CreateTypeHierarchyOperation createTypeHierarchyOperation = new CreateTypeHierarchyOperation((IType)this, iCompilationUnitArray, SearchEngine.createWorkspaceScope(), false);
        createTypeHierarchyOperation.runOperation(iProgressMonitor);
        return createTypeHierarchyOperation.getResult();
    }

    public ITypeHierarchy newSupertypeHierarchy(IWorkingCopy[] iWorkingCopyArray, IProgressMonitor iProgressMonitor) throws JavaModelException {
        ICompilationUnit[] iCompilationUnitArray;
        if (iWorkingCopyArray == null) {
            iCompilationUnitArray = null;
        } else {
            int n = iWorkingCopyArray.length;
            iCompilationUnitArray = new ICompilationUnit[n];
            System.arraycopy(iWorkingCopyArray, 0, iCompilationUnitArray, 0, n);
        }
        return this.newSupertypeHierarchy(iCompilationUnitArray, iProgressMonitor);
    }

    public ITypeHierarchy newSupertypeHierarchy(WorkingCopyOwner workingCopyOwner, IProgressMonitor iProgressMonitor) throws JavaModelException {
        ICompilationUnit[] iCompilationUnitArray = JavaModelManager.getJavaModelManager().getWorkingCopies(workingCopyOwner, true);
        CreateTypeHierarchyOperation createTypeHierarchyOperation = new CreateTypeHierarchyOperation((IType)this, iCompilationUnitArray, SearchEngine.createWorkspaceScope(), false);
        createTypeHierarchyOperation.runOperation(iProgressMonitor);
        return createTypeHierarchyOperation.getResult();
    }

    public ITypeHierarchy newTypeHierarchy(IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws JavaModelException {
        return this.newTypeHierarchy(iJavaProject, DefaultWorkingCopyOwner.PRIMARY, iProgressMonitor);
    }

    public ITypeHierarchy newTypeHierarchy(IJavaProject iJavaProject, WorkingCopyOwner workingCopyOwner, IProgressMonitor iProgressMonitor) throws JavaModelException {
        if (iJavaProject == null) {
            throw new IllegalArgumentException(Messages.hierarchy_nullProject);
        }
        ICompilationUnit[] iCompilationUnitArray = JavaModelManager.getJavaModelManager().getWorkingCopies(workingCopyOwner, true);
        ICompilationUnit[] iCompilationUnitArray2 = null;
        if (iCompilationUnitArray != null) {
            int n = iCompilationUnitArray.length;
            iCompilationUnitArray2 = new ICompilationUnit[n];
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                ICompilationUnit iCompilationUnit = iCompilationUnitArray[n3];
                if (iJavaProject.equals(iCompilationUnit.getJavaProject())) {
                    iCompilationUnitArray2[n2++] = iCompilationUnit;
                }
                ++n3;
            }
            if (n2 != n) {
                ICompilationUnit[] iCompilationUnitArray3 = iCompilationUnitArray2;
                iCompilationUnitArray2 = new ICompilationUnit[n2];
                System.arraycopy(iCompilationUnitArray3, 0, iCompilationUnitArray2, 0, n2);
            }
        }
        CreateTypeHierarchyOperation createTypeHierarchyOperation = new CreateTypeHierarchyOperation((IType)this, iCompilationUnitArray2, iJavaProject, true);
        createTypeHierarchyOperation.runOperation(iProgressMonitor);
        return createTypeHierarchyOperation.getResult();
    }

    public ITypeHierarchy newTypeHierarchy(IProgressMonitor iProgressMonitor) throws JavaModelException {
        CreateTypeHierarchyOperation createTypeHierarchyOperation = new CreateTypeHierarchyOperation((IType)this, null, SearchEngine.createWorkspaceScope(), true);
        createTypeHierarchyOperation.runOperation(iProgressMonitor);
        return createTypeHierarchyOperation.getResult();
    }

    public ITypeHierarchy newTypeHierarchy(ICompilationUnit[] iCompilationUnitArray, IProgressMonitor iProgressMonitor) throws JavaModelException {
        CreateTypeHierarchyOperation createTypeHierarchyOperation = new CreateTypeHierarchyOperation((IType)this, iCompilationUnitArray, SearchEngine.createWorkspaceScope(), true);
        createTypeHierarchyOperation.runOperation(iProgressMonitor);
        return createTypeHierarchyOperation.getResult();
    }

    public ITypeHierarchy newTypeHierarchy(IWorkingCopy[] iWorkingCopyArray, IProgressMonitor iProgressMonitor) throws JavaModelException {
        ICompilationUnit[] iCompilationUnitArray;
        if (iWorkingCopyArray == null) {
            iCompilationUnitArray = null;
        } else {
            int n = iWorkingCopyArray.length;
            iCompilationUnitArray = new ICompilationUnit[n];
            System.arraycopy(iWorkingCopyArray, 0, iCompilationUnitArray, 0, n);
        }
        return this.newTypeHierarchy(iCompilationUnitArray, iProgressMonitor);
    }

    public ITypeHierarchy newTypeHierarchy(WorkingCopyOwner workingCopyOwner, IProgressMonitor iProgressMonitor) throws JavaModelException {
        ICompilationUnit[] iCompilationUnitArray = JavaModelManager.getJavaModelManager().getWorkingCopies(workingCopyOwner, true);
        CreateTypeHierarchyOperation createTypeHierarchyOperation = new CreateTypeHierarchyOperation((IType)this, iCompilationUnitArray, SearchEngine.createWorkspaceScope(), true);
        createTypeHierarchyOperation.runOperation(iProgressMonitor);
        return createTypeHierarchyOperation.getResult();
    }

    public JavaElement resolved(Binding binding) {
        ResolvedSourceType resolvedSourceType = new ResolvedSourceType(this.parent, this.name, new String(binding.computeUniqueKey()));
        resolvedSourceType.occurrenceCount = this.occurrenceCount;
        return resolvedSourceType;
    }

    public String[][] resolveType(String string) throws JavaModelException {
        return this.resolveType(string, DefaultWorkingCopyOwner.PRIMARY);
    }

    public String[][] resolveType(String string, WorkingCopyOwner workingCopyOwner) throws JavaModelException {
        ISourceType iSourceType = (ISourceType)this.getElementInfo();
        JavaProject javaProject = (JavaProject)this.getJavaProject();
        SearchableEnvironment searchableEnvironment = this.newSearchableNameEnvironment(workingCopyOwner);
        class TypeResolveRequestor
        implements ISelectionRequestor {
            String[][] answers;
            final /* synthetic */ SourceType this$0;

            TypeResolveRequestor(SourceType sourceType) {
                this.this$0 = sourceType;
                this.answers = null;
            }

            public void acceptType(char[] cArray, char[] cArray2, int n, boolean bl, char[] cArray3, int n2, int n3) {
                String[] stringArray = new String[]{new String(cArray), new String(cArray2)};
                if (this.answers == null) {
                    this.answers = new String[][]{stringArray};
                } else {
                    int n4 = this.answers.length;
                    this.answers = new String[n4 + 1][];
                    System.arraycopy(this.answers, 0, this.answers, 0, n4);
                    this.answers[n4] = stringArray;
                }
            }

            public void acceptError(CategorizedProblem categorizedProblem) {
            }

            public void acceptField(char[] cArray, char[] cArray2, char[] cArray3, boolean bl, char[] cArray4, int n, int n2) {
            }

            public void acceptMethod(char[] cArray, char[] cArray2, String string, char[] cArray3, char[][] cArray4, char[][] cArray5, String[] stringArray, char[][] cArray6, char[][][] cArray7, boolean bl, boolean bl2, char[] cArray8, int n, int n2) {
            }

            public void acceptPackage(char[] cArray) {
            }

            public void acceptTypeParameter(char[] cArray, char[] cArray2, char[] cArray3, boolean bl, int n, int n2) {
            }

            public void acceptMethodTypeParameter(char[] cArray, char[] cArray2, char[] cArray3, int n, int n2, char[] cArray4, boolean bl, int n3, int n4) {
            }
        }
        TypeResolveRequestor typeResolveRequestor = new TypeResolveRequestor(this);
        SelectionEngine selectionEngine = new SelectionEngine(searchableEnvironment, typeResolveRequestor, javaProject.getOptions(true));
        IType[] iTypeArray = this.getCompilationUnit().getTypes();
        int n = iTypeArray.length;
        SourceTypeElementInfo[] sourceTypeElementInfoArray = new SourceTypeElementInfo[n];
        int n2 = 0;
        while (n2 < n) {
            sourceTypeElementInfoArray[n2] = (SourceTypeElementInfo)((SourceType)iTypeArray[n2]).getElementInfo();
            ++n2;
        }
        selectionEngine.selectType(iSourceType, string.toCharArray(), sourceTypeElementInfoArray, false);
        if (NameLookup.VERBOSE) {
            System.out.println(Thread.currentThread() + " TIME SPENT in NameLoopkup#seekTypesInSourcePackage: " + searchableEnvironment.nameLookup.timeSpentInSeekTypesInSourcePackage + "ms");
            System.out.println(Thread.currentThread() + " TIME SPENT in NameLoopkup#seekTypesInBinaryPackage: " + searchableEnvironment.nameLookup.timeSpentInSeekTypesInBinaryPackage + "ms");
        }
        return typeResolveRequestor.answers;
    }

    public String getDisplayName() {
        if (this.isAnonymous()) {
            return "";
        }
        return super.getDisplayName();
    }

    protected void toStringInfo(int n, StringBuffer stringBuffer, Object object, boolean bl) {
        stringBuffer.append(this.tabString(n));
        if (object == null) {
            String string = this.getElementName();
            if (string.length() == 0) {
                stringBuffer.append("<anonymous #");
                stringBuffer.append(this.occurrenceCount);
                stringBuffer.append(">");
            } else {
                this.toStringName(stringBuffer);
            }
            stringBuffer.append(" (not open)");
        } else if (object == NO_INFO) {
            String string = this.getElementName();
            if (string.length() == 0) {
                stringBuffer.append("<anonymous #");
                stringBuffer.append(this.occurrenceCount);
                stringBuffer.append(">");
            } else {
                this.toStringName(stringBuffer);
            }
        } else {
            try {
                if (this.isEnum()) {
                    stringBuffer.append("enum ");
                } else if (this.isAnnotation()) {
                    stringBuffer.append("@interface ");
                } else if (this.isInterface()) {
                    stringBuffer.append("interface ");
                } else {
                    stringBuffer.append("class ");
                }
                String string = this.getElementName();
                if (string.length() == 0) {
                    stringBuffer.append("<anonymous #");
                    stringBuffer.append(this.occurrenceCount);
                    stringBuffer.append(">");
                } else {
                    this.toStringName(stringBuffer);
                }
            }
            catch (JavaModelException javaModelException) {
                stringBuffer.append("<JavaModelException in toString of " + this.getElementName());
            }
        }
    }
}

