/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import org.eclipse.wst.jsdt.core.IType;

public final class TypeVector {
    static int INITIAL_SIZE = 10;
    public int size;
    int maxSize;
    IType[] elements;
    public static final IType[] NoElements = new IType[0];

    public TypeVector() {
        this.maxSize = INITIAL_SIZE;
        this.size = 0;
        this.elements = new IType[this.maxSize];
    }

    public TypeVector(IType[] iTypeArray) {
        this.size = iTypeArray.length;
        this.maxSize = this.size + 1;
        this.elements = new IType[this.maxSize];
        System.arraycopy(iTypeArray, 0, this.elements, 0, this.size);
    }

    public TypeVector(IType iType) {
        this.maxSize = INITIAL_SIZE;
        this.size = 1;
        this.elements = new IType[this.maxSize];
        this.elements[0] = iType;
    }

    public void add(IType iType) {
        if (this.size == this.maxSize) {
            this.elements = new IType[this.maxSize *= 2];
            System.arraycopy(this.elements, 0, this.elements, 0, this.size);
        }
        this.elements[this.size++] = iType;
    }

    public void addAll(IType[] iTypeArray) {
        if (this.size + iTypeArray.length >= this.maxSize) {
            this.maxSize = this.size + iTypeArray.length;
            this.elements = new IType[this.maxSize];
            System.arraycopy(this.elements, 0, this.elements, 0, this.size);
        }
        System.arraycopy(iTypeArray, 0, this.elements, this.size, iTypeArray.length);
        this.size += iTypeArray.length;
    }

    public boolean contains(IType iType) {
        int n = this.size;
        while (--n >= 0) {
            if (!iType.equals(this.elements[n])) continue;
            return true;
        }
        return false;
    }

    public TypeVector copy() {
        TypeVector typeVector = new TypeVector();
        int n = this.elements.length;
        typeVector.elements = new IType[n];
        System.arraycopy(this.elements, 0, typeVector.elements, 0, n);
        typeVector.size = this.size;
        typeVector.maxSize = this.maxSize;
        return typeVector;
    }

    public IType elementAt(int n) {
        return this.elements[n];
    }

    public IType[] elements() {
        if (this.size == 0) {
            return NoElements;
        }
        if (this.size < this.maxSize) {
            this.maxSize = this.size;
            this.elements = new IType[this.maxSize];
            System.arraycopy(this.elements, 0, this.elements, 0, this.size);
        }
        return this.elements;
    }

    public IType find(IType iType) {
        int n = this.size;
        while (--n >= 0) {
            if (iType != this.elements[n]) continue;
            return this.elements[n];
        }
        return null;
    }

    public IType remove(IType iType) {
        int n = this.size;
        while (--n >= 0) {
            if (iType != this.elements[n]) continue;
            System.arraycopy(this.elements, n + 1, this.elements, n, --this.size - n);
            this.elements[this.size] = null;
            return iType;
        }
        return null;
    }

    public void removeAll() {
        int n = this.size;
        while (--n >= 0) {
            this.elements[n] = null;
        }
        this.size = 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        int n = 0;
        while (n < this.size) {
            stringBuffer.append("\n");
            stringBuffer.append(this.elements[n]);
            ++n;
        }
        stringBuffer.append("\n]");
        return stringBuffer.toString();
    }
}

