/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.UserLibrary;
import org.osgi.service.prefs.BackingStoreException;

public class UserLibraryManager {
    public static final String CP_USERLIBRARY_PREFERENCES_PREFIX = "org.eclipse.wst.jsdt.core.userLibrary.";
    public static final String CP_ENTRY_IGNORE = "##<cp entry ignore>##";
    private static Map UserLibraries;
    private static ThreadLocal InitializingLibraries;
    private static final boolean logProblems = false;
    private static IEclipsePreferences.IPreferenceChangeListener listener;

    static {
        InitializingLibraries = new ThreadLocal();
        listener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent preferenceChangeEvent) {
                String string = preferenceChangeEvent.getKey();
                if (string.startsWith(UserLibraryManager.CP_USERLIBRARY_PREFERENCES_PREFIX)) {
                    try {
                        UserLibraryManager.recreatePersistedUserLibraryEntry(string, (String)preferenceChangeEvent.getNewValue(), false, true);
                    }
                    catch (JavaModelException javaModelException) {}
                }
            }
        };
    }

    private UserLibraryManager() {
    }

    public static String[] getUserLibraryNames() {
        Set set = UserLibraryManager.getLibraryMap().keySet();
        return set.toArray(new String[set.size()]);
    }

    public static UserLibrary getUserLibrary(String string) {
        return (UserLibrary)UserLibraryManager.getLibraryMap().get(string);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setUserLibraries(String[] stringArray, UserLibrary[] userLibraryArray, IProgressMonitor iProgressMonitor) throws JavaModelException {
        Assert.isTrue((stringArray.length == userLibraryArray.length ? 1 : 0) != 0, (String)"names and libraries should have the same length");
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            iProgressMonitor.beginTask("", stringArray.length);
            int n = stringArray.length - 1;
            int n2 = 0;
            while (n2 < userLibraryArray.length) {
                UserLibraryManager.internalSetUserLibrary(stringArray[n2], userLibraryArray[n2], n2 == n, true, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                ++n2;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        iProgressMonitor.done();
    }

    public static void setUserLibrary(String string, UserLibrary userLibrary, IProgressMonitor iProgressMonitor) throws JavaModelException {
        UserLibraryManager.internalSetUserLibrary(string, userLibrary, true, true, iProgressMonitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Map getLibraryMap() {
        if (UserLibraries != null) return UserLibraries;
        HashMap hashMap = (HashMap)InitializingLibraries.get();
        if (hashMap != null) {
            return hashMap;
        }
        try {
            hashMap = new HashMap();
            InitializingLibraries.set(hashMap);
            IEclipsePreferences iEclipsePreferences = JavaModelManager.getJavaModelManager().getInstancePreferences();
            iEclipsePreferences.addPreferenceChangeListener(listener);
            try {
                String[] stringArray = iEclipsePreferences.keys();
                int n = 0;
                while (n < stringArray.length) {
                    String string = stringArray[n];
                    if (string.startsWith(CP_USERLIBRARY_PREFERENCES_PREFIX)) {
                        try {
                            String string2 = iEclipsePreferences.get(string, null);
                            if (string2 != null) {
                                UserLibraryManager.recreatePersistedUserLibraryEntry(string, string2, false, false);
                            }
                        }
                        catch (JavaModelException javaModelException) {}
                    }
                    ++n;
                }
            }
            catch (BackingStoreException backingStoreException) {}
            UserLibraries = hashMap;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            InitializingLibraries.set(null);
            throw throwable;
        }
        {
            Object var6_8 = null;
            InitializingLibraries.set(null);
            return UserLibraries;
        }
    }

    static void recreatePersistedUserLibraryEntry(String string, String string2, boolean bl, boolean bl2) throws JavaModelException {
        String string3 = string.substring(CP_USERLIBRARY_PREFERENCES_PREFIX.length());
        if (string2 == null || string2.equals(CP_ENTRY_IGNORE)) {
            UserLibraryManager.internalSetUserLibrary(string3, null, bl, bl2, null);
        } else {
            try {
                StringReader stringReader = new StringReader(string2);
                UserLibrary userLibrary = UserLibrary.createFromString(stringReader);
                UserLibraryManager.internalSetUserLibrary(string3, userLibrary, bl, bl2, null);
            }
            catch (IOException iOException) {
                UserLibraryManager.internalSetUserLibrary(string3, null, bl, bl2, null);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void internalSetUserLibrary(String string, UserLibrary userLibrary, boolean bl, boolean bl2, IProgressMonitor iProgressMonitor) throws JavaModelException {
        Object object;
        if (userLibrary == null ? (object = UserLibraryManager.getLibraryMap().remove(string)) == null : userLibrary.equals(object = UserLibraryManager.getLibraryMap().put(string, userLibrary))) {
            return;
        }
        object = JavaModelManager.getJavaModelManager().getInstancePreferences();
        String string2 = CP_USERLIBRARY_PREFERENCES_PREFIX + string;
        String string3 = CP_ENTRY_IGNORE;
        if (userLibrary != null) {
            try {
                string3 = userLibrary.serialize();
            }
            catch (IOException iOException) {}
        }
        object.removePreferenceChangeListener(listener);
        try {
            object.put(string2, string3);
            if (bl) {
                try {
                    object.flush();
                }
                catch (BackingStoreException backingStoreException) {}
            }
            if (bl2) {
                UserLibraryManager.rebindClasspathEntries(string, userLibrary == null, iProgressMonitor);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            object.addPreferenceChangeListener(listener);
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        object.addPreferenceChangeListener(listener);
    }

    /*
     * Exception decompiling
     */
    private static void rebindClasspathEntries(String var0, boolean var1_1, IProgressMonitor var2_2) throws JavaModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 258->262)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

