/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.builder;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.JavaConventions;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.compiler.BuildContext;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.AbstractAnnotationProcessorManager;
import org.eclipse.wst.jsdt.internal.compiler.ClassFile;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.Compiler;
import org.eclipse.wst.jsdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.wst.jsdt.internal.compiler.ICompilerRequestor;
import org.eclipse.wst.jsdt.internal.compiler.IProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.env.INameEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleSet;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.builder.BatchImageBuilder;
import org.eclipse.wst.jsdt.internal.core.builder.BuildNotifier;
import org.eclipse.wst.jsdt.internal.core.builder.ClasspathMultiDirectory;
import org.eclipse.wst.jsdt.internal.core.builder.CompilationParticipantResult;
import org.eclipse.wst.jsdt.internal.core.builder.ICompilationUnitLocator;
import org.eclipse.wst.jsdt.internal.core.builder.ImageBuilderInternalException;
import org.eclipse.wst.jsdt.internal.core.builder.JavaBuilder;
import org.eclipse.wst.jsdt.internal.core.builder.NameEnvironment;
import org.eclipse.wst.jsdt.internal.core.builder.ProblemFactory;
import org.eclipse.wst.jsdt.internal.core.builder.ReferenceCollection;
import org.eclipse.wst.jsdt.internal.core.builder.SourceFile;
import org.eclipse.wst.jsdt.internal.core.builder.State;
import org.eclipse.wst.jsdt.internal.core.builder.WorkQueue;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public abstract class AbstractImageBuilder
implements ICompilerRequestor,
ICompilationUnitLocator {
    protected JavaBuilder javaBuilder;
    protected State newState;
    protected NameEnvironment nameEnvironment;
    protected ClasspathMultiDirectory[] sourceLocations;
    protected BuildNotifier notifier;
    protected Compiler compiler;
    protected WorkQueue workQueue;
    protected ArrayList problemSourceFiles;
    protected boolean compiledAllAtOnce;
    private boolean inCompiler;
    protected boolean keepStoringProblemMarkers;
    protected SimpleSet filesWithAnnotations = null;
    public static int MAX_AT_ONCE = 2000;
    public static final String[] JAVA_PROBLEM_MARKER_ATTRIBUTE_NAMES = new String[]{"message", "severity", "id", "charStart", "charEnd", "lineNumber", "arguments", "categoryId"};
    public static final String[] JAVA_TASK_MARKER_ATTRIBUTE_NAMES = new String[]{"message", "priority", "id", "charStart", "charEnd", "lineNumber", "userEditable", "sourceId"};
    public static final Integer S_ERROR = new Integer(2);
    public static final Integer S_WARNING = new Integer(1);
    public static final Integer P_HIGH = new Integer(2);
    public static final Integer P_NORMAL = new Integer(1);
    public static final Integer P_LOW = new Integer(0);

    protected AbstractImageBuilder(JavaBuilder javaBuilder, boolean bl, State state) {
        this.javaBuilder = javaBuilder;
        this.nameEnvironment = javaBuilder.nameEnvironment;
        this.sourceLocations = this.nameEnvironment.sourceLocations;
        this.notifier = javaBuilder.notifier;
        this.keepStoringProblemMarkers = true;
        if (bl) {
            this.newState = state == null ? new State(javaBuilder) : state;
            this.compiler = this.newCompiler();
            this.workQueue = new WorkQueue();
            this.problemSourceFiles = new ArrayList(3);
            if (this.javaBuilder.participants != null) {
                int n = 0;
                int n2 = this.javaBuilder.participants.length;
                while (n < n2) {
                    if (this.javaBuilder.participants[n].isAnnotationProcessor()) {
                        this.filesWithAnnotations = new SimpleSet(1);
                        break;
                    }
                    ++n;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void acceptResult(CompilationResult var1_1) {
        block17: {
            var2_2 = (SourceFile)var1_1.getCompilationUnit();
            if (this.workQueue.isCompiled(var2_2)) break block17;
            this.workQueue.finished(var2_2);
            try {
                this.updateProblemsFor(var2_2, var1_1);
                this.updateTasksFor(var2_2, var1_1);
            }
            catch (CoreException var3_3) {
                throw this.internalException(var3_3);
            }
            if (var1_1.hasInconsistentToplevelHierarchies && !this.problemSourceFiles.contains(var2_2)) {
                this.problemSourceFiles.add(var2_2);
            }
            var3_4 = null;
            var4_5 = null;
            var5_6 = var2_2.typeLocator();
            var6_7 = var1_1.getClassFiles();
            var7_8 = var6_7.length;
            var8_9 = null;
            var9_10 = new ArrayList<char[]>(var7_8);
            var10_11 = 0;
            while (var10_11 < var7_8) {
                block19: {
                    block18: {
                        var11_12 = var6_7[var10_11];
                        var12_13 = var11_12.getCompoundName();
                        var13_14 = var12_13[var12_13.length - 1];
                        v0 = var14_15 = var11_12.enclosingClassFile != null;
                        if (!var14_15) break block18;
                        var15_16 = new String(var11_12.outerMostEnclosingClassFile().fileName());
                        if (!this.newState.isDuplicateLocator(var15_16, var5_6)) ** GOTO lbl53
                        break block19;
                    }
                    var15_16 = new String(var11_12.fileName());
                    if (this.newState.isDuplicateLocator(var15_16, var5_6)) {
                        if (var8_9 == null) {
                            var8_9 = new ArrayList<char[][]>();
                        }
                        var8_9.add(var12_13);
                        if (var3_4 == null) {
                            try {
                                var4_5 = var2_2.initialTypeName;
                                var3_4 = this.javaBuilder.javaProject.findType(var4_5.replace('/', '.'));
                            }
                            catch (JavaModelException v1) {}
                        }
                        if (var15_16.equals(var4_5)) {
                            var16_18 = var3_4;
                        } else {
                            var17_19 = var15_16.substring(var15_16.lastIndexOf(47) + 1);
                            var16_18 = var3_4 == null ? null : var3_4.getCompilationUnit().getType(var17_19);
                        }
                        this.createProblemFor((IResource)var2_2.resource, var16_18, Messages.bind(Messages.build_duplicateClassFile, new String(var13_14)), "error");
                    } else {
                        this.newState.recordLocatorForType(var15_16, var5_6);
                        if (!var15_16.equals(var2_2.initialTypeName)) {
                            this.acceptSecondaryType(var11_12);
                        }
lbl53:
                        // 4 sources

                        try {
                            var9_10.add(this.writeClassFile(var11_12, var2_2, var14_15 == false));
                        }
                        catch (CoreException var15_17) {
                            Util.log(var15_17, "JavaBuilder handling CoreException");
                            if (var15_17.getStatus().getCode() == 275) {
                                this.createProblemFor((IResource)var2_2.resource, null, Messages.bind(Messages.build_classFileCollision, var15_17.getMessage()), "error");
                            }
                            this.createProblemFor((IResource)var2_2.resource, null, Messages.build_inconsistentClassFile, "error");
                        }
                    }
                }
                ++var10_11;
            }
            if (var1_1.hasAnnotations && this.filesWithAnnotations != null) {
                this.filesWithAnnotations.add(var2_2);
            }
            this.finishedWith(var5_6, var1_1, var2_2.getMainTypeName(), var9_10, var8_9);
            this.notifier.compiled(var2_2);
        }
    }

    protected void acceptSecondaryType(ClassFile classFile) {
    }

    protected void addAllSourceFiles(final ArrayList arrayList) throws CoreException {
        int n = 0;
        int n2 = this.sourceLocations.length;
        while (n < n2) {
            final ClasspathMultiDirectory classpathMultiDirectory = this.sourceLocations[n];
            final char[][] cArray = classpathMultiDirectory.exclusionPatterns;
            final char[][] cArray2 = classpathMultiDirectory.inclusionPatterns;
            final boolean bl = classpathMultiDirectory.sourceFolder.equals((Object)this.javaBuilder.currentProject);
            final int n3 = classpathMultiDirectory.sourceFolder.getFullPath().segmentCount();
            final IContainer iContainer = classpathMultiDirectory.binaryFolder;
            final boolean bl2 = classpathMultiDirectory.sourceFolder.equals((Object)iContainer);
            classpathMultiDirectory.sourceFolder.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy iResourceProxy) throws CoreException {
                    switch (iResourceProxy.getType()) {
                        case 1: {
                            if (Util.isJavaLikeFileName(iResourceProxy.getName())) {
                                IResource iResource = iResourceProxy.requestResource();
                                if ((cArray != null || cArray2 != null) && Util.isExcluded(iResource.getFullPath(), cArray2, cArray, false)) {
                                    return false;
                                }
                                arrayList.add(new SourceFile((IFile)iResource, classpathMultiDirectory));
                            }
                            return false;
                        }
                        case 2: {
                            String string;
                            String string2;
                            String string3;
                            IPath iPath = null;
                            if (bl && AbstractImageBuilder.this.isExcludedFromProject(iPath = iResourceProxy.requestFullPath())) {
                                return false;
                            }
                            if (cArray != null) {
                                if (iPath == null) {
                                    iPath = iResourceProxy.requestFullPath();
                                }
                                if (Util.isExcluded(iPath, cArray2, cArray, true)) {
                                    return cArray2 != null;
                                }
                            }
                            if (bl2) break;
                            if (iPath == null) {
                                iPath = iResourceProxy.requestFullPath();
                            }
                            if ((string3 = iPath.lastSegment()).length() <= 0 || JavaConventions.validatePackageName(string3, string2 = AbstractImageBuilder.this.javaBuilder.javaProject.getOption("org.eclipse.wst.jsdt.core.compiler.source", true), string = AbstractImageBuilder.this.javaBuilder.javaProject.getOption("org.eclipse.wst.jsdt.core.compiler.compliance", true)).getSeverity() == 4) break;
                            AbstractImageBuilder.this.createFolder(iPath.removeFirstSegments(n3), iContainer);
                        }
                    }
                    return true;
                }
            }, 0);
            this.notifier.checkCancel();
            ++n;
        }
    }

    protected void cleanUp() {
        this.nameEnvironment.cleanup();
        this.javaBuilder = null;
        this.nameEnvironment = null;
        this.sourceLocations = null;
        this.notifier = null;
        this.compiler = null;
        this.workQueue = null;
        this.problemSourceFiles = null;
    }

    protected void compile(SourceFile[] sourceFileArray) {
        int n;
        BuildContext[] buildContextArray;
        if (this.filesWithAnnotations != null && this.filesWithAnnotations.elementSize > 0) {
            this.filesWithAnnotations.clear();
        }
        BuildContext[] buildContextArray2 = buildContextArray = this.javaBuilder.participants == null ? null : this.notifyParticipants(sourceFileArray);
        if (buildContextArray != null && buildContextArray.length > sourceFileArray.length) {
            sourceFileArray = new SourceFile[buildContextArray.length];
            n = buildContextArray.length;
            while (--n >= 0) {
                sourceFileArray[n] = buildContextArray[n].sourceFile;
            }
        }
        boolean bl = this.compiledAllAtOnce = (n = sourceFileArray.length) <= MAX_AT_ONCE;
        if (this.compiledAllAtOnce) {
            if (JavaBuilder.DEBUG) {
                int n2 = 0;
                while (n2 < n) {
                    System.out.println("About to compile " + sourceFileArray[n2].typeLocator());
                    ++n2;
                }
            }
            this.compile(sourceFileArray, null, true);
        } else {
            SourceFile[] sourceFileArray2 = new SourceFile[n];
            System.arraycopy(sourceFileArray, 0, sourceFileArray2, 0, n);
            int n3 = n < MAX_AT_ONCE ? n : MAX_AT_ONCE;
            SourceFile[] sourceFileArray3 = new SourceFile[n3];
            int n4 = 0;
            boolean bl2 = true;
            while (n4 < n) {
                int n5 = 0;
                while (n4 < n && n5 < n3) {
                    SourceFile sourceFile = sourceFileArray2[n4];
                    if (sourceFile != null && (bl2 || this.workQueue.isWaiting(sourceFile))) {
                        if (JavaBuilder.DEBUG) {
                            System.out.println("About to compile #" + n4 + " : " + sourceFile.typeLocator());
                        }
                        sourceFileArray3[n5++] = sourceFile;
                    }
                    sourceFileArray2[n4++] = null;
                }
                if (n5 < n3) {
                    SourceFile[] sourceFileArray4 = sourceFileArray3;
                    sourceFileArray3 = new SourceFile[n5];
                    System.arraycopy(sourceFileArray4, 0, sourceFileArray3, 0, n5);
                }
                if (!bl2) {
                    int n6 = n4;
                    while (n6 < n) {
                        if (sourceFileArray2[n6] != null && this.workQueue.isCompiled(sourceFileArray2[n6])) {
                            sourceFileArray2[n6] = null;
                        }
                        ++n6;
                    }
                }
                this.compile(sourceFileArray3, sourceFileArray2, bl2);
                bl2 = false;
            }
        }
        if (buildContextArray != null) {
            int n7 = buildContextArray.length;
            while (--n7 >= 0) {
                if (buildContextArray[n7] == null) continue;
                this.recordParticipantResult(buildContextArray[n7]);
            }
            this.processAnnotations(buildContextArray);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void compile(SourceFile[] sourceFileArray, SourceFile[] sourceFileArray2, boolean bl) {
        if (sourceFileArray.length == 0) {
            return;
        }
        this.notifier.aboutToCompile(sourceFileArray[0]);
        if (!this.problemSourceFiles.isEmpty()) {
            int n;
            int n2 = this.problemSourceFiles.size();
            int n3 = n = sourceFileArray2 == null ? 0 : sourceFileArray2.length;
            if (n == 0) {
                sourceFileArray2 = new SourceFile[n2];
            } else {
                SourceFile[] sourceFileArray3 = sourceFileArray2;
                sourceFileArray2 = new SourceFile[n + n2];
                System.arraycopy(sourceFileArray3, 0, sourceFileArray2, 0, n);
            }
            int n4 = 0;
            while (n4 < n2) {
                sourceFileArray2[n + n4] = (SourceFile)this.problemSourceFiles.get(n4);
                ++n4;
            }
        }
        String[] cfr_ignored_0 = new String[sourceFileArray.length];
        this.notifier.checkCancel();
        try {
            try {
                this.inCompiler = true;
                this.compiler.compile(sourceFileArray);
            }
            catch (AbortCompilation abortCompilation) {}
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.inCompiler = false;
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.inCompiler = false;
            this.notifier.checkCancel();
            return;
        }
    }

    protected void createProblemFor(IResource iResource, IMember iMember, String string, String string2) {
        try {
            IMarker iMarker = iResource.createMarker("org.eclipse.wst.jsdt.core.problem");
            int n = string2.equals("warning") ? 1 : 2;
            ISourceRange iSourceRange = iMember == null ? null : iMember.getNameRange();
            int n2 = iSourceRange == null ? 0 : iSourceRange.getOffset();
            int n3 = iSourceRange == null ? 1 : n2 + iSourceRange.getLength();
            iMarker.setAttributes(new String[]{"message", "severity", "charStart", "charEnd", "sourceId"}, new Object[]{string, new Integer(n), new Integer(n2), new Integer(n3), "JSDT"});
        }
        catch (CoreException coreException) {
            throw this.internalException(coreException);
        }
    }

    protected void deleteGeneratedFiles(IFile[] iFileArray) {
    }

    protected SourceFile findSourceFile(IFile iFile, boolean bl) {
        if (bl && !iFile.exists()) {
            return null;
        }
        ClasspathMultiDirectory classpathMultiDirectory = this.sourceLocations[0];
        if (this.sourceLocations.length > 1) {
            IPath iPath = iFile.getFullPath();
            int n = 0;
            int n2 = this.sourceLocations.length;
            while (n < n2) {
                if (this.sourceLocations[n].sourceFolder.getFullPath().isPrefixOf(iPath)) {
                    classpathMultiDirectory = this.sourceLocations[n];
                    if (classpathMultiDirectory.exclusionPatterns == null && classpathMultiDirectory.inclusionPatterns == null || !Util.isExcluded((IResource)iFile, classpathMultiDirectory.inclusionPatterns, classpathMultiDirectory.exclusionPatterns)) break;
                }
                ++n;
            }
        }
        return new SourceFile(iFile, classpathMultiDirectory);
    }

    protected void finishedWith(String string, CompilationResult compilationResult, char[] cArray, ArrayList arrayList, ArrayList arrayList2) {
        if (arrayList2 == null) {
            this.newState.record(string, compilationResult.qualifiedReferences, compilationResult.simpleNameReferences, cArray, arrayList);
            return;
        }
        char[][][] cArray2 = compilationResult.qualifiedReferences;
        Object object = compilationResult.simpleNameReferences;
        int n = 0;
        int n2 = arrayList2.size();
        while (n < n2) {
            block4: {
                char[][] cArray3 = (char[][])arrayList2.get(n);
                char[] cArray4 = cArray3[cArray3.length - 1];
                int n3 = ((char[][])object).length;
                int n4 = 0;
                while (n4 < n3) {
                    if (!CharOperation.equals(object[n4], cArray4)) {
                        ++n4;
                        continue;
                    }
                    break block4;
                }
                char[][] cArray5 = object;
                char[][] cArrayArray = new char[n3 + 1][];
                object = cArrayArray;
                System.arraycopy(cArray5, 0, cArrayArray, 0, n3);
                object[n3] = cArray4;
            }
            ++n;
        }
        this.newState.record(string, cArray2, (char[][])object, cArray, arrayList);
    }

    protected IContainer createFolder(IPath iPath, IContainer iContainer) throws CoreException {
        if (iPath.isEmpty()) {
            return iContainer;
        }
        IFolder iFolder = iContainer.getFolder(iPath);
        if (!iFolder.exists()) {
            this.createFolder(iPath.removeLastSegments(1), iContainer);
            iFolder.create(1025, true, null);
        }
        return iFolder;
    }

    public ICompilationUnit fromIFile(IFile iFile) {
        return this.findSourceFile(iFile, true);
    }

    protected void initializeAnnotationProcessorManager(Compiler compiler) {
        AbstractAnnotationProcessorManager abstractAnnotationProcessorManager = JavaModelManager.getJavaModelManager().createAnnotationProcessorManager();
        if (abstractAnnotationProcessorManager != null) {
            abstractAnnotationProcessorManager.configureFromPlatform(compiler, this, this.javaBuilder.javaProject);
            abstractAnnotationProcessorManager.setErr(new PrintWriter(System.err));
            abstractAnnotationProcessorManager.setOut(new PrintWriter(System.out));
        }
        compiler.annotationProcessorManager = abstractAnnotationProcessorManager;
    }

    protected RuntimeException internalException(CoreException coreException) {
        ImageBuilderInternalException imageBuilderInternalException = new ImageBuilderInternalException(coreException);
        if (this.inCompiler) {
            return new AbortCompilation(true, imageBuilderInternalException);
        }
        return imageBuilderInternalException;
    }

    protected boolean isExcludedFromProject(IPath iPath) throws JavaModelException {
        if (iPath.segmentCount() > 2) {
            return false;
        }
        int n = 0;
        int n2 = this.sourceLocations.length;
        while (n < n2) {
            if (iPath.equals((Object)this.sourceLocations[n].binaryFolder.getFullPath())) {
                return true;
            }
            if (iPath.equals((Object)this.sourceLocations[n].sourceFolder.getFullPath())) {
                return true;
            }
            ++n;
        }
        return iPath.equals((Object)this.javaBuilder.javaProject.getOutputLocation());
    }

    protected Compiler newCompiler() {
        Map map = this.javaBuilder.javaProject.getOptions(true);
        String string = (String)map.get("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadoc");
        if (!(string != null && !string.equals("ignore") || (string = (String)map.get("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocTags")) != null && !string.equals("ignore") || (string = (String)map.get("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocComments")) != null && !string.equals("ignore") || (string = (String)map.get("org.eclipse.wst.jsdt.core.compiler.problem.unusedImport")) != null && !string.equals("ignore"))) {
            map.put("org.eclipse.wst.jsdt.core.compiler.doc.comment.support", "disabled");
        }
        CompilerOptions compilerOptions = new CompilerOptions(map);
        compilerOptions.performMethodsFullRecovery = true;
        compilerOptions.performStatementsRecovery = true;
        Compiler compiler = new Compiler((INameEnvironment)this.nameEnvironment, DefaultErrorHandlingPolicies.proceedWithAllProblems(), compilerOptions, (ICompilerRequestor)this, (IProblemFactory)ProblemFactory.getProblemFactory(Locale.getDefault()));
        CompilerOptions compilerOptions2 = compiler.options;
        compilerOptions2.produceReferenceInfo = true;
        if (compilerOptions2.complianceLevel >= 0x320000L && compilerOptions2.processAnnotations) {
            this.initializeAnnotationProcessorManager(compiler);
        }
        return compiler;
    }

    protected BuildContext[] notifyParticipants(SourceFile[] sourceFileArray) {
        BuildContext[] buildContextArray = new BuildContext[sourceFileArray.length];
        int n = sourceFileArray.length;
        while (--n >= 0) {
            buildContextArray[n] = new BuildContext(sourceFileArray[n]);
        }
        n = 0;
        int n2 = this.javaBuilder.participants.length;
        while (n < n2) {
            this.javaBuilder.participants[n].buildStarting(buildContextArray, this instanceof BatchImageBuilder);
            ++n;
        }
        SimpleSet simpleSet = null;
        CompilationParticipantResult[] compilationParticipantResultArray = null;
        int n3 = 0;
        int n4 = buildContextArray.length;
        while (--n4 >= 0) {
            IFile[] iFileArray;
            BuildContext buildContext = buildContextArray[n4];
            if (buildContext == null) continue;
            IFile[] iFileArray2 = buildContext.deletedFiles;
            if (iFileArray2 != null) {
                this.deleteGeneratedFiles(iFileArray2);
            }
            if ((iFileArray = buildContext.addedFiles) == null) continue;
            int n5 = iFileArray.length;
            while (--n5 >= 0) {
                SourceFile sourceFile = this.findSourceFile(iFileArray[n5], true);
                if (sourceFile == null) continue;
                if (simpleSet == null) {
                    simpleSet = new SimpleSet(sourceFileArray.length + 3);
                    int n6 = sourceFileArray.length;
                    while (--n6 >= 0) {
                        simpleSet.add(sourceFileArray[n6]);
                    }
                }
                if (simpleSet.addIfNotIncluded(sourceFile) != sourceFile) continue;
                BuildContext buildContext2 = new BuildContext(sourceFile);
                if (compilationParticipantResultArray == null) {
                    compilationParticipantResultArray = new CompilationParticipantResult[iFileArray.length];
                } else {
                    int n7 = compilationParticipantResultArray.length;
                    if (n3 == n7) {
                        CompilationParticipantResult[] compilationParticipantResultArray2 = compilationParticipantResultArray;
                        compilationParticipantResultArray = new CompilationParticipantResult[n7 + iFileArray.length];
                        System.arraycopy(compilationParticipantResultArray2, 0, compilationParticipantResultArray, 0, n7);
                    }
                }
                compilationParticipantResultArray[n3++] = buildContext2;
            }
        }
        if (n3 > 0) {
            n4 = buildContextArray.length;
            BuildContext[] buildContextArray2 = buildContextArray;
            buildContextArray = new BuildContext[n4 + n3];
            System.arraycopy(buildContextArray2, 0, buildContextArray, 0, n4);
            System.arraycopy(compilationParticipantResultArray, 0, buildContextArray, n4, n3);
        }
        return buildContextArray;
    }

    protected abstract void processAnnotationResults(CompilationParticipantResult[] var1);

    protected void processAnnotations(BuildContext[] buildContextArray) {
        boolean bl = false;
        int n = 0;
        int n2 = this.javaBuilder.participants.length;
        while (!bl && n < n2) {
            bl = this.javaBuilder.participants[n].isAnnotationProcessor();
            ++n;
        }
        if (!bl) {
            return;
        }
        n = this.filesWithAnnotations != null && this.filesWithAnnotations.elementSize > 0 ? 1 : 0;
        n2 = buildContextArray.length;
        while (--n2 >= 0) {
            buildContextArray[n2].reset(n != 0 && this.filesWithAnnotations.includes(buildContextArray[n2].sourceFile));
        }
        n2 = 0;
        int n3 = this.javaBuilder.participants.length;
        while (n2 < n3) {
            if (this.javaBuilder.participants[n2].isAnnotationProcessor()) {
                this.javaBuilder.participants[n2].processAnnotations(buildContextArray);
            }
            ++n2;
        }
        this.processAnnotationResults(buildContextArray);
    }

    protected void recordParticipantResult(CompilationParticipantResult compilationParticipantResult) {
        ReferenceCollection referenceCollection;
        String[] stringArray;
        CategorizedProblem[] categorizedProblemArray = compilationParticipantResult.problems;
        if (categorizedProblemArray != null && categorizedProblemArray.length > 0) {
            this.notifier.updateProblemCounts(categorizedProblemArray);
            try {
                this.storeProblemsFor(compilationParticipantResult.sourceFile, categorizedProblemArray);
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
        }
        if ((stringArray = compilationParticipantResult.dependencies) != null && (referenceCollection = (ReferenceCollection)this.newState.references.get(compilationParticipantResult.sourceFile.typeLocator())) != null) {
            referenceCollection.addDependencies(stringArray);
        }
    }

    protected void storeProblemsFor(SourceFile sourceFile, CategorizedProblem[] categorizedProblemArray) throws CoreException {
        if (sourceFile == null || categorizedProblemArray == null || categorizedProblemArray.length == 0) {
            return;
        }
        if (!this.keepStoringProblemMarkers) {
            return;
        }
        IFile iFile = sourceFile.resource;
        HashSet hashSet = JavaModelManager.getJavaModelManager().compilationParticipants.managedMarkerTypes();
        int n = 0;
        int n2 = categorizedProblemArray.length;
        while (n < n2) {
            IMarker iMarker;
            boolean bl;
            String string;
            CategorizedProblem categorizedProblem = categorizedProblemArray[n];
            int n3 = categorizedProblem.getID();
            if (n3 == 0x1000144) {
                string = categorizedProblem.getArguments()[0];
                if (JavaBuilder.DEBUG) {
                    System.out.println(Messages.bind(Messages.build_incompleteClassPath, string));
                }
                if ((bl = "error".equals(this.javaBuilder.javaProject.getOption("org.eclipse.wst.jsdt.core.incompleteClasspath", true))) && "abort".equals(this.javaBuilder.javaProject.getOption("org.eclipse.wst.jsdt.core.builder.invalidClasspath", true))) {
                    JavaBuilder.removeProblemsAndTasksFor((IResource)this.javaBuilder.currentProject);
                    this.keepStoringProblemMarkers = false;
                }
                iMarker = this.javaBuilder.currentProject.createMarker("org.eclipse.wst.jsdt.core.problem");
                iMarker.setAttributes(new String[]{"message", "severity", "categoryId", "sourceId"}, new Object[]{Messages.bind(Messages.build_incompleteClassPath, string), new Integer(bl ? 2 : 1), new Integer(10), "JSDT"});
            }
            string = categorizedProblem.getMarkerType();
            bl = false;
            if ("org.eclipse.wst.jsdt.core.problem".equals(string) || (bl = hashSet.contains(string))) {
                int n4;
                iMarker = iFile.createMarker(string);
                String[] stringArray = JAVA_PROBLEM_MARKER_ATTRIBUTE_NAMES;
                int n5 = stringArray.length;
                String[] stringArray2 = stringArray;
                int n6 = bl ? 0 : 1;
                String[] stringArray3 = categorizedProblem.getExtraMarkerAttributeNames();
                int n7 = n4 = stringArray3 == null ? 0 : stringArray3.length;
                if (n6 > 0 || n4 > 0) {
                    stringArray2 = new String[n5 + n6 + n4];
                    System.arraycopy(stringArray, 0, stringArray2, 0, n5);
                    if (n6 > 0) {
                        stringArray2[n5] = "sourceId";
                    }
                    System.arraycopy(stringArray3, 0, stringArray2, n5 + n6, n4);
                }
                Object[] objectArray = new Object[stringArray2.length];
                int n8 = 0;
                objectArray[n8++] = categorizedProblem.getMessage();
                objectArray[n8++] = categorizedProblem.isError() ? S_ERROR : S_WARNING;
                objectArray[n8++] = new Integer(n3);
                objectArray[n8++] = new Integer(categorizedProblem.getSourceStart());
                objectArray[n8++] = new Integer(categorizedProblem.getSourceEnd() + 1);
                objectArray[n8++] = new Integer(categorizedProblem.getSourceLineNumber());
                objectArray[n8++] = Util.getProblemArgumentsForMarker(categorizedProblem.getArguments());
                objectArray[n8++] = new Integer(categorizedProblem.getCategoryID());
                if (n6 > 0) {
                    objectArray[n8++] = "JSDT";
                }
                if (n4 > 0) {
                    System.arraycopy(categorizedProblem.getExtraMarkerAttributeValues(), 0, objectArray, n8, n4);
                }
                iMarker.setAttributes(stringArray2, objectArray);
                if (!this.keepStoringProblemMarkers) {
                    return;
                }
            }
            ++n;
        }
    }

    protected void storeTasksFor(SourceFile sourceFile, CategorizedProblem[] categorizedProblemArray) throws CoreException {
        if (sourceFile == null || categorizedProblemArray == null || categorizedProblemArray.length == 0) {
            return;
        }
        IFile iFile = sourceFile.resource;
        int n = 0;
        int n2 = categorizedProblemArray.length;
        while (n < n2) {
            CategorizedProblem categorizedProblem = categorizedProblemArray[n];
            if (categorizedProblem.getID() == 536871362) {
                int n3;
                IMarker iMarker = iFile.createMarker("org.eclipse.wst.jsdt.core.task");
                Integer n4 = P_NORMAL;
                String string = categorizedProblem.getArguments()[2];
                if ("HIGH".equals(string)) {
                    n4 = P_HIGH;
                } else if ("LOW".equals(string)) {
                    n4 = P_LOW;
                }
                String[] stringArray = JAVA_TASK_MARKER_ATTRIBUTE_NAMES;
                int n5 = stringArray.length;
                String[] stringArray2 = stringArray;
                String[] stringArray3 = categorizedProblem.getExtraMarkerAttributeNames();
                int n6 = n3 = stringArray3 == null ? 0 : stringArray3.length;
                if (n3 > 0) {
                    stringArray2 = new String[n5 + n3];
                    System.arraycopy(stringArray, 0, stringArray2, 0, n5);
                    System.arraycopy(stringArray3, 0, stringArray2, n5, n3);
                }
                Object[] objectArray = new Object[stringArray2.length];
                int n7 = 0;
                objectArray[n7++] = categorizedProblem.getMessage();
                objectArray[n7++] = n4;
                objectArray[n7++] = new Integer(categorizedProblem.getID());
                objectArray[n7++] = new Integer(categorizedProblem.getSourceStart());
                objectArray[n7++] = new Integer(categorizedProblem.getSourceEnd() + 1);
                objectArray[n7++] = new Integer(categorizedProblem.getSourceLineNumber());
                objectArray[n7++] = Boolean.FALSE;
                objectArray[n7++] = "JSDT";
                if (n3 > 0) {
                    System.arraycopy(categorizedProblem.getExtraMarkerAttributeValues(), 0, objectArray, n7, n3);
                }
                iMarker.setAttributes(stringArray2, objectArray);
            }
            ++n;
        }
    }

    protected void updateProblemsFor(SourceFile sourceFile, CompilationResult compilationResult) throws CoreException {
        CategorizedProblem[] categorizedProblemArray = compilationResult.getProblems();
        if (categorizedProblemArray == null || categorizedProblemArray.length == 0) {
            return;
        }
        this.notifier.updateProblemCounts(categorizedProblemArray);
        this.storeProblemsFor(sourceFile, categorizedProblemArray);
    }

    protected void updateTasksFor(SourceFile sourceFile, CompilationResult compilationResult) throws CoreException {
        CategorizedProblem[] categorizedProblemArray = compilationResult.getTasks();
        if (categorizedProblemArray == null || categorizedProblemArray.length == 0) {
            return;
        }
        this.storeTasksFor(sourceFile, categorizedProblemArray);
    }

    protected char[] writeClassFile(ClassFile classFile, SourceFile sourceFile, boolean bl) throws CoreException {
        IContainer iContainer;
        String string = new String(classFile.fileName());
        Path path = new Path(string);
        IContainer iContainer2 = iContainer = sourceFile.sourceLocation.binaryFolder;
        if (path.segmentCount() > 1) {
            iContainer2 = this.createFolder(path.removeLastSegments(1), iContainer);
            path = new Path(path.lastSegment());
        }
        IFile iFile = iContainer2.getFile(path.addFileExtension("js"));
        this.writeClassFileBytes(classFile.getBytes(), iFile, string, bl, sourceFile);
        if (classFile.isShared) {
            this.compiler.lookupEnvironment.classFilePool.release(classFile);
        }
        return path.lastSegment().toCharArray();
    }

    protected void writeClassFileBytes(byte[] byArray, IFile iFile, String string, boolean bl, SourceFile sourceFile) throws CoreException {
        if (iFile.exists()) {
            if (JavaBuilder.DEBUG) {
                System.out.println("Writing changed class file " + iFile.getName());
            }
            if (!iFile.isDerived()) {
                iFile.setDerived(true);
            }
            iFile.setContents((InputStream)new ByteArrayInputStream(byArray), true, false, null);
        } else {
            if (JavaBuilder.DEBUG) {
                System.out.println("Writing new class file " + iFile.getName());
            }
            iFile.create((InputStream)new ByteArrayInputStream(byArray), 1025, null);
        }
    }
}

