/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.builder;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.compiler.CompilationParticipant;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.wst.jsdt.internal.core.ClasspathEntry;
import org.eclipse.wst.jsdt.internal.core.JavaModel;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.builder.BatchImageBuilder;
import org.eclipse.wst.jsdt.internal.core.builder.BuildNotifier;
import org.eclipse.wst.jsdt.internal.core.builder.ClasspathLocation;
import org.eclipse.wst.jsdt.internal.core.builder.ImageBuilderInternalException;
import org.eclipse.wst.jsdt.internal.core.builder.IncrementalImageBuilder;
import org.eclipse.wst.jsdt.internal.core.builder.MissingSourceFileException;
import org.eclipse.wst.jsdt.internal.core.builder.NameEnvironment;
import org.eclipse.wst.jsdt.internal.core.builder.State;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class JavaBuilder
extends IncrementalProjectBuilder {
    IProject currentProject;
    JavaProject javaProject;
    IWorkspaceRoot workspaceRoot;
    CompilationParticipant[] participants;
    NameEnvironment nameEnvironment;
    SimpleLookupTable binaryLocationsPerProject;
    public State lastState;
    BuildNotifier notifier;
    char[][] extraResourceFileFilters;
    String[] extraResourceFolderFilters;
    public static final String SOURCE_ID = "JSDT";
    public static boolean DEBUG = false;
    static ArrayList builtProjects = null;

    public static IMarker[] getProblemsFor(IResource iResource) {
        try {
            if (iResource != null && iResource.exists()) {
                IMarker[] iMarkerArray = iResource.findMarkers("org.eclipse.wst.jsdt.core.problem", false, 2);
                HashSet hashSet = JavaModelManager.getJavaModelManager().compilationParticipants.managedMarkerTypes();
                if (hashSet.isEmpty()) {
                    return iMarkerArray;
                }
                ArrayList<IMarker> arrayList = new ArrayList<IMarker>(5);
                int n = 0;
                int n2 = iMarkerArray.length;
                while (n < n2) {
                    arrayList.add(iMarkerArray[n]);
                    ++n;
                }
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    iMarkerArray = iResource.findMarkers((String)iterator.next(), false, 2);
                    n2 = 0;
                    int n3 = iMarkerArray.length;
                    while (n2 < n3) {
                        arrayList.add(iMarkerArray[n2]);
                        ++n2;
                    }
                }
                IMarker[] iMarkerArray2 = new IMarker[arrayList.size()];
                arrayList.toArray(iMarkerArray2);
                return iMarkerArray2;
            }
        }
        catch (CoreException coreException) {}
        return new IMarker[0];
    }

    public static IMarker[] getTasksFor(IResource iResource) {
        try {
            if (iResource != null && iResource.exists()) {
                return iResource.findMarkers("org.eclipse.wst.jsdt.core.task", false, 2);
            }
        }
        catch (CoreException coreException) {}
        return new IMarker[0];
    }

    public static void buildStarting() {
    }

    public static void buildFinished() {
        BuildNotifier.resetProblemCounters();
    }

    public static void removeProblemsFor(IResource iResource) {
        try {
            if (iResource != null && iResource.exists()) {
                iResource.deleteMarkers("org.eclipse.wst.jsdt.core.problem", false, 2);
                HashSet hashSet = JavaModelManager.getJavaModelManager().compilationParticipants.managedMarkerTypes();
                if (hashSet.size() == 0) {
                    return;
                }
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    iResource.deleteMarkers((String)iterator.next(), false, 2);
                }
            }
        }
        catch (CoreException coreException) {}
    }

    public static void removeTasksFor(IResource iResource) {
        try {
            if (iResource != null && iResource.exists()) {
                iResource.deleteMarkers("org.eclipse.wst.jsdt.core.task", false, 2);
            }
        }
        catch (CoreException coreException) {}
    }

    public static void removeProblemsAndTasksFor(IResource iResource) {
        try {
            if (iResource != null && iResource.exists()) {
                iResource.deleteMarkers("org.eclipse.wst.jsdt.core.problem", false, 2);
                iResource.deleteMarkers("org.eclipse.wst.jsdt.core.task", false, 2);
                HashSet hashSet = JavaModelManager.getJavaModelManager().compilationParticipants.managedMarkerTypes();
                if (hashSet.size() == 0) {
                    return;
                }
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    iResource.deleteMarkers((String)iterator.next(), false, 2);
                }
            }
        }
        catch (CoreException coreException) {}
    }

    public static State readState(IProject iProject, DataInputStream dataInputStream) throws IOException {
        return State.read(iProject, dataInputStream);
    }

    public static void writeState(Object object, DataOutputStream dataOutputStream) throws IOException {
        ((State)object).write(dataOutputStream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IProject[] build(int n, Map map, IProgressMonitor iProgressMonitor) throws CoreException {
        this.currentProject = this.getProject();
        if (this.currentProject == null || !this.currentProject.isAccessible()) {
            return new IProject[0];
        }
        if (DEBUG) {
            System.out.println("\nStarting build of " + this.currentProject.getName() + " @ " + new Date(System.currentTimeMillis()));
        }
        this.notifier = new BuildNotifier(iProgressMonitor, this.currentProject);
        this.notifier.begin();
        boolean bl = false;
        try {
            Object object;
            block24: {
                try {
                    block26: {
                        block29: {
                            block30: {
                                block28: {
                                    block27: {
                                        block25: {
                                            this.notifier.checkCancel();
                                            n = this.initializeBuilder(n, true);
                                            if (!this.isWorthBuilding()) break block24;
                                            if (n != 6) break block25;
                                            if (DEBUG) {
                                                System.out.println("Performing full build as requested by user");
                                            }
                                            this.buildAll();
                                            break block26;
                                        }
                                        this.lastState = this.getLastState(this.currentProject);
                                        if (this.lastState != null) break block27;
                                        if (DEBUG) {
                                            System.out.println("Performing full build since last saved state was not found");
                                        }
                                        this.buildAll();
                                        break block26;
                                    }
                                    if (!this.hasClasspathChanged()) break block28;
                                    if (DEBUG) {
                                        System.out.println("Performing full build since classpath has changed");
                                    }
                                    this.buildAll();
                                    break block26;
                                }
                                if (this.nameEnvironment.sourceLocations.length <= 0) break block29;
                                object = this.findDeltas();
                                if (object != null) break block30;
                                if (DEBUG) {
                                    System.out.println("Performing full build since deltas are missing after incremental request");
                                }
                                this.buildAll();
                                break block26;
                            }
                            if (object.elementSize > 0) {
                                this.buildDeltas((SimpleLookupTable)object);
                                break block26;
                            } else if (DEBUG) {
                                System.out.println("Nothing to build since deltas were empty");
                            }
                            break block26;
                        }
                        if (this.hasStructuralDelta()) {
                            if (DEBUG) {
                                System.out.println("Performing full build since there are structural deltas");
                            }
                            this.buildAll();
                        } else {
                            if (DEBUG) {
                                System.out.println("Nothing to build since there are no source folders and no deltas");
                            }
                            this.lastState.tagAsNoopBuild();
                        }
                    }
                    bl = true;
                }
                catch (CoreException coreException) {
                    Util.log(coreException, "JavaBuilder handling CoreException while building: " + this.currentProject.getName());
                    IMarker iMarker = this.currentProject.createMarker("org.eclipse.wst.jsdt.core.problem");
                    iMarker.setAttributes(new String[]{"message", "severity", "categoryId", "sourceId"}, new Object[]{Messages.bind(Messages.build_inconsistentProject, coreException.getLocalizedMessage()), new Integer(2), new Integer(10), SOURCE_ID});
                }
                catch (ImageBuilderInternalException imageBuilderInternalException) {
                    Util.log(imageBuilderInternalException.getThrowable(), "JavaBuilder handling ImageBuilderInternalException while building: " + this.currentProject.getName());
                    IMarker iMarker = this.currentProject.createMarker("org.eclipse.wst.jsdt.core.problem");
                    iMarker.setAttributes(new String[]{"message", "severity", "categoryId", "sourceId"}, new Object[]{Messages.bind(Messages.build_inconsistentProject, imageBuilderInternalException.getLocalizedMessage()), new Integer(2), new Integer(10), SOURCE_ID});
                }
                catch (MissingSourceFileException missingSourceFileException) {
                    if (DEBUG) {
                        System.out.println(Messages.bind(Messages.build_missingSourceFile, missingSourceFileException.missingSourceFile));
                    }
                    JavaBuilder.removeProblemsAndTasksFor((IResource)this.currentProject);
                    IMarker iMarker = this.currentProject.createMarker("org.eclipse.wst.jsdt.core.problem");
                    iMarker.setAttributes(new String[]{"message", "severity", "sourceId"}, new Object[]{Messages.bind(Messages.build_missingSourceFile, missingSourceFileException.missingSourceFile), new Integer(2), SOURCE_ID});
                }
            }
            Object var7_14 = null;
            if (!bl) {
                this.clearLastState();
            }
            this.notifier.done();
            this.cleanup();
            object = this.getRequiredProjects(true);
            if (DEBUG) {
                System.out.println("Finished build of " + this.currentProject.getName() + " @ " + new Date(System.currentTimeMillis()));
            }
            return object;
        }
        catch (Throwable throwable) {
            Object var7_13 = null;
            if (!bl) {
                this.clearLastState();
            }
            this.notifier.done();
            this.cleanup();
            throw throwable;
        }
    }

    private void buildAll() {
        this.notifier.checkCancel();
        this.notifier.subTask(Messages.bind(Messages.build_preparingBuild, this.currentProject.getName()));
        if (DEBUG && this.lastState != null) {
            System.out.println("Clearing last state : " + this.lastState);
        }
        this.clearLastState();
        BatchImageBuilder batchImageBuilder = new BatchImageBuilder(this, true);
        batchImageBuilder.build();
    }

    private void buildDeltas(SimpleLookupTable simpleLookupTable) {
        this.notifier.checkCancel();
        this.notifier.subTask(Messages.bind(Messages.build_preparingBuild, this.currentProject.getName()));
        if (DEBUG && this.lastState != null) {
            System.out.println("Clearing last state : " + this.lastState);
        }
        this.clearLastState();
        IncrementalImageBuilder incrementalImageBuilder = new IncrementalImageBuilder(this);
        if (incrementalImageBuilder.build(simpleLookupTable)) {
            this.recordNewState(incrementalImageBuilder.newState);
        } else {
            if (DEBUG) {
                System.out.println("Performing full build since incremental build failed");
            }
            this.buildAll();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void clean(IProgressMonitor iProgressMonitor) throws CoreException {
        this.currentProject = this.getProject();
        if (this.currentProject == null || !this.currentProject.isAccessible()) {
            return;
        }
        if (DEBUG) {
            System.out.println("\nCleaning " + this.currentProject.getName() + " @ " + new Date(System.currentTimeMillis()));
        }
        this.notifier = new BuildNotifier(iProgressMonitor, this.currentProject);
        this.notifier.begin();
        try {
            try {
                this.notifier.checkCancel();
                this.initializeBuilder(15, true);
                if (DEBUG) {
                    System.out.println("Clearing last state as part of clean : " + this.lastState);
                }
                this.clearLastState();
                JavaBuilder.removeProblemsAndTasksFor((IResource)this.currentProject);
            }
            catch (CoreException coreException) {
                Util.log(coreException, "JavaBuilder handling CoreException while cleaning: " + this.currentProject.getName());
                IMarker iMarker = this.currentProject.createMarker("org.eclipse.wst.jsdt.core.problem");
                iMarker.setAttributes(new String[]{"message", "severity", "sourceId"}, new Object[]{Messages.bind(Messages.build_inconsistentProject, coreException.getLocalizedMessage()), new Integer(2), SOURCE_ID});
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.notifier.done();
            this.cleanup();
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.notifier.done();
            this.cleanup();
            if (DEBUG) {
                System.out.println("Finished cleaning " + this.currentProject.getName() + " @ " + new Date(System.currentTimeMillis()));
            }
            return;
        }
    }

    private void cleanup() {
        this.participants = null;
        this.nameEnvironment = null;
        this.binaryLocationsPerProject = null;
        this.lastState = null;
        this.notifier = null;
        this.extraResourceFileFilters = null;
        this.extraResourceFolderFilters = null;
    }

    private void clearLastState() {
        JavaModelManager.getJavaModelManager().setLastBuiltState(this.currentProject, null);
    }

    boolean filterExtraResource(IResource iResource) {
        int n;
        Object object;
        if (this.extraResourceFileFilters != null) {
            object = iResource.getName().toCharArray();
            int n2 = 0;
            n = this.extraResourceFileFilters.length;
            while (n2 < n) {
                if (CharOperation.match(this.extraResourceFileFilters[n2], object, true)) {
                    return true;
                }
                ++n2;
            }
        }
        if (this.extraResourceFolderFilters != null) {
            object = iResource.getProjectRelativePath();
            String string = object.toString();
            n = object.segmentCount();
            if (iResource.getType() == 1) {
                --n;
            }
            int n3 = 0;
            int n4 = this.extraResourceFolderFilters.length;
            while (n3 < n4) {
                if (string.indexOf(this.extraResourceFolderFilters[n3]) != -1) {
                    int n5 = 0;
                    while (n5 < n) {
                        if (this.extraResourceFolderFilters[n3].equals(object.segment(n5))) {
                            return true;
                        }
                        ++n5;
                    }
                }
                ++n3;
            }
        }
        return false;
    }

    private SimpleLookupTable findDeltas() {
        this.notifier.subTask(Messages.bind(Messages.build_readingDelta, this.currentProject.getName()));
        IResourceDelta iResourceDelta = this.getDelta(this.currentProject);
        SimpleLookupTable simpleLookupTable = new SimpleLookupTable(3);
        if (iResourceDelta != null) {
            if (iResourceDelta.getKind() != 0) {
                if (DEBUG) {
                    System.out.println("Found source delta for: " + this.currentProject.getName());
                }
                simpleLookupTable.put(this.currentProject, iResourceDelta);
            }
        } else {
            if (DEBUG) {
                System.out.println("Missing delta for: " + this.currentProject.getName());
            }
            this.notifier.subTask("");
            return null;
        }
        Object[] objectArray = this.binaryLocationsPerProject.keyTable;
        Object[] objectArray2 = this.binaryLocationsPerProject.valueTable;
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            block17: {
                IProject iProject;
                block18: {
                    iProject = (IProject)objectArray[n];
                    if (iProject == null || iProject == this.currentProject) break block17;
                    State state = this.getLastState(iProject);
                    if (this.lastState.wasStructurallyChanged(iProject, state)) break block18;
                    if (state.wasNoopBuild()) break block17;
                    ClasspathLocation[] classpathLocationArray = (ClasspathLocation[])objectArray2[n];
                    boolean bl = true;
                    int n3 = 0;
                    int n4 = classpathLocationArray.length;
                    while (n3 < n4) {
                        if (classpathLocationArray[n3].isOutputFolder()) {
                            classpathLocationArray[n3] = null;
                        } else {
                            bl = false;
                        }
                        ++n3;
                    }
                    if (bl) break block17;
                }
                this.notifier.subTask(Messages.bind(Messages.build_readingDelta, iProject.getName()));
                iResourceDelta = this.getDelta(iProject);
                if (iResourceDelta != null) {
                    if (iResourceDelta.getKind() != 0) {
                        if (DEBUG) {
                            System.out.println("Found binary delta for: " + iProject.getName());
                        }
                        simpleLookupTable.put(iProject, iResourceDelta);
                    }
                } else {
                    if (DEBUG) {
                        System.out.println("Missing delta for: " + iProject.getName());
                    }
                    this.notifier.subTask("");
                    return null;
                }
            }
            ++n;
        }
        this.notifier.subTask("");
        return simpleLookupTable;
    }

    public State getLastState(IProject iProject) {
        return (State)JavaModelManager.getJavaModelManager().getLastBuiltState(iProject, this.notifier.monitor);
    }

    private IProject[] getRequiredProjects(boolean bl) {
        IClasspathEntry[] iClasspathEntryArray;
        if (this.javaProject == null || this.workspaceRoot == null) {
            return new IProject[0];
        }
        ArrayList<IProject> arrayList = new ArrayList<IProject>();
        try {
            iClasspathEntryArray = this.javaProject.getExpandedClasspath();
            int n = 0;
            int n2 = iClasspathEntryArray.length;
            while (n < n2) {
                IClasspathEntry iClasspathEntry = iClasspathEntryArray[n];
                IPath iPath = iClasspathEntry.getPath();
                IProject iProject = null;
                switch (iClasspathEntry.getEntryKind()) {
                    case 2: {
                        iProject = this.workspaceRoot.getProject(iPath.lastSegment());
                        if (!((ClasspathEntry)iClasspathEntry).isOptional() || JavaProject.hasJavaNature(iProject)) break;
                        iProject = null;
                        break;
                    }
                    case 1: {
                        IResource iResource;
                        if (!bl || iPath.segmentCount() <= 1 || !((iResource = this.workspaceRoot.findMember(iPath.segment(0))) instanceof IProject)) break;
                        iProject = (IProject)iResource;
                    }
                }
                if (iProject != null && !arrayList.contains(iProject)) {
                    arrayList.add(iProject);
                }
                ++n;
            }
        }
        catch (JavaModelException javaModelException) {
            return new IProject[0];
        }
        iClasspathEntryArray = new IProject[arrayList.size()];
        arrayList.toArray(iClasspathEntryArray);
        return iClasspathEntryArray;
    }

    boolean hasBuildpathErrors() throws CoreException {
        return false;
    }

    private boolean hasClasspathChanged() {
        ClasspathLocation[] classpathLocationArray = this.nameEnvironment.sourceLocations;
        ClasspathLocation[] classpathLocationArray2 = this.lastState.sourceLocations;
        int n = classpathLocationArray.length;
        int n2 = classpathLocationArray2.length;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n && n3 < n2) {
            block18: {
                if (!classpathLocationArray[n4].equals(classpathLocationArray2[n3])) {
                    block17: {
                        try {
                            if (classpathLocationArray[n4].sourceFolder.members().length != 0) break block17;
                            --n3;
                            break block18;
                        }
                        catch (CoreException coreException) {}
                    }
                    if (DEBUG) {
                        System.out.println("New location: " + classpathLocationArray[n4] + "\n!= old location: " + classpathLocationArray2[n3]);
                        this.printLocations(classpathLocationArray, classpathLocationArray2);
                    }
                    return true;
                }
            }
            ++n4;
            ++n3;
        }
        while (n4 < n) {
            try {
                if (classpathLocationArray[n4].sourceFolder.members().length == 0) {
                    ++n4;
                    continue;
                }
            }
            catch (CoreException coreException) {}
            if (DEBUG) {
                System.out.println("Added non-empty source folder");
                this.printLocations(classpathLocationArray, classpathLocationArray2);
            }
            return true;
        }
        if (n3 < n2) {
            if (DEBUG) {
                System.out.println("Removed source folder");
                this.printLocations(classpathLocationArray, classpathLocationArray2);
            }
            return true;
        }
        ClasspathLocation[] classpathLocationArray3 = this.nameEnvironment.binaryLocations;
        ClasspathLocation[] classpathLocationArray4 = this.lastState.binaryLocations;
        n = classpathLocationArray3.length;
        n2 = classpathLocationArray4.length;
        n3 = 0;
        n4 = 0;
        while (n4 < n && n3 < n2) {
            if (!classpathLocationArray3[n4].equals(classpathLocationArray4[n3])) {
                if (DEBUG) {
                    System.out.println("New location: " + classpathLocationArray3[n4] + "\n!= old location: " + classpathLocationArray4[n3]);
                    this.printLocations(classpathLocationArray3, classpathLocationArray4);
                }
                return true;
            }
            ++n4;
            ++n3;
        }
        if (n4 < n || n3 < n2) {
            if (DEBUG) {
                System.out.println("Number of binary folders/jar files has changed:");
                this.printLocations(classpathLocationArray3, classpathLocationArray4);
            }
            return true;
        }
        return false;
    }

    private boolean hasJavaBuilder(IProject iProject) throws CoreException {
        ICommand[] iCommandArray = iProject.getDescription().getBuildSpec();
        int n = 0;
        int n2 = iCommandArray.length;
        while (n < n2) {
            if (iCommandArray[n].getBuilderName().equals("org.eclipse.wst.jsdt.core.javascriptValidator")) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean hasStructuralDelta() {
        ClasspathLocation[] classpathLocationArray;
        IResourceDelta iResourceDelta = this.getDelta(this.currentProject);
        if (iResourceDelta != null && iResourceDelta.getKind() != 0 && (classpathLocationArray = (ClasspathLocation[])this.binaryLocationsPerProject.get(this.currentProject)) != null) {
            int n = 0;
            int n2 = classpathLocationArray.length;
            while (n < n2) {
                IResourceDelta iResourceDelta2;
                IPath iPath;
                ClasspathLocation classpathLocation = classpathLocationArray[n];
                if (classpathLocation != null && (iPath = classpathLocation.getProjectRelativePath()) != null && (iResourceDelta2 = iResourceDelta.findMember(iPath)) != null && iResourceDelta2.getKind() != 0) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private int initializeBuilder(int n, boolean bl) throws CoreException {
        String string;
        this.javaProject = (JavaProject)JavaCore.create(this.currentProject);
        this.workspaceRoot = this.currentProject.getWorkspace().getRoot();
        if (bl) {
            this.participants = JavaModelManager.getJavaModelManager().compilationParticipants.getCompilationParticipants(this.javaProject);
            if (this.participants != null) {
                int n2 = 0;
                int n3 = this.participants.length;
                while (n2 < n3) {
                    if (this.participants[n2].aboutToBuild(this.javaProject) == CompilationParticipant.NEEDS_FULL_BUILD) {
                        n = 6;
                    }
                    ++n2;
                }
            }
            string = this.currentProject.getName();
            if (builtProjects == null || builtProjects.contains(string)) {
                JavaModel.flushExternalFileCache();
                builtProjects = new ArrayList();
            }
            builtProjects.add(string);
        }
        this.binaryLocationsPerProject = new SimpleLookupTable(3);
        this.nameEnvironment = new NameEnvironment(this.workspaceRoot, this.javaProject, this.binaryLocationsPerProject, this.notifier);
        if (bl) {
            char[][] cArray;
            string = this.javaProject.getOption("org.eclipse.wst.jsdt.core.builder.resourceCopyExclusionFilter", true);
            char[][] cArray2 = cArray = string != null && string.length() > 0 ? CharOperation.splitAndTrimOn(',', string.toCharArray()) : null;
            if (cArray == null) {
                this.extraResourceFileFilters = null;
                this.extraResourceFolderFilters = null;
            } else {
                char[] cArray3;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                int n7 = cArray.length;
                while (n6 < n7) {
                    cArray3 = cArray[n6];
                    if (cArray3.length != 0) {
                        if (cArray3[cArray3.length - 1] == '/') {
                            ++n5;
                        } else {
                            ++n4;
                        }
                    }
                    ++n6;
                }
                this.extraResourceFileFilters = new char[n4][];
                this.extraResourceFolderFilters = new String[n5];
                n6 = 0;
                n7 = cArray.length;
                while (n6 < n7) {
                    cArray3 = cArray[n6];
                    if (cArray3.length != 0) {
                        if (cArray3[cArray3.length - 1] == '/') {
                            this.extraResourceFolderFilters[--n5] = new String(cArray3, 0, cArray3.length - 1);
                        } else {
                            this.extraResourceFileFilters[--n4] = cArray3;
                        }
                    }
                    ++n6;
                }
            }
        }
        return n;
    }

    private boolean isClasspathBroken(IClasspathEntry[] iClasspathEntryArray, IProject iProject) throws CoreException {
        IMarker[] iMarkerArray = iProject.findMarkers("org.eclipse.wst.jsdt.core.buildpath_problem", false, 0);
        int n = 0;
        int n2 = iMarkerArray.length;
        while (n < n2) {
            if (iMarkerArray[n].getAttribute("severity", -1) == 2) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean isWorthBuilding() throws CoreException {
        boolean bl = "abort".equals(this.javaProject.getOption("org.eclipse.wst.jsdt.core.builder.invalidClasspath", true));
        if (!bl) {
            return true;
        }
        if (this.isClasspathBroken(this.javaProject.getRawClasspath(), this.currentProject)) {
            if (DEBUG) {
                System.out.println("Aborted build because project has classpath errors (incomplete or involved in cycle)");
            }
            JavaBuilder.removeProblemsAndTasksFor((IResource)this.currentProject);
            IMarker iMarker = this.currentProject.createMarker("org.eclipse.wst.jsdt.core.problem");
            iMarker.setAttributes(new String[]{"message", "severity", "categoryId", "sourceId"}, new Object[]{Messages.build_abortDueToClasspathProblems, new Integer(2), new Integer(10), SOURCE_ID});
            return false;
        }
        if ("warning".equals(this.javaProject.getOption("org.eclipse.wst.jsdt.core.incompleteClasspath", true))) {
            return true;
        }
        IProject[] iProjectArray = this.getRequiredProjects(false);
        int n = 0;
        int n2 = iProjectArray.length;
        while (n < n2) {
            IProject iProject = iProjectArray[n];
            if (this.getLastState(iProject) == null) {
                JavaProject javaProject = (JavaProject)JavaCore.create(iProject);
                if (javaProject.hasCycleMarker() && "warning".equals(this.javaProject.getOption("org.eclipse.wst.jsdt.core.circularClasspath", true))) {
                    if (DEBUG) {
                        System.out.println("Continued to build even though prereq project " + iProject.getName() + " was not built since its part of a cycle");
                    }
                } else if (!this.hasJavaBuilder(iProject)) {
                    if (DEBUG) {
                        System.out.println("Continued to build even though prereq project " + iProject.getName() + " is not built by JavaBuilder");
                    }
                } else {
                    if (DEBUG) {
                        System.out.println("Aborted build because prereq project " + iProject.getName() + " was not built");
                    }
                    JavaBuilder.removeProblemsAndTasksFor((IResource)this.currentProject);
                    IMarker iMarker = this.currentProject.createMarker("org.eclipse.wst.jsdt.core.problem");
                    iMarker.setAttributes(new String[]{"message", "severity", "categoryId", "sourceId"}, new Object[]{this.isClasspathBroken(javaProject.getRawClasspath(), iProject) ? Messages.bind(Messages.build_prereqProjectHasClasspathProblems, iProject.getName()) : Messages.bind(Messages.build_prereqProjectMustBeRebuilt, iProject.getName()), new Integer(2), new Integer(10), SOURCE_ID});
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    void mustPropagateStructuralChanges() {
        HashSet hashSet = new HashSet(3);
        this.javaProject.updateCycleParticipants(new ArrayList(), hashSet, this.workspaceRoot, new HashSet(3), null);
        IPath iPath = this.javaProject.getPath();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            IProject iProject;
            IPath iPath2 = (IPath)iterator.next();
            if (iPath2 == iPath || !this.hasBeenBuilt(iProject = this.workspaceRoot.getProject(iPath2.segment(0)))) continue;
            if (DEBUG) {
                System.out.println("Requesting another build iteration since cycle participant " + iProject.getName() + " has not yet seen some structural changes");
            }
            this.needRebuild();
            return;
        }
    }

    private void printLocations(ClasspathLocation[] classpathLocationArray, ClasspathLocation[] classpathLocationArray2) {
        System.out.println("New locations:");
        int n = 0;
        int n2 = classpathLocationArray.length;
        while (n < n2) {
            System.out.println("    " + classpathLocationArray[n].debugPathString());
            ++n;
        }
        System.out.println("Old locations:");
        n = 0;
        n2 = classpathLocationArray2.length;
        while (n < n2) {
            System.out.println("    " + classpathLocationArray2[n].debugPathString());
            ++n;
        }
    }

    private void recordNewState(State state) {
        Object[] objectArray = this.binaryLocationsPerProject.keyTable;
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            IProject iProject = (IProject)objectArray[n];
            if (iProject != null && iProject != this.currentProject) {
                state.recordStructuralDependency(iProject, this.getLastState(iProject));
            }
            ++n;
        }
        if (DEBUG) {
            System.out.println("Recording new state : " + state);
        }
        JavaModelManager.getJavaModelManager().setLastBuiltState(this.currentProject, state);
    }

    public String toString() {
        return this.currentProject == null ? "JavaBuilder for unknown project" : "JavaBuilder for " + this.currentProject.getName();
    }
}

