/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.builder;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;

public class QualifiedNameSet {
    public char[][][] qualifiedNames;
    public int elementSize = 0;
    public int threshold;

    public QualifiedNameSet(int n) {
        this.threshold = n;
        int n2 = (int)((float)n * 1.5f);
        if (this.threshold == n2) {
            ++n2;
        }
        this.qualifiedNames = new char[n2][][];
    }

    public char[][] add(char[][] cArray) {
        char[][] cArray2;
        int n = cArray.length;
        if (n == 0) {
            return CharOperation.NO_CHAR_CHAR;
        }
        int n2 = this.qualifiedNames.length;
        int n3 = CharOperation.hashCode(cArray[n - 1]) % n2;
        while ((cArray2 = this.qualifiedNames[n3]) != null) {
            if (CharOperation.equals(cArray2, cArray)) {
                return cArray2;
            }
            if (++n3 != n2) continue;
            n3 = 0;
        }
        this.qualifiedNames[n3] = cArray;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return cArray;
    }

    private void rehash() {
        QualifiedNameSet qualifiedNameSet = new QualifiedNameSet(this.elementSize * 2);
        int n = this.qualifiedNames.length;
        while (--n >= 0) {
            char[][] cArray = this.qualifiedNames[n];
            if (cArray == null) continue;
            qualifiedNameSet.add(cArray);
        }
        this.qualifiedNames = qualifiedNameSet.qualifiedNames;
        this.elementSize = qualifiedNameSet.elementSize;
        this.threshold = qualifiedNameSet.threshold;
    }

    public String toString() {
        String string = "";
        int n = 0;
        int n2 = this.qualifiedNames.length;
        while (n < n2) {
            char[][] cArray = this.qualifiedNames[n];
            if (cArray != null) {
                string = String.valueOf(string) + CharOperation.toString(cArray) + "\n";
            }
            ++n;
        }
        return string;
    }
}

