/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.dom.rewrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.TypeNameRequestor;

public final class ImportRewriteAnalyzer {
    private final ICompilationUnit compilationUnit;
    private final ArrayList packageEntries;
    private final List importsCreated;
    private final List staticImportsCreated;
    private final IRegion replaceRange;
    private final int importOnDemandThreshold;
    private final int staticImportOnDemandThreshold;
    private boolean filterImplicitImports;
    private boolean findAmbiguousImports;
    private int flags = 0;
    private static final int F_NEEDS_LEADING_DELIM = 2;
    private static final int F_NEEDS_TRAILING_DELIM = 4;
    private static final String JAVA_LANG = "java.lang";

    public ImportRewriteAnalyzer(ICompilationUnit iCompilationUnit, CompilationUnit compilationUnit, String[] stringArray, int n, int n2, boolean bl) {
        this.compilationUnit = iCompilationUnit;
        this.importOnDemandThreshold = n;
        this.staticImportOnDemandThreshold = n2;
        this.filterImplicitImports = true;
        this.findAmbiguousImports = true;
        this.packageEntries = new ArrayList(20);
        this.importsCreated = new ArrayList();
        this.staticImportsCreated = new ArrayList();
        this.flags = 0;
        this.replaceRange = this.evaluateReplaceRange(compilationUnit);
        if (bl) {
            this.addExistingImports(compilationUnit);
        }
        PackageEntry[] packageEntryArray = new PackageEntry[stringArray.length];
        int n3 = 0;
        while (n3 < packageEntryArray.length) {
            String string = stringArray[n3];
            if (string.length() > 0 && string.charAt(0) == '#') {
                string = string.substring(1);
                packageEntryArray[n3] = new PackageEntry(string, string, true);
            } else {
                packageEntryArray[n3] = new PackageEntry(string, string, false);
            }
            ++n3;
        }
        this.addPreferenceOrderHolders(packageEntryArray);
    }

    private int getSpacesBetweenImportGroups() {
        try {
            int n = Integer.parseInt(this.compilationUnit.getJavaProject().getOption("org.eclipse.wst.jsdt.core.formatter.blank_lines_between_import_groups", true));
            if (n >= 0) {
                return n;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return 1;
    }

    private void addPreferenceOrderHolders(PackageEntry[] packageEntryArray) {
        if (this.packageEntries.isEmpty()) {
            int n = 0;
            while (n < packageEntryArray.length) {
                this.packageEntries.add(packageEntryArray[n]);
                ++n;
            }
        } else {
            Object object;
            PackageEntry[] packageEntryArray2 = new PackageEntry[packageEntryArray.length];
            int n = 0;
            while (n < this.packageEntries.size()) {
                PackageEntry packageEntry = (PackageEntry)this.packageEntries.get(n);
                if (!packageEntry.isComment()) {
                    object = packageEntry.getName();
                    int n2 = ((String)object).length();
                    int n3 = -1;
                    int n4 = -1;
                    int n5 = 0;
                    while (n5 < packageEntryArray.length) {
                        boolean bl = packageEntryArray[n5].isStatic();
                        if (bl == packageEntry.isStatic()) {
                            String string = packageEntryArray[n5].getName();
                            int n6 = string.length();
                            if (!(!((String)object).startsWith(string) || n6 < n4 || n6 != n2 && ((String)object).charAt(n6) != '.' || n3 != -1 && n6 <= n4)) {
                                n4 = n6;
                                n3 = n5;
                            }
                        }
                        ++n5;
                    }
                    if (n3 != -1) {
                        packageEntry.setGroupID(packageEntryArray[n3].getName());
                        packageEntryArray2[n3] = packageEntry;
                    }
                }
                ++n;
            }
            n = 0;
            int n7 = 0;
            while (n7 < packageEntryArray2.length) {
                object = packageEntryArray2[n7];
                if (object == null) {
                    PackageEntry packageEntry = packageEntryArray[n7];
                    if (n == 0 && !packageEntry.isStatic()) {
                        n = this.getIndexAfterStatics();
                    }
                    this.packageEntries.add(n, packageEntry);
                    ++n;
                } else {
                    n = this.packageEntries.indexOf(object) + 1;
                }
                ++n7;
            }
        }
    }

    private static String getQualifier(ImportDeclaration importDeclaration) {
        String string = importDeclaration.getName().getFullyQualifiedName();
        return importDeclaration.isOnDemand() ? string : Signature.getQualifier(string);
    }

    private static String getFullName(ImportDeclaration importDeclaration) {
        String string = importDeclaration.getName().getFullyQualifiedName();
        return importDeclaration.isOnDemand() ? String.valueOf(string) + ".*" : string;
    }

    private void addExistingImports(CompilationUnit compilationUnit) {
        String string;
        List list = compilationUnit.imports();
        if (list.isEmpty()) {
            return;
        }
        PackageEntry packageEntry = null;
        ImportDeclaration importDeclaration = (ImportDeclaration)list.get(0);
        int n = importDeclaration.getStartPosition();
        int n2 = importDeclaration.getLength();
        int n3 = compilationUnit.getLineNumber(n + n2);
        int n4 = 1;
        while (n4 < list.size()) {
            boolean bl = importDeclaration.isStatic();
            string = ImportRewriteAnalyzer.getFullName(importDeclaration);
            String string2 = ImportRewriteAnalyzer.getQualifier(importDeclaration);
            if (packageEntry == null || packageEntry.compareTo(string2, bl) != 0) {
                packageEntry = new PackageEntry(string2, null, bl);
                this.packageEntries.add(packageEntry);
            }
            ImportDeclaration importDeclaration2 = (ImportDeclaration)list.get(n4);
            int n5 = importDeclaration2.getStartPosition();
            int n6 = importDeclaration2.getLength();
            int n7 = compilationUnit.getLineNumber(n5);
            if (n3 < n7) {
                n5 = compilationUnit.getPosition(++n3, 0);
            }
            packageEntry.add(new ImportDeclEntry(string, bl, (IRegion)new Region(n, n5 - n)));
            n = n5;
            importDeclaration = importDeclaration2;
            if (n3 < n7) {
                n5 = compilationUnit.getPosition(n7, 0);
                packageEntry = new PackageEntry();
                this.packageEntries.add(packageEntry);
                packageEntry.add(new ImportDeclEntry(null, false, (IRegion)new Region(n, n5 - n)));
                n = n5;
            }
            n3 = compilationUnit.getLineNumber(n5 + n6);
            ++n4;
        }
        n4 = importDeclaration.isStatic() ? 1 : 0;
        String string3 = ImportRewriteAnalyzer.getFullName(importDeclaration);
        string = ImportRewriteAnalyzer.getQualifier(importDeclaration);
        if (packageEntry == null || packageEntry.compareTo(string, n4 != 0) != 0) {
            packageEntry = new PackageEntry(string, null, n4 != 0);
            this.packageEntries.add(packageEntry);
        }
        int n8 = this.replaceRange.getOffset() + this.replaceRange.getLength() - importDeclaration.getStartPosition();
        packageEntry.add(new ImportDeclEntry(string3, n4 != 0, (IRegion)new Region(importDeclaration.getStartPosition(), n8)));
    }

    public void setFilterImplicitImports(boolean bl) {
        this.filterImplicitImports = bl;
    }

    public void setFindAmbiguousImports(boolean bl) {
        this.findAmbiguousImports = bl;
    }

    static int getCommonPrefixLength(String string, String string2) {
        int n = Math.min(string.length(), string2.length());
        int n2 = 0;
        while (n2 < n) {
            if (string.charAt(n2) != string2.charAt(n2)) {
                return n2;
            }
            ++n2;
        }
        return n;
    }

    static char getCharAt(String string, int n) {
        if (string.length() > n) {
            return string.charAt(n);
        }
        return '\u0000';
    }

    private PackageEntry findBestMatch(String string, boolean bl) {
        Object object;
        if (this.packageEntries.isEmpty()) {
            return null;
        }
        String string2 = null;
        int n = -1;
        int n2 = 0;
        while (n2 < this.packageEntries.size()) {
            String string3;
            object = (PackageEntry)this.packageEntries.get(n2);
            if (bl == ((PackageEntry)object).isStatic() && (string3 = ((PackageEntry)object).getGroupID()) != null && string.startsWith(string3)) {
                int n3 = string3.length();
                if (n3 == string.length()) {
                    return object;
                }
                if (string.charAt(n3) == '.' && n3 > n) {
                    n = n3;
                    string2 = string3;
                }
            }
            ++n2;
        }
        PackageEntry packageEntry = null;
        object = new PackageMatcher();
        ((PackageMatcher)object).initialize(string, "");
        int n4 = 0;
        while (n4 < this.packageEntries.size()) {
            PackageEntry packageEntry2 = (PackageEntry)this.packageEntries.get(n4);
            if (!packageEntry2.isComment() && packageEntry2.isStatic() == bl && (string2 == null || string2.equals(packageEntry2.getGroupID()))) {
                boolean bl2;
                boolean bl3 = bl2 = packageEntry == null || packageEntry2.getNumberOfImports() > packageEntry.getNumberOfImports();
                if (((PackageMatcher)object).isBetterMatch(packageEntry2.getName(), bl2)) {
                    packageEntry = packageEntry2;
                }
            }
            ++n4;
        }
        return packageEntry;
    }

    private static boolean isImplicitImport(String string, ICompilationUnit iCompilationUnit) {
        if (JAVA_LANG.equals(string)) {
            return true;
        }
        String string2 = iCompilationUnit.getParent().getElementName();
        if (string.equals(string2)) {
            return true;
        }
        String string3 = JavaCore.removeJavaLikeExtension(iCompilationUnit.getElementName());
        if (string2.length() == 0) {
            return string.equals(string3);
        }
        return string.equals(String.valueOf(string2) + '.' + string3);
    }

    public void addImport(String string, boolean bl) {
        String string2 = Signature.getQualifier(string);
        ImportDeclEntry importDeclEntry = new ImportDeclEntry(string, bl, null);
        this.sortIn(string2, importDeclEntry, bl);
    }

    public boolean removeImport(String string, boolean bl) {
        String string2 = Signature.getQualifier(string);
        int n = this.packageEntries.size();
        int n2 = 0;
        while (n2 < n) {
            PackageEntry packageEntry = (PackageEntry)this.packageEntries.get(n2);
            if (packageEntry.compareTo(string2, bl) == 0 && packageEntry.remove(string, bl)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private int getIndexAfterStatics() {
        int n = 0;
        while (n < this.packageEntries.size()) {
            if (!((PackageEntry)this.packageEntries.get(n)).isStatic()) {
                return n;
            }
            ++n;
        }
        return this.packageEntries.size();
    }

    private void sortIn(String string, ImportDeclEntry importDeclEntry, boolean bl) {
        PackageEntry packageEntry = this.findBestMatch(string, bl);
        if (packageEntry == null) {
            PackageEntry packageEntry2 = new PackageEntry(string, null, bl);
            packageEntry2.add(importDeclEntry);
            int n = packageEntry2.isStatic() ? 0 : this.getIndexAfterStatics();
            this.packageEntries.add(n, packageEntry2);
        } else {
            int n = string.compareTo(packageEntry.getName());
            if (n == 0) {
                packageEntry.sortIn(importDeclEntry);
            } else {
                String string2 = packageEntry.getGroupID();
                if (string2 != null && !string.startsWith(string2)) {
                    string2 = null;
                }
                PackageEntry packageEntry3 = new PackageEntry(string, string2, bl);
                packageEntry3.add(importDeclEntry);
                int n2 = this.packageEntries.indexOf(packageEntry);
                if (n < 0) {
                    this.packageEntries.add(n2, packageEntry3);
                } else {
                    this.packageEntries.add(n2 + 1, packageEntry3);
                }
            }
        }
    }

    private IRegion evaluateReplaceRange(CompilationUnit compilationUnit) {
        List list = compilationUnit.imports();
        if (!list.isEmpty()) {
            int n;
            ImportDeclaration importDeclaration = (ImportDeclaration)list.get(0);
            ImportDeclaration importDeclaration2 = (ImportDeclaration)list.get(list.size() - 1);
            int n2 = importDeclaration.getStartPosition();
            int n3 = compilationUnit.getExtendedStartPosition(importDeclaration2) + compilationUnit.getExtendedLength(importDeclaration2);
            int n4 = compilationUnit.getLineNumber(n3);
            if (n4 > 0 && (n = compilationUnit.getPosition(n4 + 1, 0)) >= 0) {
                int n5 = ImportRewriteAnalyzer.getFirstTypeBeginPos(compilationUnit);
                n3 = n5 != -1 && n5 < n ? n5 : n;
            }
            return new Region(n2, n3 - n2);
        }
        int n = this.getPackageStatementEndPos(compilationUnit);
        return new Region(n, 0);
    }

    public MultiTextEdit getResultingEdits(IProgressMonitor iProgressMonitor) throws JavaModelException {
        MultiTextEdit multiTextEdit;
        block20: {
            MultiTextEdit multiTextEdit2;
            if (iProgressMonitor == null) {
                iProgressMonitor = new NullProgressMonitor();
            }
            try {
                int n = this.replaceRange.getOffset();
                int n2 = this.replaceRange.getLength();
                String string = this.compilationUnit.findRecommendedLineSeparator();
                IBuffer iBuffer = this.compilationUnit.getBuffer();
                int n3 = n;
                multiTextEdit = new MultiTextEdit();
                if ((this.flags & 2) != 0) {
                    multiTextEdit.addChild((TextEdit)new InsertEdit(n3, string));
                }
                PackageEntry packageEntry = null;
                Set set = null;
                if (this.findAmbiguousImports) {
                    set = this.evaluateStarImportConflicts(iProgressMonitor);
                }
                int n4 = this.getSpacesBetweenImportGroups();
                ArrayList<Object> arrayList = new ArrayList<Object>();
                int n5 = this.packageEntries.size();
                int n6 = 0;
                while (n6 < n5) {
                    PackageEntry packageEntry2 = (PackageEntry)this.packageEntries.get(n6);
                    int n7 = packageEntry2.getNumberOfImports();
                    if (this.filterImplicitImports && !packageEntry2.isStatic() && ImportRewriteAnalyzer.isImplicitImport(packageEntry2.getName(), this.compilationUnit)) {
                        packageEntry2.removeAllNew(set);
                        n7 = packageEntry2.getNumberOfImports();
                    }
                    if (n7 != 0) {
                        Object object;
                        int n8;
                        if (n4 > 0 && packageEntry != null && !packageEntry2.isComment() && !packageEntry2.isSameGroup(packageEntry)) {
                            ImportDeclEntry importDeclEntry = packageEntry.getImportAt(packageEntry.getNumberOfImports() - 1);
                            ImportDeclEntry importDeclEntry2 = packageEntry2.getImportAt(0);
                            if (!packageEntry.isComment() && (importDeclEntry.isNew() || importDeclEntry2.isNew())) {
                                n8 = n4;
                                while (n8 > 0) {
                                    arrayList.add(string);
                                    --n8;
                                }
                            }
                        }
                        packageEntry = packageEntry2;
                        boolean bl = packageEntry2.isStatic();
                        int n9 = bl ? this.staticImportOnDemandThreshold : this.importOnDemandThreshold;
                        n8 = packageEntry2.hasStarImport(n9, set);
                        if (n8 != 0 && packageEntry2.find("*") == null) {
                            String string2 = String.valueOf(packageEntry2.getName()) + ".*";
                            object = this.getNewImportString(string2, bl, string);
                            arrayList.add(object);
                        }
                        int n10 = 0;
                        while (n10 < n7) {
                            object = packageEntry2.getImportAt(n10);
                            IRegion iRegion = ((ImportDeclEntry)object).getSourceRange();
                            if (iRegion == null) {
                                if (n8 == 0 || ((ImportDeclEntry)object).isOnDemand() || set != null && set.contains(((ImportDeclEntry)object).getSimpleName())) {
                                    String string3 = this.getNewImportString(((ImportDeclEntry)object).getElementName(), bl, string);
                                    arrayList.add(string3);
                                }
                            } else if (n8 == 0 || ((ImportDeclEntry)object).isOnDemand() || set == null || set.contains(((ImportDeclEntry)object).getSimpleName())) {
                                int n11 = iRegion.getOffset();
                                this.removeAndInsertNew(iBuffer, n3, n11, arrayList, multiTextEdit);
                                arrayList.clear();
                                n3 = n11 + iRegion.getLength();
                            }
                            ++n10;
                        }
                    }
                    ++n6;
                }
                n6 = n + n2;
                this.removeAndInsertNew(iBuffer, n3, n6, arrayList, multiTextEdit);
                if (n2 != 0) break block20;
                if (!this.importsCreated.isEmpty() || !this.staticImportsCreated.isEmpty()) {
                    if ((this.flags & 4) != 0) {
                        multiTextEdit.addChild((TextEdit)new InsertEdit(n3, string));
                    }
                    break block20;
                }
                multiTextEdit2 = new MultiTextEdit();
                Object var23_29 = null;
            }
            catch (Throwable throwable) {
                Object var23_31 = null;
                iProgressMonitor.done();
                throw throwable;
            }
            iProgressMonitor.done();
            return multiTextEdit2;
        }
        MultiTextEdit multiTextEdit3 = multiTextEdit;
        Object var23_30 = null;
        iProgressMonitor.done();
        return multiTextEdit3;
    }

    private void removeAndInsertNew(IBuffer iBuffer, int n, int n2, ArrayList arrayList, MultiTextEdit multiTextEdit) {
        int n3 = n;
        int n4 = 0;
        while (n4 < arrayList.size()) {
            String string = (String)arrayList.get(n4);
            int n5 = this.findInBuffer(iBuffer, string, n3, n2);
            if (n5 != -1) {
                if (n5 != n3) {
                    multiTextEdit.addChild((TextEdit)new DeleteEdit(n3, n5 - n3));
                }
                n3 = n5 + string.length();
            } else {
                multiTextEdit.addChild((TextEdit)new InsertEdit(n3, string));
            }
            ++n4;
        }
        if (n3 < n2) {
            multiTextEdit.addChild((TextEdit)new DeleteEdit(n3, n2 - n3));
        }
    }

    private int findInBuffer(IBuffer iBuffer, String string, int n, int n2) {
        int n3 = n;
        int n4 = string.length();
        if (n3 + n4 > n2 || string.length() == 0) {
            return -1;
        }
        char c = string.charAt(0);
        int n5 = string.indexOf(c, 1);
        if (n5 == -1) {
            n5 = n4;
        }
        while (n3 + n4 <= n2) {
            if (iBuffer.getChar(n3) == c) {
                int n6 = 1;
                while (n6 < n4 && iBuffer.getChar(n3 + n6) == string.charAt(n6)) {
                    ++n6;
                }
                if (n6 == n4) {
                    return n3;
                }
                if (n6 < n5) {
                    n3 += n6;
                    continue;
                }
                n3 += n5;
                continue;
            }
            ++n3;
        }
        return -1;
    }

    private Set evaluateStarImportConflicts(IProgressMonitor iProgressMonitor) throws JavaModelException {
        Object object;
        final HashSet hashSet = new HashSet();
        IJavaSearchScope iJavaSearchScope = SearchEngine.createJavaSearchScope(new IJavaElement[]{this.compilationUnit.getJavaProject()});
        ArrayList<char[]> arrayList = new ArrayList<char[]>();
        ArrayList<char[]> arrayList2 = new ArrayList<char[]>();
        int n = this.packageEntries.size();
        int n2 = 0;
        while (n2 < n) {
            object = (PackageEntry)this.packageEntries.get(n2);
            if (!((PackageEntry)object).isStatic() && ((PackageEntry)object).hasStarImport(this.importOnDemandThreshold, null)) {
                arrayList.add(((PackageEntry)object).getName().toCharArray());
                int n3 = 0;
                while (n3 < ((PackageEntry)object).getNumberOfImports()) {
                    ImportDeclEntry importDeclEntry = ((PackageEntry)object).getImportAt(n3);
                    if (!importDeclEntry.isOnDemand() && !importDeclEntry.isComment()) {
                        arrayList2.add(importDeclEntry.getSimpleName().toCharArray());
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        arrayList.add(this.compilationUnit.getParent().getElementName().toCharArray());
        arrayList.add(JAVA_LANG.toCharArray());
        char[][] cArray = (char[][])arrayList.toArray((T[])new char[arrayList.size()][]);
        object = (char[][])arrayList2.toArray((T[])new char[arrayList2.size()][]);
        TypeNameRequestor typeNameRequestor = new TypeNameRequestor(){
            HashMap foundTypes = new HashMap();

            private String getTypeContainerName(char[] cArray, char[][] cArray2) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(cArray);
                int n = 0;
                while (n < cArray2.length) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append('.');
                    }
                    stringBuffer.append(cArray2[n]);
                    ++n;
                }
                return stringBuffer.toString();
            }

            public void acceptType(int n, char[] cArray, char[] cArray2, char[][] cArray3, String string) {
                String string2 = new String(cArray2);
                String string3 = this.getTypeContainerName(cArray, cArray3);
                String string4 = this.foundTypes.put(string2, string3);
                if (string4 != null && !string4.equals(string3)) {
                    hashSet.add(string2);
                }
            }
        };
        new SearchEngine().searchAllTypeNames(cArray, (char[][])object, iJavaSearchScope, typeNameRequestor, 3, iProgressMonitor);
        return hashSet;
    }

    private String getNewImportString(String string, boolean bl, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("import ");
        if (bl) {
            stringBuffer.append("static ");
        }
        stringBuffer.append(string);
        stringBuffer.append(';');
        stringBuffer.append(string2);
        if (bl) {
            this.staticImportsCreated.add(string);
        } else {
            this.importsCreated.add(string);
        }
        return stringBuffer.toString();
    }

    private static int getFirstTypeBeginPos(CompilationUnit compilationUnit) {
        List list = compilationUnit.types();
        if (!list.isEmpty()) {
            return compilationUnit.getExtendedStartPosition((ASTNode)list.get(0));
        }
        return -1;
    }

    private int getPackageStatementEndPos(CompilationUnit compilationUnit) {
        int n;
        int n2;
        PackageDeclaration packageDeclaration = compilationUnit.getPackage();
        if (packageDeclaration != null && (n2 = compilationUnit.getPosition(n = compilationUnit.getLineNumber(packageDeclaration.getStartPosition() + packageDeclaration.getLength()) + 1, 0)) >= 0) {
            int n3 = ImportRewriteAnalyzer.getFirstTypeBeginPos(compilationUnit);
            if (n3 != -1 && n3 <= n2 && n3 <= n2) {
                this.flags |= 4;
                if (n3 == n2) {
                    this.flags |= 2;
                }
                return n3;
            }
            this.flags |= 2;
            return n2;
        }
        this.flags |= 4;
        return 0;
    }

    public String toString() {
        int n = this.packageEntries.size();
        StringBuffer stringBuffer = new StringBuffer("\n-----------------------\n");
        int n2 = 0;
        while (n2 < n) {
            PackageEntry packageEntry = (PackageEntry)this.packageEntries.get(n2);
            if (packageEntry.isStatic()) {
                stringBuffer.append("static ");
            }
            stringBuffer.append(packageEntry.toString());
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String[] getCreatedImports() {
        return this.importsCreated.toArray(new String[this.importsCreated.size()]);
    }

    public String[] getCreatedStaticImports() {
        return this.staticImportsCreated.toArray(new String[this.staticImportsCreated.size()]);
    }

    private static final class ImportDeclEntry {
        private String elementName;
        private IRegion sourceRange;
        private final boolean isStatic;

        public ImportDeclEntry(String string, boolean bl, IRegion iRegion) {
            this.elementName = string;
            this.sourceRange = iRegion;
            this.isStatic = bl;
        }

        public String getElementName() {
            return this.elementName;
        }

        public int compareTo(String string, boolean bl) {
            int n = this.elementName.compareTo(string);
            if (n == 0) {
                if (this.isStatic == bl) {
                    return 0;
                }
                return this.isStatic ? -1 : 1;
            }
            return n;
        }

        public String getSimpleName() {
            return Signature.getSimpleName(this.elementName);
        }

        public boolean isOnDemand() {
            return this.elementName != null && this.elementName.endsWith(".*");
        }

        public boolean isStatic() {
            return this.isStatic;
        }

        public boolean isNew() {
            return this.sourceRange == null;
        }

        public boolean isComment() {
            return this.elementName == null;
        }

        public IRegion getSourceRange() {
            return this.sourceRange;
        }
    }

    private static final class PackageEntry {
        private String name;
        private ArrayList importEntries;
        private String group;
        private boolean isStatic;

        public static PackageEntry createOnPlaceholderEntry(String string) {
            if (string.length() > 0 && string.charAt(0) == '#') {
                String string2 = string.substring(1);
                return new PackageEntry(string2, string2, true);
            }
            return new PackageEntry(string, string, false);
        }

        public PackageEntry() {
            this("!", null, false);
        }

        public PackageEntry(String string, String string2, boolean bl) {
            this.name = string;
            this.importEntries = new ArrayList(5);
            this.group = string2;
            this.isStatic = bl;
        }

        public boolean isStatic() {
            return this.isStatic;
        }

        public int compareTo(String string, boolean bl) {
            int n = this.name.compareTo(string);
            if (n == 0) {
                if (this.isStatic == bl) {
                    return 0;
                }
                return this.isStatic ? -1 : 1;
            }
            return n;
        }

        public void sortIn(ImportDeclEntry importDeclEntry) {
            String string = importDeclEntry.getElementName();
            int n = -1;
            int n2 = this.importEntries.size();
            int n3 = 0;
            while (n3 < n2) {
                ImportDeclEntry importDeclEntry2 = this.getImportAt(n3);
                if (!importDeclEntry2.isComment()) {
                    int n4 = importDeclEntry2.compareTo(string, importDeclEntry.isStatic());
                    if (n4 == 0) {
                        return;
                    }
                    if (n4 > 0 && n == -1) {
                        n = n3;
                    }
                }
                ++n3;
            }
            if (n == -1) {
                this.importEntries.add(importDeclEntry);
            } else {
                this.importEntries.add(n, importDeclEntry);
            }
        }

        public void add(ImportDeclEntry importDeclEntry) {
            this.importEntries.add(importDeclEntry);
        }

        public ImportDeclEntry find(String string) {
            int n = this.importEntries.size();
            int n2 = 0;
            while (n2 < n) {
                int n3;
                String string2;
                ImportDeclEntry importDeclEntry = this.getImportAt(n2);
                if (!importDeclEntry.isComment() && (string2 = importDeclEntry.getElementName()).endsWith(string) && ((n3 = string2.length() - string.length() - 1) == -1 || n3 > 0 && string2.charAt(n3) == '.')) {
                    return importDeclEntry;
                }
                ++n2;
            }
            return null;
        }

        public boolean remove(String string, boolean bl) {
            int n = this.importEntries.size();
            int n2 = 0;
            while (n2 < n) {
                ImportDeclEntry importDeclEntry = this.getImportAt(n2);
                if (!importDeclEntry.isComment() && importDeclEntry.compareTo(string, bl) == 0) {
                    this.importEntries.remove(n2);
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public void removeAllNew(Set set) {
            int n = this.importEntries.size();
            int n2 = n - 1;
            while (n2 >= 0) {
                ImportDeclEntry importDeclEntry = this.getImportAt(n2);
                if (importDeclEntry.isNew()) {
                    this.importEntries.remove(n2);
                }
                --n2;
            }
        }

        public ImportDeclEntry getImportAt(int n) {
            return (ImportDeclEntry)this.importEntries.get(n);
        }

        public boolean hasStarImport(int n, Set set) {
            if (this.isComment() || this.isDefaultPackage()) {
                return false;
            }
            int n2 = this.getNumberOfImports();
            int n3 = 0;
            boolean bl = false;
            int n4 = 0;
            while (n4 < n2) {
                ImportDeclEntry importDeclEntry = this.getImportAt(n4);
                if (importDeclEntry.isOnDemand()) {
                    return true;
                }
                if (!importDeclEntry.isComment()) {
                    ++n3;
                    boolean bl2 = !importDeclEntry.isStatic() && set != null && set.contains(importDeclEntry.getSimpleName());
                    bl |= importDeclEntry.isNew() && !bl2;
                }
                ++n4;
            }
            return n3 >= n && bl;
        }

        public int getNumberOfImports() {
            return this.importEntries.size();
        }

        public String getName() {
            return this.name;
        }

        public String getGroupID() {
            return this.group;
        }

        public void setGroupID(String string) {
            this.group = string;
        }

        public boolean isSameGroup(PackageEntry packageEntry) {
            if (this.group == null) {
                return packageEntry.getGroupID() == null;
            }
            return this.group.equals(packageEntry.getGroupID()) && this.isStatic == packageEntry.isStatic();
        }

        public ImportDeclEntry getLast() {
            int n = this.getNumberOfImports();
            if (n > 0) {
                return this.getImportAt(n - 1);
            }
            return null;
        }

        public boolean isComment() {
            return "!".equals(this.name);
        }

        public boolean isDefaultPackage() {
            return this.name.length() == 0;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.isComment()) {
                stringBuffer.append("comment\n");
            } else {
                stringBuffer.append(this.name);
                stringBuffer.append(", groupId: ");
                stringBuffer.append(this.group);
                stringBuffer.append("\n");
                int n = this.getNumberOfImports();
                int n2 = 0;
                while (n2 < n) {
                    ImportDeclEntry importDeclEntry = this.getImportAt(n2);
                    stringBuffer.append("  ");
                    if (importDeclEntry.isStatic()) {
                        stringBuffer.append("static ");
                    }
                    stringBuffer.append(importDeclEntry.getSimpleName());
                    if (importDeclEntry.isNew()) {
                        stringBuffer.append(" (new)");
                    }
                    stringBuffer.append("\n");
                    ++n2;
                }
            }
            return stringBuffer.toString();
        }
    }

    private static class PackageMatcher {
        private String newName;
        private String bestName;
        private int bestMatchLen;

        public void initialize(String string, String string2) {
            this.newName = string;
            this.bestName = string2;
            this.bestMatchLen = ImportRewriteAnalyzer.getCommonPrefixLength(string2, string);
        }

        public boolean isBetterMatch(String string, boolean bl) {
            boolean bl2;
            int n = ImportRewriteAnalyzer.getCommonPrefixLength(string, this.newName);
            int n2 = n - this.bestMatchLen;
            if (n2 == 0) {
                bl2 = n == this.newName.length() && n == string.length() && n == this.bestName.length() ? bl : this.sameMatchLenTest(string);
            } else {
                boolean bl3 = bl2 = n2 > 0;
            }
            if (bl2) {
                this.bestName = string;
                this.bestMatchLen = n;
            }
            return bl2;
        }

        private boolean sameMatchLenTest(String string) {
            int n = this.bestMatchLen;
            char c = ImportRewriteAnalyzer.getCharAt(this.newName, n);
            char c2 = ImportRewriteAnalyzer.getCharAt(string, n);
            char c3 = ImportRewriteAnalyzer.getCharAt(this.bestName, n);
            if (c < c2) {
                if (c3 < c) {
                    return c2 - c < c - c3;
                }
                if (c2 == c3) {
                    return false;
                }
                return c2 < c3;
            }
            if (c3 > c) {
                return c - c2 < c3 - c;
            }
            if (c2 == c3) {
                return true;
            }
            return c2 > c3;
        }
    }
}

