/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.dom.rewrite;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.internal.core.dom.rewrite.NodeRewriteEvent;
import org.eclipse.wst.jsdt.internal.core.dom.rewrite.RewriteEvent;

public class ListRewriteEvent
extends RewriteEvent {
    public static final int NEW = 1;
    public static final int OLD = 2;
    public static final int BOTH = 3;
    private List originalNodes;
    private List listEntries;

    public ListRewriteEvent(List list) {
        this.originalNodes = new ArrayList(list);
    }

    public ListRewriteEvent(RewriteEvent[] rewriteEventArray) {
        this.listEntries = new ArrayList(rewriteEventArray.length * 2);
        this.originalNodes = new ArrayList(rewriteEventArray.length * 2);
        int n = 0;
        while (n < rewriteEventArray.length) {
            RewriteEvent rewriteEvent = rewriteEventArray[n];
            this.listEntries.add(rewriteEvent);
            if (rewriteEvent.getOriginalValue() != null) {
                this.originalNodes.add(rewriteEvent.getOriginalValue());
            }
            ++n;
        }
    }

    private List getEntries() {
        if (this.listEntries == null) {
            int n = this.originalNodes.size();
            this.listEntries = new ArrayList(n * 2);
            int n2 = 0;
            while (n2 < n) {
                ASTNode aSTNode = (ASTNode)this.originalNodes.get(n2);
                this.listEntries.add(new NodeRewriteEvent(aSTNode, aSTNode));
                ++n2;
            }
        }
        return this.listEntries;
    }

    public int getChangeKind() {
        if (this.listEntries != null) {
            int n = 0;
            while (n < this.listEntries.size()) {
                RewriteEvent rewriteEvent = (RewriteEvent)this.listEntries.get(n);
                if (rewriteEvent.getChangeKind() != 0) {
                    return 8;
                }
                ++n;
            }
        }
        return 0;
    }

    public boolean isListRewrite() {
        return true;
    }

    public RewriteEvent[] getChildren() {
        List list = this.getEntries();
        return list.toArray(new RewriteEvent[list.size()]);
    }

    public Object getOriginalValue() {
        return this.originalNodes;
    }

    public Object getNewValue() {
        List list = this.getEntries();
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        int n = 0;
        while (n < list.size()) {
            RewriteEvent rewriteEvent = (RewriteEvent)list.get(n);
            Object object = rewriteEvent.getNewValue();
            if (object != null) {
                arrayList.add(object);
            }
            ++n;
        }
        return arrayList;
    }

    public RewriteEvent removeEntry(ASTNode aSTNode) {
        return this.replaceEntry(aSTNode, null);
    }

    public RewriteEvent replaceEntry(ASTNode aSTNode, ASTNode aSTNode2) {
        if (aSTNode == null) {
            throw new IllegalArgumentException();
        }
        List list = this.getEntries();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            NodeRewriteEvent nodeRewriteEvent = (NodeRewriteEvent)list.get(n2);
            if (nodeRewriteEvent.getOriginalValue() == aSTNode) {
                nodeRewriteEvent.setNewValue(aSTNode2);
                return nodeRewriteEvent;
            }
            ++n2;
        }
        return null;
    }

    public void revertChange(NodeRewriteEvent nodeRewriteEvent) {
        Object object = nodeRewriteEvent.getOriginalValue();
        if (object == null) {
            List list = this.getEntries();
            list.remove(nodeRewriteEvent);
        } else {
            nodeRewriteEvent.setNewValue(object);
        }
    }

    public int getIndex(ASTNode aSTNode, int n) {
        List list = this.getEntries();
        int n2 = list.size() - 1;
        while (n2 >= 0) {
            RewriteEvent rewriteEvent = (RewriteEvent)list.get(n2);
            if ((n & 2) != 0 && rewriteEvent.getOriginalValue() == aSTNode) {
                return n2;
            }
            if ((n & 1) != 0 && rewriteEvent.getNewValue() == aSTNode) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    public RewriteEvent insert(ASTNode aSTNode, int n) {
        NodeRewriteEvent nodeRewriteEvent = new NodeRewriteEvent(null, aSTNode);
        if (n != -1) {
            this.getEntries().add(n, nodeRewriteEvent);
        } else {
            this.getEntries().add(nodeRewriteEvent);
        }
        return nodeRewriteEvent;
    }

    public void setNewValue(ASTNode aSTNode, int n) {
        NodeRewriteEvent nodeRewriteEvent = (NodeRewriteEvent)this.getEntries().get(n);
        nodeRewriteEvent.setNewValue(aSTNode);
    }

    public int getChangeKind(int n) {
        return ((NodeRewriteEvent)this.getEntries().get(n)).getChangeKind();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" [list change\n\t");
        RewriteEvent[] rewriteEventArray = this.getChildren();
        int n = 0;
        while (n < rewriteEventArray.length) {
            if (n != 0) {
                stringBuffer.append("\n\t");
            }
            stringBuffer.append(rewriteEventArray[n]);
            ++n;
        }
        stringBuffer.append("\n]");
        return stringBuffer.toString();
    }
}

